"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cfn_element_1 = require("./cfn-element");
const cfn_fn_1 = require("./cfn-fn");
const token_1 = require("./token");
/**
 * Represents a CloudFormation mapping.
 */
class CfnMapping extends cfn_element_1.CfnRefElement {
    constructor(scope, id, props = {}) {
        super(scope, id);
        this.mapping = {};
        this.mapping = props.mapping || {};
    }
    /**
     * Sets a value in the map based on the two keys.
     */
    setValue(key1, key2, value) {
        if (!(key1 in this.mapping)) {
            this.mapping[key1] = {};
        }
        this.mapping[key1][key2] = value;
    }
    /**
     * @returns A reference to a value in the map based on the two keys.
     */
    findInMap(key1, key2) {
        // opportunistically check that the key exists (if the key does not contain tokens)
        if (!token_1.Token.isUnresolved(key1) && !(key1 in this.mapping)) {
            throw new Error(`Mapping doesn't contain top-level key '${key1}'`);
        }
        // opportunistically check that the second key exists (if the key does not contain tokens)
        if (!token_1.Token.isUnresolved(key1) && !token_1.Token.isUnresolved(key2) && !(key2 in this.mapping[key1])) {
            throw new Error(`Mapping doesn't contain second-level key '${key2}'`);
        }
        return cfn_fn_1.Fn.findInMap(this.logicalId, key1, key2);
    }
    /**
     * @internal
     */
    _toCloudFormation() {
        return {
            Mappings: {
                [this.logicalId]: this.mapping,
            },
        };
    }
}
exports.CfnMapping = CfnMapping;
//# sourceMappingURL=data:application/json;base64,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