"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * With the DeletionPolicy attribute you can preserve or (in some cases) backup a resource when its stack is deleted.
 * You specify a DeletionPolicy attribute for each resource that you want to control. If a resource has no DeletionPolicy
 * attribute, AWS CloudFormation deletes the resource by default. Note that this capability also applies to update operations
 * that lead to resources being removed.
 */
var CfnDeletionPolicy;
(function (CfnDeletionPolicy) {
    /**
     * AWS CloudFormation deletes the resource and all its content if applicable during stack deletion. You can add this
     * deletion policy to any resource type. By default, if you don't specify a DeletionPolicy, AWS CloudFormation deletes
     * your resources. However, be aware of the following considerations:
     */
    CfnDeletionPolicy["DELETE"] = "Delete";
    /**
     * AWS CloudFormation keeps the resource without deleting the resource or its contents when its stack is deleted.
     * You can add this deletion policy to any resource type. Note that when AWS CloudFormation completes the stack deletion,
     * the stack will be in Delete_Complete state; however, resources that are retained continue to exist and continue to incur
     * applicable charges until you delete those resources.
     */
    CfnDeletionPolicy["RETAIN"] = "Retain";
    /**
     * For resources that support snapshots (AWS::EC2::Volume, AWS::ElastiCache::CacheCluster, AWS::ElastiCache::ReplicationGroup,
     * AWS::RDS::DBInstance, AWS::RDS::DBCluster, and AWS::Redshift::Cluster), AWS CloudFormation creates a snapshot for the
     * resource before deleting it. Note that when AWS CloudFormation completes the stack deletion, the stack will be in the
     * Delete_Complete state; however, the snapshots that are created with this policy continue to exist and continue to
     * incur applicable charges until you delete those snapshots.
     */
    CfnDeletionPolicy["SNAPSHOT"] = "Snapshot";
})(CfnDeletionPolicy = exports.CfnDeletionPolicy || (exports.CfnDeletionPolicy = {}));
//# sourceMappingURL=data:application/json;base64,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