"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const stack_trace_1 = require("../stack-trace");
const token_1 = require("../token");
/**
 * Token subclass that represents values intrinsic to the target document language
 *
 * WARNING: this class should not be externally exposed, but is currently visible
 * because of a limitation of jsii (https://github.com/aws/jsii/issues/524).
 *
 * This class will disappear in a future release and should not be used.
 *
 * @experimental
 */
class Intrinsic {
    constructor(value) {
        if (isFunction(value)) {
            throw new Error(`Argument to Intrinsic must be a plain value object, got ${value}`);
        }
        this.creationStack = stack_trace_1.captureStackTrace();
        this.value = value;
    }
    resolve(_context) {
        return this.value;
    }
    /**
     * Convert an instance of this Token to a string
     *
     * This method will be called implicitly by language runtimes if the object
     * is embedded into a string. We treat it the same as an explicit
     * stringification.
     */
    toString() {
        return token_1.Token.asString(this);
    }
    /**
     * Turn this Token into JSON
     *
     * Called automatically when JSON.stringify() is called on a Token.
     */
    toJSON() {
        // We can't do the right work here because in case we contain a function, we
        // won't know the type of value that function represents (in the simplest
        // case, string or number), and we can't know that without an
        // IResolveContext to actually do the resolution, which we don't have.
        // We used to throw an error, but since JSON.stringify() is often used in
        // error messages to produce a readable representation of an object, if we
        // throw here we'll obfuscate that descriptive error with something worse.
        // So return a string representation that indicates this thing is a token
        // and needs resolving.
        return '<unresolved-token>';
    }
    /**
     * Creates a throwable Error object that contains the token creation stack trace.
     * @param message Error message
     */
    newError(message) {
        return new Error(`${message}\nToken created:\n    at ${this.creationStack.join('\n    at ')}\nError thrown:`);
    }
}
exports.Intrinsic = Intrinsic;
function isFunction(x) {
    return typeof x === 'function';
}
//# sourceMappingURL=data:application/json;base64,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