import { Test } from 'nodeunit';
declare const _default: {
    'resolve a plain old object should just return the object'(test: Test): void;
    'if a value is an object with a token value, it will be evaluated'(test: Test): void;
    'tokens are evaluated anywhere in the object tree'(test: Test): void;
    'tokens are evaluated recursively'(test: Test): void;
    'empty arrays or objects are kept'(test: Test): void;
    'if an object has a "resolve" property that is not a function, it is not considered a token'(test: Test): void;
    'if a resolvable object inherits from a class that is also resolvable, the "constructor" function will not get in the way (uses Object.keys instead of "for in")'(test: Test): void;
    'isToken(obj) can be used to determine if an object is a token'(test: Test): void;
    'Token can be used to create tokens that contain a constant value'(test: Test): void;
    'resolving leaves a Date object in working order'(test: Test): void;
    'tokens can be stringified and evaluated to conceptual value'(test: Test): void;
    'tokens stringification can be reversed'(test: Test): void;
    'Tokens stringification and reversing of CloudFormation Tokens is implemented using Fn::Join'(test: Test): void;
    'Doubly nested strings evaluate correctly in scalar context'(test: Test): void;
    'integer Tokens can be stringified and evaluate to conceptual value'(test: Test): void;
    'intrinsic Tokens can be stringified and evaluate to conceptual value'(test: Test): void;
    'tokens resolve properly in initial position'(test: Test): void;
    'side-by-side Tokens resolve correctly'(test: Test): void;
    'tokens can be used in hash keys but must resolve to a string'(test: Test): void;
    'tokens can be nested in hash keys'(test: Test): void;
    'tokens can be nested and concatenated in hash keys'(test: Test): void;
    'can find nested tokens in hash keys'(test: Test): void;
    'fails if token in a hash key resolves to a non-string'(test: Test): void;
    'list encoding': {
        'can encode Token to string and resolve the encoding'(test: Test): void;
        'cannot add to encoded list'(test: Test): void;
        'cannot add to strings in encoded list'(test: Test): void;
        'can pass encoded lists to FnSelect'(test: Test): void;
        'can pass encoded lists to FnJoin'(test: Test): void;
        'can pass encoded lists to FnJoin, even if join is stringified'(test: Test): void;
    };
    'number encoding': {
        'basic integer encoding works'(test: Test): void;
        'arbitrary integers can be encoded, stringified, and recovered'(test: Test): void;
        'arbitrary numbers are correctly detected as not being tokens'(test: Test): void;
        'can number-encode and resolve Token objects'(test: Test): void;
    };
    'stack trace is captured at token creation'(test: Test): void;
    'newError returns an error with the creation stack trace'(test: Test): void;
    'type coercion': any;
    'creation stack is attached to errors emitted during resolve'(test: Test): void;
    stringifyNumber: {
        'converts number to string'(test: Test): void;
        'converts tokenized number to string'(test: Test): void;
        'string remains the same'(test: Test): void;
        'Ref remains the same'(test: Test): void;
        'lazy Ref remains the same'(test: Test): void;
        'tokenized Ref remains the same'(test: Test): void;
    };
};
export = _default;
