"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.A2c = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [a2c](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsapp2container.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class A2c extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [a2c](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsapp2container.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'a2c';
        this.accessLevelList = {
            Read: [
                'GetContainerizationJobDetails',
                'GetDeploymentJobDetails'
            ],
            Write: [
                'StartContainerizationJob',
                'StartDeploymentJob'
            ]
        };
    }
    /**
     * Grants permission to get the details of all Containerization jobs
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/tk-dotnet-refactoring/latest/userguide/what-is-tk-dotnet-refactoring.html
     */
    toGetContainerizationJobDetails() {
        return this.to('GetContainerizationJobDetails');
    }
    /**
     * Grants permission to get the details of all Deployment jobs
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/tk-dotnet-refactoring/latest/userguide/what-is-tk-dotnet-refactoring.html
     */
    toGetDeploymentJobDetails() {
        return this.to('GetDeploymentJobDetails');
    }
    /**
     * Grants permission to start a Containerization job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/tk-dotnet-refactoring/latest/userguide/what-is-tk-dotnet-refactoring.html
     */
    toStartContainerizationJob() {
        return this.to('StartContainerizationJob');
    }
    /**
     * Grants permission to start a Deploymnet job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/tk-dotnet-refactoring/latest/userguide/what-is-tk-dotnet-refactoring.html
     */
    toStartDeploymentJob() {
        return this.to('StartDeploymentJob');
    }
}
exports.A2c = A2c;
_a = JSII_RTTI_SYMBOL_1;
A2c[_a] = { fqn: "iam-floyd.A2c", version: "0.505.0" };
//# sourceMappingURL=data:application/json;base64,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