import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [app-integrations](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonappintegrations.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class AppIntegrations extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [app-integrations](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonappintegrations.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to create a new DataIntegration
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - appflow:DeleteFlow
     * - appflow:DescribeConnectorProfiles
     * - iam:AttachRolePolicy
     * - iam:CreateServiceLinkedRole
     * - iam:PutRolePolicy
     * - kms:CreateGrant
     *
     * https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html
     */
    toCreateDataIntegration(): this;
    /**
     * Grants permission to create a DataIntegrationAssociation
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - appflow:CreateFlow
     * - appflow:DeleteFlow
     * - appflow:DescribeConnectorEntity
     * - appflow:DescribeConnectorProfiles
     * - appflow:TagResource
     * - appflow:UseConnectorProfile
     *
     * https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegrationAssociation.html
     */
    toCreateDataIntegrationAssociation(): this;
    /**
     * Grants permission to create a new EventIntegration
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - iam:AttachRolePolicy
     * - iam:CreateServiceLinkedRole
     * - iam:PutRolePolicy
     *
     * https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateEventIntegration.html
     */
    toCreateEventIntegration(): this;
    /**
     * Grants permission to create an EventIntegrationAssociation
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - events:PutRule
     * - events:PutTargets
     *
     * https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateEventIntegrationAssociation.html
     */
    toCreateEventIntegrationAssociation(): this;
    /**
     * Grants permission to delete a DataIntegration
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_DeleteDataIntegration.html
     */
    toDeleteDataIntegration(): this;
    /**
     * Grants permission to delete a DataIntegrationAssociation
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - appflow:CreateFlow
     * - appflow:DeleteFlow
     * - appflow:DescribeConnectorEntity
     * - appflow:DescribeConnectorProfiles
     * - appflow:StopFlow
     * - appflow:TagResource
     * - appflow:UseConnectorProfile
     *
     * https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_DeleteDataIntegrationAssociation.html
     */
    toDeleteDataIntegrationAssociation(): this;
    /**
     * Grants permission to delete an EventIntegration
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_DeleteEventIntegration.html
     */
    toDeleteEventIntegration(): this;
    /**
     * Grants permission to delete an EventIntegrationAssociation
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - events:DeleteRule
     * - events:ListTargetsByRule
     * - events:RemoveTargets
     *
     * https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_DeleteEventIntegrationAssociation.html
     */
    toDeleteEventIntegrationAssociation(): this;
    /**
     * Grants permission to view details about DataIntegrations
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_GetDataIntegration.html
     */
    toGetDataIntegration(): this;
    /**
     * Grants permission to view details about EventIntegrations
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_GetEventIntegration.html
     */
    toGetEventIntegration(): this;
    /**
     * Grants permission to list DataIntegrationAssociations
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_ListDataIntegrationAssociations.html
     */
    toListDataIntegrationAssociations(): this;
    /**
     * Grants permission to list DataIntegrations
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_ListDataIntegrations.html
     */
    toListDataIntegrations(): this;
    /**
     * Grants permission to list EventIntegrationAssociations
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_ListEventIntegrationAssociations
     */
    toListEventIntegrationAssociations(): this;
    /**
     * Grants permission to list EventIntegrations
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_ListEventIntegrations.html
     */
    toListEventIntegrations(): this;
    /**
     * Grants permission to lists tag for an Amazon AppIntegration resource
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to tag an Amazon AppIntegration resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to untag an Amazon AppIntegration resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to modify a DataIntegration
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_UpdateDataIntegration.html
     */
    toUpdateDataIntegration(): this;
    /**
     * Grants permission to modify an EventIntegration
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_UpdateEventIntegration.html
     */
    toUpdateEventIntegration(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type event-integration to the statement
     *
     * https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_EventIntegration.html
     *
     * @param eventIntegrationName - Identifier for the eventIntegrationName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onEventIntegration(eventIntegrationName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type event-integration-association to the statement
     *
     * https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_EventIntegrationAssociation.html
     *
     * @param eventIntegrationName - Identifier for the eventIntegrationName.
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onEventIntegrationAssociation(eventIntegrationName: string, resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type data-integration to the statement
     *
     * https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_DataIntegrationSummary.html
     *
     * @param dataIntegrationId - Identifier for the dataIntegrationId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onDataIntegration(dataIntegrationId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type data-integration-association to the statement
     *
     * https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_DataIntegrationAssociationSummary.html
     *
     * @param dataIntegrationId - Identifier for the dataIntegrationId.
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onDataIntegrationAssociation(dataIntegrationId: string, resourceId: string, account?: string, region?: string, partition?: string): this;
}
