"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Apprunner = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [apprunner](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsapprunner.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Apprunner extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [apprunner](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsapprunner.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'apprunner';
        this.accessLevelList = {
            Write: [
                'AssociateCustomDomain',
                'AssociateWebAcl',
                'CreateAutoScalingConfiguration',
                'CreateConnection',
                'CreateObservabilityConfiguration',
                'CreateService',
                'CreateVpcConnector',
                'CreateVpcIngressConnection',
                'DeleteAutoScalingConfiguration',
                'DeleteConnection',
                'DeleteObservabilityConfiguration',
                'DeleteService',
                'DeleteVpcConnector',
                'DeleteVpcIngressConnection',
                'DisassociateCustomDomain',
                'DisassociateWebAcl',
                'PauseService',
                'ResumeService',
                'StartDeployment',
                'UpdateService',
                'UpdateVpcIngressConnection'
            ],
            Read: [
                'DescribeAutoScalingConfiguration',
                'DescribeCustomDomains',
                'DescribeObservabilityConfiguration',
                'DescribeOperation',
                'DescribeService',
                'DescribeVpcConnector',
                'DescribeVpcIngressConnection',
                'DescribeWebAclForService',
                'ListTagsForResource'
            ],
            List: [
                'ListAssociatedServicesForWebAcl',
                'ListAutoScalingConfigurations',
                'ListConnections',
                'ListObservabilityConfigurations',
                'ListOperations',
                'ListServices',
                'ListVpcConnectors',
                'ListVpcIngressConnections'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
    /**
     * Grants permission to associate your own domain name with the AWS App Runner subdomain URL of your App Runner service
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_AssociateCustomDomain.html
     */
    toAssociateCustomDomain() {
        return this.to('AssociateCustomDomain');
    }
    /**
     * Grants permission to associate the service with an AWS WAF web ACL
     *
     * Access Level: Write
     */
    toAssociateWebAcl() {
        return this.to('AssociateWebAcl');
    }
    /**
     * Grants permission to create an AWS App Runner automatic scaling configuration resource
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_CreateAutoScalingConfiguration.html
     */
    toCreateAutoScalingConfiguration() {
        return this.to('CreateAutoScalingConfiguration');
    }
    /**
     * Grants permission to create an AWS App Runner connection resource
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_CreateConnection.html
     */
    toCreateConnection() {
        return this.to('CreateConnection');
    }
    /**
     * Grants permission to create an AWS App Runner observability configuration resource
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_CreateObservabilityConfiguration.html
     */
    toCreateObservabilityConfiguration() {
        return this.to('CreateObservabilityConfiguration');
    }
    /**
     * Grants permission to create an AWS App Runner service resource
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifConnectionArn()
     * - .ifAutoScalingConfigurationArn()
     * - .ifObservabilityConfigurationArn()
     * - .ifVpcConnectorArn()
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_CreateService.html
     */
    toCreateService() {
        return this.to('CreateService');
    }
    /**
     * Grants permission to create an AWS App Runner VPC connector resource
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_CreateVpcConnector.html
     */
    toCreateVpcConnector() {
        return this.to('CreateVpcConnector');
    }
    /**
     * Grants permission to create an AWS App Runner VpcIngressConnection resource
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifServiceArn()
     * - .ifVpcId()
     * - .ifVpcEndpointId()
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_CreateVpcIngressConnection.html
     */
    toCreateVpcIngressConnection() {
        return this.to('CreateVpcIngressConnection');
    }
    /**
     * Grants permission to delete an AWS App Runner automatic scaling configuration resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_DeleteAutoScalingConfiguration.html
     */
    toDeleteAutoScalingConfiguration() {
        return this.to('DeleteAutoScalingConfiguration');
    }
    /**
     * Grants permission to delete an AWS App Runner connection resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_DeleteConnection.html
     */
    toDeleteConnection() {
        return this.to('DeleteConnection');
    }
    /**
     * Grants permission to delete an AWS App Runner observability configuration resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_DeleteObservabilityConfiguration.html
     */
    toDeleteObservabilityConfiguration() {
        return this.to('DeleteObservabilityConfiguration');
    }
    /**
     * Grants permission to delete an AWS App Runner service resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_DeleteService.html
     */
    toDeleteService() {
        return this.to('DeleteService');
    }
    /**
     * Grants permission to delete an AWS App Runner VPC connector resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_DeleteVpcConnector.html
     */
    toDeleteVpcConnector() {
        return this.to('DeleteVpcConnector');
    }
    /**
     * Grants permission to delete an AWS App Runner VpcIngressConnection resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_DeleteVpcIngressConnection.html
     */
    toDeleteVpcIngressConnection() {
        return this.to('DeleteVpcIngressConnection');
    }
    /**
     * Grants permission to retrieve the description of an AWS App Runner automatic scaling configuration resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_DescribeAutoScalingConfiguration.html
     */
    toDescribeAutoScalingConfiguration() {
        return this.to('DescribeAutoScalingConfiguration');
    }
    /**
     * Grants permission to retrieve descriptions of custom domain names associated with an AWS App Runner service
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_DescribeCustomDomains.html
     */
    toDescribeCustomDomains() {
        return this.to('DescribeCustomDomains');
    }
    /**
     * Grants permission to retrieve the description of an AWS App Runner observability configuration resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_DescribeObservabilityConfiguration.html
     */
    toDescribeObservabilityConfiguration() {
        return this.to('DescribeObservabilityConfiguration');
    }
    /**
     * Grants permission to retrieve the description of an operation that occurred on an AWS App Runner service
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_DescribeOperation.html
     */
    toDescribeOperation() {
        return this.to('DescribeOperation');
    }
    /**
     * Grants permission to retrieve the description of an AWS App Runner service resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_DescribeService.html
     */
    toDescribeService() {
        return this.to('DescribeService');
    }
    /**
     * Grants permission to retrieve the description of an AWS App Runner VPC connector resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_DescribeVpcConnector.html
     */
    toDescribeVpcConnector() {
        return this.to('DescribeVpcConnector');
    }
    /**
     * Grants permission to retrieve the description of an AWS App Runner VpcIngressConnection resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_DescribeVpcIngressConnection.html
     */
    toDescribeVpcIngressConnection() {
        return this.to('DescribeVpcIngressConnection');
    }
    /**
     * Grants permission to get the AWS WAF web ACL that is associated with an AWS App Runner service
     *
     * Access Level: Read
     */
    toDescribeWebAclForService() {
        return this.to('DescribeWebAclForService');
    }
    /**
     * Grants permission to disassociate a custom domain name from an AWS App Runner service
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_DisassociateCustomDomain.html
     */
    toDisassociateCustomDomain() {
        return this.to('DisassociateCustomDomain');
    }
    /**
     * Grants permission to disassociate the service with an AWS WAF web ACL
     *
     * Access Level: Write
     */
    toDisassociateWebAcl() {
        return this.to('DisassociateWebAcl');
    }
    /**
     * Grants permission to list the services that are associated with an AWS WAF web ACL
     *
     * Access Level: List
     */
    toListAssociatedServicesForWebAcl() {
        return this.to('ListAssociatedServicesForWebAcl');
    }
    /**
     * Grants permission to retrieve a list of AWS App Runner automatic scaling configurations in your AWS account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_ListAutoScalingConfigurations.html
     */
    toListAutoScalingConfigurations() {
        return this.to('ListAutoScalingConfigurations');
    }
    /**
     * Grants permission to retrieve a list of AWS App Runner connections in your AWS account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_ListConnections.html
     */
    toListConnections() {
        return this.to('ListConnections');
    }
    /**
     * Grants permission to retrieve a list of AWS App Runner observability configurations in your AWS account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_ListObservabilityConfigurations.html
     */
    toListObservabilityConfigurations() {
        return this.to('ListObservabilityConfigurations');
    }
    /**
     * Grants permission to retrieve a list of operations that occurred on an AWS App Runner service resource
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_ListOperations.html
     */
    toListOperations() {
        return this.to('ListOperations');
    }
    /**
     * Grants permission to retrieve a list of running AWS App Runner services in your AWS account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_ListServices.html
     */
    toListServices() {
        return this.to('ListServices');
    }
    /**
     * Grants permission to list tags associated with an AWS App Runner resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_ListTagsForResource.html
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Grants permission to retrieve a list of AWS App Runner VPC connectors in your AWS account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_ListVpcConnectors.html
     */
    toListVpcConnectors() {
        return this.to('ListVpcConnectors');
    }
    /**
     * Grants permission to retrieve a list of AWS App Runner VpcIngressConnections in your AWS account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_ListVpcConnections.html
     */
    toListVpcIngressConnections() {
        return this.to('ListVpcIngressConnections');
    }
    /**
     * Grants permission to pause an active AWS App Runner service
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_PauseService.html
     */
    toPauseService() {
        return this.to('PauseService');
    }
    /**
     * Grants permission to resume an active AWS App Runner service
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_ResumeService.html
     */
    toResumeService() {
        return this.to('ResumeService');
    }
    /**
     * Grants permission to initiate a manual deployemnt to an AWS App Runner service
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_StartDeployment.html
     */
    toStartDeployment() {
        return this.to('StartDeployment');
    }
    /**
     * Grants permission to add tags to, or update tag values of, an AWS App Runner resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_TagResource.html
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Grants permission to remove tags from an AWS App Runner resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_UntagResource.html
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Grants permission to update an AWS App Runner service resource
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifConnectionArn()
     * - .ifAutoScalingConfigurationArn()
     * - .ifObservabilityConfigurationArn()
     * - .ifVpcConnectorArn()
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_UpdateService.html
     */
    toUpdateService() {
        return this.to('UpdateService');
    }
    /**
     * Grants permission to update an AWS App Runner VpcIngressConnection resource
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifVpcId()
     * - .ifVpcEndpointId()
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_UpdateVpcIngressConnection.html
     */
    toUpdateVpcIngressConnection() {
        return this.to('UpdateVpcIngressConnection');
    }
    /**
     * Adds a resource of type service to the statement
     *
     * @param serviceName - Identifier for the serviceName.
     * @param serviceId - Identifier for the serviceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onService(serviceName, serviceId, account, region, partition) {
        return this.on(`arn:${partition || Apprunner.defaultPartition}:apprunner:${region || '*'}:${account || '*'}:service/${serviceName}/${serviceId}`);
    }
    /**
     * Adds a resource of type connection to the statement
     *
     * @param connectionName - Identifier for the connectionName.
     * @param connectionId - Identifier for the connectionId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onConnection(connectionName, connectionId, account, region, partition) {
        return this.on(`arn:${partition || Apprunner.defaultPartition}:apprunner:${region || '*'}:${account || '*'}:connection/${connectionName}/${connectionId}`);
    }
    /**
     * Adds a resource of type autoscalingconfiguration to the statement
     *
     * @param autoscalingConfigurationName - Identifier for the autoscalingConfigurationName.
     * @param autoscalingConfigurationVersion - Identifier for the autoscalingConfigurationVersion.
     * @param autoscalingConfigurationId - Identifier for the autoscalingConfigurationId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onAutoscalingconfiguration(autoscalingConfigurationName, autoscalingConfigurationVersion, autoscalingConfigurationId, account, region, partition) {
        return this.on(`arn:${partition || Apprunner.defaultPartition}:apprunner:${region || '*'}:${account || '*'}:autoscalingconfiguration/${autoscalingConfigurationName}/${autoscalingConfigurationVersion}/${autoscalingConfigurationId}`);
    }
    /**
     * Adds a resource of type observabilityconfiguration to the statement
     *
     * @param observabilityConfigurationName - Identifier for the observabilityConfigurationName.
     * @param observabilityConfigurationVersion - Identifier for the observabilityConfigurationVersion.
     * @param observabilityConfigurationId - Identifier for the observabilityConfigurationId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onObservabilityconfiguration(observabilityConfigurationName, observabilityConfigurationVersion, observabilityConfigurationId, account, region, partition) {
        return this.on(`arn:${partition || Apprunner.defaultPartition}:apprunner:${region || '*'}:${account || '*'}:observabilityconfiguration/${observabilityConfigurationName}/${observabilityConfigurationVersion}/${observabilityConfigurationId}`);
    }
    /**
     * Adds a resource of type vpcconnector to the statement
     *
     * @param vpcConnectorName - Identifier for the vpcConnectorName.
     * @param vpcConnectorVersion - Identifier for the vpcConnectorVersion.
     * @param vpcConnectorId - Identifier for the vpcConnectorId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onVpcconnector(vpcConnectorName, vpcConnectorVersion, vpcConnectorId, account, region, partition) {
        return this.on(`arn:${partition || Apprunner.defaultPartition}:apprunner:${region || '*'}:${account || '*'}:vpcconnector/${vpcConnectorName}/${vpcConnectorVersion}/${vpcConnectorId}`);
    }
    /**
     * Adds a resource of type vpcingressconnection to the statement
     *
     * @param vpcIngressConnectionName - Identifier for the vpcIngressConnectionName.
     * @param vpcIngressConnectionId - Identifier for the vpcIngressConnectionId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onVpcingressconnection(vpcIngressConnectionName, vpcIngressConnectionId, account, region, partition) {
        return this.on(`arn:${partition || Apprunner.defaultPartition}:apprunner:${region || '*'}:${account || '*'}:vpcingressconnection/${vpcIngressConnectionName}/${vpcIngressConnectionId}`);
    }
    /**
     * Adds a resource of type webacl to the statement
     *
     * @param scope - Identifier for the scope.
     * @param name - Identifier for the name.
     * @param id - Identifier for the id.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onWebacl(scope, name, id, account, region, partition) {
        return this.on(`arn:${partition || Apprunner.defaultPartition}:wafv2:${region || '*'}:${account || '*'}:${scope}/webacl/${name}/${id}`);
    }
    /**
     * Filters access by the CreateService and UpdateService actions based on the ARN of an associated AutoScalingConfiguration resource
     *
     * Applies to actions:
     * - .toCreateService()
     * - .toUpdateService()
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifAutoScalingConfigurationArn(value, operator) {
        return this.if(`AutoScalingConfigurationArn`, value, operator || 'ArnLike');
    }
    /**
     * Filters access by the CreateService and UpdateService actions based on the ARN of an associated Connection resource
     *
     * Applies to actions:
     * - .toCreateService()
     * - .toUpdateService()
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifConnectionArn(value, operator) {
        return this.if(`ConnectionArn`, value, operator || 'ArnLike');
    }
    /**
     * Filters access by the CreateService and UpdateService actions based on the ARN of an associated ObservabilityConfiguration resource
     *
     * Applies to actions:
     * - .toCreateService()
     * - .toUpdateService()
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifObservabilityConfigurationArn(value, operator) {
        return this.if(`ObservabilityConfigurationArn`, value, operator || 'ArnLike');
    }
    /**
     * Filters access by the CreateVpcIngressConnection action based on the ARN of an associated Service resource
     *
     * Applies to actions:
     * - .toCreateVpcIngressConnection()
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifServiceArn(value, operator) {
        return this.if(`ServiceArn`, value, operator || 'ArnLike');
    }
    /**
     * Filters access by the CreateService and UpdateService actions based on the ARN of an associated VpcConnector resource
     *
     * Applies to actions:
     * - .toCreateService()
     * - .toUpdateService()
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifVpcConnectorArn(value, operator) {
        return this.if(`VpcConnectorArn`, value, operator || 'ArnLike');
    }
    /**
     * Filters access by the CreateVpcIngressConnection and UpdateVpcIngressConnection actions based on the VPC Endpoint in the request
     *
     * Applies to actions:
     * - .toCreateVpcIngressConnection()
     * - .toUpdateVpcIngressConnection()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifVpcEndpointId(value, operator) {
        return this.if(`VpcEndpointId`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the CreateVpcIngressConnection and UpdateVpcIngressConnection actions based on the VPC in the request
     *
     * Applies to actions:
     * - .toCreateVpcIngressConnection()
     * - .toUpdateVpcIngressConnection()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifVpcId(value, operator) {
        return this.if(`VpcId`, value, operator || 'StringLike');
    }
}
exports.Apprunner = Apprunner;
_a = JSII_RTTI_SYMBOL_1;
Apprunner[_a] = { fqn: "iam-floyd.Apprunner", version: "0.505.0" };
//# sourceMappingURL=data:application/json;base64,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