import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [codewhisperer](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncodewhisperer.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Codewhisperer extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [codewhisperer](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncodewhisperer.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to invoke CreateProfile on CodeWhisperer
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codewhisperer/latest/dg/API_CreateProfile.html
     */
    toCreateProfile(): this;
    /**
     * Grants permission to invoke GenerateRecommendations on CodeWhisperer
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codewhisperer/latest/dg/API_GenerateRecommendations.html
     */
    toGenerateRecommendations(): this;
    /**
     * Grants permission to invoke ListProfiles on CodeWhisperer
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/codewhisperer/latest/dg/API_ListProfiles.html
     */
    toListProfiles(): this;
    /**
     * Grants permission to invoke UpdateProfile on CodeWhisperer
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codewhisperer/latest/dg/API_UpdateProfile.html
     */
    toUpdateProfile(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type profile to the statement
     *
     * https://docs.aws.amazon.com/codewhisperer/latest/dg/profile.html
     *
     * @param identifier - Identifier for the identifier.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onProfile(identifier: string, account?: string, partition?: string): this;
}
