"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Datazonecontrol = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [datazonecontrol](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazondatazonecontrol.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Datazonecontrol extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [datazonecontrol](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazondatazonecontrol.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'datazonecontrol';
        this.accessLevelList = {
            Write: [
                'CreateAccountAssociationInvitation',
                'CreateDataSource',
                'CreateEnvironment',
                'DeleteDataSource',
                'DeleteEnvironment',
                'DissociateAccount',
                'ReviewAccountAssociationInvitation',
                'UpdateAccountAssociationDescription',
                'UpdateDataSource',
                'UpdateEnvironment'
            ],
            Read: [
                'GetAssociatedDomain',
                'GetDataSourceByEnvironment',
                'GetDomain',
                'GetEnvironment',
                'GetMetadataCollector',
                'GetUserPortalLoginAuthCode',
                'ListTagsForResource'
            ],
            List: [
                'ListAccountAssociationInvitations',
                'ListAllAssociatedAccountsForEnvironment',
                'ListAssociatedEnvironments',
                'ListDataSources',
                'ListDataSourcesByEnvironment',
                'ListDomains',
                'ListEnvironment',
                'ListMetadataCollectorRuns',
                'ListMetadataCollectors',
                'ListProjects'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
    /**
     * Grants permission to request association of an account with a given domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/datazone/latest/userguide/what-is-datazone.html#accessing-datazone
     */
    toCreateAccountAssociationInvitation() {
        return this.to('CreateAccountAssociationInvitation');
    }
    /**
     * Grants permission to create Amazon DataZone data sources used for publishing and subscribing to data
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/datazone/latest/userguide/what-is-datazone.html#accessing-datazone
     */
    toCreateDataSource() {
        return this.to('CreateDataSource');
    }
    /**
     * Grants permission to provision a root-domain which is a top level entity that contains other Amazon DataZone resources
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/datazone/latest/userguide/what-is-datazone.html#accessing-datazone
     */
    toCreateEnvironment() {
        return this.to('CreateEnvironment');
    }
    /**
     * Grants permission to delete a data source
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/datazone/latest/userguide/what-is-datazone.html#accessing-datazone
     */
    toDeleteDataSource() {
        return this.to('DeleteDataSource');
    }
    /**
     * Grants permission to delete a provisioned root-domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/datazone/latest/userguide/what-is-datazone.html#accessing-datazone
     */
    toDeleteEnvironment() {
        return this.to('DeleteEnvironment');
    }
    /**
     * Grants permission to disassociate an account with a given domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/datazone/latest/userguide/what-is-datazone.html#accessing-datazone
     */
    toDissociateAccount() {
        return this.to('DissociateAccount');
    }
    /**
     * Grants permission to retrieve information about any associated domain in the associated account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/datazone/latest/userguide/what-is-datazone.html#accessing-datazone
     */
    toGetAssociatedDomain() {
        return this.to('GetAssociatedDomain');
    }
    /**
     * Grants permission to retrieve any data source under any domain for a given root-domain
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/datazone/latest/userguide/what-is-datazone.html#accessing-datazone
     */
    toGetDataSourceByEnvironment() {
        return this.to('GetDataSourceByEnvironment');
    }
    /**
     * Grants permission to retrieve information about any domain in the account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/datazone/latest/userguide/what-is-datazone.html#accessing-datazone
     */
    toGetDomain() {
        return this.to('GetDomain');
    }
    /**
     * Grants permission to retrieve information about a root-domain
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/datazone/latest/userguide/what-is-datazone.html#accessing-datazone
     */
    toGetEnvironment() {
        return this.to('GetEnvironment');
    }
    /**
     * Grants permission to retrieve a publishing job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/datazone/latest/userguide/what-is-datazone.html#accessing-datazone
     */
    toGetMetadataCollector() {
        return this.to('GetMetadataCollector');
    }
    /**
     * Grants permission to retrieve credentials to log into Amazon DataZone data portal from AWS management console
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/datazone/latest/userguide/what-is-datazone.html#accessing-datazone
     */
    toGetUserPortalLoginAuthCode() {
        return this.to('GetUserPortalLoginAuthCode');
    }
    /**
     * Grants permission to retrieve all account-association invitations for a given associated account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/datazone/latest/userguide/what-is-datazone.html#accessing-datazone
     */
    toListAccountAssociationInvitations() {
        return this.to('ListAccountAssociationInvitations');
    }
    /**
     * Grants permission to list all associated accounts under the given root-domain, including accounts associated to its sub-domains
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/datazone/latest/userguide/what-is-datazone.html#accessing-datazone
     */
    toListAllAssociatedAccountsForEnvironment() {
        return this.to('ListAllAssociatedAccountsForEnvironment');
    }
    /**
     * Grants permission to lists all the associated domains for a given associated account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/datazone/latest/userguide/what-is-datazone.html#accessing-datazone
     */
    toListAssociatedEnvironments() {
        return this.to('ListAssociatedEnvironments');
    }
    /**
     * Grants permission to retrieve all data sources under any domain in the associated account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/datazone/latest/userguide/what-is-datazone.html#accessing-datazone
     */
    toListDataSources() {
        return this.to('ListDataSources');
    }
    /**
     * Grants permission to retrieve all data sources under any domain for a given root-domain
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/datazone/latest/userguide/what-is-datazone.html#accessing-datazone
     */
    toListDataSourcesByEnvironment() {
        return this.to('ListDataSourcesByEnvironment');
    }
    /**
     * Grants permission to list all the sub-domains for a given domain or a root-domain
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/datazone/latest/userguide/what-is-datazone.html#accessing-datazone
     */
    toListDomains() {
        return this.to('ListDomains');
    }
    /**
     * Grants permission to retrieve all root-domains
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/datazone/latest/userguide/what-is-datazone.html#accessing-datazone
     */
    toListEnvironment() {
        return this.to('ListEnvironment');
    }
    /**
     * Grants permission to list all runs for a given publishing job through Amazon DataZone console for a data source
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/datazone/latest/userguide/what-is-datazone.html#accessing-datazone
     */
    toListMetadataCollectorRuns() {
        return this.to('ListMetadataCollectorRuns');
    }
    /**
     * Grants permission to retrieve all publishing jobs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/datazone/latest/userguide/what-is-datazone.html#accessing-datazone
     */
    toListMetadataCollectors() {
        return this.to('ListMetadataCollectors');
    }
    /**
     * Grants permission to retrieve all Amazon DataZone projects
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/datazone/latest/userguide/what-is-datazone.html#accessing-datazone
     */
    toListProjects() {
        return this.to('ListProjects');
    }
    /**
     * Grants permission to retrieve all tags associated with a resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/datazone/latest/userguide/what-is-datazone.html#accessing-datazone
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Grants permission to accept or reject the pending association requests for the given account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/datazone/latest/userguide/what-is-datazone.html#accessing-datazone
     */
    toReviewAccountAssociationInvitation() {
        return this.to('ReviewAccountAssociationInvitation');
    }
    /**
     * Grants permission to add or update tags to a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/datazone/latest/userguide/what-is-datazone.html#accessing-datazone
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Grants permission to remove tags associated with a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/datazone/latest/userguide/what-is-datazone.html#accessing-datazone
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Grants permission to update the description of the account association of the given associated account and given domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/datazone/latest/userguide/what-is-datazone.html#accessing-datazone
     */
    toUpdateAccountAssociationDescription() {
        return this.to('UpdateAccountAssociationDescription');
    }
    /**
     * Grants permission to update a data source
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/datazone/latest/userguide/what-is-datazone.html#accessing-datazone
     */
    toUpdateDataSource() {
        return this.to('UpdateDataSource');
    }
    /**
     * Grants permission to update information for a root-domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/datazone/latest/userguide/what-is-datazone.html#accessing-datazone
     */
    toUpdateEnvironment() {
        return this.to('UpdateEnvironment');
    }
    /**
     * Adds a resource of type environment to the statement
     *
     * https://docs.aws.amazon.com/datazone/latest/userguide/create-root-domain.html
     *
     * @param domainId - Identifier for the domainId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onEnvironment(domainId, account, region, partition) {
        return this.on(`arn:${partition || Datazonecontrol.defaultPartition}:datazonecontrol:${region || '*'}:${account || '*'}:domain/${domainId}`);
    }
    /**
     * Adds a resource of type data-source to the statement
     *
     * https://docs.aws.amazon.com/datazone/latest/userguide/create-glue-data-source.html
     *
     * @param domainId - Identifier for the domainId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onDataSource(domainId, account, region, partition) {
        return this.on(`arn:${partition || Datazonecontrol.defaultPartition}:datazonecontrol:${region || '*'}:${account || '*'}:data-source/${domainId}`);
    }
}
exports.Datazonecontrol = Datazonecontrol;
_a = JSII_RTTI_SYMBOL_1;
Datazonecontrol[_a] = { fqn: "iam-floyd.Datazonecontrol", version: "0.505.0" };
//# sourceMappingURL=data:application/json;base64,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