"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DevopsGuru = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [devops-guru](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazondevopsguru.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class DevopsGuru extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [devops-guru](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazondevopsguru.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'devops-guru';
        this.accessLevelList = {
            Write: [
                'AddNotificationChannel',
                'DeleteInsight',
                'PutFeedback',
                'RemoveNotificationChannel',
                'UpdateEventSourcesConfig',
                'UpdateResourceCollection',
                'UpdateServiceIntegration'
            ],
            Read: [
                'DescribeAccountHealth',
                'DescribeAccountOverview',
                'DescribeAnomaly',
                'DescribeEventSourcesConfig',
                'DescribeFeedback',
                'DescribeInsight',
                'DescribeOrganizationHealth',
                'DescribeOrganizationOverview',
                'DescribeOrganizationResourceCollectionHealth',
                'DescribeResourceCollectionHealth',
                'DescribeServiceIntegration',
                'GetCostEstimation',
                'GetResourceCollection',
                'StartCostEstimation'
            ],
            List: [
                'ListAnomaliesForInsight',
                'ListAnomalousLogGroups',
                'ListEvents',
                'ListInsights',
                'ListMonitoredResources',
                'ListNotificationChannels',
                'ListOrganizationInsights',
                'ListRecommendations',
                'SearchInsights',
                'SearchOrganizationInsights'
            ]
        };
    }
    /**
     * Grants permission to add a notification channel to DevOps Guru
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - sns:GetTopicAttributes
     * - sns:SetTopicAttributes
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_AddNotificationChannel.html
     */
    toAddNotificationChannel() {
        return this.to('AddNotificationChannel');
    }
    /**
     * Grants permission to delete specified insight in your account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_DeleteInsight.html
     */
    toDeleteInsight() {
        return this.to('DeleteInsight');
    }
    /**
     * Grants permission to view the health of operations in your AWS account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_DescribeAccountHealth.html
     */
    toDescribeAccountHealth() {
        return this.to('DescribeAccountHealth');
    }
    /**
     * Grants permission to view the health of operations within a time range in your AWS account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_DescribeAccountOverview.html
     */
    toDescribeAccountOverview() {
        return this.to('DescribeAccountOverview');
    }
    /**
     * Grants permission to list the details of a specified anomaly
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_DescribeAnomaly.html
     */
    toDescribeAnomaly() {
        return this.to('DescribeAnomaly');
    }
    /**
     * Grants permission to retrieve details about event sources for DevOps Guru
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_DescribeEventSourcesConfig.html
     */
    toDescribeEventSourcesConfig() {
        return this.to('DescribeEventSourcesConfig');
    }
    /**
     * Grants permission to view the feedback details of a specified insight
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_DescribeFeedback.html
     */
    toDescribeFeedback() {
        return this.to('DescribeFeedback');
    }
    /**
     * Grants permission to list the details of a specified insight
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_DescribeInsight.html
     */
    toDescribeInsight() {
        return this.to('DescribeInsight');
    }
    /**
     * Grants permission to view the health of operations in your organization
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_DescribeOrganizationHealth.html
     */
    toDescribeOrganizationHealth() {
        return this.to('DescribeOrganizationHealth');
    }
    /**
     * Grants permission to view the health of operations within a time range in your organization
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_DescribeOrganizationOverview.html
     */
    toDescribeOrganizationOverview() {
        return this.to('DescribeOrganizationOverview');
    }
    /**
     * Grants permission to view the health of operations for each AWS CloudFormation stack or AWS Services or accounts specified in DevOps Guru in your organization
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_DescribeOrganizationResourceCollectionHealth.html
     */
    toDescribeOrganizationResourceCollectionHealth() {
        return this.to('DescribeOrganizationResourceCollectionHealth');
    }
    /**
     * Grants permission to view the health of operations for each AWS CloudFormation stack specified in DevOps Guru
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_DescribeResourceCollectionHealth.html
     */
    toDescribeResourceCollectionHealth() {
        return this.to('DescribeResourceCollectionHealth');
    }
    /**
     * Grants permission to view the integration status of services that can be integrated with DevOps Guru
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_DescribeServiceIntegration.html
     */
    toDescribeServiceIntegration() {
        return this.to('DescribeServiceIntegration');
    }
    /**
     * Grants permission to list service resource cost estimates
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_GetCostEstimation.html
     */
    toGetCostEstimation() {
        return this.to('GetCostEstimation');
    }
    /**
     * Grants permission to list AWS CloudFormation stacks that DevOps Guru is configured to use
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_GetResourceCollection.html
     */
    toGetResourceCollection() {
        return this.to('GetResourceCollection');
    }
    /**
     * Grants permission to list anomalies of a given insight in your account
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifServiceNames()
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_ListAnomaliesForInsight.html
     */
    toListAnomaliesForInsight() {
        return this.to('ListAnomaliesForInsight');
    }
    /**
     * Grants permission to list log anomalies of a given insight in your account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_ListAnomalousLogGroups.html
     */
    toListAnomalousLogGroups() {
        return this.to('ListAnomalousLogGroups');
    }
    /**
     * Grants permission to list resource events that are evaluated by DevOps Guru
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_ListEvents.html
     */
    toListEvents() {
        return this.to('ListEvents');
    }
    /**
     * Grants permission to list insights in your account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_ListInsights.html
     */
    toListInsights() {
        return this.to('ListInsights');
    }
    /**
     * Grants permission to list resource monitored by DevOps Guru in your account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_ListMonitoredResources.html
     */
    toListMonitoredResources() {
        return this.to('ListMonitoredResources');
    }
    /**
     * Grants permission to list notification channels configured for DevOps Guru in your account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_ListNotificationChannels.html
     */
    toListNotificationChannels() {
        return this.to('ListNotificationChannels');
    }
    /**
     * Grants permission to list insights in your organization
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_ListOrganizationInsights.html
     */
    toListOrganizationInsights() {
        return this.to('ListOrganizationInsights');
    }
    /**
     * Grants permission to list a specified insight's recommendations
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_ListRecommendations.html
     */
    toListRecommendations() {
        return this.to('ListRecommendations');
    }
    /**
     * Grants permission to submit a feedback to DevOps Guru
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_PutFeedback.html
     */
    toPutFeedback() {
        return this.to('PutFeedback');
    }
    /**
     * Grants permission to remove a notification channel from DevOps Guru
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - sns:GetTopicAttributes
     * - sns:SetTopicAttributes
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_RemoveNotificationChannel.html
     */
    toRemoveNotificationChannel() {
        return this.to('RemoveNotificationChannel');
    }
    /**
     * Grants permission to search insights in your account
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifServiceNames()
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_SearchInsights.html
     */
    toSearchInsights() {
        return this.to('SearchInsights');
    }
    /**
     * Grants permission to search insights in your organization
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_SearchOrganizationInsights.html
     */
    toSearchOrganizationInsights() {
        return this.to('SearchOrganizationInsights');
    }
    /**
     * Grants permission to start the creation of an estimate of the monthly cost
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_StartCostEstimation.html
     */
    toStartCostEstimation() {
        return this.to('StartCostEstimation');
    }
    /**
     * Grants permission to update an event source for DevOps Guru
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_UpdateEventSourcesConfig.html
     */
    toUpdateEventSourcesConfig() {
        return this.to('UpdateEventSourcesConfig');
    }
    /**
     * Grants permission to update the list of AWS CloudFormation stacks that are used to specify which AWS resources in your account are analyzed by DevOps Guru
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_UpdateResourceCollection.html
     */
    toUpdateResourceCollection() {
        return this.to('UpdateResourceCollection');
    }
    /**
     * Grants permission to enable or disable a service that integrates with DevOps Guru
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_UpdateServiceIntegration.html
     */
    toUpdateServiceIntegration() {
        return this.to('UpdateServiceIntegration');
    }
    /**
     * Adds a resource of type topic to the statement
     *
     * https://docs.aws.amazon.com/devops-guru/latest/userguide/setting-up.html#setting-up-notifications
     *
     * @param topicName - Identifier for the topicName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onTopic(topicName, account, region, partition) {
        return this.on(`arn:${partition || DevopsGuru.defaultPartition}:sns:${region || '*'}:${account || '*'}:${topicName}`);
    }
    /**
     * Filters access by API to restrict access to given AWS service names
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_ServiceCollection.html
     *
     * Applies to actions:
     * - .toListAnomaliesForInsight()
     * - .toSearchInsights()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifServiceNames(value, operator) {
        return this.if(`ServiceNames`, value, operator || 'StringLike');
    }
}
exports.DevopsGuru = DevopsGuru;
_a = JSII_RTTI_SYMBOL_1;
DevopsGuru[_a] = { fqn: "iam-floyd.DevopsGuru", version: "0.505.0" };
//# sourceMappingURL=data:application/json;base64,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