"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IdentitySync = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [identity-sync](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsidentitysync.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class IdentitySync extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [identity-sync](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsidentitysync.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'identity-sync';
        this.accessLevelList = {
            Write: [
                'CreateSyncFilter',
                'CreateSyncProfile',
                'CreateSyncTarget',
                'DeleteSyncFilter',
                'DeleteSyncProfile',
                'DeleteSyncTarget',
                'StartSync',
                'StopSync',
                'UpdateSyncTarget'
            ],
            Read: [
                'GetSyncProfile',
                'GetSyncTarget'
            ],
            List: [
                'ListSyncFilters'
            ]
        };
    }
    /**
     * Grants permission to create a sync filter on the sync profile
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/security-iam-awsmanpol.html
     */
    toCreateSyncFilter() {
        return this.to('CreateSyncFilter');
    }
    /**
     * Grants permission to create a sync profile for the identity source
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ds:AuthorizeApplication
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/security-iam-awsmanpol.html
     */
    toCreateSyncProfile() {
        return this.to('CreateSyncProfile');
    }
    /**
     * Grants permission to create a sync target for the identity source
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/security-iam-awsmanpol.html
     */
    toCreateSyncTarget() {
        return this.to('CreateSyncTarget');
    }
    /**
     * Grants permission to delete a sync filter from the sync profile
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/security-iam-awsmanpol.html
     */
    toDeleteSyncFilter() {
        return this.to('DeleteSyncFilter');
    }
    /**
     * Grants permission to delete a sync profile from the source
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ds:UnauthorizeApplication
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/security-iam-awsmanpol.html
     */
    toDeleteSyncProfile() {
        return this.to('DeleteSyncProfile');
    }
    /**
     * Grants permission to delete a sync target from the source
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/security-iam-awsmanpol.html
     */
    toDeleteSyncTarget() {
        return this.to('DeleteSyncTarget');
    }
    /**
     * Grants permission to retrieve a sync profile by using a sync profile name
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/security-iam-awsmanpol.html
     */
    toGetSyncProfile() {
        return this.to('GetSyncProfile');
    }
    /**
     * Grants permission to retrieve a sync target from the sync profile
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/security-iam-awsmanpol.html
     */
    toGetSyncTarget() {
        return this.to('GetSyncTarget');
    }
    /**
     * Grants permission to list the sync filters from the sync profile
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/security-iam-awsmanpol.html
     */
    toListSyncFilters() {
        return this.to('ListSyncFilters');
    }
    /**
     * Grants permission to start a sync process or to resume a sync process that was previously paused
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/security-iam-awsmanpol.html
     */
    toStartSync() {
        return this.to('StartSync');
    }
    /**
     * Grants permission to stop any planned sync process in the sync schedule from starting
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/security-iam-awsmanpol.html
     */
    toStopSync() {
        return this.to('StopSync');
    }
    /**
     * Grants permission to update a sync target on the sync profile
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/security-iam-awsmanpol.html
     */
    toUpdateSyncTarget() {
        return this.to('UpdateSyncTarget');
    }
    /**
     * Adds a resource of type SyncProfileResource to the statement
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/security-iam-awsmanpol.html
     *
     * @param syncProfileName - Identifier for the syncProfileName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onSyncProfileResource(syncProfileName, account, region, partition) {
        return this.on(`arn:${partition || IdentitySync.defaultPartition}:identity-sync:${region || '*'}:${account || '*'}:profile/${syncProfileName}`);
    }
    /**
     * Adds a resource of type SyncTargetResource to the statement
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/security-iam-awsmanpol.html
     *
     * @param syncProfileName - Identifier for the syncProfileName.
     * @param syncTargetName - Identifier for the syncTargetName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onSyncTargetResource(syncProfileName, syncTargetName, account, region, partition) {
        return this.on(`arn:${partition || IdentitySync.defaultPartition}:identity-sync:${region || '*'}:${account || '*'}:target/${syncProfileName}/${syncTargetName}`);
    }
}
exports.IdentitySync = IdentitySync;
_a = JSII_RTTI_SYMBOL_1;
IdentitySync[_a] = { fqn: "iam-floyd.IdentitySync", version: "0.505.0" };
//# sourceMappingURL=data:application/json;base64,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