"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Panorama = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [panorama](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awspanorama.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Panorama extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [panorama](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awspanorama.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'panorama';
        this.accessLevelList = {
            Write: [
                'CreateApplicationInstance',
                'CreateJobForDevices',
                'CreateNodeFromTemplateJob',
                'CreatePackage',
                'CreatePackageImportJob',
                'DeleteDevice',
                'DeletePackage',
                'DeregisterPackageVersion',
                'ProvisionDevice',
                'RegisterPackageVersion',
                'RemoveApplicationInstance',
                'SignalApplicationInstanceNodeInstances',
                'UpdateDeviceMetadata'
            ],
            Read: [
                'DescribeApplicationInstance',
                'DescribeApplicationInstanceDetails',
                'DescribeDevice',
                'DescribeDeviceJob',
                'DescribeNode',
                'DescribeNodeFromTemplateJob',
                'DescribePackage',
                'DescribePackageImportJob',
                'DescribePackageVersion',
                'DescribeSoftware',
                'GetWebSocketURL',
                'ListTagsForResource'
            ],
            List: [
                'ListApplicationInstanceDependencies',
                'ListApplicationInstanceNodeInstances',
                'ListApplicationInstances',
                'ListDevices',
                'ListDevicesJobs',
                'ListNodeFromTemplateJobs',
                'ListNodes',
                'ListPackageImportJobs',
                'ListPackages'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
    /**
     * Grants permission to create an AWS Panorama Application Instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/panorama/latest/api/API_CreateApplicationInstance.html
     */
    toCreateApplicationInstance() {
        return this.to('CreateApplicationInstance');
    }
    /**
     * Grants permission to create a job for an AWS Panorama Appliance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/api/API_CreateJobForDevices.html
     */
    toCreateJobForDevices() {
        return this.to('CreateJobForDevices');
    }
    /**
     * Grants permission to create an AWS Panorama Node
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/api/API_CreateNodeFromTemplateJob.html
     */
    toCreateNodeFromTemplateJob() {
        return this.to('CreateNodeFromTemplateJob');
    }
    /**
     * Grants permission to create an AWS Panorama Package
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/panorama/latest/api/API_CreatePackage.html
     */
    toCreatePackage() {
        return this.to('CreatePackage');
    }
    /**
     * Grants permission to create an AWS Panorama Package
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/api/API_CreatePackageImportJob.html
     */
    toCreatePackageImportJob() {
        return this.to('CreatePackageImportJob');
    }
    /**
     * Grants permission to deregister an AWS Panorama Appliance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/api/API_DeleteDevice.html
     */
    toDeleteDevice() {
        return this.to('DeleteDevice');
    }
    /**
     * Grants permission to delete an AWS Panorama Package
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/api/API_DeletePackage.html
     */
    toDeletePackage() {
        return this.to('DeletePackage');
    }
    /**
     * Grants permission to deregister an AWS Panorama package version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/api/API_DeregisterPackageVersion.html
     */
    toDeregisterPackageVersion() {
        return this.to('DeregisterPackageVersion');
    }
    /**
     * Grants permission to view details about an AWS Panorama application instance
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/api/API_DescribeApplicationInstance.html
     */
    toDescribeApplicationInstance() {
        return this.to('DescribeApplicationInstance');
    }
    /**
     * Grants permission to view details about an AWS Panorama application instance
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/api/API_DescribeApplicationInstanceDetails.html
     */
    toDescribeApplicationInstanceDetails() {
        return this.to('DescribeApplicationInstanceDetails');
    }
    /**
     * Grants permission to view details about an AWS Panorama Appliance
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/api/API_DescribeDevice.html
     */
    toDescribeDevice() {
        return this.to('DescribeDevice');
    }
    /**
     * Grants permission to view job details for an AWS Panorama Appliance
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/api/API_DescribeDeviceJob.html
     */
    toDescribeDeviceJob() {
        return this.to('DescribeDeviceJob');
    }
    /**
     * Grants permission to view details about an AWS Panorama application node
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/api/API_DescribeNode.html
     */
    toDescribeNode() {
        return this.to('DescribeNode');
    }
    /**
     * Grants permission to view details about AWS Panorama application node
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/api/API_DescribeNodeFromTemplateJob.html
     */
    toDescribeNodeFromTemplateJob() {
        return this.to('DescribeNodeFromTemplateJob');
    }
    /**
     * Grants permission to view details about an AWS Panorama package
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/api/API_DescribePackage.html
     */
    toDescribePackage() {
        return this.to('DescribePackage');
    }
    /**
     * Grants permission to view details about an AWS Panorama package
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/api/API_DescribePackageImportJob.html
     */
    toDescribePackageImportJob() {
        return this.to('DescribePackageImportJob');
    }
    /**
     * Grants permission to view details about an AWS Panorama package version
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/api/API_DescribePackageVersion.html
     */
    toDescribePackageVersion() {
        return this.to('DescribePackageVersion');
    }
    /**
     * Grants permission to view details about a software version for the AWS Panorama Appliance
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awspanorama.html
     */
    toDescribeSoftware() {
        return this.to('DescribeSoftware');
    }
    /**
     * Grants permission to generate a WebSocket endpoint for communication with AWS Panorama
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awspanorama.html
     */
    toGetWebSocketURL() {
        return this.to('GetWebSocketURL');
    }
    /**
     * Grants permission to retrieve a list of application instance dependencies in AWS Panorama
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/panorama/latest/api/API_ListApplicationInstanceDependencies.html
     */
    toListApplicationInstanceDependencies() {
        return this.to('ListApplicationInstanceDependencies');
    }
    /**
     * Grants permission to retrieve a list of node instances of application instances in AWS Panorama
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/panorama/latest/api/API_ListApplicationInstanceNodeInstances.html
     */
    toListApplicationInstanceNodeInstances() {
        return this.to('ListApplicationInstanceNodeInstances');
    }
    /**
     * Grants permission to retrieve a list of application instances in AWS Panorama
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/panorama/latest/api/API_ListApplicationInstances.html
     */
    toListApplicationInstances() {
        return this.to('ListApplicationInstances');
    }
    /**
     * Grants permission to retrieve a list of appliances in AWS Panorama
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/panorama/latest/api/API_ListDevices.html
     */
    toListDevices() {
        return this.to('ListDevices');
    }
    /**
     * Grants permission to retrieve a list of jobs for an AWS Panorama Appliance
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/panorama/latest/api/API_ListDevicesJobs.html
     */
    toListDevicesJobs() {
        return this.to('ListDevicesJobs');
    }
    /**
     * Grants permission to retrieve a list of Nodes for an AWS Panorama Appliance
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/panorama/latest/api/API_ListNodeFromTemplateJobs.html
     */
    toListNodeFromTemplateJobs() {
        return this.to('ListNodeFromTemplateJobs');
    }
    /**
     * Grants permission to retrieve a list of nodes in AWS Panorama
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/panorama/latest/api/API_ListNodes.html
     */
    toListNodes() {
        return this.to('ListNodes');
    }
    /**
     * Grants permission to retrieve a list of packages in AWS Panorama
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/panorama/latest/api/API_ListPackageImportJobs.html
     */
    toListPackageImportJobs() {
        return this.to('ListPackageImportJobs');
    }
    /**
     * Grants permission to retrieve a list of packages in AWS Panorama
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/panorama/latest/api/API_ListPackages.html
     */
    toListPackages() {
        return this.to('ListPackages');
    }
    /**
     * Grants permission to retrieve a list of tags for a resource in AWS Panorama
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/panorama/latest/api/API_ListTagsForResource.html
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Grants permission to register an AWS Panorama Appliance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/panorama/latest/api/API_ProvisionDevice.html
     */
    toProvisionDevice() {
        return this.to('ProvisionDevice');
    }
    /**
     * Grants permission to register an AWS Panorama package version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/api/API_RegisterPackageVersion.html
     */
    toRegisterPackageVersion() {
        return this.to('RegisterPackageVersion');
    }
    /**
     * Grants permission to remove an AWS Panorama application instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/api/API_RemoveApplicationInstance.html
     */
    toRemoveApplicationInstance() {
        return this.to('RemoveApplicationInstance');
    }
    /**
     * Grants permission to signal camera nodes in an application instance to pause or resume
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/api/API_SignalApplicationInstanceNodeInstances.html
     */
    toSignalApplicationInstanceNodeInstances() {
        return this.to('SignalApplicationInstanceNodeInstances');
    }
    /**
     * Grants permission to add tags to a resource in AWS Panorama
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/panorama/latest/api/API_TagResource.html
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Grants permission to remove tags from a resource in AWS Panorama
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/panorama/latest/api/API_UntagResource.html
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Grants permission to modify basic settings for an AWS Panorama Appliance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/panorama/latest/api/API_UpdateDeviceMetadata.html
     */
    toUpdateDeviceMetadata() {
        return this.to('UpdateDeviceMetadata');
    }
    /**
     * Adds a resource of type device to the statement
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/gettingstarted-concepts.html#gettingstarted-concepts-appliance
     *
     * @param deviceId - Identifier for the deviceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onDevice(deviceId, account, region, partition) {
        return this.on(`arn:${partition || Panorama.defaultPartition}:panorama:${region || '*'}:${account || '*'}:device/${deviceId}`);
    }
    /**
     * Adds a resource of type package to the statement
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/gettingstarted-concepts.html#gettingstarted-concepts-node
     *
     * @param packageId - Identifier for the packageId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onPackage(packageId, account, region, partition) {
        return this.on(`arn:${partition || Panorama.defaultPartition}:panorama:${region || '*'}:${account || '*'}:package/${packageId}`);
    }
    /**
     * Adds a resource of type applicationInstance to the statement
     *
     * https://docs.aws.amazon.com/panorama/latest/dev/gettingstarted-concepts.html#gettingstarted-concepts-application
     *
     * @param applicationInstanceId - Identifier for the applicationInstanceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onApplicationInstance(applicationInstanceId, account, region, partition) {
        return this.on(`arn:${partition || Panorama.defaultPartition}:panorama:${region || '*'}:${account || '*'}:applicationInstance/${applicationInstanceId}`);
    }
}
exports.Panorama = Panorama;
_a = JSII_RTTI_SYMBOL_1;
Panorama[_a] = { fqn: "iam-floyd.Panorama", version: "0.505.0" };
//# sourceMappingURL=data:application/json;base64,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