"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Route53 = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [route53](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonroute53.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Route53 extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [route53](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonroute53.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'route53';
        this.accessLevelList = {
            Write: [
                'ActivateKeySigningKey',
                'AssociateVPCWithHostedZone',
                'ChangeCidrCollection',
                'ChangeResourceRecordSets',
                'CreateCidrCollection',
                'CreateHealthCheck',
                'CreateHostedZone',
                'CreateKeySigningKey',
                'CreateQueryLoggingConfig',
                'CreateReusableDelegationSet',
                'CreateTrafficPolicy',
                'CreateTrafficPolicyInstance',
                'CreateTrafficPolicyVersion',
                'CreateVPCAssociationAuthorization',
                'DeactivateKeySigningKey',
                'DeleteCidrCollection',
                'DeleteHealthCheck',
                'DeleteHostedZone',
                'DeleteKeySigningKey',
                'DeleteQueryLoggingConfig',
                'DeleteReusableDelegationSet',
                'DeleteTrafficPolicy',
                'DeleteTrafficPolicyInstance',
                'DeleteVPCAssociationAuthorization',
                'DisableHostedZoneDNSSEC',
                'DisassociateVPCFromHostedZone',
                'EnableHostedZoneDNSSEC',
                'UpdateHealthCheck',
                'UpdateHostedZoneComment',
                'UpdateTrafficPolicyComment',
                'UpdateTrafficPolicyInstance'
            ],
            Tagging: [
                'ChangeTagsForResource'
            ],
            Read: [
                'GetAccountLimit',
                'GetDNSSEC',
                'GetHealthCheck',
                'GetHostedZoneLimit',
                'GetQueryLoggingConfig',
                'GetReusableDelegationSetLimit',
                'GetTrafficPolicy',
                'GetTrafficPolicyInstance',
                'GetTrafficPolicyInstanceCount',
                'ListGeoLocations',
                'ListHealthChecks',
                'ListReusableDelegationSets',
                'ListTagsForResource',
                'ListTagsForResources',
                'ListTrafficPolicyInstances',
                'TestDNSAnswer'
            ],
            List: [
                'GetChange',
                'GetCheckerIpRanges',
                'GetGeoLocation',
                'GetHealthCheckCount',
                'GetHealthCheckLastFailureReason',
                'GetHealthCheckStatus',
                'GetHostedZone',
                'GetHostedZoneCount',
                'GetReusableDelegationSet',
                'ListCidrBlocks',
                'ListCidrCollections',
                'ListCidrLocations',
                'ListHostedZones',
                'ListHostedZonesByName',
                'ListHostedZonesByVPC',
                'ListQueryLoggingConfigs',
                'ListResourceRecordSets',
                'ListTrafficPolicies',
                'ListTrafficPolicyInstancesByHostedZone',
                'ListTrafficPolicyInstancesByPolicy',
                'ListTrafficPolicyVersions',
                'ListVPCAssociationAuthorizations'
            ]
        };
    }
    /**
     * Grants permission to activate a key-signing key so that it can be used for signing by DNSSEC
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_ActivateKeySigningKey.html
     */
    toActivateKeySigningKey() {
        return this.to('ActivateKeySigningKey');
    }
    /**
     * Grants permission to associate an additional Amazon VPC with a private hosted zone
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ec2:DescribeVpcs
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_AssociateVPCWithHostedZone.html
     */
    toAssociateVPCWithHostedZone() {
        return this.to('AssociateVPCWithHostedZone');
    }
    /**
     * Grants permission to create or delete CIDR blocks within a CIDR collection
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_ChangeCidrCollection.html
     */
    toChangeCidrCollection() {
        return this.to('ChangeCidrCollection');
    }
    /**
     * Grants permission to create, update, or delete a record, which contains authoritative DNS information for a specified domain or subdomain name
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifChangeResourceRecordSetsNormalizedRecordNames()
     * - .ifChangeResourceRecordSetsRecordTypes()
     * - .ifChangeResourceRecordSetsActions()
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_ChangeResourceRecordSets.html
     */
    toChangeResourceRecordSets() {
        return this.to('ChangeResourceRecordSets');
    }
    /**
     * Grants permission to add, edit, or delete tags for a health check or a hosted zone
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_ChangeTagsForResource.html
     */
    toChangeTagsForResource() {
        return this.to('ChangeTagsForResource');
    }
    /**
     * Grants permission to create a new CIDR collection
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateCidrCollection.html
     */
    toCreateCidrCollection() {
        return this.to('CreateCidrCollection');
    }
    /**
     * Grants permission to create a new health check, which monitors the health and performance of your web applications, web servers, and other resources
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateHealthCheck.html
     */
    toCreateHealthCheck() {
        return this.to('CreateHealthCheck');
    }
    /**
     * Grants permission to create a public hosted zone, which you use to specify how the Domain Name System (DNS) routes traffic on the Internet for a domain, such as example.com, and its subdomains
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ec2:DescribeVpcs
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateHostedZone.html
     */
    toCreateHostedZone() {
        return this.to('CreateHostedZone');
    }
    /**
     * Grants permission to create a new key-signing key associated with a hosted zone
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateKeySigningKey.html
     */
    toCreateKeySigningKey() {
        return this.to('CreateKeySigningKey');
    }
    /**
     * Grants permission to create a configuration for DNS query logging
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateQueryLoggingConfig.html
     */
    toCreateQueryLoggingConfig() {
        return this.to('CreateQueryLoggingConfig');
    }
    /**
     * Grants permission to create a delegation set (a group of four name servers) that can be reused by multiple hosted zones
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateReusableDelegationSet.html
     */
    toCreateReusableDelegationSet() {
        return this.to('CreateReusableDelegationSet');
    }
    /**
     * Grants permission to create a traffic policy, which you use to create multiple DNS records for one domain name (such as example.com) or one subdomain name (such as www.example.com)
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateTrafficPolicy.html
     */
    toCreateTrafficPolicy() {
        return this.to('CreateTrafficPolicy');
    }
    /**
     * Grants permission to create records in a specified hosted zone based on the settings in a specified traffic policy version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateTrafficPolicyInstance.html
     */
    toCreateTrafficPolicyInstance() {
        return this.to('CreateTrafficPolicyInstance');
    }
    /**
     * Grants permission to create a new version of an existing traffic policy
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateTrafficPolicyVersion.html
     */
    toCreateTrafficPolicyVersion() {
        return this.to('CreateTrafficPolicyVersion');
    }
    /**
     * Grants permission to authorize the AWS account that created a specified VPC to submit an AssociateVPCWithHostedZone request, which associates the VPC with a specified hosted zone that was created by a different account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateVPCAssociationAuthorization.html
     */
    toCreateVPCAssociationAuthorization() {
        return this.to('CreateVPCAssociationAuthorization');
    }
    /**
     * Grants permission to deactivate a key-signing key so that it will not be used for signing by DNSSEC
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_DeactivateKeySigningKey.html
     */
    toDeactivateKeySigningKey() {
        return this.to('DeactivateKeySigningKey');
    }
    /**
     * Grants permission to delete a CIDR collection
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_DeleteCidrCollection.html
     */
    toDeleteCidrCollection() {
        return this.to('DeleteCidrCollection');
    }
    /**
     * Grants permission to delete a health check
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_DeleteHealthCheck.html
     */
    toDeleteHealthCheck() {
        return this.to('DeleteHealthCheck');
    }
    /**
     * Grants permission to delete a hosted zone
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_DeleteHostedZone.html
     */
    toDeleteHostedZone() {
        return this.to('DeleteHostedZone');
    }
    /**
     * Grants permission to delete a key-signing key
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_DeleteKeySigningKey.html
     */
    toDeleteKeySigningKey() {
        return this.to('DeleteKeySigningKey');
    }
    /**
     * Grants permission to delete a configuration for DNS query logging
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_DeleteQueryLoggingConfig.html
     */
    toDeleteQueryLoggingConfig() {
        return this.to('DeleteQueryLoggingConfig');
    }
    /**
     * Grants permission to delete a reusable delegation set
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_DeleteReusableDelegationSet.html
     */
    toDeleteReusableDelegationSet() {
        return this.to('DeleteReusableDelegationSet');
    }
    /**
     * Grants permission to delete a traffic policy
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_DeleteTrafficPolicy.html
     */
    toDeleteTrafficPolicy() {
        return this.to('DeleteTrafficPolicy');
    }
    /**
     * Grants permission to delete a traffic policy instance and all the records that Route 53 created when you created the instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_DeleteTrafficPolicyInstance.html
     */
    toDeleteTrafficPolicyInstance() {
        return this.to('DeleteTrafficPolicyInstance');
    }
    /**
     * Grants permission to remove authorization for associating an Amazon Virtual Private Cloud with a Route 53 private hosted zone
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_DeleteVPCAssociationAuthorization.html
     */
    toDeleteVPCAssociationAuthorization() {
        return this.to('DeleteVPCAssociationAuthorization');
    }
    /**
     * Grants permission to disable DNSSEC signing in a specific hosted zone
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_DisableHostedZoneDNSSEC.html
     */
    toDisableHostedZoneDNSSEC() {
        return this.to('DisableHostedZoneDNSSEC');
    }
    /**
     * Grants permission to disassociate an Amazon Virtual Private Cloud from a Route 53 private hosted zone
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ec2:DescribeVpcs
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_DisassociateVPCFromHostedZone.html
     */
    toDisassociateVPCFromHostedZone() {
        return this.to('DisassociateVPCFromHostedZone');
    }
    /**
     * Grants permission to enable DNSSEC signing in a specific hosted zone
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_EnableHostedZoneDNSSEC.html
     */
    toEnableHostedZoneDNSSEC() {
        return this.to('EnableHostedZoneDNSSEC');
    }
    /**
     * Grants permission to get the specified limit for the current account, for example, the maximum number of health checks that you can create using the account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetAccountLimit.html
     */
    toGetAccountLimit() {
        return this.to('GetAccountLimit');
    }
    /**
     * Grants permission to get the current status of a request to create, update, or delete one or more records
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetChange.html
     */
    toGetChange() {
        return this.to('GetChange');
    }
    /**
     * Grants permission to get a list of the IP ranges that are used by Route 53 health checkers to check the health of your resources
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetCheckerIpRanges.html
     */
    toGetCheckerIpRanges() {
        return this.to('GetCheckerIpRanges');
    }
    /**
     * Grants permission to get information about DNSSEC for a specific hosted zone, including the key-signing keys in the hosted zone
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetDNSSEC.html
     */
    toGetDNSSEC() {
        return this.to('GetDNSSEC');
    }
    /**
     * Grants permission to get information about whether a specified geographic location is supported for Route 53 geolocation records
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetGeoLocation.html
     */
    toGetGeoLocation() {
        return this.to('GetGeoLocation');
    }
    /**
     * Grants permission to get information about a specified health check
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetHealthCheck.html
     */
    toGetHealthCheck() {
        return this.to('GetHealthCheck');
    }
    /**
     * Grants permission to get the number of health checks that are associated with the current AWS account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetHealthCheckCount.html
     */
    toGetHealthCheckCount() {
        return this.to('GetHealthCheckCount');
    }
    /**
     * Grants permission to get the reason that a specified health check failed most recently
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetHealthCheckLastFailureReason.html
     */
    toGetHealthCheckLastFailureReason() {
        return this.to('GetHealthCheckLastFailureReason');
    }
    /**
     * Grants permission to get the status of a specified health check
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetHealthCheckStatus.html
     */
    toGetHealthCheckStatus() {
        return this.to('GetHealthCheckStatus');
    }
    /**
     * Grants permission to get information about a specified hosted zone including the four name servers that Route 53 assigned to the hosted zone
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetHostedZone.html
     */
    toGetHostedZone() {
        return this.to('GetHostedZone');
    }
    /**
     * Grants permission to get the number of hosted zones that are associated with the current AWS account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetHostedZoneCount.html
     */
    toGetHostedZoneCount() {
        return this.to('GetHostedZoneCount');
    }
    /**
     * Grants permission to get the specified limit for a specified hosted zone
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetHostedZoneLimit.html
     */
    toGetHostedZoneLimit() {
        return this.to('GetHostedZoneLimit');
    }
    /**
     * Grants permission to get information about a specified configuration for DNS query logging
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetQueryLoggingConfig.html
     */
    toGetQueryLoggingConfig() {
        return this.to('GetQueryLoggingConfig');
    }
    /**
     * Grants permission to get information about a specified reusable delegation set, including the four name servers that are assigned to the delegation set
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetReusableDelegationSet.html
     */
    toGetReusableDelegationSet() {
        return this.to('GetReusableDelegationSet');
    }
    /**
     * Grants permission to get the maximum number of hosted zones that you can associate with the specified reusable delegation set
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetReusableDelegationSetLimit.html
     */
    toGetReusableDelegationSetLimit() {
        return this.to('GetReusableDelegationSetLimit');
    }
    /**
     * Grants permission to get information about a specified traffic policy version
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetTrafficPolicy.html
     */
    toGetTrafficPolicy() {
        return this.to('GetTrafficPolicy');
    }
    /**
     * Grants permission to get information about a specified traffic policy instance
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetTrafficPolicyInstance.html
     */
    toGetTrafficPolicyInstance() {
        return this.to('GetTrafficPolicyInstance');
    }
    /**
     * Grants permission to get the number of traffic policy instances that are associated with the current AWS account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetTrafficPolicyInstanceCount.html
     */
    toGetTrafficPolicyInstanceCount() {
        return this.to('GetTrafficPolicyInstanceCount');
    }
    /**
     * Grants permission to get a list of the CIDR blocks within a specified CIDR collection
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListCidrBlocks.html
     */
    toListCidrBlocks() {
        return this.to('ListCidrBlocks');
    }
    /**
     * Grants permission to get a list of the CIDR collections that are associated with the current AWS account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListCidrCollections.html
     */
    toListCidrCollections() {
        return this.to('ListCidrCollections');
    }
    /**
     * Grants permission to get a list of the CIDR locations that belong to a specified CIDR collection
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListCidrLocations.html
     */
    toListCidrLocations() {
        return this.to('ListCidrLocations');
    }
    /**
     * Grants permission to get a list of geographic locations that Route 53 supports for geolocation
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListGeoLocations.html
     */
    toListGeoLocations() {
        return this.to('ListGeoLocations');
    }
    /**
     * Grants permission to get a list of the health checks that are associated with the current AWS account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListHealthChecks.html
     */
    toListHealthChecks() {
        return this.to('ListHealthChecks');
    }
    /**
     * Grants permission to get a list of the public and private hosted zones that are associated with the current AWS account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListHostedZones.html
     */
    toListHostedZones() {
        return this.to('ListHostedZones');
    }
    /**
     * Grants permission to get a list of your hosted zones in lexicographic order. Hosted zones are sorted by name with the labels reversed, for example, com.example.www
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListHostedZonesByName.html
     */
    toListHostedZonesByName() {
        return this.to('ListHostedZonesByName');
    }
    /**
     * Grants permission to get a list of all the private hosted zones that a specified VPC is associated with
     *
     * Access Level: List
     *
     * Dependent actions:
     * - ec2:DescribeVpcs
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListHostedZonesByVPC.html
     */
    toListHostedZonesByVPC() {
        return this.to('ListHostedZonesByVPC');
    }
    /**
     * Grants permission to list the configurations for DNS query logging that are associated with the current AWS account or the configuration that is associated with a specified hosted zone
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListQueryLoggingConfigs.html
     */
    toListQueryLoggingConfigs() {
        return this.to('ListQueryLoggingConfigs');
    }
    /**
     * Grants permission to list the records in a specified hosted zone
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListResourceRecordSets.html
     */
    toListResourceRecordSets() {
        return this.to('ListResourceRecordSets');
    }
    /**
     * Grants permission to list the reusable delegation sets that are associated with the current AWS account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListReusableDelegationSets.html
     */
    toListReusableDelegationSets() {
        return this.to('ListReusableDelegationSets');
    }
    /**
     * Grants permission to list tags for one health check or hosted zone
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Grants permission to list tags for up to 10 health checks or hosted zones
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListTagsForResources.html
     */
    toListTagsForResources() {
        return this.to('ListTagsForResources');
    }
    /**
     * Grants permission to get information about the latest version for every traffic policy that is associated with the current AWS account. Policies are listed in the order in which they were created
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListTrafficPolicies.html
     */
    toListTrafficPolicies() {
        return this.to('ListTrafficPolicies');
    }
    /**
     * Grants permission to get information about the traffic policy instances that you created by using the current AWS account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListTrafficPolicyInstances.html
     */
    toListTrafficPolicyInstances() {
        return this.to('ListTrafficPolicyInstances');
    }
    /**
     * Grants permission to get information about the traffic policy instances that you created in a specified hosted zone
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListTrafficPolicyInstancesByHostedZone.html
     */
    toListTrafficPolicyInstancesByHostedZone() {
        return this.to('ListTrafficPolicyInstancesByHostedZone');
    }
    /**
     * Grants permission to get information about the traffic policy instances that you created using a specified traffic policy version
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListTrafficPolicyInstancesByPolicy.html
     */
    toListTrafficPolicyInstancesByPolicy() {
        return this.to('ListTrafficPolicyInstancesByPolicy');
    }
    /**
     * Grants permission to get information about all the versions for a specified traffic policy
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListTrafficPolicyVersions.html
     */
    toListTrafficPolicyVersions() {
        return this.to('ListTrafficPolicyVersions');
    }
    /**
     * Grants permission to get a list of the VPCs that were created by other accounts and that can be associated with a specified hosted zone
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListVPCAssociationAuthorizations.html
     */
    toListVPCAssociationAuthorizations() {
        return this.to('ListVPCAssociationAuthorizations');
    }
    /**
     * Grants permission to get the value that Route 53 returns in response to a DNS query for a specified record name and type
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_TestDNSAnswer.html
     */
    toTestDNSAnswer() {
        return this.to('TestDNSAnswer');
    }
    /**
     * Grants permission to update an existing health check
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateHealthCheck.html
     */
    toUpdateHealthCheck() {
        return this.to('UpdateHealthCheck');
    }
    /**
     * Grants permission to update the comment for a specified hosted zone
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateHostedZoneComment.html
     */
    toUpdateHostedZoneComment() {
        return this.to('UpdateHostedZoneComment');
    }
    /**
     * Grants permission to update the comment for a specified traffic policy version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateTrafficPolicyComment.html
     */
    toUpdateTrafficPolicyComment() {
        return this.to('UpdateTrafficPolicyComment');
    }
    /**
     * Grants permission to update the records in a specified hosted zone that were created based on the settings in a specified traffic policy version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateTrafficPolicyInstance.html
     */
    toUpdateTrafficPolicyInstance() {
        return this.to('UpdateTrafficPolicyInstance');
    }
    /**
     * Adds a resource of type cidrcollection to the statement
     *
     * @param id - Identifier for the id.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onCidrcollection(id, partition) {
        return this.on(`arn:${partition || Route53.defaultPartition}:route53:::cidrcollection/${id}`);
    }
    /**
     * Adds a resource of type change to the statement
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_Change.html
     *
     * @param id - Identifier for the id.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onChange(id, partition) {
        return this.on(`arn:${partition || Route53.defaultPartition}:route53:::change/${id}`);
    }
    /**
     * Adds a resource of type delegationset to the statement
     *
     * https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/route-53-concepts.html#route-53-concepts-reusable-delegation-set
     *
     * @param id - Identifier for the id.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onDelegationset(id, partition) {
        return this.on(`arn:${partition || Route53.defaultPartition}:route53:::delegationset/${id}`);
    }
    /**
     * Adds a resource of type healthcheck to the statement
     *
     * https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/route-53-concepts.html#route-53-concepts-health-check
     *
     * @param id - Identifier for the id.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onHealthcheck(id, partition) {
        return this.on(`arn:${partition || Route53.defaultPartition}:route53:::healthcheck/${id}`);
    }
    /**
     * Adds a resource of type hostedzone to the statement
     *
     * https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/route-53-concepts.html#route-53-concepts-hosted-zone
     *
     * @param id - Identifier for the id.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onHostedzone(id, partition) {
        return this.on(`arn:${partition || Route53.defaultPartition}:route53:::hostedzone/${id}`);
    }
    /**
     * Adds a resource of type trafficpolicy to the statement
     *
     * https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/traffic-policies.html
     *
     * @param id - Identifier for the id.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onTrafficpolicy(id, partition) {
        return this.on(`arn:${partition || Route53.defaultPartition}:route53:::trafficpolicy/${id}`);
    }
    /**
     * Adds a resource of type trafficpolicyinstance to the statement
     *
     * https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/traffic-policy-records.html
     *
     * @param id - Identifier for the id.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onTrafficpolicyinstance(id, partition) {
        return this.on(`arn:${partition || Route53.defaultPartition}:route53:::trafficpolicyinstance/${id}`);
    }
    /**
     * Adds a resource of type queryloggingconfig to the statement
     *
     * https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/query-logs.html
     *
     * @param id - Identifier for the id.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onQueryloggingconfig(id, partition) {
        return this.on(`arn:${partition || Route53.defaultPartition}:route53:::queryloggingconfig/${id}`);
    }
    /**
     * Adds a resource of type vpc to the statement
     *
     * https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html
     *
     * @param vpcId - Identifier for the vpcId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onVpc(vpcId, account, region, partition) {
        return this.on(`arn:${partition || Route53.defaultPartition}:ec2:${region || '*'}:${account || '*'}:vpc/${vpcId}`);
    }
    /**
     * Filters access by the change actions, CREATE, UPSERT, or DELETE, in a ChangeResourceRecordSets request
     *
     * https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/specifying-rrset-conditions.html#route53_rrset_ConditionKeys
     *
     * Applies to actions:
     * - .toChangeResourceRecordSets()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifChangeResourceRecordSetsActions(value, operator) {
        return this.if(`ChangeResourceRecordSetsActions`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the normalized DNS record names in a ChangeResourceRecordSets request
     *
     * https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/specifying-rrset-conditions.html#route53_rrset_ConditionKeys
     *
     * Applies to actions:
     * - .toChangeResourceRecordSets()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifChangeResourceRecordSetsNormalizedRecordNames(value, operator) {
        return this.if(`ChangeResourceRecordSetsNormalizedRecordNames`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the DNS record types in a ChangeResourceRecordSets request
     *
     * https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/specifying-rrset-conditions.html#route53_rrset_ConditionKeys
     *
     * Applies to actions:
     * - .toChangeResourceRecordSets()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifChangeResourceRecordSetsRecordTypes(value, operator) {
        return this.if(`ChangeResourceRecordSetsRecordTypes`, value, operator || 'StringLike');
    }
}
exports.Route53 = Route53;
_a = JSII_RTTI_SYMBOL_1;
Route53[_a] = { fqn: "iam-floyd.Route53", version: "0.505.0" };
//# sourceMappingURL=data:application/json;base64,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