"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Snowball = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [snowball](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssnowball.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Snowball extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [snowball](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssnowball.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'snowball';
        this.accessLevelList = {
            Write: [
                'CancelCluster',
                'CancelJob',
                'CreateAddress',
                'CreateCluster',
                'CreateJob',
                'CreateLongTermPricing',
                'CreateReturnShippingLabel',
                'UpdateCluster',
                'UpdateJob',
                'UpdateJobShipmentState',
                'UpdateLongTermPricing'
            ],
            Read: [
                'DescribeAddress',
                'DescribeCluster',
                'DescribeJob',
                'DescribeReturnShippingLabel',
                'GetJobManifest',
                'GetJobUnlockCode',
                'GetSnowballUsage',
                'GetSoftwareUpdates',
                'ListLongTermPricing'
            ],
            List: [
                'DescribeAddresses',
                'ListClusterJobs',
                'ListClusters',
                'ListCompatibleImages',
                'ListJobs',
                'ListServiceVersions'
            ]
        };
    }
    /**
     * Grants permission to cancel a cluster job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_CancelCluster.html
     */
    toCancelCluster() {
        return this.to('CancelCluster');
    }
    /**
     * Grants permission to cancel the specified job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_CancelJob.html
     */
    toCancelJob() {
        return this.to('CancelJob');
    }
    /**
     * Grants permission to create an address for a Snowball to be shipped to
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_CreateAddress.html
     */
    toCreateAddress() {
        return this.to('CreateAddress');
    }
    /**
     * Grants permission to create an empty cluster
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_CreateCluster.html
     */
    toCreateCluster() {
        return this.to('CreateCluster');
    }
    /**
     * Grants permission to creates a job to import or export data between Amazon S3 and your on-premises data center
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_CreateJob.html
     */
    toCreateJob() {
        return this.to('CreateJob');
    }
    /**
     * Grants permission to creates a LongTermPricingListEntry for allowing customers to add an upfront billing contract for a job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_CreateLongTermPricing.html
     */
    toCreateLongTermPricing() {
        return this.to('CreateLongTermPricing');
    }
    /**
     * Grants permission to create a shipping label that will be used to return the Snow device to AWS
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_CreateReturnShippingLabel.html
     */
    toCreateReturnShippingLabel() {
        return this.to('CreateReturnShippingLabel');
    }
    /**
     * Grants permission to get specific details about that address in the form of an Address object
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_DescribeAddress.html
     */
    toDescribeAddress() {
        return this.to('DescribeAddress');
    }
    /**
     * Grants permission to describe a specified number of ADDRESS objects
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_DescribeAddresses.html
     */
    toDescribeAddresses() {
        return this.to('DescribeAddresses');
    }
    /**
     * Grants permission to describe information about a specific cluster including shipping information, cluster status, and other important metadata
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_DescribeCluster.html
     */
    toDescribeCluster() {
        return this.to('DescribeCluster');
    }
    /**
     * Grants permission to describe information about a specific job including shipping information, job status, and other important metadata
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_DescribeJob.html
     */
    toDescribeJob() {
        return this.to('DescribeJob');
    }
    /**
     * Grants permission to describe information on the shipping label of a Snow device that is being returned to AWS
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_DescribeReturnShippingLabel.html
     */
    toDescribeReturnShippingLabel() {
        return this.to('DescribeReturnShippingLabel');
    }
    /**
     * Grants permission to get a link to an Amazon S3 presigned URL for the manifest file associated with the specified JobId value
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_GetJobManifest.html
     */
    toGetJobManifest() {
        return this.to('GetJobManifest');
    }
    /**
     * Grants permission to get the UnlockCode code value for the specified job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_GetJobUnlockCode.html
     */
    toGetJobUnlockCode() {
        return this.to('GetJobUnlockCode');
    }
    /**
     * Grants permission to get information about the Snowball service limit for your account, and also the number of Snowballs your account has in use
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_GetSnowballUsage.html
     */
    toGetSnowballUsage() {
        return this.to('GetSnowballUsage');
    }
    /**
     * Grants permission to return an Amazon S3 presigned URL for an update file associated with a specified JobId
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_GetSoftwareUpdates.html
     */
    toGetSoftwareUpdates() {
        return this.to('GetSoftwareUpdates');
    }
    /**
     * Grants permission to list JobListEntry objects of the specified length
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_ListClusterJobs.html
     */
    toListClusterJobs() {
        return this.to('ListClusterJobs');
    }
    /**
     * Grants permission to list ClusterListEntry objects of the specified length
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_ListClusters.html
     */
    toListClusters() {
        return this.to('ListClusters');
    }
    /**
     * Grants permission to return a list of the different Amazon EC2 Amazon Machine Images (AMIs) that are owned by your AWS account that would be supported for use on a Snow device
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_ListCompatibleImages.html
     */
    toListCompatibleImages() {
        return this.to('ListCompatibleImages');
    }
    /**
     * Grants permission to list JobListEntry objects of the specified length
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_ListJobs.html
     */
    toListJobs() {
        return this.to('ListJobs');
    }
    /**
     * Grants permission to list LongTermPricingListEntry objects for the account making the request
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_ListLongTermPricing.html
     */
    toListLongTermPricing() {
        return this.to('ListLongTermPricing');
    }
    /**
     * Grants permission to list all supported versions for Snow on-device services
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_ListServiceVersions.html
     */
    toListServiceVersions() {
        return this.to('ListServiceVersions');
    }
    /**
     * Grants permission to update while a cluster's ClusterState value is in the AwaitingQuorum state, you can update some of the information associated with a cluster
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_UpdateCluster.html
     */
    toUpdateCluster() {
        return this.to('UpdateCluster');
    }
    /**
     * Grants permission to update while a job's JobState value is New, you can update some of the information associated with a job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_UpdateJob.html
     */
    toUpdateJob() {
        return this.to('UpdateJob');
    }
    /**
     * Grants permission to update the state when a the shipment states changes to a different state
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_UpdateJobShipmentState.html
     */
    toUpdateJobShipmentState() {
        return this.to('UpdateJobShipmentState');
    }
    /**
     * Grants permission to update a specific upfront billing contract for a job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_UpdateLongTermPricing.html
     */
    toUpdateLongTermPricing() {
        return this.to('UpdateLongTermPricing');
    }
}
exports.Snowball = Snowball;
_a = JSII_RTTI_SYMBOL_1;
Snowball[_a] = { fqn: "iam-floyd.Snowball", version: "0.505.0" };
//# sourceMappingURL=data:application/json;base64,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