import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement, Operator } from '../shared';
/**
 * Statement provider for service [vpc-lattice](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonvpclattice.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class VpcLattice extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [vpc-lattice](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonvpclattice.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to create an access log subscription
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * Dependent actions:
     * - logs:CreateLogDelivery
     * - logs:GetLogDelivery
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_CreateAccessLogSubscription.html
     */
    toCreateAccessLogSubscription(): this;
    /**
     * Grants permission to create a listener
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifProtocol()
     * - .ifTargetGroupArns()
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_CreateListener.html
     */
    toCreateListener(): this;
    /**
     * Grants permission to create a rule
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifTargetGroupArns()
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_CreateRule.html
     */
    toCreateRule(): this;
    /**
     * Grants permission to create a service
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAuthType()
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * Dependent actions:
     * - iam:CreateServiceLinkedRole
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_CreateService.html
     */
    toCreateService(): this;
    /**
     * Grants permission to create a service network
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAuthType()
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * Dependent actions:
     * - iam:CreateServiceLinkedRole
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_CreateServiceNetwork.html
     */
    toCreateServiceNetwork(): this;
    /**
     * Grants permission to create a service network and service association
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifServiceNetworkArn()
     * - .ifServiceArn()
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_CreateServiceNetworkServiceAssociation.html
     */
    toCreateServiceNetworkServiceAssociation(): this;
    /**
     * Grants permission to create a service network and VPC association
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifVpcId()
     * - .ifServiceNetworkArn()
     * - .ifSecurityGroupIds()
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * Dependent actions:
     * - ec2:DescribeVpcs
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_CreateServiceNetworkVpcAssociation.html
     */
    toCreateServiceNetworkVpcAssociation(): this;
    /**
     * Grants permission to create a target group
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifVpcId()
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * Dependent actions:
     * - iam:CreateServiceLinkedRole
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_CreateTargetGroup.html
     */
    toCreateTargetGroup(): this;
    /**
     * Grants permission to delete an access log subscription
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * Dependent actions:
     * - logs:DeleteLogDelivery
     * - logs:GetLogDelivery
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_DeleteAccessLogSubscription.html
     */
    toDeleteAccessLogSubscription(): this;
    /**
     * Grants permission to delete an auth policy
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_DeleteAuthPolicy.html
     */
    toDeleteAuthPolicy(): this;
    /**
     * Grants permission to delete a listener
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_DeleteListener.html
     */
    toDeleteListener(): this;
    /**
     * Grants permission to delete a resource policy
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_DeleteResourcePolicy.html
     */
    toDeleteResourcePolicy(): this;
    /**
     * Grants permission to delete a rule
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_DeleteRule.html
     */
    toDeleteRule(): this;
    /**
     * Grants permission to delete a service
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_DeleteService.html
     */
    toDeleteService(): this;
    /**
     * Grants permission to delete a service network
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_DeleteServiceNetwork.html
     */
    toDeleteServiceNetwork(): this;
    /**
     * Grants permission to delete a service network service association
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifServiceNetworkArn()
     * - .ifServiceArn()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_DeleteServiceNetworkServiceAssociation.html
     */
    toDeleteServiceNetworkServiceAssociation(): this;
    /**
     * Grants permission to delete a service network and VPC association
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifVpcId()
     * - .ifServiceNetworkArn()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_DeleteServiceNetworkVpcAssociation.html
     */
    toDeleteServiceNetworkVpcAssociation(): this;
    /**
     * Grants permission to delete a target group
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_DeleteTargetGroup.html
     */
    toDeleteTargetGroup(): this;
    /**
     * Grants permission to deregister targets from a target group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_DeregisterTargets.html
     */
    toDeregisterTargets(): this;
    /**
     * Grants permission to get information about an access log subscription
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * Dependent actions:
     * - logs:GetLogDelivery
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_GetAccessLogSubscription.html
     */
    toGetAccessLogSubscription(): this;
    /**
     * Grants permission to get information about an auth policy
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_GetAuthPolicy.html
     */
    toGetAuthPolicy(): this;
    /**
     * Grants permission to get information about a listener
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_GetListener.html
     */
    toGetListener(): this;
    /**
     * Grants permission to get information about a resource policy
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_GetResourcePolicy.html
     */
    toGetResourcePolicy(): this;
    /**
     * Grants permission to get information about a rule
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_GetRule.html
     */
    toGetRule(): this;
    /**
     * Grants permission to get information about a service
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_GetService.html
     */
    toGetService(): this;
    /**
     * Grants permission to get information about a service network
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_GetServiceNetwork.html
     */
    toGetServiceNetwork(): this;
    /**
     * Grants permission to get information about a service network and service association
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifServiceNetworkArn()
     * - .ifServiceArn()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_GetServiceNetworkServiceAssociation.html
     */
    toGetServiceNetworkServiceAssociation(): this;
    /**
     * Grants permission to get information about a service network and VPC association
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifVpcId()
     * - .ifServiceNetworkArn()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_GetServiceNetworkVpcAssociation.html
     */
    toGetServiceNetworkVpcAssociation(): this;
    /**
     * Grants permission to get information about a target group
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_GetTargetGroup.html
     */
    toGetTargetGroup(): this;
    /**
     * Grants permission to list some or all access log subscriptions about a service network or a service
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_ListAccessLogSubscriptions.html
     */
    toListAccessLogSubscriptions(): this;
    /**
     * Grants permission to list some or all listeners
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_ListListeners.html
     */
    toListListeners(): this;
    /**
     * Grants permission to list some or all rules
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_ListRules.html
     */
    toListRules(): this;
    /**
     * Grants permission to list some or all service network and service associations
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifServiceNetworkArn()
     * - .ifServiceArn()
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_ListServiceNetworkServiceAssociations.html
     */
    toListServiceNetworkServiceAssociations(): this;
    /**
     * Grants permission to list some or all service network and VPC associations
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifVpcId()
     * - .ifServiceNetworkArn()
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_ListServiceNetworkVpcAssociations.html
     */
    toListServiceNetworkVpcAssociations(): this;
    /**
     * Grants permission to list the service networks owned by a caller account or shared with the caller account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_ListServiceNetworks.html
     */
    toListServiceNetworks(): this;
    /**
     * Grants permission to list the services owned by a caller account or shared with the caller account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_ListServices.html
     */
    toListServices(): this;
    /**
     * Grants permission to list tags for a vpc-lattice resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to list some or all target groups
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_ListTargetGroups.html
     */
    toListTargetGroups(): this;
    /**
     * Grants permission to list some or all targets in a target group
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_ListTargets.html
     */
    toListTargets(): this;
    /**
     * Grants permission to create or update the auth policy for a service network or a service
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_PutAuthPolicy.html
     */
    toPutAuthPolicy(): this;
    /**
     * Grants permission to create a resource policy for a service network or a service
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_PutResourcePolicy.html
     */
    toPutResourcePolicy(): this;
    /**
     * Grants permission to register targets to a target group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_RegisterTargets.html
     */
    toRegisterTargets(): this;
    /**
     * Grants permission to tag a vpc-lattice resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to untag a vpc-lattice resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update an access log subscription
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * Dependent actions:
     * - logs:GetLogDelivery
     * - logs:UpdateLogDelivery
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_UpdateAccessLogSubscription.html
     */
    toUpdateAccessLogSubscription(): this;
    /**
     * Grants permission to update a listener
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifTargetGroupArns()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_UpdateListener.html
     */
    toUpdateListener(): this;
    /**
     * Grants permission to update a rule
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifTargetGroupArns()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_UpdateRule.html
     */
    toUpdateRule(): this;
    /**
     * Grants permission to update a service
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAuthType()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_UpdateService.html
     */
    toUpdateService(): this;
    /**
     * Grants permission to update a service network
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAuthType()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_UpdateServiceNetwork.html
     */
    toUpdateServiceNetwork(): this;
    /**
     * Grants permission to update a service network and VPC association
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifVpcId()
     * - .ifServiceNetworkArn()
     * - .ifSecurityGroupIds()
     * - .ifAwsResourceTag()
     *
     * Dependent actions:
     * - ec2:DescribeSecurityGroups
     * - ec2:DescribeVpcs
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_UpdateServiceNetworkVpcAssociation.html
     */
    toUpdateServiceNetworkVpcAssociation(): this;
    /**
     * Grants permission to update a target group
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_UpdateTargetGroup.html
     */
    toUpdateTargetGroup(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type ServiceNetwork to the statement
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/ug/service-networks.html
     *
     * @param serviceNetworkId - Identifier for the serviceNetworkId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifAuthType()
     */
    onServiceNetwork(serviceNetworkId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type Service to the statement
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/ug/services.html
     *
     * @param serviceId - Identifier for the serviceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifAuthType()
     */
    onService(serviceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type ServiceNetworkVpcAssociation to the statement
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/ug/service-network-associations.html#service-network-vpc-associations
     *
     * @param serviceNetworkVpcAssociationId - Identifier for the serviceNetworkVpcAssociationId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifSecurityGroupIds()
     * - .ifServiceNetworkArn()
     * - .ifVpcId()
     */
    onServiceNetworkVpcAssociation(serviceNetworkVpcAssociationId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type ServiceNetworkServiceAssociation to the statement
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/ug/service-network-associations.html#service-network-service-associations
     *
     * @param serviceNetworkServiceAssociationId - Identifier for the serviceNetworkServiceAssociationId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifServiceArn()
     * - .ifServiceNetworkArn()
     */
    onServiceNetworkServiceAssociation(serviceNetworkServiceAssociationId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type TargetGroup to the statement
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/ug/target-groups.html
     *
     * @param targetGroupId - Identifier for the targetGroupId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifVpcId()
     */
    onTargetGroup(targetGroupId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type Listener to the statement
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/ug/listeners.html
     *
     * @param serviceId - Identifier for the serviceId.
     * @param listenerId - Identifier for the listenerId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifProtocol()
     * - .ifTargetGroupArns()
     */
    onListener(serviceId: string, listenerId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type Rule to the statement
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/ug/listeners.html#listener-rules
     *
     * @param serviceId - Identifier for the serviceId.
     * @param listenerId - Identifier for the listenerId.
     * @param ruleId - Identifier for the ruleId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifTargetGroupArns()
     */
    onRule(serviceId: string, listenerId: string, ruleId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type AccessLogSubscription to the statement
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/ug/monitoring-access-logs.html
     *
     * @param accessLogSubscriptionId - Identifier for the accessLogSubscriptionId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     */
    onAccessLogSubscription(accessLogSubscriptionId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by the auth type specified in the request
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/ug/
     *
     * Applies to actions:
     * - .toCreateService()
     * - .toCreateServiceNetwork()
     * - .toUpdateService()
     * - .toUpdateServiceNetwork()
     *
     * Applies to resource types:
     * - ServiceNetwork
     * - Service
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAuthType(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the protocol specified in the request
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/ug/
     *
     * Applies to actions:
     * - .toCreateListener()
     *
     * Applies to resource types:
     * - Listener
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifProtocol(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the IDs of security groups
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/ug/
     *
     * Applies to actions:
     * - .toCreateServiceNetworkVpcAssociation()
     * - .toUpdateServiceNetworkVpcAssociation()
     *
     * Applies to resource types:
     * - ServiceNetworkVpcAssociation
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifSecurityGroupIds(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the ARN of a service
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/ug/
     *
     * Applies to actions:
     * - .toCreateServiceNetworkServiceAssociation()
     * - .toDeleteServiceNetworkServiceAssociation()
     * - .toGetServiceNetworkServiceAssociation()
     * - .toListServiceNetworkServiceAssociations()
     *
     * Applies to resource types:
     * - ServiceNetworkServiceAssociation
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifServiceArn(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the ARN of a service network
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/ug/
     *
     * Applies to actions:
     * - .toCreateServiceNetworkServiceAssociation()
     * - .toCreateServiceNetworkVpcAssociation()
     * - .toDeleteServiceNetworkServiceAssociation()
     * - .toDeleteServiceNetworkVpcAssociation()
     * - .toGetServiceNetworkServiceAssociation()
     * - .toGetServiceNetworkVpcAssociation()
     * - .toListServiceNetworkServiceAssociations()
     * - .toListServiceNetworkVpcAssociations()
     * - .toUpdateServiceNetworkVpcAssociation()
     *
     * Applies to resource types:
     * - ServiceNetworkVpcAssociation
     * - ServiceNetworkServiceAssociation
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifServiceNetworkArn(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the ARNs of target groups
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/ug/
     *
     * Applies to actions:
     * - .toCreateListener()
     * - .toCreateRule()
     * - .toUpdateListener()
     * - .toUpdateRule()
     *
     * Applies to resource types:
     * - Listener
     * - Rule
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifTargetGroupArns(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the ID of a virtual private cloud (VPC)
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/ug/
     *
     * Applies to actions:
     * - .toCreateServiceNetworkVpcAssociation()
     * - .toCreateTargetGroup()
     * - .toDeleteServiceNetworkVpcAssociation()
     * - .toGetServiceNetworkVpcAssociation()
     * - .toListServiceNetworkVpcAssociations()
     * - .toUpdateServiceNetworkVpcAssociation()
     *
     * Applies to resource types:
     * - ServiceNetworkVpcAssociation
     * - TargetGroup
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifVpcId(value: string | string[], operator?: Operator | string): this;
}
