"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PolicyStatementBase = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// This file is used in the base variant of the package: iam-floyd
/**
 * Base class for the Policy Statement
 */
class PolicyStatementBase {
    constructor(sid) {
        this.sid = '';
        /**
         * Holds the prefix of the service actions, e.g. `ec2`
         */
        this.servicePrefix = '';
        if (typeof sid !== 'undefined') {
            this.sid = sid;
        }
    }
    /**
     * JSON-ify the policy statement
     *
     * Used when JSON.stringify() is called
     */
    toJSON() {
        const statement = {};
        if (this.sid.length) {
            statement.Sid = this.sid;
        }
        return statement;
    }
}
exports.PolicyStatementBase = PolicyStatementBase;
_a = JSII_RTTI_SYMBOL_1;
PolicyStatementBase[_a] = { fqn: "iam-floyd.PolicyStatementBase", version: "0.505.0" };
/**
 * The default partition for ARNs (such as one of [aws, aws-us-gov, aws-cn]). In
 * CDK applications, this is a reference to the current partition, otherwise, 'aws'.
 */
PolicyStatementBase.defaultPartition = 'aws';
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiMS1iYXNlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiMS1iYXNlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsa0VBQWtFO0FBRWxFOztHQUVHO0FBQ0gsTUFBYSxtQkFBbUI7SUFjOUIsWUFBWSxHQUFZO1FBUGpCLFFBQUcsR0FBRyxFQUFFLENBQUM7UUFFaEI7O1dBRUc7UUFDSSxrQkFBYSxHQUFHLEVBQUUsQ0FBQztRQUd4QixJQUFJLE9BQU8sR0FBRyxLQUFLLFdBQVcsRUFBRTtZQUM5QixJQUFJLENBQUMsR0FBRyxHQUFHLEdBQUcsQ0FBQztTQUNoQjtJQUNILENBQUM7SUFFRDs7OztPQUlHO0lBRUksTUFBTTtRQUNYLE1BQU0sU0FBUyxHQUFRLEVBQUUsQ0FBQztRQUUxQixJQUFJLElBQUksQ0FBQyxHQUFHLENBQUMsTUFBTSxFQUFFO1lBQ25CLFNBQVMsQ0FBQyxHQUFHLEdBQUcsSUFBSSxDQUFDLEdBQUcsQ0FBQztTQUMxQjtRQUVELE9BQU8sU0FBUyxDQUFDO0lBQ25CLENBQUM7O0FBbENILGtEQW1DQzs7O0FBbENDOzs7R0FHRztBQUN1QixvQ0FBZ0IsR0FBRyxLQUFLLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyIvLyBUaGlzIGZpbGUgaXMgdXNlZCBpbiB0aGUgYmFzZSB2YXJpYW50IG9mIHRoZSBwYWNrYWdlOiBpYW0tZmxveWRcblxuLyoqXG4gKiBCYXNlIGNsYXNzIGZvciB0aGUgUG9saWN5IFN0YXRlbWVudFxuICovXG5leHBvcnQgY2xhc3MgUG9saWN5U3RhdGVtZW50QmFzZSB7XG4gIC8qKlxuICAgKiBUaGUgZGVmYXVsdCBwYXJ0aXRpb24gZm9yIEFSTnMgKHN1Y2ggYXMgb25lIG9mIFthd3MsIGF3cy11cy1nb3YsIGF3cy1jbl0pLiBJblxuICAgKiBDREsgYXBwbGljYXRpb25zLCB0aGlzIGlzIGEgcmVmZXJlbmNlIHRvIHRoZSBjdXJyZW50IHBhcnRpdGlvbiwgb3RoZXJ3aXNlLCAnYXdzJy5cbiAgICovXG4gIHByb3RlY3RlZCBzdGF0aWMgcmVhZG9ubHkgZGVmYXVsdFBhcnRpdGlvbiA9ICdhd3MnO1xuXG4gIHB1YmxpYyBzaWQgPSAnJztcblxuICAvKipcbiAgICogSG9sZHMgdGhlIHByZWZpeCBvZiB0aGUgc2VydmljZSBhY3Rpb25zLCBlLmcuIGBlYzJgXG4gICAqL1xuICBwdWJsaWMgc2VydmljZVByZWZpeCA9ICcnO1xuXG4gIGNvbnN0cnVjdG9yKHNpZD86IHN0cmluZykge1xuICAgIGlmICh0eXBlb2Ygc2lkICE9PSAndW5kZWZpbmVkJykge1xuICAgICAgdGhpcy5zaWQgPSBzaWQ7XG4gICAgfVxuICB9XG5cbiAgLyoqXG4gICAqIEpTT04taWZ5IHRoZSBwb2xpY3kgc3RhdGVtZW50XG4gICAqXG4gICAqIFVzZWQgd2hlbiBKU09OLnN0cmluZ2lmeSgpIGlzIGNhbGxlZFxuICAgKi9cblxuICBwdWJsaWMgdG9KU09OKCk6IGFueSB7XG4gICAgY29uc3Qgc3RhdGVtZW50OiBhbnkgPSB7fTtcblxuICAgIGlmICh0aGlzLnNpZC5sZW5ndGgpIHtcbiAgICAgIHN0YXRlbWVudC5TaWQgPSB0aGlzLnNpZDtcbiAgICB9XG5cbiAgICByZXR1cm4gc3RhdGVtZW50O1xuICB9XG59XG4iXX0=