"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Schema = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * @see https://docs.aws.amazon.com/athena/latest/ug/data-types.html
 * @experimental
 */
class Schema {
    /**
     * (experimental) Creates a decimal type.
     *
     * TODO: Bounds
     *
     * @param precision the total number of digits.
     * @param scale the number of digits in fractional part, the default is 0.
     * @experimental
     */
    static decimal(precision, scale) {
        return {
            isPrimitive: true,
            inputString: scale !== undefined ? `decimal(${precision},${scale})` : `decimal(${precision})`,
        };
    }
    /**
     * (experimental) Fixed length character data, with a specified length between 1 and 255.
     *
     * @param length length between 1 and 255.
     * @experimental
     */
    static char(length) {
        if (length <= 0 || length > 255) {
            throw new Error(`char length must be (inclusively) between 1 and 255, but was ${length}`);
        }
        if (length % 1 !== 0) {
            throw new Error(`char length must be a positive integer, was ${length}`);
        }
        return {
            isPrimitive: true,
            inputString: `char(${length})`,
        };
    }
    /**
     * (experimental) Variable length character data, with a specified length between 1 and 65535.
     *
     * @param length length between 1 and 65535.
     * @experimental
     */
    static varchar(length) {
        if (length <= 0 || length > 65535) {
            throw new Error(`varchar length must be (inclusively) between 1 and 65535, but was ${length}`);
        }
        if (length % 1 !== 0) {
            throw new Error(`varchar length must be a positive integer, was ${length}`);
        }
        return {
            isPrimitive: true,
            inputString: `varchar(${length})`,
        };
    }
    /**
     * (experimental) Creates an array of some other type.
     *
     * @param itemType type contained by the array.
     * @experimental
     */
    static array(itemType) {
        jsiiDeprecationWarnings._aws_cdk_aws_glue_alpha_Type(itemType);
        return {
            isPrimitive: false,
            inputString: `array<${itemType.inputString}>`,
        };
    }
    /**
     * (experimental) Creates a map of some primitive key type to some value type.
     *
     * @param keyType type of key, must be a primitive.
     * @param valueType type fo the value indexed by the key.
     * @experimental
     */
    static map(keyType, valueType) {
        jsiiDeprecationWarnings._aws_cdk_aws_glue_alpha_Type(keyType);
        jsiiDeprecationWarnings._aws_cdk_aws_glue_alpha_Type(valueType);
        if (!keyType.isPrimitive) {
            throw new Error(`the key type of a 'map' must be a primitive, but was ${keyType.inputString}`);
        }
        return {
            isPrimitive: false,
            inputString: `map<${keyType.inputString},${valueType.inputString}>`,
        };
    }
    /**
     * (experimental) Creates a nested structure containing individually named and typed columns.
     *
     * @param columns the columns of the structure.
     * @experimental
     */
    static struct(columns) {
        return {
            isPrimitive: false,
            inputString: `struct<${columns.map(column => {
                if (column.comment === undefined) {
                    return `${column.name}:${column.type.inputString}`;
                }
                else {
                    return `${column.name}:${column.type.inputString} COMMENT '${column.comment}'`;
                }
            }).join(',')}>`,
        };
    }
}
exports.Schema = Schema;
_a = JSII_RTTI_SYMBOL_1;
Schema[_a] = { fqn: "@aws-cdk/aws-glue-alpha.Schema", version: "2.5.0-alpha.0" };
/**
 * @experimental
 */
Schema.BOOLEAN = {
    isPrimitive: true,
    inputString: 'boolean',
};
/**
 * @experimental
 */
Schema.BINARY = {
    isPrimitive: true,
    inputString: 'binary',
};
/**
 * (experimental) A 64-bit signed INTEGER in two’s complement format, with a minimum value of -2^63 and a maximum value of 2^63-1.
 *
 * @experimental
 */
Schema.BIG_INT = {
    isPrimitive: true,
    inputString: 'bigint',
};
/**
 * @experimental
 */
Schema.DOUBLE = {
    isPrimitive: true,
    inputString: 'double',
};
/**
 * @experimental
 */
Schema.FLOAT = {
    isPrimitive: true,
    inputString: 'float',
};
/**
 * (experimental) A 32-bit signed INTEGER in two’s complement format, with a minimum value of -2^31 and a maximum value of 2^31-1.
 *
 * @experimental
 */
Schema.INTEGER = {
    isPrimitive: true,
    inputString: 'int',
};
/**
 * (experimental) A 16-bit signed INTEGER in two’s complement format, with a minimum value of -2^15 and a maximum value of 2^15-1.
 *
 * @experimental
 */
Schema.SMALL_INT = {
    isPrimitive: true,
    inputString: 'smallint',
};
/**
 * (experimental) A 8-bit signed INTEGER in two’s complement format, with a minimum value of -2^7 and a maximum value of 2^7-1.
 *
 * @experimental
 */
Schema.TINY_INT = {
    isPrimitive: true,
    inputString: 'tinyint',
};
/**
 * (experimental) Date type.
 *
 * @experimental
 */
Schema.DATE = {
    isPrimitive: true,
    inputString: 'date',
};
/**
 * (experimental) Timestamp type (date and time).
 *
 * @experimental
 */
Schema.TIMESTAMP = {
    isPrimitive: true,
    inputString: 'timestamp',
};
/**
 * (experimental) Arbitrary-length string type.
 *
 * @experimental
 */
Schema.STRING = {
    isPrimitive: true,
    inputString: 'string',
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic2NoZW1hLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsic2NoZW1hLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7Ozs7Ozs7QUFzQkEsTUFBYSxNQUFNOzs7Ozs7Ozs7O0lBZ0VWLE1BQU0sQ0FBQyxPQUFPLENBQUMsU0FBaUIsRUFBRSxLQUFjO1FBQ3JELE9BQU87WUFDTCxXQUFXLEVBQUUsSUFBSTtZQUNqQixXQUFXLEVBQUUsS0FBSyxLQUFLLFNBQVMsQ0FBQyxDQUFDLENBQUMsV0FBVyxTQUFTLElBQUksS0FBSyxHQUFHLENBQUMsQ0FBQyxDQUFDLFdBQVcsU0FBUyxHQUFHO1NBQzlGLENBQUM7S0FDSDs7Ozs7OztJQUdNLE1BQU0sQ0FBQyxJQUFJLENBQUMsTUFBYztRQUMvQixJQUFJLE1BQU0sSUFBSSxDQUFDLElBQUksTUFBTSxHQUFHLEdBQUcsRUFBRTtZQUMvQixNQUFNLElBQUksS0FBSyxDQUFDLGdFQUFnRSxNQUFNLEVBQUUsQ0FBQyxDQUFDO1NBQzNGO1FBQ0QsSUFBSSxNQUFNLEdBQUcsQ0FBQyxLQUFLLENBQUMsRUFBRTtZQUNwQixNQUFNLElBQUksS0FBSyxDQUFDLCtDQUErQyxNQUFNLEVBQUUsQ0FBQyxDQUFDO1NBQzFFO1FBQ0QsT0FBTztZQUNMLFdBQVcsRUFBRSxJQUFJO1lBQ2pCLFdBQVcsRUFBRSxRQUFRLE1BQU0sR0FBRztTQUMvQixDQUFDO0tBQ0g7Ozs7Ozs7SUFHTSxNQUFNLENBQUMsT0FBTyxDQUFDLE1BQWM7UUFDbEMsSUFBSSxNQUFNLElBQUksQ0FBQyxJQUFJLE1BQU0sR0FBRyxLQUFLLEVBQUU7WUFDakMsTUFBTSxJQUFJLEtBQUssQ0FBQyxxRUFBcUUsTUFBTSxFQUFFLENBQUMsQ0FBQztTQUNoRztRQUNELElBQUksTUFBTSxHQUFHLENBQUMsS0FBSyxDQUFDLEVBQUU7WUFDcEIsTUFBTSxJQUFJLEtBQUssQ0FBQyxrREFBa0QsTUFBTSxFQUFFLENBQUMsQ0FBQztTQUM3RTtRQUNELE9BQU87WUFDTCxXQUFXLEVBQUUsSUFBSTtZQUNqQixXQUFXLEVBQUUsV0FBVyxNQUFNLEdBQUc7U0FDbEMsQ0FBQztLQUNIOzs7Ozs7O0lBR00sTUFBTSxDQUFDLEtBQUssQ0FBQyxRQUFjOztRQUNoQyxPQUFPO1lBQ0wsV0FBVyxFQUFFLEtBQUs7WUFDbEIsV0FBVyxFQUFFLFNBQVMsUUFBUSxDQUFDLFdBQVcsR0FBRztTQUM5QyxDQUFDO0tBQ0g7Ozs7Ozs7O0lBR00sTUFBTSxDQUFDLEdBQUcsQ0FBQyxPQUFhLEVBQUUsU0FBZTs7O1FBQzlDLElBQUksQ0FBQyxPQUFPLENBQUMsV0FBVyxFQUFFO1lBQ3hCLE1BQU0sSUFBSSxLQUFLLENBQUMsd0RBQXdELE9BQU8sQ0FBQyxXQUFXLEVBQUUsQ0FBQyxDQUFDO1NBQ2hHO1FBQ0QsT0FBTztZQUNMLFdBQVcsRUFBRSxLQUFLO1lBQ2xCLFdBQVcsRUFBRSxPQUFPLE9BQU8sQ0FBQyxXQUFXLElBQUksU0FBUyxDQUFDLFdBQVcsR0FBRztTQUNwRSxDQUFDO0tBQ0g7Ozs7Ozs7SUFHTSxNQUFNLENBQUMsTUFBTSxDQUFDLE9BQWlCO1FBQ3BDLE9BQU87WUFDTCxXQUFXLEVBQUUsS0FBSztZQUNsQixXQUFXLEVBQUUsVUFBVSxPQUFPLENBQUMsR0FBRyxDQUFDLE1BQU0sQ0FBQyxFQUFFO2dCQUMxQyxJQUFJLE1BQU0sQ0FBQyxPQUFPLEtBQUssU0FBUyxFQUFFO29CQUNoQyxPQUFPLEdBQUcsTUFBTSxDQUFDLElBQUksSUFBSSxNQUFNLENBQUMsSUFBSSxDQUFDLFdBQVcsRUFBRSxDQUFDO2lCQUNwRDtxQkFBTTtvQkFDTCxPQUFPLEdBQUcsTUFBTSxDQUFDLElBQUksSUFBSSxNQUFNLENBQUMsSUFBSSxDQUFDLFdBQVcsYUFBYSxNQUFNLENBQUMsT0FBTyxHQUFHLENBQUM7aUJBQ2hGO1lBQ0gsQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxHQUFHO1NBQ2hCLENBQUM7S0FDSDs7QUFsSUgsd0JBbUlDOzs7Ozs7QUFsSXdCLGNBQU8sR0FBUztJQUNyQyxXQUFXLEVBQUUsSUFBSTtJQUNqQixXQUFXLEVBQUUsU0FBUztDQUN2QixDQUFDOzs7O0FBRXFCLGFBQU0sR0FBUztJQUNwQyxXQUFXLEVBQUUsSUFBSTtJQUNqQixXQUFXLEVBQUUsUUFBUTtDQUN0QixDQUFDOzs7Ozs7QUFHcUIsY0FBTyxHQUFTO0lBQ3JDLFdBQVcsRUFBRSxJQUFJO0lBQ2pCLFdBQVcsRUFBRSxRQUFRO0NBQ3RCLENBQUM7Ozs7QUFFcUIsYUFBTSxHQUFTO0lBQ3BDLFdBQVcsRUFBRSxJQUFJO0lBQ2pCLFdBQVcsRUFBRSxRQUFRO0NBQ3RCLENBQUM7Ozs7QUFFcUIsWUFBSyxHQUFTO0lBQ25DLFdBQVcsRUFBRSxJQUFJO0lBQ2pCLFdBQVcsRUFBRSxPQUFPO0NBQ3JCLENBQUM7Ozs7OztBQUdxQixjQUFPLEdBQVM7SUFDckMsV0FBVyxFQUFFLElBQUk7SUFDakIsV0FBVyxFQUFFLEtBQUs7Q0FDbkIsQ0FBQzs7Ozs7O0FBR3FCLGdCQUFTLEdBQVM7SUFDdkMsV0FBVyxFQUFFLElBQUk7SUFDakIsV0FBVyxFQUFFLFVBQVU7Q0FDeEIsQ0FBQzs7Ozs7O0FBR3FCLGVBQVEsR0FBUztJQUN0QyxXQUFXLEVBQUUsSUFBSTtJQUNqQixXQUFXLEVBQUUsU0FBUztDQUN2QixDQUFDOzs7Ozs7QUFHcUIsV0FBSSxHQUFTO0lBQ2xDLFdBQVcsRUFBRSxJQUFJO0lBQ2pCLFdBQVcsRUFBRSxNQUFNO0NBQ3BCLENBQUM7Ozs7OztBQUdxQixnQkFBUyxHQUFTO0lBQ3ZDLFdBQVcsRUFBRSxJQUFJO0lBQ2pCLFdBQVcsRUFBRSxXQUFXO0NBQ3pCLENBQUM7Ozs7OztBQUdxQixhQUFNLEdBQVM7SUFDcEMsV0FBVyxFQUFFLElBQUk7SUFDakIsV0FBVyxFQUFFLFFBQVE7Q0FDdEIsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgQ29sdW1uIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBuYW1lOiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSB0eXBlOiBUeXBlO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGNvbW1lbnQ/OiBzdHJpbmc7XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIFR5cGUge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBpc1ByaW1pdGl2ZTogYm9vbGVhbjtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGlucHV0U3RyaW5nOiBzdHJpbmc7XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBjbGFzcyBTY2hlbWEge1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEJPT0xFQU46IFR5cGUgPSB7XG4gICAgaXNQcmltaXRpdmU6IHRydWUsXG4gICAgaW5wdXRTdHJpbmc6ICdib29sZWFuJyxcbiAgfTtcblxuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEJJTkFSWTogVHlwZSA9IHtcbiAgICBpc1ByaW1pdGl2ZTogdHJ1ZSxcbiAgICBpbnB1dFN0cmluZzogJ2JpbmFyeScsXG4gIH07XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEJJR19JTlQ6IFR5cGUgPSB7XG4gICAgaXNQcmltaXRpdmU6IHRydWUsXG4gICAgaW5wdXRTdHJpbmc6ICdiaWdpbnQnLFxuICB9O1xuXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgRE9VQkxFOiBUeXBlID0ge1xuICAgIGlzUHJpbWl0aXZlOiB0cnVlLFxuICAgIGlucHV0U3RyaW5nOiAnZG91YmxlJyxcbiAgfTtcblxuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEZMT0FUOiBUeXBlID0ge1xuICAgIGlzUHJpbWl0aXZlOiB0cnVlLFxuICAgIGlucHV0U3RyaW5nOiAnZmxvYXQnLFxuICB9O1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBJTlRFR0VSOiBUeXBlID0ge1xuICAgIGlzUHJpbWl0aXZlOiB0cnVlLFxuICAgIGlucHV0U3RyaW5nOiAnaW50JyxcbiAgfTtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgU01BTExfSU5UOiBUeXBlID0ge1xuICAgIGlzUHJpbWl0aXZlOiB0cnVlLFxuICAgIGlucHV0U3RyaW5nOiAnc21hbGxpbnQnLFxuICB9O1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFRJTllfSU5UOiBUeXBlID0ge1xuICAgIGlzUHJpbWl0aXZlOiB0cnVlLFxuICAgIGlucHV0U3RyaW5nOiAndGlueWludCcsXG4gIH07XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IERBVEU6IFR5cGUgPSB7XG4gICAgaXNQcmltaXRpdmU6IHRydWUsXG4gICAgaW5wdXRTdHJpbmc6ICdkYXRlJyxcbiAgfTtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVElNRVNUQU1QOiBUeXBlID0ge1xuICAgIGlzUHJpbWl0aXZlOiB0cnVlLFxuICAgIGlucHV0U3RyaW5nOiAndGltZXN0YW1wJyxcbiAgfTtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFNUUklORzogVHlwZSA9IHtcbiAgICBpc1ByaW1pdGl2ZTogdHJ1ZSxcbiAgICBpbnB1dFN0cmluZzogJ3N0cmluZycsXG4gIH07XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHN0YXRpYyBkZWNpbWFsKHByZWNpc2lvbjogbnVtYmVyLCBzY2FsZT86IG51bWJlcik6IFR5cGUge1xuICAgIHJldHVybiB7XG4gICAgICBpc1ByaW1pdGl2ZTogdHJ1ZSxcbiAgICAgIGlucHV0U3RyaW5nOiBzY2FsZSAhPT0gdW5kZWZpbmVkID8gYGRlY2ltYWwoJHtwcmVjaXNpb259LCR7c2NhbGV9KWAgOiBgZGVjaW1hbCgke3ByZWNpc2lvbn0pYCxcbiAgICB9O1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBzdGF0aWMgY2hhcihsZW5ndGg6IG51bWJlcik6IFR5cGUge1xuICAgIGlmIChsZW5ndGggPD0gMCB8fCBsZW5ndGggPiAyNTUpIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcihgY2hhciBsZW5ndGggbXVzdCBiZSAoaW5jbHVzaXZlbHkpIGJldHdlZW4gMSBhbmQgMjU1LCBidXQgd2FzICR7bGVuZ3RofWApO1xuICAgIH1cbiAgICBpZiAobGVuZ3RoICUgMSAhPT0gMCkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKGBjaGFyIGxlbmd0aCBtdXN0IGJlIGEgcG9zaXRpdmUgaW50ZWdlciwgd2FzICR7bGVuZ3RofWApO1xuICAgIH1cbiAgICByZXR1cm4ge1xuICAgICAgaXNQcmltaXRpdmU6IHRydWUsXG4gICAgICBpbnB1dFN0cmluZzogYGNoYXIoJHtsZW5ndGh9KWAsXG4gICAgfTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBzdGF0aWMgdmFyY2hhcihsZW5ndGg6IG51bWJlcik6IFR5cGUge1xuICAgIGlmIChsZW5ndGggPD0gMCB8fCBsZW5ndGggPiA2NTUzNSkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKGB2YXJjaGFyIGxlbmd0aCBtdXN0IGJlIChpbmNsdXNpdmVseSkgYmV0d2VlbiAxIGFuZCA2NTUzNSwgYnV0IHdhcyAke2xlbmd0aH1gKTtcbiAgICB9XG4gICAgaWYgKGxlbmd0aCAlIDEgIT09IDApIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcihgdmFyY2hhciBsZW5ndGggbXVzdCBiZSBhIHBvc2l0aXZlIGludGVnZXIsIHdhcyAke2xlbmd0aH1gKTtcbiAgICB9XG4gICAgcmV0dXJuIHtcbiAgICAgIGlzUHJpbWl0aXZlOiB0cnVlLFxuICAgICAgaW5wdXRTdHJpbmc6IGB2YXJjaGFyKCR7bGVuZ3RofSlgLFxuICAgIH07XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBzdGF0aWMgYXJyYXkoaXRlbVR5cGU6IFR5cGUpOiBUeXBlIHtcbiAgICByZXR1cm4ge1xuICAgICAgaXNQcmltaXRpdmU6IGZhbHNlLFxuICAgICAgaW5wdXRTdHJpbmc6IGBhcnJheTwke2l0ZW1UeXBlLmlucHV0U3RyaW5nfT5gLFxuICAgIH07XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgc3RhdGljIG1hcChrZXlUeXBlOiBUeXBlLCB2YWx1ZVR5cGU6IFR5cGUpOiBUeXBlIHtcbiAgICBpZiAoIWtleVR5cGUuaXNQcmltaXRpdmUpIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcihgdGhlIGtleSB0eXBlIG9mIGEgJ21hcCcgbXVzdCBiZSBhIHByaW1pdGl2ZSwgYnV0IHdhcyAke2tleVR5cGUuaW5wdXRTdHJpbmd9YCk7XG4gICAgfVxuICAgIHJldHVybiB7XG4gICAgICBpc1ByaW1pdGl2ZTogZmFsc2UsXG4gICAgICBpbnB1dFN0cmluZzogYG1hcDwke2tleVR5cGUuaW5wdXRTdHJpbmd9LCR7dmFsdWVUeXBlLmlucHV0U3RyaW5nfT5gLFxuICAgIH07XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBzdGF0aWMgc3RydWN0KGNvbHVtbnM6IENvbHVtbltdKTogVHlwZSB7XG4gICAgcmV0dXJuIHtcbiAgICAgIGlzUHJpbWl0aXZlOiBmYWxzZSxcbiAgICAgIGlucHV0U3RyaW5nOiBgc3RydWN0PCR7Y29sdW1ucy5tYXAoY29sdW1uID0+IHtcbiAgICAgICAgaWYgKGNvbHVtbi5jb21tZW50ID09PSB1bmRlZmluZWQpIHtcbiAgICAgICAgICByZXR1cm4gYCR7Y29sdW1uLm5hbWV9OiR7Y29sdW1uLnR5cGUuaW5wdXRTdHJpbmd9YDtcbiAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICByZXR1cm4gYCR7Y29sdW1uLm5hbWV9OiR7Y29sdW1uLnR5cGUuaW5wdXRTdHJpbmd9IENPTU1FTlQgJyR7Y29sdW1uLmNvbW1lbnR9J2A7XG4gICAgICAgIH1cbiAgICAgIH0pLmpvaW4oJywnKX0+YCxcbiAgICB9O1xuICB9XG59XG4iXX0=