"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SecurityConfiguration = exports.JobBookmarksEncryptionMode = exports.CloudWatchEncryptionMode = exports.S3EncryptionMode = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const kms = require("aws-cdk-lib/aws-kms");
const cdk = require("aws-cdk-lib");
const aws_glue_1 = require("aws-cdk-lib/aws-glue");
/**
 * (experimental) Encryption mode for S3.
 *
 * @see https://docs.aws.amazon.com/glue/latest/webapi/API_S3Encryption.html#Glue-Type-S3Encryption-S3EncryptionMode
 * @experimental
 */
var S3EncryptionMode;
(function (S3EncryptionMode) {
    S3EncryptionMode["S3_MANAGED"] = "SSE-S3";
    S3EncryptionMode["KMS"] = "SSE-KMS";
})(S3EncryptionMode = exports.S3EncryptionMode || (exports.S3EncryptionMode = {}));
/**
 * Encryption mode for CloudWatch Logs.
 * @see https://docs.aws.amazon.com/glue/latest/webapi/API_CloudWatchEncryption.html#Glue-Type-CloudWatchEncryption-CloudWatchEncryptionMode
 */
var CloudWatchEncryptionMode;
(function (CloudWatchEncryptionMode) {
    CloudWatchEncryptionMode["KMS"] = "SSE-KMS";
})(CloudWatchEncryptionMode = exports.CloudWatchEncryptionMode || (exports.CloudWatchEncryptionMode = {}));
/**
 * Encryption mode for Job Bookmarks.
 * @see https://docs.aws.amazon.com/glue/latest/webapi/API_JobBookmarksEncryption.html#Glue-Type-JobBookmarksEncryption-JobBookmarksEncryptionMode
 */
var JobBookmarksEncryptionMode;
(function (JobBookmarksEncryptionMode) {
    JobBookmarksEncryptionMode["CLIENT_SIDE_KMS"] = "CSE-KMS";
})(JobBookmarksEncryptionMode = exports.JobBookmarksEncryptionMode || (exports.JobBookmarksEncryptionMode = {}));
/**
 * (experimental) A security configuration is a set of security properties that can be used by AWS Glue to encrypt data at rest.
 *
 * The following scenarios show some of the ways that you can use a security configuration.
 * - Attach a security configuration to an AWS Glue crawler to write encrypted Amazon CloudWatch Logs.
 * - Attach a security configuration to an extract, transform, and load (ETL) job to write encrypted Amazon Simple Storage Service (Amazon S3) targets and encrypted CloudWatch Logs.
 * - Attach a security configuration to an ETL job to write its jobs bookmarks as encrypted Amazon S3 data.
 * - Attach a security configuration to a development endpoint to write encrypted Amazon S3 targets.
 *
 * @experimental
 */
class SecurityConfiguration extends cdk.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _b, _c, _d;
        super(scope, id, {
            physicalName: props.securityConfigurationName,
        });
        jsiiDeprecationWarnings._aws_cdk_aws_glue_alpha_SecurityConfigurationProps(props);
        if (!props.s3Encryption && !props.cloudWatchEncryption && !props.jobBookmarksEncryption) {
            throw new Error('One of cloudWatchEncryption, jobBookmarksEncryption or s3Encryption must be defined');
        }
        const kmsKeyCreationRequired = (props.s3Encryption && props.s3Encryption.mode === S3EncryptionMode.KMS && !props.s3Encryption.kmsKey) ||
            (props.cloudWatchEncryption && !props.cloudWatchEncryption.kmsKey) ||
            (props.jobBookmarksEncryption && !props.jobBookmarksEncryption.kmsKey);
        const autoCreatedKmsKey = kmsKeyCreationRequired ? new kms.Key(this, 'Key') : undefined;
        let cloudWatchEncryption;
        if (props.cloudWatchEncryption) {
            this.cloudWatchEncryptionKey = props.cloudWatchEncryption.kmsKey || autoCreatedKmsKey;
            cloudWatchEncryption = {
                cloudWatchEncryptionMode: props.cloudWatchEncryption.mode,
                kmsKeyArn: (_b = this.cloudWatchEncryptionKey) === null || _b === void 0 ? void 0 : _b.keyArn,
            };
        }
        let jobBookmarksEncryption;
        if (props.jobBookmarksEncryption) {
            this.jobBookmarksEncryptionKey = props.jobBookmarksEncryption.kmsKey || autoCreatedKmsKey;
            jobBookmarksEncryption = {
                jobBookmarksEncryptionMode: props.jobBookmarksEncryption.mode,
                kmsKeyArn: (_c = this.jobBookmarksEncryptionKey) === null || _c === void 0 ? void 0 : _c.keyArn,
            };
        }
        let s3Encryptions;
        if (props.s3Encryption) {
            if (props.s3Encryption.mode === S3EncryptionMode.KMS) {
                this.s3EncryptionKey = props.s3Encryption.kmsKey || autoCreatedKmsKey;
            }
            // NOTE: CloudFormations errors out if array is of length > 1. That's why the props don't expose an array
            s3Encryptions = [{
                    s3EncryptionMode: props.s3Encryption.mode,
                    kmsKeyArn: (_d = this.s3EncryptionKey) === null || _d === void 0 ? void 0 : _d.keyArn,
                }];
        }
        const resource = new aws_glue_1.CfnSecurityConfiguration(this, 'Resource', {
            name: props.securityConfigurationName,
            encryptionConfiguration: {
                cloudWatchEncryption,
                jobBookmarksEncryption,
                s3Encryptions,
            },
        });
        this.securityConfigurationName = this.getResourceNameAttribute(resource.ref);
    }
    /**
     * (experimental) Creates a Connection construct that represents an external security configuration.
     *
     * @param scope The scope creating construct (usually `this`).
     * @param id The construct's id.
     * @param securityConfigurationName name of external security configuration.
     * @experimental
     */
    static fromSecurityConfigurationName(scope, id, securityConfigurationName) {
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.securityConfigurationName = securityConfigurationName;
            }
        }
        return new Import(scope, id);
    }
}
exports.SecurityConfiguration = SecurityConfiguration;
_a = JSII_RTTI_SYMBOL_1;
SecurityConfiguration[_a] = { fqn: "@aws-cdk/aws-glue-alpha.SecurityConfiguration", version: "2.5.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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