"use strict";
/**
 *  Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultGlueTableProps = void 0;
const core_1 = require("@aws-cdk/core");
function DefaultGlueTableProps(database, fieldSchema, sourceType, parameters) {
    let _tableProps;
    if (sourceType === 'kinesis') {
        const kinesisStreamName = parameters.STREAM_NAME;
        const _paths = fieldSchema.map((item) => {
            return item.name;
        }).join(',');
        _tableProps = {
            catalogId: database.catalogId,
            databaseName: database.ref,
            tableInput: {
                storageDescriptor: {
                    columns: fieldSchema,
                    location: kinesisStreamName,
                    inputFormat: "org.apache.hadoop.mapred.TextInputFormat",
                    outputFormat: "org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat",
                    compressed: false,
                    numberOfBuckets: -1,
                    serdeInfo: {
                        serializationLibrary: "org.openx.data.jsonserde.JsonSerDe",
                        parameters: {
                            paths: _paths
                        }
                    },
                    parameters: {
                        endpointUrl: `https://kinesis.${core_1.Aws.REGION}.amazonaws.com`,
                        streamName: kinesisStreamName,
                        typeOfData: sourceType
                    }
                },
                tableType: 'EXTERNAL_TABLE',
                parameters: {
                    classication: 'json'
                }
            }
        };
        return _tableProps;
    }
    else {
        throw Error('Source Type not Supported. Valid Source Type not provided');
    }
}
exports.DefaultGlueTableProps = DefaultGlueTableProps;
//# sourceMappingURL=data:application/json;base64,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