"use strict";
/**
 *  Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultSagemakerNotebookProps = void 0;
function DefaultSagemakerNotebookProps(roleArn, kmsKeyId, subnetId, securityGroupIds) {
    return {
        instanceType: 'ml.t2.medium',
        roleArn,
        kmsKeyId,
        ...subnetId && { subnetId, directInternetAccess: 'Disabled' },
        ...securityGroupIds && { securityGroupIds },
    };
}
exports.DefaultSagemakerNotebookProps = DefaultSagemakerNotebookProps;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic2FnZW1ha2VyLWRlZmF1bHRzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsic2FnZW1ha2VyLWRlZmF1bHRzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7QUFBQTs7Ozs7Ozs7Ozs7R0FXRzs7O0FBSUgsU0FBZ0IsNkJBQTZCLENBQUMsT0FBZSxFQUFFLFFBQWdCLEVBQzdFLFFBQWlCLEVBQUUsZ0JBQTJCO0lBQzlDLE9BQU87UUFDTCxZQUFZLEVBQUUsY0FBYztRQUM1QixPQUFPO1FBQ1AsUUFBUTtRQUNSLEdBQUksUUFBUSxJQUFJLEVBQUMsUUFBUSxFQUFFLG9CQUFvQixFQUFFLFVBQVUsRUFBQztRQUM1RCxHQUFJLGdCQUFnQixJQUFJLEVBQUMsZ0JBQWdCLEVBQUM7S0FDZixDQUFDO0FBQ2hDLENBQUM7QUFURCxzRUFTQyIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogIENvcHlyaWdodCAyMDIxIEFtYXpvbi5jb20sIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG4gKlxuICogIExpY2Vuc2VkIHVuZGVyIHRoZSBBcGFjaGUgTGljZW5zZSwgVmVyc2lvbiAyLjAgKHRoZSBcIkxpY2Vuc2VcIikuIFlvdSBtYXkgbm90IHVzZSB0aGlzIGZpbGUgZXhjZXB0IGluIGNvbXBsaWFuY2VcbiAqICB3aXRoIHRoZSBMaWNlbnNlLiBBIGNvcHkgb2YgdGhlIExpY2Vuc2UgaXMgbG9jYXRlZCBhdFxuICpcbiAqICAgICAgaHR0cDovL3d3dy5hcGFjaGUub3JnL2xpY2Vuc2VzL0xJQ0VOU0UtMi4wXG4gKlxuICogIG9yIGluIHRoZSAnbGljZW5zZScgZmlsZSBhY2NvbXBhbnlpbmcgdGhpcyBmaWxlLiBUaGlzIGZpbGUgaXMgZGlzdHJpYnV0ZWQgb24gYW4gJ0FTIElTJyBCQVNJUywgV0lUSE9VVCBXQVJSQU5USUVTXG4gKiAgT1IgQ09ORElUSU9OUyBPRiBBTlkgS0lORCwgZXhwcmVzcyBvciBpbXBsaWVkLiBTZWUgdGhlIExpY2Vuc2UgZm9yIHRoZSBzcGVjaWZpYyBsYW5ndWFnZSBnb3Zlcm5pbmcgcGVybWlzc2lvbnNcbiAqICBhbmQgbGltaXRhdGlvbnMgdW5kZXIgdGhlIExpY2Vuc2UuXG4gKi9cblxuaW1wb3J0IHsgQ2ZuTm90ZWJvb2tJbnN0YW5jZVByb3BzIH0gZnJvbSAnQGF3cy1jZGsvYXdzLXNhZ2VtYWtlcic7XG5cbmV4cG9ydCBmdW5jdGlvbiBEZWZhdWx0U2FnZW1ha2VyTm90ZWJvb2tQcm9wcyhyb2xlQXJuOiBzdHJpbmcsIGttc0tleUlkOiBzdHJpbmcsXG4gIHN1Ym5ldElkPzogc3RyaW5nLCBzZWN1cml0eUdyb3VwSWRzPzogc3RyaW5nW10pOiBDZm5Ob3RlYm9va0luc3RhbmNlUHJvcHMge1xuICByZXR1cm4ge1xuICAgIGluc3RhbmNlVHlwZTogJ21sLnQyLm1lZGl1bScsXG4gICAgcm9sZUFybixcbiAgICBrbXNLZXlJZCxcbiAgICAuLi4gc3VibmV0SWQgJiYge3N1Ym5ldElkLCBkaXJlY3RJbnRlcm5ldEFjY2VzczogJ0Rpc2FibGVkJ30sXG4gICAgLi4uIHNlY3VyaXR5R3JvdXBJZHMgJiYge3NlY3VyaXR5R3JvdXBJZHN9LFxuICB9IGFzIENmbk5vdGVib29rSW5zdGFuY2VQcm9wcztcbn0iXX0=