"use strict";
/**
 *  Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.printWarning = exports.overrideProps = void 0;
const deepmerge = require("deepmerge");
const override_warning_service_1 = require("./override-warning-service");
const log = require("npmlog");
function isObject(val) {
    return val != null && typeof val === 'object'
        && Object.prototype.toString.call(val) === '[object Object]';
}
function isPlainObject(o) {
    if (Array.isArray(o) === true) {
        return true;
    }
    if (isObject(o) === false) {
        return false;
    }
    // If has modified constructor
    const ctor = o.constructor;
    if (typeof ctor !== 'function') {
        return false;
    }
    // If has modified prototype
    const prot = ctor.prototype;
    if (isObject(prot) === false) {
        return false;
    }
    // If constructor does not have an Object-specific method
    if (prot.hasOwnProperty('isPrototypeOf') === false) {
        return false;
    }
    // Most likely a plain Object
    return true;
}
function combineMerge(target, source) {
    return target.concat(source);
}
function overwriteMerge(target, source) {
    target = source;
    return target;
}
function overrideProps(DefaultProps, userProps, concatArray = false) {
    // Notify the user via console output if defaults are overridden
    const overrideWarningsEnabled = (process.env.overrideWarningsEnabled !== 'false');
    if (overrideWarningsEnabled) {
        override_warning_service_1.flagOverriddenDefaults(DefaultProps, userProps);
    }
    // Override the sensible defaults with user provided props
    if (concatArray) {
        return deepmerge(DefaultProps, userProps, {
            arrayMerge: combineMerge,
            isMergeableObject: isPlainObject
        });
    }
    else {
        return deepmerge(DefaultProps, userProps, {
            arrayMerge: overwriteMerge,
            isMergeableObject: isPlainObject
        });
    }
}
exports.overrideProps = overrideProps;
function printWarning(message) {
    // Style the log output
    log.prefixStyle.bold = true;
    log.prefixStyle.fg = 'red';
    log.enableColor();
    log.warn('AWS_SOLUTIONS_CONSTRUCTS_WARNING: ', message);
}
exports.printWarning = printWarning;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXRpbHMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJ1dGlscy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiO0FBQUE7Ozs7Ozs7Ozs7O0dBV0c7OztBQUVILHVDQUF1QztBQUN2Qyx5RUFBb0U7QUFDcEUsOEJBQThCO0FBRTlCLFNBQVMsUUFBUSxDQUFDLEdBQVc7SUFDM0IsT0FBTyxHQUFHLElBQUksSUFBSSxJQUFJLE9BQU8sR0FBRyxLQUFLLFFBQVE7V0FDcEMsTUFBTSxDQUFDLFNBQVMsQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxLQUFLLGlCQUFpQixDQUFDO0FBQ3JFLENBQUM7QUFFRCxTQUFTLGFBQWEsQ0FBQyxDQUFTO0lBQzlCLElBQUksS0FBSyxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsS0FBSyxJQUFJLEVBQUU7UUFDN0IsT0FBTyxJQUFJLENBQUM7S0FDYjtJQUVELElBQUksUUFBUSxDQUFDLENBQUMsQ0FBQyxLQUFLLEtBQUssRUFBRTtRQUN6QixPQUFPLEtBQUssQ0FBQztLQUNkO0lBRUQsOEJBQThCO0lBQzlCLE1BQU0sSUFBSSxHQUFHLENBQUMsQ0FBQyxXQUFXLENBQUM7SUFDM0IsSUFBSSxPQUFPLElBQUksS0FBSyxVQUFVLEVBQUU7UUFDOUIsT0FBTyxLQUFLLENBQUM7S0FDZDtJQUVELDRCQUE0QjtJQUM1QixNQUFNLElBQUksR0FBRyxJQUFJLENBQUMsU0FBUyxDQUFDO0lBQzVCLElBQUksUUFBUSxDQUFDLElBQUksQ0FBQyxLQUFLLEtBQUssRUFBRTtRQUM1QixPQUFPLEtBQUssQ0FBQztLQUNkO0lBRUQseURBQXlEO0lBQ3pELElBQUksSUFBSSxDQUFDLGNBQWMsQ0FBQyxlQUFlLENBQUMsS0FBSyxLQUFLLEVBQUU7UUFDbEQsT0FBTyxLQUFLLENBQUM7S0FDZDtJQUVELDZCQUE2QjtJQUM3QixPQUFPLElBQUksQ0FBQztBQUNkLENBQUM7QUFFRCxTQUFTLFlBQVksQ0FBQyxNQUFhLEVBQUUsTUFBYTtJQUNoRCxPQUFPLE1BQU0sQ0FBQyxNQUFNLENBQUMsTUFBTSxDQUFDLENBQUM7QUFDL0IsQ0FBQztBQUVELFNBQVMsY0FBYyxDQUFDLE1BQWEsRUFBRSxNQUFhO0lBQ2xELE1BQU0sR0FBRyxNQUFNLENBQUM7SUFDaEIsT0FBTyxNQUFNLENBQUM7QUFDaEIsQ0FBQztBQUVELFNBQWdCLGFBQWEsQ0FBQyxZQUFvQixFQUFFLFNBQWlCLEVBQUUsY0FBdUIsS0FBSztJQUNqRyxnRUFBZ0U7SUFDaEUsTUFBTSx1QkFBdUIsR0FBRyxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsdUJBQXVCLEtBQUssT0FBTyxDQUFDLENBQUM7SUFDbEYsSUFBSSx1QkFBdUIsRUFBRTtRQUMzQixpREFBc0IsQ0FBQyxZQUFZLEVBQUUsU0FBUyxDQUFDLENBQUM7S0FDakQ7SUFDRCwwREFBMEQ7SUFDMUQsSUFBSSxXQUFXLEVBQUU7UUFDZixPQUFPLFNBQVMsQ0FBQyxZQUFZLEVBQUUsU0FBUyxFQUFFO1lBQ3hDLFVBQVUsRUFBRSxZQUFZO1lBQ3hCLGlCQUFpQixFQUFFLGFBQWE7U0FDakMsQ0FBQyxDQUFDO0tBQ0o7U0FBTTtRQUNMLE9BQU8sU0FBUyxDQUFDLFlBQVksRUFBRSxTQUFTLEVBQUU7WUFDeEMsVUFBVSxFQUFFLGNBQWM7WUFDMUIsaUJBQWlCLEVBQUUsYUFBYTtTQUNqQyxDQUFDLENBQUM7S0FDSjtBQUNILENBQUM7QUFsQkQsc0NBa0JDO0FBRUQsU0FBZ0IsWUFBWSxDQUFDLE9BQWU7SUFDMUMsdUJBQXVCO0lBQ3ZCLEdBQUcsQ0FBQyxXQUFXLENBQUMsSUFBSSxHQUFHLElBQUksQ0FBQztJQUM1QixHQUFHLENBQUMsV0FBVyxDQUFDLEVBQUUsR0FBRyxLQUFLLENBQUM7SUFDM0IsR0FBRyxDQUFDLFdBQVcsRUFBRSxDQUFDO0lBQ2xCLEdBQUcsQ0FBQyxJQUFJLENBQUMsb0NBQW9DLEVBQUUsT0FBTyxDQUFDLENBQUM7QUFDMUQsQ0FBQztBQU5ELG9DQU1DIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiAgQ29weXJpZ2h0IDIwMjEgQW1hem9uLmNvbSwgSW5jLiBvciBpdHMgYWZmaWxpYXRlcy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cbiAqXG4gKiAgTGljZW5zZWQgdW5kZXIgdGhlIEFwYWNoZSBMaWNlbnNlLCBWZXJzaW9uIDIuMCAodGhlIFwiTGljZW5zZVwiKS4gWW91IG1heSBub3QgdXNlIHRoaXMgZmlsZSBleGNlcHQgaW4gY29tcGxpYW5jZVxuICogIHdpdGggdGhlIExpY2Vuc2UuIEEgY29weSBvZiB0aGUgTGljZW5zZSBpcyBsb2NhdGVkIGF0XG4gKlxuICogICAgICBodHRwOi8vd3d3LmFwYWNoZS5vcmcvbGljZW5zZXMvTElDRU5TRS0yLjBcbiAqXG4gKiAgb3IgaW4gdGhlICdsaWNlbnNlJyBmaWxlIGFjY29tcGFueWluZyB0aGlzIGZpbGUuIFRoaXMgZmlsZSBpcyBkaXN0cmlidXRlZCBvbiBhbiAnQVMgSVMnIEJBU0lTLCBXSVRIT1VUIFdBUlJBTlRJRVNcbiAqICBPUiBDT05ESVRJT05TIE9GIEFOWSBLSU5ELCBleHByZXNzIG9yIGltcGxpZWQuIFNlZSB0aGUgTGljZW5zZSBmb3IgdGhlIHNwZWNpZmljIGxhbmd1YWdlIGdvdmVybmluZyBwZXJtaXNzaW9uc1xuICogIGFuZCBsaW1pdGF0aW9ucyB1bmRlciB0aGUgTGljZW5zZS5cbiAqL1xuXG5pbXBvcnQgKiBhcyBkZWVwbWVyZ2UgZnJvbSAnZGVlcG1lcmdlJztcbmltcG9ydCB7IGZsYWdPdmVycmlkZGVuRGVmYXVsdHMgfSBmcm9tICcuL292ZXJyaWRlLXdhcm5pbmctc2VydmljZSc7XG5pbXBvcnQgKiBhcyBsb2cgZnJvbSAnbnBtbG9nJztcblxuZnVuY3Rpb24gaXNPYmplY3QodmFsOiBvYmplY3QpIHtcbiAgcmV0dXJuIHZhbCAhPSBudWxsICYmIHR5cGVvZiB2YWwgPT09ICdvYmplY3QnXG4gICAgICAgICYmIE9iamVjdC5wcm90b3R5cGUudG9TdHJpbmcuY2FsbCh2YWwpID09PSAnW29iamVjdCBPYmplY3RdJztcbn1cblxuZnVuY3Rpb24gaXNQbGFpbk9iamVjdChvOiBvYmplY3QpIHtcbiAgaWYgKEFycmF5LmlzQXJyYXkobykgPT09IHRydWUpIHtcbiAgICByZXR1cm4gdHJ1ZTtcbiAgfVxuXG4gIGlmIChpc09iamVjdChvKSA9PT0gZmFsc2UpIHtcbiAgICByZXR1cm4gZmFsc2U7XG4gIH1cblxuICAvLyBJZiBoYXMgbW9kaWZpZWQgY29uc3RydWN0b3JcbiAgY29uc3QgY3RvciA9IG8uY29uc3RydWN0b3I7XG4gIGlmICh0eXBlb2YgY3RvciAhPT0gJ2Z1bmN0aW9uJykge1xuICAgIHJldHVybiBmYWxzZTtcbiAgfVxuXG4gIC8vIElmIGhhcyBtb2RpZmllZCBwcm90b3R5cGVcbiAgY29uc3QgcHJvdCA9IGN0b3IucHJvdG90eXBlO1xuICBpZiAoaXNPYmplY3QocHJvdCkgPT09IGZhbHNlKSB7XG4gICAgcmV0dXJuIGZhbHNlO1xuICB9XG5cbiAgLy8gSWYgY29uc3RydWN0b3IgZG9lcyBub3QgaGF2ZSBhbiBPYmplY3Qtc3BlY2lmaWMgbWV0aG9kXG4gIGlmIChwcm90Lmhhc093blByb3BlcnR5KCdpc1Byb3RvdHlwZU9mJykgPT09IGZhbHNlKSB7XG4gICAgcmV0dXJuIGZhbHNlO1xuICB9XG5cbiAgLy8gTW9zdCBsaWtlbHkgYSBwbGFpbiBPYmplY3RcbiAgcmV0dXJuIHRydWU7XG59XG5cbmZ1bmN0aW9uIGNvbWJpbmVNZXJnZSh0YXJnZXQ6IGFueVtdLCBzb3VyY2U6IGFueVtdKSB7XG4gIHJldHVybiB0YXJnZXQuY29uY2F0KHNvdXJjZSk7XG59XG5cbmZ1bmN0aW9uIG92ZXJ3cml0ZU1lcmdlKHRhcmdldDogYW55W10sIHNvdXJjZTogYW55W10pIHtcbiAgdGFyZ2V0ID0gc291cmNlO1xuICByZXR1cm4gdGFyZ2V0O1xufVxuXG5leHBvcnQgZnVuY3Rpb24gb3ZlcnJpZGVQcm9wcyhEZWZhdWx0UHJvcHM6IG9iamVjdCwgdXNlclByb3BzOiBvYmplY3QsIGNvbmNhdEFycmF5OiBib29sZWFuID0gZmFsc2UpOiBhbnkge1xuICAvLyBOb3RpZnkgdGhlIHVzZXIgdmlhIGNvbnNvbGUgb3V0cHV0IGlmIGRlZmF1bHRzIGFyZSBvdmVycmlkZGVuXG4gIGNvbnN0IG92ZXJyaWRlV2FybmluZ3NFbmFibGVkID0gKHByb2Nlc3MuZW52Lm92ZXJyaWRlV2FybmluZ3NFbmFibGVkICE9PSAnZmFsc2UnKTtcbiAgaWYgKG92ZXJyaWRlV2FybmluZ3NFbmFibGVkKSB7XG4gICAgZmxhZ092ZXJyaWRkZW5EZWZhdWx0cyhEZWZhdWx0UHJvcHMsIHVzZXJQcm9wcyk7XG4gIH1cbiAgLy8gT3ZlcnJpZGUgdGhlIHNlbnNpYmxlIGRlZmF1bHRzIHdpdGggdXNlciBwcm92aWRlZCBwcm9wc1xuICBpZiAoY29uY2F0QXJyYXkpIHtcbiAgICByZXR1cm4gZGVlcG1lcmdlKERlZmF1bHRQcm9wcywgdXNlclByb3BzLCB7XG4gICAgICBhcnJheU1lcmdlOiBjb21iaW5lTWVyZ2UsXG4gICAgICBpc01lcmdlYWJsZU9iamVjdDogaXNQbGFpbk9iamVjdFxuICAgIH0pO1xuICB9IGVsc2Uge1xuICAgIHJldHVybiBkZWVwbWVyZ2UoRGVmYXVsdFByb3BzLCB1c2VyUHJvcHMsIHtcbiAgICAgIGFycmF5TWVyZ2U6IG92ZXJ3cml0ZU1lcmdlLFxuICAgICAgaXNNZXJnZWFibGVPYmplY3Q6IGlzUGxhaW5PYmplY3RcbiAgICB9KTtcbiAgfVxufVxuXG5leHBvcnQgZnVuY3Rpb24gcHJpbnRXYXJuaW5nKG1lc3NhZ2U6IHN0cmluZykge1xuICAvLyBTdHlsZSB0aGUgbG9nIG91dHB1dFxuICBsb2cucHJlZml4U3R5bGUuYm9sZCA9IHRydWU7XG4gIGxvZy5wcmVmaXhTdHlsZS5mZyA9ICdyZWQnO1xuICBsb2cuZW5hYmxlQ29sb3IoKTtcbiAgbG9nLndhcm4oJ0FXU19TT0xVVElPTlNfQ09OU1RSVUNUU19XQVJOSU5HOiAnLCBtZXNzYWdlKTtcbn1cbiJdfQ==