#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""
Настраиваемые константные значения

"""

###############################################################################
# Значения, потенциально интересные пользователю


UNKNOWN_NAME = '<unknown>'
"""Такая строка будет отображаться там, где не удалось получить значение
"""

TRACER_SYSTEM_NAME = 'zipkin'
"""Такая строка должна быть в logging.tracer, чтобы данный трассер работал
"""

CUT_LIMIT = 4000
"""Максимальная длина строки содержимого

    Строки, длина которых в символах больше указанного здесь значения,
    будут обрезаться посередине
"""

CUT_LINE = '.......<CUT OVER {cut_limit} CHARS, FROM {ttl_len} TOTAL>.......'
"""Такая строка появится на месте вырезанного содержимого

    Можно использовать значения cut_limit, ttl_len. Или не использовать
"""

LOG_STRING_WRAP = 60
"""Аннотации являющиеся текстом не JSON переносить по строкам такой длины
"""

STATSD_DURATION_FACTOR = 1000

TAG_ESSENTIAL_FIELD_NAMES = (
    'code',
    ('form_request_id', 'request_id'),
    ('pid', 'payment_id', 'id', 'inplat_paym_id', 'orderNumber',),
    'link_id',
    'client_id',
    'refill_id',
    'account',
    'widget_id',
    'method',
    'orderId',
    'orderStatus',
    ('apikey', 'api_key',),
    'url_out',
    'url_in',
)
"""Существенные значения, помещаемые в заголовок

    Атрибуты, значения которых надо вытаскивать из тела запроса
    и помещать в заголовок, в метки для поиска
    если элемент - список, то вытаскивать значения под всеми этими именами,
    а размещать в метках под первым
"""

TAG_ESSENTIAL_BODY_NAMES = (
    'request_body',
    'response_body',
    'params',
    'pay_params',
    'params_extra',
)
"""Где искать существенные значения

    Если элементы данных представляют из себя словари или объекты,
    то существенные данные разыскиваются в их ключах или атрибутах
    соответственно под данными именами
"""

MASK_PARAMS = {
    'pan',
    'cvv',
    'cvc',
    'pwd',
    'password',
    'secret',
    'secret_key',
    'ACTIONPARAM_ID_17',
    'Authorization',
    'access_token',
}
MASK_PARAMS_PARTIALLY = {
    'pan',
}
MASK_CHAR = 'x'
MASK_CHAR_PARTIALLY = '*'
"""Какие данные маскировать

    Перед записью в участок трассера, уже преобразованное в строку
    перехваченное значение прогоняется через регулярное выражение, которое
    заменяет данные встречененые после присутствующих здесь слов на символ
    'x', или на частичное маскирование звездочками в варианте 'part',
     если этот ключ повторяется в множестве PARTIALLY.
"""


###############################################################################
# Никому неинтересные внутренние значения


COLLECT_TRACE = True
"""Собирать ли список вызовов при прохождении перехватчика

    Из него берутся наименования методов, вызывающие перехватвыаемую точку,
    чтобы в наименовании вместо ничего не говорящего "query" увидеть.
    например, "get_checked_payment" или вместо "send"
    получить "make_upay_request"

    Флаг был введён когда получение стека было реализовано накладным способом,
    через встроенную функцию inspect, сейчас, возможно, он уже потерял свой
    смысл
"""

PATH_IGNORE_METHODS = ('decorated', 'wrapper', '<module>')
"""Игнорировать методы для истории стека

    Для сбора истории стека вызовов игнорировать методы с данными именами
"""

PATH_IGNORE_PIECE = r'tracuni/'
"""Игнорировать пути для истории стека

    Для сбора истории стека вызовов игнорировать методы из модулей по данному
    пути
"""

CONTEXT_UID_NAME = 'span_context_uid'
"""Идентификатор участка в контексте

    Наименование ключа для идентификатора участка при сохранении в контексте
    асинхронных вызовов
"""

CONTEXT_SPAN_NAME = 'span_context'
"""Данные участка в контексте

    Наименование ключа для идентификатора участка при сохранении в контексте
    асинхронных вызовов
"""

SECRET_MASK_METHOD_NAME = 'pipe_secret'
"""Наименование маскирующего метода для работы конфигурации его запрета
"""
