# coding: utf-8

"""
    DeviceServer

    DeviceServer API  # noqa: E501

    The version of the OpenAPI document: 1.0.8
    Contact: david@3adesign.co.uk
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from DeviceServer.api_client import ApiClient
from DeviceServer.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class DevicesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_attenuator_state(self, device_id, expander_index, **kwargs):  # noqa: E501
        """GET attenuation state  # noqa: E501

        Get attenuation state selected expander port  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_attenuator_state(device_id, expander_index, async_req=True)
        >>> result = thread.get()

        :param device_id: (required)
        :type device_id: str
        :param expander_index: expander index (required)
        :type expander_index: int
        :param expander_port_index: expander port index
        :type expander_port_index: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetAttenuatorState200Response
        """
        kwargs['_return_http_data_only'] = True
        return self.get_attenuator_state_with_http_info(device_id, expander_index, **kwargs)  # noqa: E501

    def get_attenuator_state_with_http_info(self, device_id, expander_index, **kwargs):  # noqa: E501
        """GET attenuation state  # noqa: E501

        Get attenuation state selected expander port  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_attenuator_state_with_http_info(device_id, expander_index, async_req=True)
        >>> result = thread.get()

        :param device_id: (required)
        :type device_id: str
        :param expander_index: expander index (required)
        :type expander_index: int
        :param expander_port_index: expander port index
        :type expander_port_index: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetAttenuatorState200Response, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'device_id',
            'expander_index',
            'expander_port_index'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_attenuator_state" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'device_id' is set
        if self.api_client.client_side_validation and local_var_params.get('device_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `device_id` when calling `get_attenuator_state`")  # noqa: E501
        # verify the required parameter 'expander_index' is set
        if self.api_client.client_side_validation and local_var_params.get('expander_index') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `expander_index` when calling `get_attenuator_state`")  # noqa: E501

        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) > 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `get_attenuator_state`, length must be less than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) < 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `get_attenuator_state`, length must be greater than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and 'device_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}', local_var_params['device_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `get_attenuator_state`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}/`")  # noqa: E501
        if self.api_client.client_side_validation and 'expander_index' in local_var_params and local_var_params['expander_index'] > 10:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `expander_index` when calling `get_attenuator_state`, must be a value less than or equal to `10`")  # noqa: E501
        if self.api_client.client_side_validation and 'expander_index' in local_var_params and local_var_params['expander_index'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `expander_index` when calling `get_attenuator_state`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in local_var_params:
            path_params['device_id'] = local_var_params['device_id']  # noqa: E501

        query_params = []
        if local_var_params.get('expander_index') is not None:  # noqa: E501
            query_params.append(('expander_index', local_var_params['expander_index']))  # noqa: E501
        if local_var_params.get('expander_port_index') is not None:  # noqa: E501
            query_params.append(('expander_port_index', local_var_params['expander_port_index']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {
            200: "GetAttenuatorState200Response",
            201: None,
            400: None,
            401: None,
            403: None,
            404: None,
            500: None,
        }

        return self.api_client.call_api(
            '/Devices/{device_id}/Attenuate', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_channel_attenuation(self, device_id, channel_index, **kwargs):  # noqa: E501
        """GET attenuation channel state  # noqa: E501

        Get attenuation state sof selected channel  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_channel_attenuation(device_id, channel_index, async_req=True)
        >>> result = thread.get()

        :param device_id: (required)
        :type device_id: str
        :param channel_index: channel index (required)
        :type channel_index: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetAttenuatorState200Response
        """
        kwargs['_return_http_data_only'] = True
        return self.get_channel_attenuation_with_http_info(device_id, channel_index, **kwargs)  # noqa: E501

    def get_channel_attenuation_with_http_info(self, device_id, channel_index, **kwargs):  # noqa: E501
        """GET attenuation channel state  # noqa: E501

        Get attenuation state sof selected channel  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_channel_attenuation_with_http_info(device_id, channel_index, async_req=True)
        >>> result = thread.get()

        :param device_id: (required)
        :type device_id: str
        :param channel_index: channel index (required)
        :type channel_index: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetAttenuatorState200Response, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'device_id',
            'channel_index'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_channel_attenuation" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'device_id' is set
        if self.api_client.client_side_validation and local_var_params.get('device_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `device_id` when calling `get_channel_attenuation`")  # noqa: E501
        # verify the required parameter 'channel_index' is set
        if self.api_client.client_side_validation and local_var_params.get('channel_index') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `channel_index` when calling `get_channel_attenuation`")  # noqa: E501

        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) > 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `get_channel_attenuation`, length must be less than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) < 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `get_channel_attenuation`, length must be greater than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and 'device_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}', local_var_params['device_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `get_channel_attenuation`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}/`")  # noqa: E501
        if self.api_client.client_side_validation and 'channel_index' in local_var_params and local_var_params['channel_index'] > 10:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `channel_index` when calling `get_channel_attenuation`, must be a value less than or equal to `10`")  # noqa: E501
        if self.api_client.client_side_validation and 'channel_index' in local_var_params and local_var_params['channel_index'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `channel_index` when calling `get_channel_attenuation`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in local_var_params:
            path_params['device_id'] = local_var_params['device_id']  # noqa: E501

        query_params = []
        if local_var_params.get('channel_index') is not None:  # noqa: E501
            query_params.append(('channel_index', local_var_params['channel_index']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {
            200: "GetAttenuatorState200Response",
            201: None,
            400: None,
            401: None,
            403: None,
            404: None,
            500: None,
        }

        return self.api_client.call_api(
            '/Devices/{device_id}/AttenuateChannel', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_current(self, device_id, current_index, **kwargs):  # noqa: E501
        """GET current reading of device  # noqa: E501

        Returns voltage reading on selected device.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_current(device_id, current_index, async_req=True)
        >>> result = thread.get()

        :param device_id: UUID of device (required)
        :type device_id: str
        :param current_index: Index of Current port (required)
        :type current_index: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: float
        """
        kwargs['_return_http_data_only'] = True
        return self.get_current_with_http_info(device_id, current_index, **kwargs)  # noqa: E501

    def get_current_with_http_info(self, device_id, current_index, **kwargs):  # noqa: E501
        """GET current reading of device  # noqa: E501

        Returns voltage reading on selected device.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_current_with_http_info(device_id, current_index, async_req=True)
        >>> result = thread.get()

        :param device_id: UUID of device (required)
        :type device_id: str
        :param current_index: Index of Current port (required)
        :type current_index: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(float, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'device_id',
            'current_index'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_current" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'device_id' is set
        if self.api_client.client_side_validation and local_var_params.get('device_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `device_id` when calling `get_current`")  # noqa: E501
        # verify the required parameter 'current_index' is set
        if self.api_client.client_side_validation and local_var_params.get('current_index') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `current_index` when calling `get_current`")  # noqa: E501

        if self.api_client.client_side_validation and 'device_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}', local_var_params['device_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `get_current`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}/`")  # noqa: E501
        if self.api_client.client_side_validation and 'current_index' in local_var_params and local_var_params['current_index'] > 100:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `current_index` when calling `get_current`, must be a value less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and 'current_index' in local_var_params and local_var_params['current_index'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `current_index` when calling `get_current`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in local_var_params:
            path_params['device_id'] = local_var_params['device_id']  # noqa: E501
        if 'current_index' in local_var_params:
            path_params['current_index'] = local_var_params['current_index']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {
            200: "float",
            201: None,
            400: None,
            401: None,
            403: None,
            404: None,
            500: None,
        }

        return self.api_client.call_api(
            '/Devices/{device_id}/Currents/{current_index}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_device_attenuation_configuration(self, device_id, **kwargs):  # noqa: E501
        """GET attenuation device config  # noqa: E501

        Get attenuation condig sent through by the device  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_device_attenuation_configuration(device_id, async_req=True)
        >>> result = thread.get()

        :param device_id: (required)
        :type device_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: object
        """
        kwargs['_return_http_data_only'] = True
        return self.get_device_attenuation_configuration_with_http_info(device_id, **kwargs)  # noqa: E501

    def get_device_attenuation_configuration_with_http_info(self, device_id, **kwargs):  # noqa: E501
        """GET attenuation device config  # noqa: E501

        Get attenuation condig sent through by the device  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_device_attenuation_configuration_with_http_info(device_id, async_req=True)
        >>> result = thread.get()

        :param device_id: (required)
        :type device_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(object, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'device_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_device_attenuation_configuration" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'device_id' is set
        if self.api_client.client_side_validation and local_var_params.get('device_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `device_id` when calling `get_device_attenuation_configuration`")  # noqa: E501

        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) > 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `get_device_attenuation_configuration`, length must be less than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) < 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `get_device_attenuation_configuration`, length must be greater than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and 'device_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}', local_var_params['device_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `get_device_attenuation_configuration`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in local_var_params:
            path_params['device_id'] = local_var_params['device_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {
            200: "object",
            201: None,
            400: None,
            401: None,
            403: None,
            404: None,
            500: None,
        }

        return self.api_client.call_api(
            '/Devices/{device_id}/AttenuatorConfig', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_device_device_id_buttons(self, device_id, **kwargs):  # noqa: E501
        """GET all buttons for device  # noqa: E501

        Returns a list of all buttons attached to a device.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_device_device_id_buttons(device_id, async_req=True)
        >>> result = thread.get()

        :param device_id: UUID of device (required)
        :type device_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[DeviceButton]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_device_device_id_buttons_with_http_info(device_id, **kwargs)  # noqa: E501

    def get_device_device_id_buttons_with_http_info(self, device_id, **kwargs):  # noqa: E501
        """GET all buttons for device  # noqa: E501

        Returns a list of all buttons attached to a device.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_device_device_id_buttons_with_http_info(device_id, async_req=True)
        >>> result = thread.get()

        :param device_id: UUID of device (required)
        :type device_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[DeviceButton], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'device_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_device_device_id_buttons" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'device_id' is set
        if self.api_client.client_side_validation and local_var_params.get('device_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `device_id` when calling `get_device_device_id_buttons`")  # noqa: E501

        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) > 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `get_device_device_id_buttons`, length must be less than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) < 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `get_device_device_id_buttons`, length must be greater than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and 'device_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}', local_var_params['device_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `get_device_device_id_buttons`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in local_var_params:
            path_params['device_id'] = local_var_params['device_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {
            200: "list[DeviceButton]",
            201: None,
            400: None,
            401: None,
            403: None,
            404: None,
            500: None,
        }

        return self.api_client.call_api(
            '/Devices/{device_id}/Buttons', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_device_device_id_leds(self, device_id, **kwargs):  # noqa: E501
        """GET all leds for device  # noqa: E501

        Returns a list of all buttons attached to a device.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_device_device_id_leds(device_id, async_req=True)
        >>> result = thread.get()

        :param device_id: UUID of device (required)
        :type device_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[DeviceLed]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_device_device_id_leds_with_http_info(device_id, **kwargs)  # noqa: E501

    def get_device_device_id_leds_with_http_info(self, device_id, **kwargs):  # noqa: E501
        """GET all leds for device  # noqa: E501

        Returns a list of all buttons attached to a device.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_device_device_id_leds_with_http_info(device_id, async_req=True)
        >>> result = thread.get()

        :param device_id: UUID of device (required)
        :type device_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[DeviceLed], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'device_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_device_device_id_leds" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'device_id' is set
        if self.api_client.client_side_validation and local_var_params.get('device_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `device_id` when calling `get_device_device_id_leds`")  # noqa: E501

        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) > 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `get_device_device_id_leds`, length must be less than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) < 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `get_device_device_id_leds`, length must be greater than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and 'device_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}', local_var_params['device_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `get_device_device_id_leds`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in local_var_params:
            path_params['device_id'] = local_var_params['device_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {
            200: "list[DeviceLed]",
            201: None,
            400: None,
            401: None,
            403: None,
            404: None,
            500: None,
        }

        return self.api_client.call_api(
            '/Devices/{device_id}/Leds', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_device_device_id_ports(self, device_id, **kwargs):  # noqa: E501
        """GET all ports for device  # noqa: E501

        Returns a list of all ports attached to a device.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_device_device_id_ports(device_id, async_req=True)
        >>> result = thread.get()

        :param device_id: UUID of device (required)
        :type device_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[DevicePort]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_device_device_id_ports_with_http_info(device_id, **kwargs)  # noqa: E501

    def get_device_device_id_ports_with_http_info(self, device_id, **kwargs):  # noqa: E501
        """GET all ports for device  # noqa: E501

        Returns a list of all ports attached to a device.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_device_device_id_ports_with_http_info(device_id, async_req=True)
        >>> result = thread.get()

        :param device_id: UUID of device (required)
        :type device_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[DevicePort], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'device_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_device_device_id_ports" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'device_id' is set
        if self.api_client.client_side_validation and local_var_params.get('device_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `device_id` when calling `get_device_device_id_ports`")  # noqa: E501

        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) > 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `get_device_device_id_ports`, length must be less than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) < 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `get_device_device_id_ports`, length must be greater than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and 'device_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}', local_var_params['device_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `get_device_device_id_ports`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in local_var_params:
            path_params['device_id'] = local_var_params['device_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {
            200: "list[DevicePort]",
            201: None,
            400: None,
            401: None,
            403: None,
            404: None,
            500: None,
        }

        return self.api_client.call_api(
            '/Devices/{device_id}/Ports', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_device_device_id_temperature_ports(self, device_id, **kwargs):  # noqa: E501
        """GET all temperature ports for device  # noqa: E501

        Returns a list of all temperature ports attached to a device.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_device_device_id_temperature_ports(device_id, async_req=True)
        >>> result = thread.get()

        :param device_id: UUID of device (required)
        :type device_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[DeviceTemperaturePort]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_device_device_id_temperature_ports_with_http_info(device_id, **kwargs)  # noqa: E501

    def get_device_device_id_temperature_ports_with_http_info(self, device_id, **kwargs):  # noqa: E501
        """GET all temperature ports for device  # noqa: E501

        Returns a list of all temperature ports attached to a device.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_device_device_id_temperature_ports_with_http_info(device_id, async_req=True)
        >>> result = thread.get()

        :param device_id: UUID of device (required)
        :type device_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[DeviceTemperaturePort], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'device_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_device_device_id_temperature_ports" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'device_id' is set
        if self.api_client.client_side_validation and local_var_params.get('device_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `device_id` when calling `get_device_device_id_temperature_ports`")  # noqa: E501

        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) > 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `get_device_device_id_temperature_ports`, length must be less than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) < 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `get_device_device_id_temperature_ports`, length must be greater than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and 'device_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}', local_var_params['device_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `get_device_device_id_temperature_ports`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in local_var_params:
            path_params['device_id'] = local_var_params['device_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {
            200: "list[DeviceTemperaturePort]",
            201: None,
            400: None,
            401: None,
            403: None,
            404: None,
            500: None,
        }

        return self.api_client.call_api(
            '/Devices/{device_id}/Temparatures', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_device_id_port_index(self, device_id, port_index, **kwargs):  # noqa: E501
        """GET status of port  # noqa: E501

        Returns status of ports.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_device_id_port_index(device_id, port_index, async_req=True)
        >>> result = thread.get()

        :param device_id: UUID of device (required)
        :type device_id: str
        :param port_index: Index of port (required)
        :type port_index: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DevicePort
        """
        kwargs['_return_http_data_only'] = True
        return self.get_device_id_port_index_with_http_info(device_id, port_index, **kwargs)  # noqa: E501

    def get_device_id_port_index_with_http_info(self, device_id, port_index, **kwargs):  # noqa: E501
        """GET status of port  # noqa: E501

        Returns status of ports.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_device_id_port_index_with_http_info(device_id, port_index, async_req=True)
        >>> result = thread.get()

        :param device_id: UUID of device (required)
        :type device_id: str
        :param port_index: Index of port (required)
        :type port_index: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DevicePort, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'device_id',
            'port_index'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_device_id_port_index" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'device_id' is set
        if self.api_client.client_side_validation and local_var_params.get('device_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `device_id` when calling `get_device_id_port_index`")  # noqa: E501
        # verify the required parameter 'port_index' is set
        if self.api_client.client_side_validation and local_var_params.get('port_index') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `port_index` when calling `get_device_id_port_index`")  # noqa: E501

        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) > 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `get_device_id_port_index`, length must be less than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) < 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `get_device_id_port_index`, length must be greater than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and 'device_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}', local_var_params['device_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `get_device_id_port_index`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}/`")  # noqa: E501
        if self.api_client.client_side_validation and 'port_index' in local_var_params and local_var_params['port_index'] > 100:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `port_index` when calling `get_device_id_port_index`, must be a value less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and 'port_index' in local_var_params and local_var_params['port_index'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `port_index` when calling `get_device_id_port_index`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in local_var_params:
            path_params['device_id'] = local_var_params['device_id']  # noqa: E501
        if 'port_index' in local_var_params:
            path_params['port_index'] = local_var_params['port_index']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {
            200: "DevicePort",
            201: None,
            400: None,
            401: None,
            403: None,
            404: None,
            500: None,
        }

        return self.api_client.call_api(
            '/Devices/{device_id}/Ports/{port_index}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_device_port_current(self, device_id, port_index, **kwargs):  # noqa: E501
        """GET current reading of device Port  # noqa: E501

        Returns current reading on selected device port   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_device_port_current(device_id, port_index, async_req=True)
        >>> result = thread.get()

        :param device_id: UUID of device (required)
        :type device_id: str
        :param port_index: Port Index (required)
        :type port_index: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: float
        """
        kwargs['_return_http_data_only'] = True
        return self.get_device_port_current_with_http_info(device_id, port_index, **kwargs)  # noqa: E501

    def get_device_port_current_with_http_info(self, device_id, port_index, **kwargs):  # noqa: E501
        """GET current reading of device Port  # noqa: E501

        Returns current reading on selected device port   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_device_port_current_with_http_info(device_id, port_index, async_req=True)
        >>> result = thread.get()

        :param device_id: UUID of device (required)
        :type device_id: str
        :param port_index: Port Index (required)
        :type port_index: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(float, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'device_id',
            'port_index'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_device_port_current" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'device_id' is set
        if self.api_client.client_side_validation and local_var_params.get('device_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `device_id` when calling `get_device_port_current`")  # noqa: E501
        # verify the required parameter 'port_index' is set
        if self.api_client.client_side_validation and local_var_params.get('port_index') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `port_index` when calling `get_device_port_current`")  # noqa: E501

        if self.api_client.client_side_validation and 'device_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}', local_var_params['device_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `get_device_port_current`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}/`")  # noqa: E501
        if self.api_client.client_side_validation and 'port_index' in local_var_params and local_var_params['port_index'] > 100:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `port_index` when calling `get_device_port_current`, must be a value less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and 'port_index' in local_var_params and local_var_params['port_index'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `port_index` when calling `get_device_port_current`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in local_var_params:
            path_params['device_id'] = local_var_params['device_id']  # noqa: E501
        if 'port_index' in local_var_params:
            path_params['port_index'] = local_var_params['port_index']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {
            200: "float",
            201: None,
            400: None,
            401: None,
            403: None,
            404: None,
            500: None,
        }

        return self.api_client.call_api(
            '/Devices/{device_id}/Ports/{port_index}/Currents', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_device_port_module_led_state(self, device_id, port_index, module_index, **kwargs):  # noqa: E501
        """GET state of Port LED  # noqa: E501

        Returns state of selected led on specified device's port's module  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_device_port_module_led_state(device_id, port_index, module_index, async_req=True)
        >>> result = thread.get()

        :param device_id: UUID of device (required)
        :type device_id: str
        :param port_index: Index of Port (required)
        :type port_index: int
        :param module_index: Index of Module (required)
        :type module_index: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: object
        """
        kwargs['_return_http_data_only'] = True
        return self.get_device_port_module_led_state_with_http_info(device_id, port_index, module_index, **kwargs)  # noqa: E501

    def get_device_port_module_led_state_with_http_info(self, device_id, port_index, module_index, **kwargs):  # noqa: E501
        """GET state of Port LED  # noqa: E501

        Returns state of selected led on specified device's port's module  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_device_port_module_led_state_with_http_info(device_id, port_index, module_index, async_req=True)
        >>> result = thread.get()

        :param device_id: UUID of device (required)
        :type device_id: str
        :param port_index: Index of Port (required)
        :type port_index: int
        :param module_index: Index of Module (required)
        :type module_index: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(object, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'device_id',
            'port_index',
            'module_index'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_device_port_module_led_state" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'device_id' is set
        if self.api_client.client_side_validation and local_var_params.get('device_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `device_id` when calling `get_device_port_module_led_state`")  # noqa: E501
        # verify the required parameter 'port_index' is set
        if self.api_client.client_side_validation and local_var_params.get('port_index') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `port_index` when calling `get_device_port_module_led_state`")  # noqa: E501
        # verify the required parameter 'module_index' is set
        if self.api_client.client_side_validation and local_var_params.get('module_index') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `module_index` when calling `get_device_port_module_led_state`")  # noqa: E501

        if self.api_client.client_side_validation and 'device_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}', local_var_params['device_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `get_device_port_module_led_state`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}/`")  # noqa: E501
        if self.api_client.client_side_validation and 'port_index' in local_var_params and local_var_params['port_index'] > 8:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `port_index` when calling `get_device_port_module_led_state`, must be a value less than or equal to `8`")  # noqa: E501
        if self.api_client.client_side_validation and 'port_index' in local_var_params and local_var_params['port_index'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `port_index` when calling `get_device_port_module_led_state`, must be a value greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'module_index' in local_var_params and local_var_params['module_index'] > 100:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `module_index` when calling `get_device_port_module_led_state`, must be a value less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and 'module_index' in local_var_params and local_var_params['module_index'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `module_index` when calling `get_device_port_module_led_state`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in local_var_params:
            path_params['device_id'] = local_var_params['device_id']  # noqa: E501
        if 'port_index' in local_var_params:
            path_params['port_index'] = local_var_params['port_index']  # noqa: E501
        if 'module_index' in local_var_params:
            path_params['module_index'] = local_var_params['module_index']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {
            200: "object",
            201: None,
            400: None,
            401: None,
            403: None,
            404: None,
            500: None,
        }

        return self.api_client.call_api(
            '/Devices/{device_id}/Ports/{port_index}/Modules/{module_index}/Leds', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_device_port_module_relay_state(self, device_id, port_index, module_index, relay_index, **kwargs):  # noqa: E501
        """GET state of Port LED  # noqa: E501

        Returns state of selected relay on specified device's port's module  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_device_port_module_relay_state(device_id, port_index, module_index, relay_index, async_req=True)
        >>> result = thread.get()

        :param device_id: UUID of device (required)
        :type device_id: str
        :param port_index: Index of Port (required)
        :type port_index: int
        :param module_index: Index of Module (required)
        :type module_index: int
        :param relay_index: Index of Relay (required)
        :type relay_index: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: object
        """
        kwargs['_return_http_data_only'] = True
        return self.get_device_port_module_relay_state_with_http_info(device_id, port_index, module_index, relay_index, **kwargs)  # noqa: E501

    def get_device_port_module_relay_state_with_http_info(self, device_id, port_index, module_index, relay_index, **kwargs):  # noqa: E501
        """GET state of Port LED  # noqa: E501

        Returns state of selected relay on specified device's port's module  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_device_port_module_relay_state_with_http_info(device_id, port_index, module_index, relay_index, async_req=True)
        >>> result = thread.get()

        :param device_id: UUID of device (required)
        :type device_id: str
        :param port_index: Index of Port (required)
        :type port_index: int
        :param module_index: Index of Module (required)
        :type module_index: int
        :param relay_index: Index of Relay (required)
        :type relay_index: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(object, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'device_id',
            'port_index',
            'module_index',
            'relay_index'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_device_port_module_relay_state" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'device_id' is set
        if self.api_client.client_side_validation and local_var_params.get('device_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `device_id` when calling `get_device_port_module_relay_state`")  # noqa: E501
        # verify the required parameter 'port_index' is set
        if self.api_client.client_side_validation and local_var_params.get('port_index') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `port_index` when calling `get_device_port_module_relay_state`")  # noqa: E501
        # verify the required parameter 'module_index' is set
        if self.api_client.client_side_validation and local_var_params.get('module_index') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `module_index` when calling `get_device_port_module_relay_state`")  # noqa: E501
        # verify the required parameter 'relay_index' is set
        if self.api_client.client_side_validation and local_var_params.get('relay_index') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `relay_index` when calling `get_device_port_module_relay_state`")  # noqa: E501

        if self.api_client.client_side_validation and 'device_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}', local_var_params['device_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `get_device_port_module_relay_state`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}/`")  # noqa: E501
        if self.api_client.client_side_validation and 'port_index' in local_var_params and local_var_params['port_index'] > 8:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `port_index` when calling `get_device_port_module_relay_state`, must be a value less than or equal to `8`")  # noqa: E501
        if self.api_client.client_side_validation and 'port_index' in local_var_params and local_var_params['port_index'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `port_index` when calling `get_device_port_module_relay_state`, must be a value greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'module_index' in local_var_params and local_var_params['module_index'] > 32:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `module_index` when calling `get_device_port_module_relay_state`, must be a value less than or equal to `32`")  # noqa: E501
        if self.api_client.client_side_validation and 'module_index' in local_var_params and local_var_params['module_index'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `module_index` when calling `get_device_port_module_relay_state`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in local_var_params:
            path_params['device_id'] = local_var_params['device_id']  # noqa: E501
        if 'port_index' in local_var_params:
            path_params['port_index'] = local_var_params['port_index']  # noqa: E501
        if 'module_index' in local_var_params:
            path_params['module_index'] = local_var_params['module_index']  # noqa: E501
        if 'relay_index' in local_var_params:
            path_params['relay_index'] = local_var_params['relay_index']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {
            200: "object",
            201: None,
            400: None,
            401: None,
            403: None,
            404: None,
            500: None,
        }

        return self.api_client.call_api(
            '/Devices/{device_id}/Ports/{port_index}/Modules/{module_index}/Relays/{relay_index}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_device_port_voltage(self, device_id, port_index, **kwargs):  # noqa: E501
        """GET voltage reading of device Port  # noqa: E501

        Returns voltage reading on selected device port  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_device_port_voltage(device_id, port_index, async_req=True)
        >>> result = thread.get()

        :param device_id: UUID of device (required)
        :type device_id: str
        :param port_index: Port Index (required)
        :type port_index: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: float
        """
        kwargs['_return_http_data_only'] = True
        return self.get_device_port_voltage_with_http_info(device_id, port_index, **kwargs)  # noqa: E501

    def get_device_port_voltage_with_http_info(self, device_id, port_index, **kwargs):  # noqa: E501
        """GET voltage reading of device Port  # noqa: E501

        Returns voltage reading on selected device port  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_device_port_voltage_with_http_info(device_id, port_index, async_req=True)
        >>> result = thread.get()

        :param device_id: UUID of device (required)
        :type device_id: str
        :param port_index: Port Index (required)
        :type port_index: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(float, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'device_id',
            'port_index'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_device_port_voltage" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'device_id' is set
        if self.api_client.client_side_validation and local_var_params.get('device_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `device_id` when calling `get_device_port_voltage`")  # noqa: E501
        # verify the required parameter 'port_index' is set
        if self.api_client.client_side_validation and local_var_params.get('port_index') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `port_index` when calling `get_device_port_voltage`")  # noqa: E501

        if self.api_client.client_side_validation and 'device_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}', local_var_params['device_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `get_device_port_voltage`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}/`")  # noqa: E501
        if self.api_client.client_side_validation and 'port_index' in local_var_params and local_var_params['port_index'] > 100:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `port_index` when calling `get_device_port_voltage`, must be a value less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and 'port_index' in local_var_params and local_var_params['port_index'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `port_index` when calling `get_device_port_voltage`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in local_var_params:
            path_params['device_id'] = local_var_params['device_id']  # noqa: E501
        if 'port_index' in local_var_params:
            path_params['port_index'] = local_var_params['port_index']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {
            200: "float",
            201: None,
            400: None,
            401: None,
            403: None,
            404: None,
            500: None,
        }

        return self.api_client.call_api(
            '/Devices/{device_id}/Ports/{port_index}/Voltages', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_device_rotation_angle(self, device_id, **kwargs):  # noqa: E501
        """GET Rotation Angle  # noqa: E501

        Get the rotation angle of the rotary turntable  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_device_rotation_angle(device_id, async_req=True)
        >>> result = thread.get()

        :param device_id: (required)
        :type device_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: object
        """
        kwargs['_return_http_data_only'] = True
        return self.get_device_rotation_angle_with_http_info(device_id, **kwargs)  # noqa: E501

    def get_device_rotation_angle_with_http_info(self, device_id, **kwargs):  # noqa: E501
        """GET Rotation Angle  # noqa: E501

        Get the rotation angle of the rotary turntable  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_device_rotation_angle_with_http_info(device_id, async_req=True)
        >>> result = thread.get()

        :param device_id: (required)
        :type device_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(object, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'device_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_device_rotation_angle" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'device_id' is set
        if self.api_client.client_side_validation and local_var_params.get('device_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `device_id` when calling `get_device_rotation_angle`")  # noqa: E501

        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) > 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `get_device_rotation_angle`, length must be less than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) < 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `get_device_rotation_angle`, length must be greater than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and 'device_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}', local_var_params['device_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `get_device_rotation_angle`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in local_var_params:
            path_params['device_id'] = local_var_params['device_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {
            200: "object",
            201: None,
            400: None,
            401: None,
            403: None,
            404: None,
            500: None,
        }

        return self.api_client.call_api(
            '/Devices/{device_id}/Rotation', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_device_uuid(self, device_serial, device_type, **kwargs):  # noqa: E501
        """GET uuid from database  # noqa: E501

        Query database for device_id with device_serial and device_type  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_device_uuid(device_serial, device_type, async_req=True)
        >>> result = thread.get()

        :param device_serial: Serial number of device (required)
        :type device_serial: str
        :param device_type: Type of device (required)
        :type device_type: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        return self.get_device_uuid_with_http_info(device_serial, device_type, **kwargs)  # noqa: E501

    def get_device_uuid_with_http_info(self, device_serial, device_type, **kwargs):  # noqa: E501
        """GET uuid from database  # noqa: E501

        Query database for device_id with device_serial and device_type  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_device_uuid_with_http_info(device_serial, device_type, async_req=True)
        >>> result = thread.get()

        :param device_serial: Serial number of device (required)
        :type device_serial: str
        :param device_type: Type of device (required)
        :type device_type: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'device_serial',
            'device_type'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_device_uuid" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'device_serial' is set
        if self.api_client.client_side_validation and local_var_params.get('device_serial') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `device_serial` when calling `get_device_uuid`")  # noqa: E501
        # verify the required parameter 'device_type' is set
        if self.api_client.client_side_validation and local_var_params.get('device_type') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `device_type` when calling `get_device_uuid`")  # noqa: E501

        if self.api_client.client_side_validation and ('device_serial' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_serial']) > 32):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_serial` when calling `get_device_uuid`, length must be less than or equal to `32`")  # noqa: E501
        if self.api_client.client_side_validation and ('device_serial' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_serial']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_serial` when calling `get_device_uuid`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and ('device_type' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_type']) > 32):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_type` when calling `get_device_uuid`, length must be less than or equal to `32`")  # noqa: E501
        if self.api_client.client_side_validation and ('device_type' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_type']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_type` when calling `get_device_uuid`, length must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_serial' in local_var_params:
            path_params['device_serial'] = local_var_params['device_serial']  # noqa: E501
        if 'device_type' in local_var_params:
            path_params['device_type'] = local_var_params['device_type']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {
            200: "str",
            201: None,
            400: None,
            401: None,
            403: None,
            404: None,
            500: None,
        }

        return self.api_client.call_api(
            '/Serial/{device_serial}/Type/{device_type}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_devices(self, **kwargs):  # noqa: E501
        """GET list of devices  # noqa: E501

        Returns list of devices  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_devices(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[Device]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_devices_with_http_info(**kwargs)  # noqa: E501

    def get_devices_with_http_info(self, **kwargs):  # noqa: E501
        """GET list of devices  # noqa: E501

        Returns list of devices  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_devices_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[Device], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_devices" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {
            200: "list[Device]",
            201: None,
            400: None,
            401: None,
            403: None,
            404: None,
            500: None,
        }

        return self.api_client.call_api(
            '/Devices', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_devices_button(self, device_id, button_index, **kwargs):  # noqa: E501
        """GET state of button  # noqa: E501

        Returns state of the selected devices button  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_devices_button(device_id, button_index, async_req=True)
        >>> result = thread.get()

        :param device_id: UUID of device (required)
        :type device_id: str
        :param button_index: Index of the button on tha device (1-100) (required)
        :type button_index: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetDevicesLed200Response
        """
        kwargs['_return_http_data_only'] = True
        return self.get_devices_button_with_http_info(device_id, button_index, **kwargs)  # noqa: E501

    def get_devices_button_with_http_info(self, device_id, button_index, **kwargs):  # noqa: E501
        """GET state of button  # noqa: E501

        Returns state of the selected devices button  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_devices_button_with_http_info(device_id, button_index, async_req=True)
        >>> result = thread.get()

        :param device_id: UUID of device (required)
        :type device_id: str
        :param button_index: Index of the button on tha device (1-100) (required)
        :type button_index: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetDevicesLed200Response, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'device_id',
            'button_index'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_devices_button" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'device_id' is set
        if self.api_client.client_side_validation and local_var_params.get('device_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `device_id` when calling `get_devices_button`")  # noqa: E501
        # verify the required parameter 'button_index' is set
        if self.api_client.client_side_validation and local_var_params.get('button_index') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `button_index` when calling `get_devices_button`")  # noqa: E501

        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) > 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `get_devices_button`, length must be less than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) < 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `get_devices_button`, length must be greater than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and 'device_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}', local_var_params['device_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `get_devices_button`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}/`")  # noqa: E501
        if self.api_client.client_side_validation and 'button_index' in local_var_params and local_var_params['button_index'] > 100:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `button_index` when calling `get_devices_button`, must be a value less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and 'button_index' in local_var_params and local_var_params['button_index'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `button_index` when calling `get_devices_button`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in local_var_params:
            path_params['device_id'] = local_var_params['device_id']  # noqa: E501

        query_params = []
        if local_var_params.get('button_index') is not None:  # noqa: E501
            query_params.append(('button_index', local_var_params['button_index']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {
            200: "GetDevicesLed200Response",
            201: None,
            400: None,
            401: None,
            403: None,
            404: None,
            500: None,
        }

        return self.api_client.call_api(
            '/Devices/{device_id}/Button', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_devices_index(self, device_id, **kwargs):  # noqa: E501
        """GET single device  # noqa: E501

        Gets information for a single device  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_devices_index(device_id, async_req=True)
        >>> result = thread.get()

        :param device_id: UUID of device (required)
        :type device_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Device
        """
        kwargs['_return_http_data_only'] = True
        return self.get_devices_index_with_http_info(device_id, **kwargs)  # noqa: E501

    def get_devices_index_with_http_info(self, device_id, **kwargs):  # noqa: E501
        """GET single device  # noqa: E501

        Gets information for a single device  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_devices_index_with_http_info(device_id, async_req=True)
        >>> result = thread.get()

        :param device_id: UUID of device (required)
        :type device_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Device, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'device_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_devices_index" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'device_id' is set
        if self.api_client.client_side_validation and local_var_params.get('device_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `device_id` when calling `get_devices_index`")  # noqa: E501

        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) > 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `get_devices_index`, length must be less than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) < 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `get_devices_index`, length must be greater than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and 'device_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}', local_var_params['device_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `get_devices_index`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in local_var_params:
            path_params['device_id'] = local_var_params['device_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {
            200: "Device",
            201: None,
            400: None,
            401: None,
            403: None,
            404: None,
            500: None,
        }

        return self.api_client.call_api(
            '/Devices/{device_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_devices_led(self, device_id, led_index, **kwargs):  # noqa: E501
        """GET state of LED  # noqa: E501

        Returns state of selected led on selected device  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_devices_led(device_id, led_index, async_req=True)
        >>> result = thread.get()

        :param device_id: UUID of device (required)
        :type device_id: str
        :param led_index: Index of LED (required)
        :type led_index: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetDevicesLed200Response
        """
        kwargs['_return_http_data_only'] = True
        return self.get_devices_led_with_http_info(device_id, led_index, **kwargs)  # noqa: E501

    def get_devices_led_with_http_info(self, device_id, led_index, **kwargs):  # noqa: E501
        """GET state of LED  # noqa: E501

        Returns state of selected led on selected device  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_devices_led_with_http_info(device_id, led_index, async_req=True)
        >>> result = thread.get()

        :param device_id: UUID of device (required)
        :type device_id: str
        :param led_index: Index of LED (required)
        :type led_index: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetDevicesLed200Response, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'device_id',
            'led_index'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_devices_led" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'device_id' is set
        if self.api_client.client_side_validation and local_var_params.get('device_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `device_id` when calling `get_devices_led`")  # noqa: E501
        # verify the required parameter 'led_index' is set
        if self.api_client.client_side_validation and local_var_params.get('led_index') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `led_index` when calling `get_devices_led`")  # noqa: E501

        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) > 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `get_devices_led`, length must be less than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) < 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `get_devices_led`, length must be greater than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and 'device_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}', local_var_params['device_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `get_devices_led`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}/`")  # noqa: E501
        if self.api_client.client_side_validation and 'led_index' in local_var_params and local_var_params['led_index'] > 100:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `led_index` when calling `get_devices_led`, must be a value less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and 'led_index' in local_var_params and local_var_params['led_index'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `led_index` when calling `get_devices_led`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in local_var_params:
            path_params['device_id'] = local_var_params['device_id']  # noqa: E501
        if 'led_index' in local_var_params:
            path_params['led_index'] = local_var_params['led_index']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {
            200: "GetDevicesLed200Response",
            201: None,
            400: None,
            401: None,
            403: None,
            404: None,
            500: None,
        }

        return self.api_client.call_api(
            '/Devices/{device_id}/Leds/{led_index}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_devices_temperature(self, device_id, **kwargs):  # noqa: E501
        """GET temperature reading  # noqa: E501

        Get temperature reading from specified device  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_devices_temperature(device_id, async_req=True)
        >>> result = thread.get()

        :param device_id: (required)
        :type device_id: str
        :param thermometer_index: Index of the thermometer (1-7)
        :type thermometer_index: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: float
        """
        kwargs['_return_http_data_only'] = True
        return self.get_devices_temperature_with_http_info(device_id, **kwargs)  # noqa: E501

    def get_devices_temperature_with_http_info(self, device_id, **kwargs):  # noqa: E501
        """GET temperature reading  # noqa: E501

        Get temperature reading from specified device  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_devices_temperature_with_http_info(device_id, async_req=True)
        >>> result = thread.get()

        :param device_id: (required)
        :type device_id: str
        :param thermometer_index: Index of the thermometer (1-7)
        :type thermometer_index: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(float, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'device_id',
            'thermometer_index'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_devices_temperature" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'device_id' is set
        if self.api_client.client_side_validation and local_var_params.get('device_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `device_id` when calling `get_devices_temperature`")  # noqa: E501

        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) > 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `get_devices_temperature`, length must be less than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) < 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `get_devices_temperature`, length must be greater than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and 'device_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}', local_var_params['device_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `get_devices_temperature`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}/`")  # noqa: E501
        if self.api_client.client_side_validation and 'thermometer_index' in local_var_params and local_var_params['thermometer_index'] > 7:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `thermometer_index` when calling `get_devices_temperature`, must be a value less than or equal to `7`")  # noqa: E501
        if self.api_client.client_side_validation and 'thermometer_index' in local_var_params and local_var_params['thermometer_index'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `thermometer_index` when calling `get_devices_temperature`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in local_var_params:
            path_params['device_id'] = local_var_params['device_id']  # noqa: E501

        query_params = []
        if local_var_params.get('thermometer_index') is not None:  # noqa: E501
            query_params.append(('thermometer_index', local_var_params['thermometer_index']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {
            200: "float",
            400: None,
            401: None,
            403: None,
            404: None,
            500: None,
        }

        return self.api_client.call_api(
            '/Devices/{device_id}/Temperature', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_fan_speed(self, device_id, fan_index, **kwargs):  # noqa: E501
        """GET device fan speed  # noqa: E501

        Get the fan speed of the selected index   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_fan_speed(device_id, fan_index, async_req=True)
        >>> result = thread.get()

        :param device_id: (required)
        :type device_id: str
        :param fan_index: (required)
        :type fan_index: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetFanSpeed200Response
        """
        kwargs['_return_http_data_only'] = True
        return self.get_fan_speed_with_http_info(device_id, fan_index, **kwargs)  # noqa: E501

    def get_fan_speed_with_http_info(self, device_id, fan_index, **kwargs):  # noqa: E501
        """GET device fan speed  # noqa: E501

        Get the fan speed of the selected index   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_fan_speed_with_http_info(device_id, fan_index, async_req=True)
        >>> result = thread.get()

        :param device_id: (required)
        :type device_id: str
        :param fan_index: (required)
        :type fan_index: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetFanSpeed200Response, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'device_id',
            'fan_index'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_fan_speed" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'device_id' is set
        if self.api_client.client_side_validation and local_var_params.get('device_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `device_id` when calling `get_fan_speed`")  # noqa: E501
        # verify the required parameter 'fan_index' is set
        if self.api_client.client_side_validation and local_var_params.get('fan_index') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `fan_index` when calling `get_fan_speed`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'device_id' in local_var_params:
            path_params['device_id'] = local_var_params['device_id']  # noqa: E501
        if 'fan_index' in local_var_params:
            path_params['fan_index'] = local_var_params['fan_index']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {
            200: "GetFanSpeed200Response",
        }

        return self.api_client.call_api(
            '/Devices/{device_id}/Fan/{fan_index}/Speed', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_fan_target_temperature(self, device_id, fan_index, **kwargs):  # noqa: E501
        """GET device fan target temperature  # noqa: E501

        Get the fan target temeprature of the selected index   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_fan_target_temperature(device_id, fan_index, async_req=True)
        >>> result = thread.get()

        :param device_id: (required)
        :type device_id: str
        :param fan_index: (required)
        :type fan_index: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetFanTargetTemperature200Response
        """
        kwargs['_return_http_data_only'] = True
        return self.get_fan_target_temperature_with_http_info(device_id, fan_index, **kwargs)  # noqa: E501

    def get_fan_target_temperature_with_http_info(self, device_id, fan_index, **kwargs):  # noqa: E501
        """GET device fan target temperature  # noqa: E501

        Get the fan target temeprature of the selected index   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_fan_target_temperature_with_http_info(device_id, fan_index, async_req=True)
        >>> result = thread.get()

        :param device_id: (required)
        :type device_id: str
        :param fan_index: (required)
        :type fan_index: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetFanTargetTemperature200Response, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'device_id',
            'fan_index'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_fan_target_temperature" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'device_id' is set
        if self.api_client.client_side_validation and local_var_params.get('device_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `device_id` when calling `get_fan_target_temperature`")  # noqa: E501
        # verify the required parameter 'fan_index' is set
        if self.api_client.client_side_validation and local_var_params.get('fan_index') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `fan_index` when calling `get_fan_target_temperature`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'device_id' in local_var_params:
            path_params['device_id'] = local_var_params['device_id']  # noqa: E501
        if 'fan_index' in local_var_params:
            path_params['fan_index'] = local_var_params['fan_index']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {
            200: "GetFanTargetTemperature200Response",
        }

        return self.api_client.call_api(
            '/Devices/{device_id}/Fan/{fan_index}/TargetTemperature', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_fan_temperature(self, device_id, fan_index, **kwargs):  # noqa: E501
        """GET device fan temperature  # noqa: E501

        Get the fan temperature of the selected index   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_fan_temperature(device_id, fan_index, async_req=True)
        >>> result = thread.get()

        :param device_id: (required)
        :type device_id: str
        :param fan_index: (required)
        :type fan_index: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetFanTemperature200Response
        """
        kwargs['_return_http_data_only'] = True
        return self.get_fan_temperature_with_http_info(device_id, fan_index, **kwargs)  # noqa: E501

    def get_fan_temperature_with_http_info(self, device_id, fan_index, **kwargs):  # noqa: E501
        """GET device fan temperature  # noqa: E501

        Get the fan temperature of the selected index   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_fan_temperature_with_http_info(device_id, fan_index, async_req=True)
        >>> result = thread.get()

        :param device_id: (required)
        :type device_id: str
        :param fan_index: (required)
        :type fan_index: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetFanTemperature200Response, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'device_id',
            'fan_index'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_fan_temperature" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'device_id' is set
        if self.api_client.client_side_validation and local_var_params.get('device_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `device_id` when calling `get_fan_temperature`")  # noqa: E501
        # verify the required parameter 'fan_index' is set
        if self.api_client.client_side_validation and local_var_params.get('fan_index') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `fan_index` when calling `get_fan_temperature`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'device_id' in local_var_params:
            path_params['device_id'] = local_var_params['device_id']  # noqa: E501
        if 'fan_index' in local_var_params:
            path_params['fan_index'] = local_var_params['fan_index']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {
            200: "GetFanTemperature200Response",
        }

        return self.api_client.call_api(
            '/Devices/{device_id}/Fan/{fan_index}/Temperature', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_firmware_version(self, device_id, **kwargs):  # noqa: E501
        """GET Device Firmware Version  # noqa: E501

        Get the device firmware version.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_firmware_version(device_id, async_req=True)
        >>> result = thread.get()

        :param device_id: Device ID (required)
        :type device_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetFirmwareVersion200Response
        """
        kwargs['_return_http_data_only'] = True
        return self.get_firmware_version_with_http_info(device_id, **kwargs)  # noqa: E501

    def get_firmware_version_with_http_info(self, device_id, **kwargs):  # noqa: E501
        """GET Device Firmware Version  # noqa: E501

        Get the device firmware version.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_firmware_version_with_http_info(device_id, async_req=True)
        >>> result = thread.get()

        :param device_id: Device ID (required)
        :type device_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetFirmwareVersion200Response, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'device_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_firmware_version" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'device_id' is set
        if self.api_client.client_side_validation and local_var_params.get('device_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `device_id` when calling `get_firmware_version`")  # noqa: E501

        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) > 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `get_firmware_version`, length must be less than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) < 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `get_firmware_version`, length must be greater than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and 'device_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}', local_var_params['device_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `get_firmware_version`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in local_var_params:
            path_params['device_id'] = local_var_params['device_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {
            200: "GetFirmwareVersion200Response",
            400: None,
            401: None,
            403: None,
            404: None,
            500: None,
        }

        return self.api_client.call_api(
            '/Devices/{device_id}/Firmware', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_message_from_rx_buffer(self, **kwargs):  # noqa: E501
        """GET message from RX table  # noqa: E501

        GET a message from the rx table  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_message_from_rx_buffer(async_req=True)
        >>> result = thread.get()

        :param device_id:
        :type device_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: object
        """
        kwargs['_return_http_data_only'] = True
        return self.get_message_from_rx_buffer_with_http_info(**kwargs)  # noqa: E501

    def get_message_from_rx_buffer_with_http_info(self, **kwargs):  # noqa: E501
        """GET message from RX table  # noqa: E501

        GET a message from the rx table  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_message_from_rx_buffer_with_http_info(async_req=True)
        >>> result = thread.get()

        :param device_id:
        :type device_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(object, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'device_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_message_from_rx_buffer" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if local_var_params.get('device_id') is not None:  # noqa: E501
            query_params.append(('device_id', local_var_params['device_id']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {
            200: "object",
            201: None,
            400: None,
            401: None,
            403: None,
            404: None,
            500: None,
        }

        return self.api_client.call_api(
            '/Devices/messages/rx', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_message_from_tx_buffer(self, **kwargs):  # noqa: E501
        """GET message from TX table  # noqa: E501

        GET a message from the tx table  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_message_from_tx_buffer(async_req=True)
        >>> result = thread.get()

        :param device_id:
        :type device_id: str
        :param device_serial:
        :type device_serial: str
        :param device_type:
        :type device_type: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        return self.get_message_from_tx_buffer_with_http_info(**kwargs)  # noqa: E501

    def get_message_from_tx_buffer_with_http_info(self, **kwargs):  # noqa: E501
        """GET message from TX table  # noqa: E501

        GET a message from the tx table  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_message_from_tx_buffer_with_http_info(async_req=True)
        >>> result = thread.get()

        :param device_id:
        :type device_id: str
        :param device_serial:
        :type device_serial: str
        :param device_type:
        :type device_type: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'device_id',
            'device_serial',
            'device_type'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_message_from_tx_buffer" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if local_var_params.get('device_id') is not None:  # noqa: E501
            query_params.append(('device_id', local_var_params['device_id']))  # noqa: E501
        if local_var_params.get('device_serial') is not None:  # noqa: E501
            query_params.append(('device_serial', local_var_params['device_serial']))  # noqa: E501
        if local_var_params.get('device_type') is not None:  # noqa: E501
            query_params.append(('device_type', local_var_params['device_type']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {
            200: "str",
            201: None,
            400: None,
            401: None,
            403: None,
            404: None,
            500: None,
        }

        return self.api_client.call_api(
            '/Devices/messages/tx', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_port(self, port_id, **kwargs):  # noqa: E501
        """GET status of port by id  # noqa: E501

        returns status of port  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_port(port_id, async_req=True)
        >>> result = thread.get()

        :param port_id: id of port to set (required)
        :type port_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DevicePort
        """
        kwargs['_return_http_data_only'] = True
        return self.get_port_with_http_info(port_id, **kwargs)  # noqa: E501

    def get_port_with_http_info(self, port_id, **kwargs):  # noqa: E501
        """GET status of port by id  # noqa: E501

        returns status of port  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_port_with_http_info(port_id, async_req=True)
        >>> result = thread.get()

        :param port_id: id of port to set (required)
        :type port_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DevicePort, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'port_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_port" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'port_id' is set
        if self.api_client.client_side_validation and local_var_params.get('port_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `port_id` when calling `get_port`")  # noqa: E501

        if self.api_client.client_side_validation and ('port_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['port_id']) > 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `port_id` when calling `get_port`, length must be less than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and ('port_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['port_id']) < 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `port_id` when calling `get_port`, length must be greater than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and 'port_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}', local_var_params['port_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `port_id` when calling `get_port`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'port_id' in local_var_params:
            path_params['port_id'] = local_var_params['port_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {
            200: "DevicePort",
            201: None,
            400: None,
            401: None,
            403: None,
            404: None,
            500: None,
        }

        return self.api_client.call_api(
            '/Port/{port_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_port_led_state(self, device_id, port_index, led_index, **kwargs):  # noqa: E501
        """GET state of Port LED  # noqa: E501

        Returns state of selected led on specified device's port  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_port_led_state(device_id, port_index, led_index, async_req=True)
        >>> result = thread.get()

        :param device_id: UUID of device (required)
        :type device_id: str
        :param port_index: Index of Port (required)
        :type port_index: int
        :param led_index: Index of Led (required)
        :type led_index: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetDevicesLed200Response
        """
        kwargs['_return_http_data_only'] = True
        return self.get_port_led_state_with_http_info(device_id, port_index, led_index, **kwargs)  # noqa: E501

    def get_port_led_state_with_http_info(self, device_id, port_index, led_index, **kwargs):  # noqa: E501
        """GET state of Port LED  # noqa: E501

        Returns state of selected led on specified device's port  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_port_led_state_with_http_info(device_id, port_index, led_index, async_req=True)
        >>> result = thread.get()

        :param device_id: UUID of device (required)
        :type device_id: str
        :param port_index: Index of Port (required)
        :type port_index: int
        :param led_index: Index of Led (required)
        :type led_index: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetDevicesLed200Response, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'device_id',
            'port_index',
            'led_index'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_port_led_state" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'device_id' is set
        if self.api_client.client_side_validation and local_var_params.get('device_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `device_id` when calling `get_port_led_state`")  # noqa: E501
        # verify the required parameter 'port_index' is set
        if self.api_client.client_side_validation and local_var_params.get('port_index') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `port_index` when calling `get_port_led_state`")  # noqa: E501
        # verify the required parameter 'led_index' is set
        if self.api_client.client_side_validation and local_var_params.get('led_index') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `led_index` when calling `get_port_led_state`")  # noqa: E501

        if self.api_client.client_side_validation and 'device_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}', local_var_params['device_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `get_port_led_state`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}/`")  # noqa: E501
        if self.api_client.client_side_validation and 'port_index' in local_var_params and local_var_params['port_index'] > 8:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `port_index` when calling `get_port_led_state`, must be a value less than or equal to `8`")  # noqa: E501
        if self.api_client.client_side_validation and 'port_index' in local_var_params and local_var_params['port_index'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `port_index` when calling `get_port_led_state`, must be a value greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'led_index' in local_var_params and local_var_params['led_index'] > 32:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `led_index` when calling `get_port_led_state`, must be a value less than or equal to `32`")  # noqa: E501
        if self.api_client.client_side_validation and 'led_index' in local_var_params and local_var_params['led_index'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `led_index` when calling `get_port_led_state`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in local_var_params:
            path_params['device_id'] = local_var_params['device_id']  # noqa: E501
        if 'port_index' in local_var_params:
            path_params['port_index'] = local_var_params['port_index']  # noqa: E501
        if 'led_index' in local_var_params:
            path_params['led_index'] = local_var_params['led_index']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {
            200: "GetDevicesLed200Response",
            201: None,
            400: None,
            401: None,
            403: None,
            404: None,
            500: None,
        }

        return self.api_client.call_api(
            '/Devices/{device_id}/Ports/{port_index}/Leds/{led_index}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_port_setup_status(self, device_id, port_index, **kwargs):  # noqa: E501
        """GET status of port  # noqa: E501

        Returns setup and connection status of port  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_port_setup_status(device_id, port_index, async_req=True)
        >>> result = thread.get()

        :param device_id: UUID of device (required)
        :type device_id: str
        :param port_index: Index of port (required)
        :type port_index: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: object
        """
        kwargs['_return_http_data_only'] = True
        return self.get_port_setup_status_with_http_info(device_id, port_index, **kwargs)  # noqa: E501

    def get_port_setup_status_with_http_info(self, device_id, port_index, **kwargs):  # noqa: E501
        """GET status of port  # noqa: E501

        Returns setup and connection status of port  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_port_setup_status_with_http_info(device_id, port_index, async_req=True)
        >>> result = thread.get()

        :param device_id: UUID of device (required)
        :type device_id: str
        :param port_index: Index of port (required)
        :type port_index: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(object, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'device_id',
            'port_index'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_port_setup_status" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'device_id' is set
        if self.api_client.client_side_validation and local_var_params.get('device_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `device_id` when calling `get_port_setup_status`")  # noqa: E501
        # verify the required parameter 'port_index' is set
        if self.api_client.client_side_validation and local_var_params.get('port_index') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `port_index` when calling `get_port_setup_status`")  # noqa: E501

        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) > 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `get_port_setup_status`, length must be less than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) < 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `get_port_setup_status`, length must be greater than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and 'device_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}', local_var_params['device_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `get_port_setup_status`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}/`")  # noqa: E501
        if self.api_client.client_side_validation and 'port_index' in local_var_params and local_var_params['port_index'] > 100:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `port_index` when calling `get_port_setup_status`, must be a value less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and 'port_index' in local_var_params and local_var_params['port_index'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `port_index` when calling `get_port_setup_status`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in local_var_params:
            path_params['device_id'] = local_var_params['device_id']  # noqa: E501
        if 'port_index' in local_var_params:
            path_params['port_index'] = local_var_params['port_index']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {
            200: "object",
            201: None,
            400: None,
            401: None,
            403: None,
            404: None,
            500: None,
        }

        return self.api_client.call_api(
            '/Devices/{device_id}/Ports/{port_index}/SetupStatus', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_port_states(self, port_id, **kwargs):  # noqa: E501
        """GET port states by port id  # noqa: E501

        Gets a list of available port states for a port  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_port_states(port_id, async_req=True)
        >>> result = thread.get()

        :param port_id: (required)
        :type port_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[PortState]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_port_states_with_http_info(port_id, **kwargs)  # noqa: E501

    def get_port_states_with_http_info(self, port_id, **kwargs):  # noqa: E501
        """GET port states by port id  # noqa: E501

        Gets a list of available port states for a port  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_port_states_with_http_info(port_id, async_req=True)
        >>> result = thread.get()

        :param port_id: (required)
        :type port_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[PortState], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'port_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_port_states" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'port_id' is set
        if self.api_client.client_side_validation and local_var_params.get('port_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `port_id` when calling `get_port_states`")  # noqa: E501

        if self.api_client.client_side_validation and ('port_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['port_id']) > 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `port_id` when calling `get_port_states`, length must be less than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and ('port_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['port_id']) < 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `port_id` when calling `get_port_states`, length must be greater than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and 'port_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}', local_var_params['port_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `port_id` when calling `get_port_states`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'port_id' in local_var_params:
            path_params['port_id'] = local_var_params['port_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {
            200: "list[PortState]",
            201: None,
            400: None,
            401: None,
            403: None,
            404: None,
            500: None,
        }

        return self.api_client.call_api(
            '/PortStates/{port_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_ports(self, **kwargs):  # noqa: E501
        """GET status of all ports  # noqa: E501

        status of port  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_ports(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[DevicePort]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_ports_with_http_info(**kwargs)  # noqa: E501

    def get_ports_with_http_info(self, **kwargs):  # noqa: E501
        """GET status of all ports  # noqa: E501

        status of port  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_ports_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[DevicePort], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ports" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {
            200: "list[DevicePort]",
            201: None,
            400: None,
            401: None,
            403: None,
            404: None,
            500: None,
        }

        return self.api_client.call_api(
            '/Ports', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_relay_state(self, device_id, index, **kwargs):  # noqa: E501
        """GET state of relay  # noqa: E501

        Get state of relay at index  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_relay_state(device_id, index, async_req=True)
        >>> result = thread.get()

        :param device_id: (required)
        :type device_id: str
        :param index: index of relay to get state of (required)
        :type index: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetDevicesLed200Response
        """
        kwargs['_return_http_data_only'] = True
        return self.get_relay_state_with_http_info(device_id, index, **kwargs)  # noqa: E501

    def get_relay_state_with_http_info(self, device_id, index, **kwargs):  # noqa: E501
        """GET state of relay  # noqa: E501

        Get state of relay at index  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_relay_state_with_http_info(device_id, index, async_req=True)
        >>> result = thread.get()

        :param device_id: (required)
        :type device_id: str
        :param index: index of relay to get state of (required)
        :type index: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetDevicesLed200Response, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'device_id',
            'index'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_relay_state" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'device_id' is set
        if self.api_client.client_side_validation and local_var_params.get('device_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `device_id` when calling `get_relay_state`")  # noqa: E501
        # verify the required parameter 'index' is set
        if self.api_client.client_side_validation and local_var_params.get('index') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `index` when calling `get_relay_state`")  # noqa: E501

        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) > 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `get_relay_state`, length must be less than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) < 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `get_relay_state`, length must be greater than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and 'device_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}', local_var_params['device_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `get_relay_state`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in local_var_params:
            path_params['device_id'] = local_var_params['device_id']  # noqa: E501

        query_params = []
        if local_var_params.get('index') is not None:  # noqa: E501
            query_params.append(('index', local_var_params['index']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {
            200: "GetDevicesLed200Response",
            201: None,
            400: None,
            401: None,
            403: None,
            404: None,
            500: None,
        }

        return self.api_client.call_api(
            '/Devices/{device_id}/Relay', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_temperature_range(self, device_id, **kwargs):  # noqa: E501
        """GET Temperature Range  # noqa: E501

        Get the minimum and maximum temperatures for a given hex thermometer  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_temperature_range(device_id, async_req=True)
        >>> result = thread.get()

        :param device_id: (required)
        :type device_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TempRange
        """
        kwargs['_return_http_data_only'] = True
        return self.get_temperature_range_with_http_info(device_id, **kwargs)  # noqa: E501

    def get_temperature_range_with_http_info(self, device_id, **kwargs):  # noqa: E501
        """GET Temperature Range  # noqa: E501

        Get the minimum and maximum temperatures for a given hex thermometer  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_temperature_range_with_http_info(device_id, async_req=True)
        >>> result = thread.get()

        :param device_id: (required)
        :type device_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(TempRange, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'device_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_temperature_range" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'device_id' is set
        if self.api_client.client_side_validation and local_var_params.get('device_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `device_id` when calling `get_temperature_range`")  # noqa: E501

        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) > 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `get_temperature_range`, length must be less than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) < 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `get_temperature_range`, length must be greater than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and 'device_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}', local_var_params['device_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `get_temperature_range`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in local_var_params:
            path_params['device_id'] = local_var_params['device_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {
            200: "TempRange",
            400: None,
            401: None,
            403: None,
            404: None,
            500: None,
        }

        return self.api_client.call_api(
            '/Devices/{device_id}/Temperature/Range', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_temperature_thresholds(self, device_id, **kwargs):  # noqa: E501
        """GET Temperature Thresholds  # noqa: E501

        get the points at which the temperature enters danger zones  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_temperature_thresholds(device_id, async_req=True)
        >>> result = thread.get()

        :param device_id: the device id (required)
        :type device_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[float]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_temperature_thresholds_with_http_info(device_id, **kwargs)  # noqa: E501

    def get_temperature_thresholds_with_http_info(self, device_id, **kwargs):  # noqa: E501
        """GET Temperature Thresholds  # noqa: E501

        get the points at which the temperature enters danger zones  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_temperature_thresholds_with_http_info(device_id, async_req=True)
        >>> result = thread.get()

        :param device_id: the device id (required)
        :type device_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[float], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'device_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_temperature_thresholds" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'device_id' is set
        if self.api_client.client_side_validation and local_var_params.get('device_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `device_id` when calling `get_temperature_thresholds`")  # noqa: E501

        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) > 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `get_temperature_thresholds`, length must be less than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) < 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `get_temperature_thresholds`, length must be greater than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and 'device_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}', local_var_params['device_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `get_temperature_thresholds`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in local_var_params:
            path_params['device_id'] = local_var_params['device_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {
            200: "list[float]",
            201: None,
            400: None,
            401: None,
            403: None,
            404: None,
            500: None,
        }

        return self.api_client.call_api(
            '/Devices/{device_id}/Temperature/Thresholds', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_voltage(self, device_id, voltage_index, **kwargs):  # noqa: E501
        """GET voltage reading of device  # noqa: E501

        Returns voltage reading on selected device   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_voltage(device_id, voltage_index, async_req=True)
        >>> result = thread.get()

        :param device_id: UUID of device (required)
        :type device_id: str
        :param voltage_index: Index of Voltage port (required)
        :type voltage_index: int
        :param voltage_index2: Voltage index to query
        :type voltage_index2: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: float
        """
        kwargs['_return_http_data_only'] = True
        return self.get_voltage_with_http_info(device_id, voltage_index, **kwargs)  # noqa: E501

    def get_voltage_with_http_info(self, device_id, voltage_index, **kwargs):  # noqa: E501
        """GET voltage reading of device  # noqa: E501

        Returns voltage reading on selected device   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_voltage_with_http_info(device_id, voltage_index, async_req=True)
        >>> result = thread.get()

        :param device_id: UUID of device (required)
        :type device_id: str
        :param voltage_index: Index of Voltage port (required)
        :type voltage_index: int
        :param voltage_index2: Voltage index to query
        :type voltage_index2: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(float, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'device_id',
            'voltage_index',
            'voltage_index2'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_voltage" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'device_id' is set
        if self.api_client.client_side_validation and local_var_params.get('device_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `device_id` when calling `get_voltage`")  # noqa: E501
        # verify the required parameter 'voltage_index' is set
        if self.api_client.client_side_validation and local_var_params.get('voltage_index') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `voltage_index` when calling `get_voltage`")  # noqa: E501

        if self.api_client.client_side_validation and 'device_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}', local_var_params['device_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `get_voltage`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}/`")  # noqa: E501
        if self.api_client.client_side_validation and 'voltage_index' in local_var_params and local_var_params['voltage_index'] > 100:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `voltage_index` when calling `get_voltage`, must be a value less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and 'voltage_index' in local_var_params and local_var_params['voltage_index'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `voltage_index` when calling `get_voltage`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in local_var_params:
            path_params['device_id'] = local_var_params['device_id']  # noqa: E501
        if 'voltage_index' in local_var_params:
            path_params['voltage_index'] = local_var_params['voltage_index']  # noqa: E501

        query_params = []
        if local_var_params.get('voltage_index2') is not None:  # noqa: E501
            query_params.append(('voltage_index', local_var_params['voltage_index2']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {
            200: "float",
            201: None,
            400: None,
            401: None,
            403: None,
            404: None,
            500: None,
        }

        return self.api_client.call_api(
            '/Devices/{device_id}/Voltages/{voltage_index}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def put_attenuator_state(self, device_id, expander_index, expander_port_index, value, **kwargs):  # noqa: E501
        """PUT attenuation state  # noqa: E501

        Get attenuation state selected expander port  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_attenuator_state(device_id, expander_index, expander_port_index, value, async_req=True)
        >>> result = thread.get()

        :param device_id: (required)
        :type device_id: str
        :param expander_index: expander index (required)
        :type expander_index: int
        :param expander_port_index: expander port (required)
        :type expander_port_index: int
        :param value: attenuation value (required)
        :type value: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.put_attenuator_state_with_http_info(device_id, expander_index, expander_port_index, value, **kwargs)  # noqa: E501

    def put_attenuator_state_with_http_info(self, device_id, expander_index, expander_port_index, value, **kwargs):  # noqa: E501
        """PUT attenuation state  # noqa: E501

        Get attenuation state selected expander port  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_attenuator_state_with_http_info(device_id, expander_index, expander_port_index, value, async_req=True)
        >>> result = thread.get()

        :param device_id: (required)
        :type device_id: str
        :param expander_index: expander index (required)
        :type expander_index: int
        :param expander_port_index: expander port (required)
        :type expander_port_index: int
        :param value: attenuation value (required)
        :type value: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'device_id',
            'expander_index',
            'expander_port_index',
            'value'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_attenuator_state" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'device_id' is set
        if self.api_client.client_side_validation and local_var_params.get('device_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `device_id` when calling `put_attenuator_state`")  # noqa: E501
        # verify the required parameter 'expander_index' is set
        if self.api_client.client_side_validation and local_var_params.get('expander_index') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `expander_index` when calling `put_attenuator_state`")  # noqa: E501
        # verify the required parameter 'expander_port_index' is set
        if self.api_client.client_side_validation and local_var_params.get('expander_port_index') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `expander_port_index` when calling `put_attenuator_state`")  # noqa: E501
        # verify the required parameter 'value' is set
        if self.api_client.client_side_validation and local_var_params.get('value') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `value` when calling `put_attenuator_state`")  # noqa: E501

        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) > 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `put_attenuator_state`, length must be less than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) < 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `put_attenuator_state`, length must be greater than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and 'device_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}', local_var_params['device_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `put_attenuator_state`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in local_var_params:
            path_params['device_id'] = local_var_params['device_id']  # noqa: E501

        query_params = []
        if local_var_params.get('expander_index') is not None:  # noqa: E501
            query_params.append(('expander_index', local_var_params['expander_index']))  # noqa: E501
        if local_var_params.get('expander_port_index') is not None:  # noqa: E501
            query_params.append(('expander_port_index', local_var_params['expander_port_index']))  # noqa: E501
        if local_var_params.get('value') is not None:  # noqa: E501
            query_params.append(('value', local_var_params['value']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {}

        return self.api_client.call_api(
            '/Devices/{device_id}/Attenuate', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def put_channel_attenuation(self, device_id, channel_index, value, **kwargs):  # noqa: E501
        """PUT attenuation state  # noqa: E501

        Put attenuation state of selected channel  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_channel_attenuation(device_id, channel_index, value, async_req=True)
        >>> result = thread.get()

        :param device_id: (required)
        :type device_id: str
        :param channel_index: channel index (required)
        :type channel_index: int
        :param value: attenuation value (required)
        :type value: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.put_channel_attenuation_with_http_info(device_id, channel_index, value, **kwargs)  # noqa: E501

    def put_channel_attenuation_with_http_info(self, device_id, channel_index, value, **kwargs):  # noqa: E501
        """PUT attenuation state  # noqa: E501

        Put attenuation state of selected channel  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_channel_attenuation_with_http_info(device_id, channel_index, value, async_req=True)
        >>> result = thread.get()

        :param device_id: (required)
        :type device_id: str
        :param channel_index: channel index (required)
        :type channel_index: int
        :param value: attenuation value (required)
        :type value: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'device_id',
            'channel_index',
            'value'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_channel_attenuation" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'device_id' is set
        if self.api_client.client_side_validation and local_var_params.get('device_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `device_id` when calling `put_channel_attenuation`")  # noqa: E501
        # verify the required parameter 'channel_index' is set
        if self.api_client.client_side_validation and local_var_params.get('channel_index') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `channel_index` when calling `put_channel_attenuation`")  # noqa: E501
        # verify the required parameter 'value' is set
        if self.api_client.client_side_validation and local_var_params.get('value') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `value` when calling `put_channel_attenuation`")  # noqa: E501

        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) > 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `put_channel_attenuation`, length must be less than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) < 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `put_channel_attenuation`, length must be greater than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and 'device_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}', local_var_params['device_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `put_channel_attenuation`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in local_var_params:
            path_params['device_id'] = local_var_params['device_id']  # noqa: E501

        query_params = []
        if local_var_params.get('channel_index') is not None:  # noqa: E501
            query_params.append(('channel_index', local_var_params['channel_index']))  # noqa: E501
        if local_var_params.get('value') is not None:  # noqa: E501
            query_params.append(('value', local_var_params['value']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {}

        return self.api_client.call_api(
            '/Devices/{device_id}/AttenuateChannel', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def put_device(self, **kwargs):  # noqa: E501
        """PUT Add device  # noqa: E501

        Add device to database  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_device(async_req=True)
        >>> result = thread.get()

        :param device_id: Device UUID
        :type device_id: str
        :param config_file_name: Config file name
        :type config_file_name: str
        :param device_serial: Device Serial
        :type device_serial: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.put_device_with_http_info(**kwargs)  # noqa: E501

    def put_device_with_http_info(self, **kwargs):  # noqa: E501
        """PUT Add device  # noqa: E501

        Add device to database  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_device_with_http_info(async_req=True)
        >>> result = thread.get()

        :param device_id: Device UUID
        :type device_id: str
        :param config_file_name: Config file name
        :type config_file_name: str
        :param device_serial: Device Serial
        :type device_serial: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'device_id',
            'config_file_name',
            'device_serial'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_device" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) > 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `put_device`, length must be less than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) < 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `put_device`, length must be greater than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and 'device_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}', local_var_params['device_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `put_device`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if local_var_params.get('device_id') is not None:  # noqa: E501
            query_params.append(('device_id', local_var_params['device_id']))  # noqa: E501
        if local_var_params.get('config_file_name') is not None:  # noqa: E501
            query_params.append(('config_file_name', local_var_params['config_file_name']))  # noqa: E501
        if local_var_params.get('device_serial') is not None:  # noqa: E501
            query_params.append(('device_serial', local_var_params['device_serial']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {}

        return self.api_client.call_api(
            '/Devices/AddDevice', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def put_device_device_id_description(self, device_id, description, **kwargs):  # noqa: E501
        """PUT a description for a Device  # noqa: E501

        Set Description of the Device hosting ports   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_device_device_id_description(device_id, description, async_req=True)
        >>> result = thread.get()

        :param device_id: (required)
        :type device_id: str
        :param description: (required)
        :type description: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.put_device_device_id_description_with_http_info(device_id, description, **kwargs)  # noqa: E501

    def put_device_device_id_description_with_http_info(self, device_id, description, **kwargs):  # noqa: E501
        """PUT a description for a Device  # noqa: E501

        Set Description of the Device hosting ports   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_device_device_id_description_with_http_info(device_id, description, async_req=True)
        >>> result = thread.get()

        :param device_id: (required)
        :type device_id: str
        :param description: (required)
        :type description: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'device_id',
            'description'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_device_device_id_description" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'device_id' is set
        if self.api_client.client_side_validation and local_var_params.get('device_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `device_id` when calling `put_device_device_id_description`")  # noqa: E501
        # verify the required parameter 'description' is set
        if self.api_client.client_side_validation and local_var_params.get('description') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `description` when calling `put_device_device_id_description`")  # noqa: E501

        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) > 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `put_device_device_id_description`, length must be less than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) < 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `put_device_device_id_description`, length must be greater than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and 'device_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}', local_var_params['device_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `put_device_device_id_description`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}/`")  # noqa: E501
        if self.api_client.client_side_validation and ('description' in local_var_params and  # noqa: E501
                                                        len(local_var_params['description']) > 100):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `description` when calling `put_device_device_id_description`, length must be less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and ('description' in local_var_params and  # noqa: E501
                                                        len(local_var_params['description']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `description` when calling `put_device_device_id_description`, length must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in local_var_params:
            path_params['device_id'] = local_var_params['device_id']  # noqa: E501

        query_params = []
        if local_var_params.get('description') is not None:  # noqa: E501
            query_params.append(('description', local_var_params['description']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {}

        return self.api_client.call_api(
            '/Device/{device_id}/Description', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def put_device_device_id_name(self, device_id, name, **kwargs):  # noqa: E501
        """PUT a name for a Device  # noqa: E501

        set name of device  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_device_device_id_name(device_id, name, async_req=True)
        >>> result = thread.get()

        :param device_id: id of device  (required)
        :type device_id: str
        :param name: name to apply to device (required)
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.put_device_device_id_name_with_http_info(device_id, name, **kwargs)  # noqa: E501

    def put_device_device_id_name_with_http_info(self, device_id, name, **kwargs):  # noqa: E501
        """PUT a name for a Device  # noqa: E501

        set name of device  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_device_device_id_name_with_http_info(device_id, name, async_req=True)
        >>> result = thread.get()

        :param device_id: id of device  (required)
        :type device_id: str
        :param name: name to apply to device (required)
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'device_id',
            'name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_device_device_id_name" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'device_id' is set
        if self.api_client.client_side_validation and local_var_params.get('device_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `device_id` when calling `put_device_device_id_name`")  # noqa: E501
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and local_var_params.get('name') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `name` when calling `put_device_device_id_name`")  # noqa: E501

        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) > 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `put_device_device_id_name`, length must be less than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) < 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `put_device_device_id_name`, length must be greater than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and 'device_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}', local_var_params['device_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `put_device_device_id_name`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in local_var_params:
            path_params['device_id'] = local_var_params['device_id']  # noqa: E501

        query_params = []
        if local_var_params.get('name') is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {}

        return self.api_client.call_api(
            '/Device/{device_id}/Name', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def put_device_id_label(self, device_id, port_index, label, **kwargs):  # noqa: E501
        """PUT a Port label  # noqa: E501

        Sets the label used for a port  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_device_id_label(device_id, port_index, label, async_req=True)
        >>> result = thread.get()

        :param device_id: (required)
        :type device_id: str
        :param port_index: (required)
        :type port_index: int
        :param label: new label for port (required)
        :type label: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.put_device_id_label_with_http_info(device_id, port_index, label, **kwargs)  # noqa: E501

    def put_device_id_label_with_http_info(self, device_id, port_index, label, **kwargs):  # noqa: E501
        """PUT a Port label  # noqa: E501

        Sets the label used for a port  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_device_id_label_with_http_info(device_id, port_index, label, async_req=True)
        >>> result = thread.get()

        :param device_id: (required)
        :type device_id: str
        :param port_index: (required)
        :type port_index: int
        :param label: new label for port (required)
        :type label: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'device_id',
            'port_index',
            'label'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_device_id_label" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'device_id' is set
        if self.api_client.client_side_validation and local_var_params.get('device_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `device_id` when calling `put_device_id_label`")  # noqa: E501
        # verify the required parameter 'port_index' is set
        if self.api_client.client_side_validation and local_var_params.get('port_index') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `port_index` when calling `put_device_id_label`")  # noqa: E501
        # verify the required parameter 'label' is set
        if self.api_client.client_side_validation and local_var_params.get('label') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `label` when calling `put_device_id_label`")  # noqa: E501

        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) > 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `put_device_id_label`, length must be less than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) < 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `put_device_id_label`, length must be greater than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and 'device_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}', local_var_params['device_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `put_device_id_label`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}/`")  # noqa: E501
        if self.api_client.client_side_validation and 'port_index' in local_var_params and local_var_params['port_index'] > 100:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `port_index` when calling `put_device_id_label`, must be a value less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and 'port_index' in local_var_params and local_var_params['port_index'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `port_index` when calling `put_device_id_label`, must be a value greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and ('label' in local_var_params and  # noqa: E501
                                                        len(local_var_params['label']) > 100):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `label` when calling `put_device_id_label`, length must be less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and ('label' in local_var_params and  # noqa: E501
                                                        len(local_var_params['label']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `label` when calling `put_device_id_label`, length must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in local_var_params:
            path_params['device_id'] = local_var_params['device_id']  # noqa: E501
        if 'port_index' in local_var_params:
            path_params['port_index'] = local_var_params['port_index']  # noqa: E501

        query_params = []
        if local_var_params.get('label') is not None:  # noqa: E501
            query_params.append(('label', local_var_params['label']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {}

        return self.api_client.call_api(
            '/Device/{device_id}/Port/{port_index}/Label', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def put_device_port_module_led_state(self, device_id, port_index, module_index, state, **kwargs):  # noqa: E501
        """PUT state of Port LED  # noqa: E501

        Set led at index on specified device's port  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_device_port_module_led_state(device_id, port_index, module_index, state, async_req=True)
        >>> result = thread.get()

        :param device_id: UUID of device (required)
        :type device_id: str
        :param port_index: Index of Port (required)
        :type port_index: int
        :param module_index: Index of Module (required)
        :type module_index: int
        :param state: True = LED on, False = LED off (required)
        :type state: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.put_device_port_module_led_state_with_http_info(device_id, port_index, module_index, state, **kwargs)  # noqa: E501

    def put_device_port_module_led_state_with_http_info(self, device_id, port_index, module_index, state, **kwargs):  # noqa: E501
        """PUT state of Port LED  # noqa: E501

        Set led at index on specified device's port  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_device_port_module_led_state_with_http_info(device_id, port_index, module_index, state, async_req=True)
        >>> result = thread.get()

        :param device_id: UUID of device (required)
        :type device_id: str
        :param port_index: Index of Port (required)
        :type port_index: int
        :param module_index: Index of Module (required)
        :type module_index: int
        :param state: True = LED on, False = LED off (required)
        :type state: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'device_id',
            'port_index',
            'module_index',
            'state'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_device_port_module_led_state" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'device_id' is set
        if self.api_client.client_side_validation and local_var_params.get('device_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `device_id` when calling `put_device_port_module_led_state`")  # noqa: E501
        # verify the required parameter 'port_index' is set
        if self.api_client.client_side_validation and local_var_params.get('port_index') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `port_index` when calling `put_device_port_module_led_state`")  # noqa: E501
        # verify the required parameter 'module_index' is set
        if self.api_client.client_side_validation and local_var_params.get('module_index') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `module_index` when calling `put_device_port_module_led_state`")  # noqa: E501
        # verify the required parameter 'state' is set
        if self.api_client.client_side_validation and local_var_params.get('state') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `state` when calling `put_device_port_module_led_state`")  # noqa: E501

        if self.api_client.client_side_validation and 'device_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}', local_var_params['device_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `put_device_port_module_led_state`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}/`")  # noqa: E501
        if self.api_client.client_side_validation and 'port_index' in local_var_params and local_var_params['port_index'] > 8:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `port_index` when calling `put_device_port_module_led_state`, must be a value less than or equal to `8`")  # noqa: E501
        if self.api_client.client_side_validation and 'port_index' in local_var_params and local_var_params['port_index'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `port_index` when calling `put_device_port_module_led_state`, must be a value greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'module_index' in local_var_params and local_var_params['module_index'] > 100:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `module_index` when calling `put_device_port_module_led_state`, must be a value less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and 'module_index' in local_var_params and local_var_params['module_index'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `module_index` when calling `put_device_port_module_led_state`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in local_var_params:
            path_params['device_id'] = local_var_params['device_id']  # noqa: E501
        if 'port_index' in local_var_params:
            path_params['port_index'] = local_var_params['port_index']  # noqa: E501
        if 'module_index' in local_var_params:
            path_params['module_index'] = local_var_params['module_index']  # noqa: E501

        query_params = []
        if local_var_params.get('state') is not None:  # noqa: E501
            query_params.append(('state', local_var_params['state']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {}

        return self.api_client.call_api(
            '/Devices/{device_id}/Ports/{port_index}/Modules/{module_index}/Leds', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def put_device_port_module_relay_state(self, device_id, port_index, module_index, relay_index, state, **kwargs):  # noqa: E501
        """PUT state of Port Relay  # noqa: E501

        Set relay at index on specified device's port's module  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_device_port_module_relay_state(device_id, port_index, module_index, relay_index, state, async_req=True)
        >>> result = thread.get()

        :param device_id: UUID of device (required)
        :type device_id: str
        :param port_index: Index of Port (required)
        :type port_index: int
        :param module_index: Index of Module (required)
        :type module_index: int
        :param relay_index: Index of Relay (required)
        :type relay_index: int
        :param state: True = LED on, False = LED off (required)
        :type state: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.put_device_port_module_relay_state_with_http_info(device_id, port_index, module_index, relay_index, state, **kwargs)  # noqa: E501

    def put_device_port_module_relay_state_with_http_info(self, device_id, port_index, module_index, relay_index, state, **kwargs):  # noqa: E501
        """PUT state of Port Relay  # noqa: E501

        Set relay at index on specified device's port's module  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_device_port_module_relay_state_with_http_info(device_id, port_index, module_index, relay_index, state, async_req=True)
        >>> result = thread.get()

        :param device_id: UUID of device (required)
        :type device_id: str
        :param port_index: Index of Port (required)
        :type port_index: int
        :param module_index: Index of Module (required)
        :type module_index: int
        :param relay_index: Index of Relay (required)
        :type relay_index: int
        :param state: True = LED on, False = LED off (required)
        :type state: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'device_id',
            'port_index',
            'module_index',
            'relay_index',
            'state'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_device_port_module_relay_state" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'device_id' is set
        if self.api_client.client_side_validation and local_var_params.get('device_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `device_id` when calling `put_device_port_module_relay_state`")  # noqa: E501
        # verify the required parameter 'port_index' is set
        if self.api_client.client_side_validation and local_var_params.get('port_index') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `port_index` when calling `put_device_port_module_relay_state`")  # noqa: E501
        # verify the required parameter 'module_index' is set
        if self.api_client.client_side_validation and local_var_params.get('module_index') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `module_index` when calling `put_device_port_module_relay_state`")  # noqa: E501
        # verify the required parameter 'relay_index' is set
        if self.api_client.client_side_validation and local_var_params.get('relay_index') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `relay_index` when calling `put_device_port_module_relay_state`")  # noqa: E501
        # verify the required parameter 'state' is set
        if self.api_client.client_side_validation and local_var_params.get('state') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `state` when calling `put_device_port_module_relay_state`")  # noqa: E501

        if self.api_client.client_side_validation and 'device_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}', local_var_params['device_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `put_device_port_module_relay_state`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}/`")  # noqa: E501
        if self.api_client.client_side_validation and 'port_index' in local_var_params and local_var_params['port_index'] > 8:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `port_index` when calling `put_device_port_module_relay_state`, must be a value less than or equal to `8`")  # noqa: E501
        if self.api_client.client_side_validation and 'port_index' in local_var_params and local_var_params['port_index'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `port_index` when calling `put_device_port_module_relay_state`, must be a value greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'module_index' in local_var_params and local_var_params['module_index'] > 32:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `module_index` when calling `put_device_port_module_relay_state`, must be a value less than or equal to `32`")  # noqa: E501
        if self.api_client.client_side_validation and 'module_index' in local_var_params and local_var_params['module_index'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `module_index` when calling `put_device_port_module_relay_state`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in local_var_params:
            path_params['device_id'] = local_var_params['device_id']  # noqa: E501
        if 'port_index' in local_var_params:
            path_params['port_index'] = local_var_params['port_index']  # noqa: E501
        if 'module_index' in local_var_params:
            path_params['module_index'] = local_var_params['module_index']  # noqa: E501
        if 'relay_index' in local_var_params:
            path_params['relay_index'] = local_var_params['relay_index']  # noqa: E501

        query_params = []
        if local_var_params.get('state') is not None:  # noqa: E501
            query_params.append(('state', local_var_params['state']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {}

        return self.api_client.call_api(
            '/Devices/{device_id}/Ports/{port_index}/Modules/{module_index}/Relays/{relay_index}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def put_device_rotation(self, device_id, steps, direction, delay, **kwargs):  # noqa: E501
        """PUT Rotation  # noqa: E501

        Put rotation state of rotary turntable  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_device_rotation(device_id, steps, direction, delay, async_req=True)
        >>> result = thread.get()

        :param device_id: (required)
        :type device_id: str
        :param steps: Number of stepper motor steps to take (required)
        :type steps: int
        :param direction: Direction of rotation (required)
        :type direction: int
        :param delay: Delay between each step (required)
        :type delay: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.put_device_rotation_with_http_info(device_id, steps, direction, delay, **kwargs)  # noqa: E501

    def put_device_rotation_with_http_info(self, device_id, steps, direction, delay, **kwargs):  # noqa: E501
        """PUT Rotation  # noqa: E501

        Put rotation state of rotary turntable  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_device_rotation_with_http_info(device_id, steps, direction, delay, async_req=True)
        >>> result = thread.get()

        :param device_id: (required)
        :type device_id: str
        :param steps: Number of stepper motor steps to take (required)
        :type steps: int
        :param direction: Direction of rotation (required)
        :type direction: int
        :param delay: Delay between each step (required)
        :type delay: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'device_id',
            'steps',
            'direction',
            'delay'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_device_rotation" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'device_id' is set
        if self.api_client.client_side_validation and local_var_params.get('device_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `device_id` when calling `put_device_rotation`")  # noqa: E501
        # verify the required parameter 'steps' is set
        if self.api_client.client_side_validation and local_var_params.get('steps') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `steps` when calling `put_device_rotation`")  # noqa: E501
        # verify the required parameter 'direction' is set
        if self.api_client.client_side_validation and local_var_params.get('direction') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `direction` when calling `put_device_rotation`")  # noqa: E501
        # verify the required parameter 'delay' is set
        if self.api_client.client_side_validation and local_var_params.get('delay') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `delay` when calling `put_device_rotation`")  # noqa: E501

        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) > 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `put_device_rotation`, length must be less than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) < 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `put_device_rotation`, length must be greater than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and 'device_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}', local_var_params['device_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `put_device_rotation`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}/`")  # noqa: E501
        if self.api_client.client_side_validation and 'steps' in local_var_params and local_var_params['steps'] > 16000:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `steps` when calling `put_device_rotation`, must be a value less than or equal to `16000`")  # noqa: E501
        if self.api_client.client_side_validation and 'steps' in local_var_params and local_var_params['steps'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `steps` when calling `put_device_rotation`, must be a value greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'direction' in local_var_params and local_var_params['direction'] > 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `direction` when calling `put_device_rotation`, must be a value less than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'direction' in local_var_params and local_var_params['direction'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `direction` when calling `put_device_rotation`, must be a value greater than or equal to `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'delay' in local_var_params and local_var_params['delay'] > 1000:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `delay` when calling `put_device_rotation`, must be a value less than or equal to `1000`")  # noqa: E501
        if self.api_client.client_side_validation and 'delay' in local_var_params and local_var_params['delay'] < 500:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `delay` when calling `put_device_rotation`, must be a value greater than or equal to `500`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in local_var_params:
            path_params['device_id'] = local_var_params['device_id']  # noqa: E501

        query_params = []
        if local_var_params.get('steps') is not None:  # noqa: E501
            query_params.append(('steps', local_var_params['steps']))  # noqa: E501
        if local_var_params.get('direction') is not None:  # noqa: E501
            query_params.append(('direction', local_var_params['direction']))  # noqa: E501
        if local_var_params.get('delay') is not None:  # noqa: E501
            query_params.append(('delay', local_var_params['delay']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {}

        return self.api_client.call_api(
            '/Devices/{device_id}/Rotation', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def put_devices_led_index(self, device_id, led_index, state, **kwargs):  # noqa: E501
        """PUT state of LED  # noqa: E501

        Set led at index on selected device  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_devices_led_index(device_id, led_index, state, async_req=True)
        >>> result = thread.get()

        :param device_id: UUID of device (required)
        :type device_id: str
        :param led_index: Index of LED (required)
        :type led_index: int
        :param state: True = LED on, False = LED off (required)
        :type state: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.put_devices_led_index_with_http_info(device_id, led_index, state, **kwargs)  # noqa: E501

    def put_devices_led_index_with_http_info(self, device_id, led_index, state, **kwargs):  # noqa: E501
        """PUT state of LED  # noqa: E501

        Set led at index on selected device  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_devices_led_index_with_http_info(device_id, led_index, state, async_req=True)
        >>> result = thread.get()

        :param device_id: UUID of device (required)
        :type device_id: str
        :param led_index: Index of LED (required)
        :type led_index: int
        :param state: True = LED on, False = LED off (required)
        :type state: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'device_id',
            'led_index',
            'state'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_devices_led_index" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'device_id' is set
        if self.api_client.client_side_validation and local_var_params.get('device_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `device_id` when calling `put_devices_led_index`")  # noqa: E501
        # verify the required parameter 'led_index' is set
        if self.api_client.client_side_validation and local_var_params.get('led_index') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `led_index` when calling `put_devices_led_index`")  # noqa: E501
        # verify the required parameter 'state' is set
        if self.api_client.client_side_validation and local_var_params.get('state') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `state` when calling `put_devices_led_index`")  # noqa: E501

        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) > 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `put_devices_led_index`, length must be less than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) < 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `put_devices_led_index`, length must be greater than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and 'device_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}', local_var_params['device_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `put_devices_led_index`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}/`")  # noqa: E501
        if self.api_client.client_side_validation and 'led_index' in local_var_params and local_var_params['led_index'] > 100:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `led_index` when calling `put_devices_led_index`, must be a value less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and 'led_index' in local_var_params and local_var_params['led_index'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `led_index` when calling `put_devices_led_index`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in local_var_params:
            path_params['device_id'] = local_var_params['device_id']  # noqa: E501
        if 'led_index' in local_var_params:
            path_params['led_index'] = local_var_params['led_index']  # noqa: E501

        query_params = []
        if local_var_params.get('state') is not None:  # noqa: E501
            query_params.append(('state', local_var_params['state']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {}

        return self.api_client.call_api(
            '/Devices/{device_id}/Leds/{led_index}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def put_devices_ports(self, device_id, port_index, state, **kwargs):  # noqa: E501
        """PUT state of port  # noqa: E501

        Set state of port.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_devices_ports(device_id, port_index, state, async_req=True)
        >>> result = thread.get()

        :param device_id: UUID of device (required)
        :type device_id: str
        :param port_index: Index of port (required)
        :type port_index: int
        :param state: state id to switch to, 1 or more (required)
        :type state: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.put_devices_ports_with_http_info(device_id, port_index, state, **kwargs)  # noqa: E501

    def put_devices_ports_with_http_info(self, device_id, port_index, state, **kwargs):  # noqa: E501
        """PUT state of port  # noqa: E501

        Set state of port.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_devices_ports_with_http_info(device_id, port_index, state, async_req=True)
        >>> result = thread.get()

        :param device_id: UUID of device (required)
        :type device_id: str
        :param port_index: Index of port (required)
        :type port_index: int
        :param state: state id to switch to, 1 or more (required)
        :type state: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'device_id',
            'port_index',
            'state'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_devices_ports" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'device_id' is set
        if self.api_client.client_side_validation and local_var_params.get('device_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `device_id` when calling `put_devices_ports`")  # noqa: E501
        # verify the required parameter 'port_index' is set
        if self.api_client.client_side_validation and local_var_params.get('port_index') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `port_index` when calling `put_devices_ports`")  # noqa: E501
        # verify the required parameter 'state' is set
        if self.api_client.client_side_validation and local_var_params.get('state') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `state` when calling `put_devices_ports`")  # noqa: E501

        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) > 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `put_devices_ports`, length must be less than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) < 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `put_devices_ports`, length must be greater than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and 'device_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}', local_var_params['device_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `put_devices_ports`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}/`")  # noqa: E501
        if self.api_client.client_side_validation and 'port_index' in local_var_params and local_var_params['port_index'] > 100:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `port_index` when calling `put_devices_ports`, must be a value less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and 'port_index' in local_var_params and local_var_params['port_index'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `port_index` when calling `put_devices_ports`, must be a value greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'state' in local_var_params and local_var_params['state'] > 100:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `state` when calling `put_devices_ports`, must be a value less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and 'state' in local_var_params and local_var_params['state'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `state` when calling `put_devices_ports`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in local_var_params:
            path_params['device_id'] = local_var_params['device_id']  # noqa: E501
        if 'port_index' in local_var_params:
            path_params['port_index'] = local_var_params['port_index']  # noqa: E501

        query_params = []
        if local_var_params.get('state') is not None:  # noqa: E501
            query_params.append(('state', local_var_params['state']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {}

        return self.api_client.call_api(
            '/Devices/{device_id}/Ports/{port_index}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def put_port_led_state(self, device_id, port_index, led_index, state, **kwargs):  # noqa: E501
        """PUT state of Port LED  # noqa: E501

        Set led at index on specified device's port  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_port_led_state(device_id, port_index, led_index, state, async_req=True)
        >>> result = thread.get()

        :param device_id: UUID of device (required)
        :type device_id: str
        :param port_index: Index of Port (required)
        :type port_index: int
        :param led_index: Index of Led (required)
        :type led_index: int
        :param state: True = LED on, False = LED off (required)
        :type state: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.put_port_led_state_with_http_info(device_id, port_index, led_index, state, **kwargs)  # noqa: E501

    def put_port_led_state_with_http_info(self, device_id, port_index, led_index, state, **kwargs):  # noqa: E501
        """PUT state of Port LED  # noqa: E501

        Set led at index on specified device's port  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_port_led_state_with_http_info(device_id, port_index, led_index, state, async_req=True)
        >>> result = thread.get()

        :param device_id: UUID of device (required)
        :type device_id: str
        :param port_index: Index of Port (required)
        :type port_index: int
        :param led_index: Index of Led (required)
        :type led_index: int
        :param state: True = LED on, False = LED off (required)
        :type state: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'device_id',
            'port_index',
            'led_index',
            'state'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_port_led_state" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'device_id' is set
        if self.api_client.client_side_validation and local_var_params.get('device_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `device_id` when calling `put_port_led_state`")  # noqa: E501
        # verify the required parameter 'port_index' is set
        if self.api_client.client_side_validation and local_var_params.get('port_index') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `port_index` when calling `put_port_led_state`")  # noqa: E501
        # verify the required parameter 'led_index' is set
        if self.api_client.client_side_validation and local_var_params.get('led_index') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `led_index` when calling `put_port_led_state`")  # noqa: E501
        # verify the required parameter 'state' is set
        if self.api_client.client_side_validation and local_var_params.get('state') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `state` when calling `put_port_led_state`")  # noqa: E501

        if self.api_client.client_side_validation and 'device_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}', local_var_params['device_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `put_port_led_state`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}/`")  # noqa: E501
        if self.api_client.client_side_validation and 'port_index' in local_var_params and local_var_params['port_index'] > 8:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `port_index` when calling `put_port_led_state`, must be a value less than or equal to `8`")  # noqa: E501
        if self.api_client.client_side_validation and 'port_index' in local_var_params and local_var_params['port_index'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `port_index` when calling `put_port_led_state`, must be a value greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'led_index' in local_var_params and local_var_params['led_index'] > 32:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `led_index` when calling `put_port_led_state`, must be a value less than or equal to `32`")  # noqa: E501
        if self.api_client.client_side_validation and 'led_index' in local_var_params and local_var_params['led_index'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `led_index` when calling `put_port_led_state`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in local_var_params:
            path_params['device_id'] = local_var_params['device_id']  # noqa: E501
        if 'port_index' in local_var_params:
            path_params['port_index'] = local_var_params['port_index']  # noqa: E501
        if 'led_index' in local_var_params:
            path_params['led_index'] = local_var_params['led_index']  # noqa: E501

        query_params = []
        if local_var_params.get('state') is not None:  # noqa: E501
            query_params.append(('state', local_var_params['state']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {}

        return self.api_client.call_api(
            '/Devices/{device_id}/Ports/{port_index}/Leds/{led_index}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def put_port_port_id_label(self, port_id, **kwargs):  # noqa: E501
        """PUT the label for a Port  # noqa: E501

        set the label for the port identified by the given id  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_port_port_id_label(port_id, async_req=True)
        >>> result = thread.get()

        :param port_id: id of port for which label applies (required)
        :type port_id: str
        :param label: new label for the given port
        :type label: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.put_port_port_id_label_with_http_info(port_id, **kwargs)  # noqa: E501

    def put_port_port_id_label_with_http_info(self, port_id, **kwargs):  # noqa: E501
        """PUT the label for a Port  # noqa: E501

        set the label for the port identified by the given id  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_port_port_id_label_with_http_info(port_id, async_req=True)
        >>> result = thread.get()

        :param port_id: id of port for which label applies (required)
        :type port_id: str
        :param label: new label for the given port
        :type label: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'port_id',
            'label'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_port_port_id_label" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'port_id' is set
        if self.api_client.client_side_validation and local_var_params.get('port_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `port_id` when calling `put_port_port_id_label`")  # noqa: E501

        if self.api_client.client_side_validation and ('port_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['port_id']) > 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `port_id` when calling `put_port_port_id_label`, length must be less than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and ('port_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['port_id']) < 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `port_id` when calling `put_port_port_id_label`, length must be greater than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and 'port_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}', local_var_params['port_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `port_id` when calling `put_port_port_id_label`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'port_id' in local_var_params:
            path_params['port_id'] = local_var_params['port_id']  # noqa: E501

        query_params = []
        if local_var_params.get('label') is not None:  # noqa: E501
            query_params.append(('label', local_var_params['label']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {}

        return self.api_client.call_api(
            '/Port/{port_id}/Label', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def put_port_port_id_state_label(self, port_id, state_label, **kwargs):  # noqa: E501
        """PUT state label  # noqa: E501

        set the state label for the port identified by the given id  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_port_port_id_state_label(port_id, state_label, async_req=True)
        >>> result = thread.get()

        :param port_id: id of port for which state label applies (required)
        :type port_id: str
        :param state_label: new state label for the given port (required)
        :type state_label: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.put_port_port_id_state_label_with_http_info(port_id, state_label, **kwargs)  # noqa: E501

    def put_port_port_id_state_label_with_http_info(self, port_id, state_label, **kwargs):  # noqa: E501
        """PUT state label  # noqa: E501

        set the state label for the port identified by the given id  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_port_port_id_state_label_with_http_info(port_id, state_label, async_req=True)
        >>> result = thread.get()

        :param port_id: id of port for which state label applies (required)
        :type port_id: str
        :param state_label: new state label for the given port (required)
        :type state_label: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'port_id',
            'state_label'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_port_port_id_state_label" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'port_id' is set
        if self.api_client.client_side_validation and local_var_params.get('port_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `port_id` when calling `put_port_port_id_state_label`")  # noqa: E501
        # verify the required parameter 'state_label' is set
        if self.api_client.client_side_validation and local_var_params.get('state_label') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `state_label` when calling `put_port_port_id_state_label`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'port_id' in local_var_params:
            path_params['port_id'] = local_var_params['port_id']  # noqa: E501

        query_params = []
        if local_var_params.get('state_label') is not None:  # noqa: E501
            query_params.append(('state_label', local_var_params['state_label']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {}

        return self.api_client.call_api(
            '/Port/{port_id}/StateLabel', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def put_port_states_port_id(self, port_id, **kwargs):  # noqa: E501
        """  # noqa: E501

        Updates the list of port states for given port   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_port_states_port_id(port_id, async_req=True)
        >>> result = thread.get()

        :param port_id: (required)
        :type port_id: str
        :param port_state: Array of ports states to be used for the port given
        :type port_state: list[PortState]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.put_port_states_port_id_with_http_info(port_id, **kwargs)  # noqa: E501

    def put_port_states_port_id_with_http_info(self, port_id, **kwargs):  # noqa: E501
        """  # noqa: E501

        Updates the list of port states for given port   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_port_states_port_id_with_http_info(port_id, async_req=True)
        >>> result = thread.get()

        :param port_id: (required)
        :type port_id: str
        :param port_state: Array of ports states to be used for the port given
        :type port_state: list[PortState]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'port_id',
            'port_state'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_port_states_port_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'port_id' is set
        if self.api_client.client_side_validation and local_var_params.get('port_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `port_id` when calling `put_port_states_port_id`")  # noqa: E501

        if self.api_client.client_side_validation and ('port_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['port_id']) > 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `port_id` when calling `put_port_states_port_id`, length must be less than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and ('port_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['port_id']) < 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `port_id` when calling `put_port_states_port_id`, length must be greater than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and 'port_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}', local_var_params['port_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `port_id` when calling `put_port_states_port_id`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'port_id' in local_var_params:
            path_params['port_id'] = local_var_params['port_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'port_state' in local_var_params:
            body_params = local_var_params['port_state']
        # HTTP header `Content-Type`
        content_types_list = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json'],
                'PUT', body_params))  # noqa: E501
        if content_types_list:
                header_params['Content-Type'] = content_types_list

        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {}

        return self.api_client.call_api(
            '/PortStates/{port_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def put_ports_pulse(self, device_id, port_index, time, state, **kwargs):  # noqa: E501
        """PUT port into state for period of time  # noqa: E501

        Pulse port from one state to another for a period of time in seconds  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_ports_pulse(device_id, port_index, time, state, async_req=True)
        >>> result = thread.get()

        :param device_id: UUID of device (required)
        :type device_id: str
        :param port_index: Index of port (required)
        :type port_index: int
        :param time: time in seconds to press for 0.1 = 100ms (required)
        :type time: float
        :param state: state to switch to (required)
        :type state: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.put_ports_pulse_with_http_info(device_id, port_index, time, state, **kwargs)  # noqa: E501

    def put_ports_pulse_with_http_info(self, device_id, port_index, time, state, **kwargs):  # noqa: E501
        """PUT port into state for period of time  # noqa: E501

        Pulse port from one state to another for a period of time in seconds  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_ports_pulse_with_http_info(device_id, port_index, time, state, async_req=True)
        >>> result = thread.get()

        :param device_id: UUID of device (required)
        :type device_id: str
        :param port_index: Index of port (required)
        :type port_index: int
        :param time: time in seconds to press for 0.1 = 100ms (required)
        :type time: float
        :param state: state to switch to (required)
        :type state: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'device_id',
            'port_index',
            'time',
            'state'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_ports_pulse" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'device_id' is set
        if self.api_client.client_side_validation and local_var_params.get('device_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `device_id` when calling `put_ports_pulse`")  # noqa: E501
        # verify the required parameter 'port_index' is set
        if self.api_client.client_side_validation and local_var_params.get('port_index') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `port_index` when calling `put_ports_pulse`")  # noqa: E501
        # verify the required parameter 'time' is set
        if self.api_client.client_side_validation and local_var_params.get('time') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `time` when calling `put_ports_pulse`")  # noqa: E501
        # verify the required parameter 'state' is set
        if self.api_client.client_side_validation and local_var_params.get('state') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `state` when calling `put_ports_pulse`")  # noqa: E501

        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) > 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `put_ports_pulse`, length must be less than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) < 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `put_ports_pulse`, length must be greater than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and 'device_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}', local_var_params['device_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `put_ports_pulse`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}/`")  # noqa: E501
        if self.api_client.client_side_validation and 'port_index' in local_var_params and local_var_params['port_index'] > 100:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `port_index` when calling `put_ports_pulse`, must be a value less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and 'port_index' in local_var_params and local_var_params['port_index'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `port_index` when calling `put_ports_pulse`, must be a value greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'state' in local_var_params and local_var_params['state'] > 1000:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `state` when calling `put_ports_pulse`, must be a value less than or equal to `1000`")  # noqa: E501
        if self.api_client.client_side_validation and 'state' in local_var_params and local_var_params['state'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `state` when calling `put_ports_pulse`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in local_var_params:
            path_params['device_id'] = local_var_params['device_id']  # noqa: E501
        if 'port_index' in local_var_params:
            path_params['port_index'] = local_var_params['port_index']  # noqa: E501

        query_params = []
        if local_var_params.get('time') is not None:  # noqa: E501
            query_params.append(('time', local_var_params['time']))  # noqa: E501
        if local_var_params.get('state') is not None:  # noqa: E501
            query_params.append(('state', local_var_params['state']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {}

        return self.api_client.call_api(
            '/Devices/{device_id}/Ports/{port_index}/Pulse', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def put_relay_state(self, device_id, index, state, **kwargs):  # noqa: E501
        """  # noqa: E501

        Put state of relay at index  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_relay_state(device_id, index, state, async_req=True)
        >>> result = thread.get()

        :param device_id: (required)
        :type device_id: str
        :param index: index of relay to set state (required)
        :type index: int
        :param state: state to put (required)
        :type state: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.put_relay_state_with_http_info(device_id, index, state, **kwargs)  # noqa: E501

    def put_relay_state_with_http_info(self, device_id, index, state, **kwargs):  # noqa: E501
        """  # noqa: E501

        Put state of relay at index  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_relay_state_with_http_info(device_id, index, state, async_req=True)
        >>> result = thread.get()

        :param device_id: (required)
        :type device_id: str
        :param index: index of relay to set state (required)
        :type index: int
        :param state: state to put (required)
        :type state: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'device_id',
            'index',
            'state'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_relay_state" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'device_id' is set
        if self.api_client.client_side_validation and local_var_params.get('device_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `device_id` when calling `put_relay_state`")  # noqa: E501
        # verify the required parameter 'index' is set
        if self.api_client.client_side_validation and local_var_params.get('index') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `index` when calling `put_relay_state`")  # noqa: E501
        # verify the required parameter 'state' is set
        if self.api_client.client_side_validation and local_var_params.get('state') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `state` when calling `put_relay_state`")  # noqa: E501

        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) > 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `put_relay_state`, length must be less than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) < 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `put_relay_state`, length must be greater than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and 'device_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}', local_var_params['device_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `put_relay_state`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in local_var_params:
            path_params['device_id'] = local_var_params['device_id']  # noqa: E501

        query_params = []
        if local_var_params.get('index') is not None:  # noqa: E501
            query_params.append(('index', local_var_params['index']))  # noqa: E501
        if local_var_params.get('state') is not None:  # noqa: E501
            query_params.append(('state', local_var_params['state']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {}

        return self.api_client.call_api(
            '/Devices/{device_id}/Relay', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def put_serial_test_message(self, device_id, port_index, serial_message, **kwargs):  # noqa: E501
        """Serial Message Test  # noqa: E501

        Send a serial message to the device SerialUSB bus  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_serial_test_message(device_id, port_index, serial_message, async_req=True)
        >>> result = thread.get()

        :param device_id: Device ID (required)
        :type device_id: str
        :param port_index: Port Index (required)
        :type port_index: float
        :param serial_message: Serial message to SerialUSB (required)
        :type serial_message: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.put_serial_test_message_with_http_info(device_id, port_index, serial_message, **kwargs)  # noqa: E501

    def put_serial_test_message_with_http_info(self, device_id, port_index, serial_message, **kwargs):  # noqa: E501
        """Serial Message Test  # noqa: E501

        Send a serial message to the device SerialUSB bus  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_serial_test_message_with_http_info(device_id, port_index, serial_message, async_req=True)
        >>> result = thread.get()

        :param device_id: Device ID (required)
        :type device_id: str
        :param port_index: Port Index (required)
        :type port_index: float
        :param serial_message: Serial message to SerialUSB (required)
        :type serial_message: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'device_id',
            'port_index',
            'serial_message'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_serial_test_message" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'device_id' is set
        if self.api_client.client_side_validation and local_var_params.get('device_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `device_id` when calling `put_serial_test_message`")  # noqa: E501
        # verify the required parameter 'port_index' is set
        if self.api_client.client_side_validation and local_var_params.get('port_index') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `port_index` when calling `put_serial_test_message`")  # noqa: E501
        # verify the required parameter 'serial_message' is set
        if self.api_client.client_side_validation and local_var_params.get('serial_message') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `serial_message` when calling `put_serial_test_message`")  # noqa: E501

        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) > 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `put_serial_test_message`, length must be less than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and ('device_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['device_id']) < 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `put_serial_test_message`, length must be greater than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and 'device_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}', local_var_params['device_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `device_id` when calling `put_serial_test_message`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}/`")  # noqa: E501
        if self.api_client.client_side_validation and 'port_index' in local_var_params and local_var_params['port_index'] > 100:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `port_index` when calling `put_serial_test_message`, must be a value less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and 'port_index' in local_var_params and local_var_params['port_index'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `port_index` when calling `put_serial_test_message`, must be a value greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and ('serial_message' in local_var_params and  # noqa: E501
                                                        len(local_var_params['serial_message']) > 23):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `serial_message` when calling `put_serial_test_message`, length must be less than or equal to `23`")  # noqa: E501
        if self.api_client.client_side_validation and ('serial_message' in local_var_params and  # noqa: E501
                                                        len(local_var_params['serial_message']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `serial_message` when calling `put_serial_test_message`, length must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in local_var_params:
            path_params['device_id'] = local_var_params['device_id']  # noqa: E501
        if 'port_index' in local_var_params:
            path_params['port_index'] = local_var_params['port_index']  # noqa: E501

        query_params = []
        if local_var_params.get('serial_message') is not None:  # noqa: E501
            query_params.append(('serial_message', local_var_params['serial_message']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {}

        return self.api_client.call_api(
            '/Devices/{device_id}/Ports/{port_index}/SerialMessage', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def put_state_by_port_id(self, port_id, state, **kwargs):  # noqa: E501
        """PUT state of port  # noqa: E501

        Set State of Port by id   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_state_by_port_id(port_id, state, async_req=True)
        >>> result = thread.get()

        :param port_id: id of port to set (required)
        :type port_id: str
        :param state: state id to switch to, 1 or more (required)
        :type state: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.put_state_by_port_id_with_http_info(port_id, state, **kwargs)  # noqa: E501

    def put_state_by_port_id_with_http_info(self, port_id, state, **kwargs):  # noqa: E501
        """PUT state of port  # noqa: E501

        Set State of Port by id   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_state_by_port_id_with_http_info(port_id, state, async_req=True)
        >>> result = thread.get()

        :param port_id: id of port to set (required)
        :type port_id: str
        :param state: state id to switch to, 1 or more (required)
        :type state: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'port_id',
            'state'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_state_by_port_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'port_id' is set
        if self.api_client.client_side_validation and local_var_params.get('port_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `port_id` when calling `put_state_by_port_id`")  # noqa: E501
        # verify the required parameter 'state' is set
        if self.api_client.client_side_validation and local_var_params.get('state') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `state` when calling `put_state_by_port_id`")  # noqa: E501

        if self.api_client.client_side_validation and ('port_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['port_id']) > 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `port_id` when calling `put_state_by_port_id`, length must be less than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and ('port_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['port_id']) < 36):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `port_id` when calling `put_state_by_port_id`, length must be greater than or equal to `36`")  # noqa: E501
        if self.api_client.client_side_validation and 'port_id' in local_var_params and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}', local_var_params['port_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `port_id` when calling `put_state_by_port_id`, must conform to the pattern `/[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'port_id' in local_var_params:
            path_params['port_id'] = local_var_params['port_id']  # noqa: E501

        query_params = []
        if local_var_params.get('state') is not None:  # noqa: E501
            query_params.append(('state', local_var_params['state']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        response_types_map = {}

        return self.api_client.call_api(
            '/Port/{port_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))
