# coding: utf-8

"""
    DeviceServer

    DeviceServer API  # noqa: E501

    The version of the OpenAPI document: 1.0.8
    Contact: david@3adesign.co.uk
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from DeviceServer.configuration import Configuration


class Device(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'device_id': 'str',
        'device_index': 'int',
        'device_type': 'str',
        'device_serial': 'str',
        'name': 'str',
        'description': 'str',
        'port_count': 'int',
        'button_count': 'int',
        'led_count': 'int',
        'temperature_port_count': 'int'
    }

    attribute_map = {
        'device_id': 'device_id',
        'device_index': 'device_index',
        'device_type': 'device_type',
        'device_serial': 'device_serial',
        'name': 'name',
        'description': 'description',
        'port_count': 'port_count',
        'button_count': 'button_count',
        'led_count': 'led_count',
        'temperature_port_count': 'temperature_port_count'
    }

    def __init__(self, device_id=None, device_index=None, device_type=None, device_serial=None, name=None, description=None, port_count=None, button_count=None, led_count=None, temperature_port_count=None, local_vars_configuration=None):  # noqa: E501
        """Device - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._device_id = None
        self._device_index = None
        self._device_type = None
        self._device_serial = None
        self._name = None
        self._description = None
        self._port_count = None
        self._button_count = None
        self._led_count = None
        self._temperature_port_count = None
        self.discriminator = None

        self.device_id = device_id
        self.device_index = device_index
        if device_type is not None:
            self.device_type = device_type
        if device_serial is not None:
            self.device_serial = device_serial
        self.name = name
        if description is not None:
            self.description = description
        if port_count is not None:
            self.port_count = port_count
        if button_count is not None:
            self.button_count = button_count
        if led_count is not None:
            self.led_count = led_count
        if temperature_port_count is not None:
            self.temperature_port_count = temperature_port_count

    @property
    def device_id(self):
        """Gets the device_id of this Device.  # noqa: E501


        :return: The device_id of this Device.  # noqa: E501
        :rtype: str
        """
        return self._device_id

    @device_id.setter
    def device_id(self, device_id):
        """Sets the device_id of this Device.


        :param device_id: The device_id of this Device.  # noqa: E501
        :type device_id: str
        """
        if self.local_vars_configuration.client_side_validation and device_id is None:  # noqa: E501
            raise ValueError("Invalid value for `device_id`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                device_id is not None and len(device_id) > 36):
            raise ValueError("Invalid value for `device_id`, length must be less than or equal to `36`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                device_id is not None and len(device_id) < 36):
            raise ValueError("Invalid value for `device_id`, length must be greater than or equal to `36`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                device_id is not None and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}', device_id)):  # noqa: E501
            raise ValueError(r"Invalid value for `device_id`, must be a follow pattern or equal to `/[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}/`")  # noqa: E501

        self._device_id = device_id

    @property
    def device_index(self):
        """Gets the device_index of this Device.  # noqa: E501


        :return: The device_index of this Device.  # noqa: E501
        :rtype: int
        """
        return self._device_index

    @device_index.setter
    def device_index(self, device_index):
        """Sets the device_index of this Device.


        :param device_index: The device_index of this Device.  # noqa: E501
        :type device_index: int
        """
        if self.local_vars_configuration.client_side_validation and device_index is None:  # noqa: E501
            raise ValueError("Invalid value for `device_index`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                device_index is not None and device_index < 0):  # noqa: E501
            raise ValueError("Invalid value for `device_index`, must be a value greater than or equal to `0`")  # noqa: E501

        self._device_index = device_index

    @property
    def device_type(self):
        """Gets the device_type of this Device.  # noqa: E501


        :return: The device_type of this Device.  # noqa: E501
        :rtype: str
        """
        return self._device_type

    @device_type.setter
    def device_type(self, device_type):
        """Sets the device_type of this Device.


        :param device_type: The device_type of this Device.  # noqa: E501
        :type device_type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                device_type is not None and len(device_type) > 100):
            raise ValueError("Invalid value for `device_type`, length must be less than or equal to `100`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                device_type is not None and len(device_type) < 1):
            raise ValueError("Invalid value for `device_type`, length must be greater than or equal to `1`")  # noqa: E501

        self._device_type = device_type

    @property
    def device_serial(self):
        """Gets the device_serial of this Device.  # noqa: E501


        :return: The device_serial of this Device.  # noqa: E501
        :rtype: str
        """
        return self._device_serial

    @device_serial.setter
    def device_serial(self, device_serial):
        """Sets the device_serial of this Device.


        :param device_serial: The device_serial of this Device.  # noqa: E501
        :type device_serial: str
        """
        if (self.local_vars_configuration.client_side_validation and
                device_serial is not None and len(device_serial) > 32):
            raise ValueError("Invalid value for `device_serial`, length must be less than or equal to `32`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                device_serial is not None and len(device_serial) < 1):
            raise ValueError("Invalid value for `device_serial`, length must be greater than or equal to `1`")  # noqa: E501

        self._device_serial = device_serial

    @property
    def name(self):
        """Gets the name of this Device.  # noqa: E501


        :return: The name of this Device.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Device.


        :param name: The name of this Device.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                name is not None and len(name) > 64):
            raise ValueError("Invalid value for `name`, length must be less than or equal to `64`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                name is not None and len(name) < 1):
            raise ValueError("Invalid value for `name`, length must be greater than or equal to `1`")  # noqa: E501

        self._name = name

    @property
    def description(self):
        """Gets the description of this Device.  # noqa: E501


        :return: The description of this Device.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this Device.


        :param description: The description of this Device.  # noqa: E501
        :type description: str
        """
        if (self.local_vars_configuration.client_side_validation and
                description is not None and len(description) > 100):
            raise ValueError("Invalid value for `description`, length must be less than or equal to `100`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                description is not None and len(description) < 1):
            raise ValueError("Invalid value for `description`, length must be greater than or equal to `1`")  # noqa: E501

        self._description = description

    @property
    def port_count(self):
        """Gets the port_count of this Device.  # noqa: E501

        Number of ports available on device  # noqa: E501

        :return: The port_count of this Device.  # noqa: E501
        :rtype: int
        """
        return self._port_count

    @port_count.setter
    def port_count(self, port_count):
        """Sets the port_count of this Device.

        Number of ports available on device  # noqa: E501

        :param port_count: The port_count of this Device.  # noqa: E501
        :type port_count: int
        """
        if (self.local_vars_configuration.client_side_validation and
                port_count is not None and port_count > 100):  # noqa: E501
            raise ValueError("Invalid value for `port_count`, must be a value less than or equal to `100`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                port_count is not None and port_count < 0):  # noqa: E501
            raise ValueError("Invalid value for `port_count`, must be a value greater than or equal to `0`")  # noqa: E501

        self._port_count = port_count

    @property
    def button_count(self):
        """Gets the button_count of this Device.  # noqa: E501

        Number of buttons available on device  # noqa: E501

        :return: The button_count of this Device.  # noqa: E501
        :rtype: int
        """
        return self._button_count

    @button_count.setter
    def button_count(self, button_count):
        """Sets the button_count of this Device.

        Number of buttons available on device  # noqa: E501

        :param button_count: The button_count of this Device.  # noqa: E501
        :type button_count: int
        """
        if (self.local_vars_configuration.client_side_validation and
                button_count is not None and button_count > 100):  # noqa: E501
            raise ValueError("Invalid value for `button_count`, must be a value less than or equal to `100`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                button_count is not None and button_count < 0):  # noqa: E501
            raise ValueError("Invalid value for `button_count`, must be a value greater than or equal to `0`")  # noqa: E501

        self._button_count = button_count

    @property
    def led_count(self):
        """Gets the led_count of this Device.  # noqa: E501

        Number of leds available on device  # noqa: E501

        :return: The led_count of this Device.  # noqa: E501
        :rtype: int
        """
        return self._led_count

    @led_count.setter
    def led_count(self, led_count):
        """Sets the led_count of this Device.

        Number of leds available on device  # noqa: E501

        :param led_count: The led_count of this Device.  # noqa: E501
        :type led_count: int
        """
        if (self.local_vars_configuration.client_side_validation and
                led_count is not None and led_count > 100):  # noqa: E501
            raise ValueError("Invalid value for `led_count`, must be a value less than or equal to `100`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                led_count is not None and led_count < 0):  # noqa: E501
            raise ValueError("Invalid value for `led_count`, must be a value greater than or equal to `0`")  # noqa: E501

        self._led_count = led_count

    @property
    def temperature_port_count(self):
        """Gets the temperature_port_count of this Device.  # noqa: E501

        Number of temperature ports available on device  # noqa: E501

        :return: The temperature_port_count of this Device.  # noqa: E501
        :rtype: int
        """
        return self._temperature_port_count

    @temperature_port_count.setter
    def temperature_port_count(self, temperature_port_count):
        """Sets the temperature_port_count of this Device.

        Number of temperature ports available on device  # noqa: E501

        :param temperature_port_count: The temperature_port_count of this Device.  # noqa: E501
        :type temperature_port_count: int
        """
        if (self.local_vars_configuration.client_side_validation and
                temperature_port_count is not None and temperature_port_count > 100):  # noqa: E501
            raise ValueError("Invalid value for `temperature_port_count`, must be a value less than or equal to `100`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                temperature_port_count is not None and temperature_port_count < 0):  # noqa: E501
            raise ValueError("Invalid value for `temperature_port_count`, must be a value greater than or equal to `0`")  # noqa: E501

        self._temperature_port_count = temperature_port_count

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Device):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Device):
            return True

        return self.to_dict() != other.to_dict()
