# coding: utf-8

"""
    DeviceServer

    DeviceServer API  # noqa: E501

    The version of the OpenAPI document: 1.0.8
    Contact: david@3adesign.co.uk
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from DeviceServer.configuration import Configuration


class DevicePort(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'port_index': 'int',
        'label': 'str',
        'state_index': 'int',
        'state_count': 'int',
        'port_id': 'str',
        'state_label': 'str'
    }

    attribute_map = {
        'port_index': 'port_index',
        'label': 'label',
        'state_index': 'state_index',
        'state_count': 'state_count',
        'port_id': 'port_id',
        'state_label': 'state_label'
    }

    def __init__(self, port_index=None, label=None, state_index=None, state_count=None, port_id=None, state_label=None, local_vars_configuration=None):  # noqa: E501
        """DevicePort - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._port_index = None
        self._label = None
        self._state_index = None
        self._state_count = None
        self._port_id = None
        self._state_label = None
        self.discriminator = None

        self.port_index = port_index
        if label is not None:
            self.label = label
        if state_index is not None:
            self.state_index = state_index
        if state_count is not None:
            self.state_count = state_count
        self.port_id = port_id
        if state_label is not None:
            self.state_label = state_label

    @property
    def port_index(self):
        """Gets the port_index of this DevicePort.  # noqa: E501


        :return: The port_index of this DevicePort.  # noqa: E501
        :rtype: int
        """
        return self._port_index

    @port_index.setter
    def port_index(self, port_index):
        """Sets the port_index of this DevicePort.


        :param port_index: The port_index of this DevicePort.  # noqa: E501
        :type port_index: int
        """
        if self.local_vars_configuration.client_side_validation and port_index is None:  # noqa: E501
            raise ValueError("Invalid value for `port_index`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                port_index is not None and port_index > 100):  # noqa: E501
            raise ValueError("Invalid value for `port_index`, must be a value less than or equal to `100`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                port_index is not None and port_index < 1):  # noqa: E501
            raise ValueError("Invalid value for `port_index`, must be a value greater than or equal to `1`")  # noqa: E501

        self._port_index = port_index

    @property
    def label(self):
        """Gets the label of this DevicePort.  # noqa: E501


        :return: The label of this DevicePort.  # noqa: E501
        :rtype: str
        """
        return self._label

    @label.setter
    def label(self, label):
        """Sets the label of this DevicePort.


        :param label: The label of this DevicePort.  # noqa: E501
        :type label: str
        """
        if (self.local_vars_configuration.client_side_validation and
                label is not None and len(label) > 64):
            raise ValueError("Invalid value for `label`, length must be less than or equal to `64`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                label is not None and len(label) < 1):
            raise ValueError("Invalid value for `label`, length must be greater than or equal to `1`")  # noqa: E501

        self._label = label

    @property
    def state_index(self):
        """Gets the state_index of this DevicePort.  # noqa: E501


        :return: The state_index of this DevicePort.  # noqa: E501
        :rtype: int
        """
        return self._state_index

    @state_index.setter
    def state_index(self, state_index):
        """Sets the state_index of this DevicePort.


        :param state_index: The state_index of this DevicePort.  # noqa: E501
        :type state_index: int
        """
        if (self.local_vars_configuration.client_side_validation and
                state_index is not None and state_index < 0):  # noqa: E501
            raise ValueError("Invalid value for `state_index`, must be a value greater than or equal to `0`")  # noqa: E501

        self._state_index = state_index

    @property
    def state_count(self):
        """Gets the state_count of this DevicePort.  # noqa: E501


        :return: The state_count of this DevicePort.  # noqa: E501
        :rtype: int
        """
        return self._state_count

    @state_count.setter
    def state_count(self, state_count):
        """Sets the state_count of this DevicePort.


        :param state_count: The state_count of this DevicePort.  # noqa: E501
        :type state_count: int
        """
        if (self.local_vars_configuration.client_side_validation and
                state_count is not None and state_count < 1):  # noqa: E501
            raise ValueError("Invalid value for `state_count`, must be a value greater than or equal to `1`")  # noqa: E501

        self._state_count = state_count

    @property
    def port_id(self):
        """Gets the port_id of this DevicePort.  # noqa: E501


        :return: The port_id of this DevicePort.  # noqa: E501
        :rtype: str
        """
        return self._port_id

    @port_id.setter
    def port_id(self, port_id):
        """Sets the port_id of this DevicePort.


        :param port_id: The port_id of this DevicePort.  # noqa: E501
        :type port_id: str
        """
        if self.local_vars_configuration.client_side_validation and port_id is None:  # noqa: E501
            raise ValueError("Invalid value for `port_id`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                port_id is not None and len(port_id) > 36):
            raise ValueError("Invalid value for `port_id`, length must be less than or equal to `36`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                port_id is not None and len(port_id) < 36):
            raise ValueError("Invalid value for `port_id`, length must be greater than or equal to `36`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                port_id is not None and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}', port_id)):  # noqa: E501
            raise ValueError(r"Invalid value for `port_id`, must be a follow pattern or equal to `/[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}/`")  # noqa: E501

        self._port_id = port_id

    @property
    def state_label(self):
        """Gets the state_label of this DevicePort.  # noqa: E501


        :return: The state_label of this DevicePort.  # noqa: E501
        :rtype: str
        """
        return self._state_label

    @state_label.setter
    def state_label(self, state_label):
        """Sets the state_label of this DevicePort.


        :param state_label: The state_label of this DevicePort.  # noqa: E501
        :type state_label: str
        """
        if (self.local_vars_configuration.client_side_validation and
                state_label is not None and len(state_label) > 64):
            raise ValueError("Invalid value for `state_label`, length must be less than or equal to `64`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                state_label is not None and len(state_label) < 1):
            raise ValueError("Invalid value for `state_label`, length must be greater than or equal to `1`")  # noqa: E501

        self._state_label = state_label

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DevicePort):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, DevicePort):
            return True

        return self.to_dict() != other.to_dict()
