# DeviceServer
DeviceServer API

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0.8
- Package version: 1.0.8
- Build package: org.openapitools.codegen.languages.PythonLegacyClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import DeviceServer
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import DeviceServer
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function

import time
import DeviceServer
from DeviceServer.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost/DeviceServer
# See configuration.py for a list of all supported configuration parameters.
configuration = DeviceServer.Configuration(
    host = "http://localhost/DeviceServer"
)



# Enter a context with an instance of the API client
with DeviceServer.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = DeviceServer.DevicesApi(api_client)
    device_id = 'device_id_example' # str | 
expander_index = 56 # int | expander index
expander_port_index = 56 # int | expander port index (optional)

    try:
        # GET attenuation state
        api_response = api_instance.get_attenuator_state(device_id, expander_index, expander_port_index=expander_port_index)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling DevicesApi->get_attenuator_state: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost/DeviceServer*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DevicesApi* | [**get_attenuator_state**](docs/DevicesApi.md#get_attenuator_state) | **GET** /Devices/{device_id}/Attenuate | GET attenuation state
*DevicesApi* | [**get_channel_attenuation**](docs/DevicesApi.md#get_channel_attenuation) | **GET** /Devices/{device_id}/AttenuateChannel | GET attenuation channel state
*DevicesApi* | [**get_current**](docs/DevicesApi.md#get_current) | **GET** /Devices/{device_id}/Currents/{current_index} | GET current reading of device
*DevicesApi* | [**get_device_attenuation_configuration**](docs/DevicesApi.md#get_device_attenuation_configuration) | **GET** /Devices/{device_id}/AttenuatorConfig | GET attenuation device config
*DevicesApi* | [**get_device_device_id_buttons**](docs/DevicesApi.md#get_device_device_id_buttons) | **GET** /Devices/{device_id}/Buttons | GET all buttons for device
*DevicesApi* | [**get_device_device_id_leds**](docs/DevicesApi.md#get_device_device_id_leds) | **GET** /Devices/{device_id}/Leds | GET all leds for device
*DevicesApi* | [**get_device_device_id_ports**](docs/DevicesApi.md#get_device_device_id_ports) | **GET** /Devices/{device_id}/Ports | GET all ports for device
*DevicesApi* | [**get_device_device_id_temperature_ports**](docs/DevicesApi.md#get_device_device_id_temperature_ports) | **GET** /Devices/{device_id}/Temparatures | GET all temperature ports for device
*DevicesApi* | [**get_device_id_port_index**](docs/DevicesApi.md#get_device_id_port_index) | **GET** /Devices/{device_id}/Ports/{port_index} | GET status of port
*DevicesApi* | [**get_device_port_current**](docs/DevicesApi.md#get_device_port_current) | **GET** /Devices/{device_id}/Ports/{port_index}/Currents | GET current reading of device Port
*DevicesApi* | [**get_device_port_module_led_state**](docs/DevicesApi.md#get_device_port_module_led_state) | **GET** /Devices/{device_id}/Ports/{port_index}/Modules/{module_index}/Leds | GET state of Port LED
*DevicesApi* | [**get_device_port_module_relay_state**](docs/DevicesApi.md#get_device_port_module_relay_state) | **GET** /Devices/{device_id}/Ports/{port_index}/Modules/{module_index}/Relays/{relay_index} | GET state of Port LED
*DevicesApi* | [**get_device_port_voltage**](docs/DevicesApi.md#get_device_port_voltage) | **GET** /Devices/{device_id}/Ports/{port_index}/Voltages | GET voltage reading of device Port
*DevicesApi* | [**get_device_rotation_angle**](docs/DevicesApi.md#get_device_rotation_angle) | **GET** /Devices/{device_id}/Rotation | GET Rotation Angle
*DevicesApi* | [**get_device_uuid**](docs/DevicesApi.md#get_device_uuid) | **GET** /Serial/{device_serial}/Type/{device_type} | GET uuid from database
*DevicesApi* | [**get_devices**](docs/DevicesApi.md#get_devices) | **GET** /Devices | GET list of devices
*DevicesApi* | [**get_devices_button**](docs/DevicesApi.md#get_devices_button) | **GET** /Devices/{device_id}/Button | GET state of button
*DevicesApi* | [**get_devices_index**](docs/DevicesApi.md#get_devices_index) | **GET** /Devices/{device_id} | GET single device
*DevicesApi* | [**get_devices_led**](docs/DevicesApi.md#get_devices_led) | **GET** /Devices/{device_id}/Leds/{led_index} | GET state of LED
*DevicesApi* | [**get_devices_temperature**](docs/DevicesApi.md#get_devices_temperature) | **GET** /Devices/{device_id}/Temperature | GET temperature reading
*DevicesApi* | [**get_fan_speed**](docs/DevicesApi.md#get_fan_speed) | **GET** /Devices/{device_id}/Fan/{fan_index}/Speed | GET device fan speed
*DevicesApi* | [**get_fan_target_temperature**](docs/DevicesApi.md#get_fan_target_temperature) | **GET** /Devices/{device_id}/Fan/{fan_index}/TargetTemperature | GET device fan target temperature
*DevicesApi* | [**get_fan_temperature**](docs/DevicesApi.md#get_fan_temperature) | **GET** /Devices/{device_id}/Fan/{fan_index}/Temperature | GET device fan temperature
*DevicesApi* | [**get_firmware_version**](docs/DevicesApi.md#get_firmware_version) | **GET** /Devices/{device_id}/Firmware | GET Device Firmware Version
*DevicesApi* | [**get_message_from_rx_buffer**](docs/DevicesApi.md#get_message_from_rx_buffer) | **GET** /Devices/messages/rx | GET message from RX table
*DevicesApi* | [**get_message_from_tx_buffer**](docs/DevicesApi.md#get_message_from_tx_buffer) | **GET** /Devices/messages/tx | GET message from TX table
*DevicesApi* | [**get_port**](docs/DevicesApi.md#get_port) | **GET** /Port/{port_id} | GET status of port by id
*DevicesApi* | [**get_port_led_state**](docs/DevicesApi.md#get_port_led_state) | **GET** /Devices/{device_id}/Ports/{port_index}/Leds/{led_index} | GET state of Port LED
*DevicesApi* | [**get_port_setup_status**](docs/DevicesApi.md#get_port_setup_status) | **GET** /Devices/{device_id}/Ports/{port_index}/SetupStatus | GET status of port
*DevicesApi* | [**get_port_states**](docs/DevicesApi.md#get_port_states) | **GET** /PortStates/{port_id} | GET port states by port id
*DevicesApi* | [**get_ports**](docs/DevicesApi.md#get_ports) | **GET** /Ports | GET status of all ports
*DevicesApi* | [**get_relay_state**](docs/DevicesApi.md#get_relay_state) | **GET** /Devices/{device_id}/Relay | GET state of relay
*DevicesApi* | [**get_temperature_range**](docs/DevicesApi.md#get_temperature_range) | **GET** /Devices/{device_id}/Temperature/Range | GET Temperature Range
*DevicesApi* | [**get_temperature_thresholds**](docs/DevicesApi.md#get_temperature_thresholds) | **GET** /Devices/{device_id}/Temperature/Thresholds | GET Temperature Thresholds
*DevicesApi* | [**get_voltage**](docs/DevicesApi.md#get_voltage) | **GET** /Devices/{device_id}/Voltages/{voltage_index} | GET voltage reading of device
*DevicesApi* | [**put_attenuator_state**](docs/DevicesApi.md#put_attenuator_state) | **PUT** /Devices/{device_id}/Attenuate | PUT attenuation state
*DevicesApi* | [**put_channel_attenuation**](docs/DevicesApi.md#put_channel_attenuation) | **PUT** /Devices/{device_id}/AttenuateChannel | PUT attenuation state
*DevicesApi* | [**put_device**](docs/DevicesApi.md#put_device) | **PUT** /Devices/AddDevice | PUT Add device
*DevicesApi* | [**put_device_device_id_description**](docs/DevicesApi.md#put_device_device_id_description) | **PUT** /Device/{device_id}/Description | PUT a description for a Device
*DevicesApi* | [**put_device_device_id_name**](docs/DevicesApi.md#put_device_device_id_name) | **PUT** /Device/{device_id}/Name | PUT a name for a Device
*DevicesApi* | [**put_device_id_label**](docs/DevicesApi.md#put_device_id_label) | **PUT** /Device/{device_id}/Port/{port_index}/Label | PUT a Port label
*DevicesApi* | [**put_device_port_module_led_state**](docs/DevicesApi.md#put_device_port_module_led_state) | **PUT** /Devices/{device_id}/Ports/{port_index}/Modules/{module_index}/Leds | PUT state of Port LED
*DevicesApi* | [**put_device_port_module_relay_state**](docs/DevicesApi.md#put_device_port_module_relay_state) | **PUT** /Devices/{device_id}/Ports/{port_index}/Modules/{module_index}/Relays/{relay_index} | PUT state of Port Relay
*DevicesApi* | [**put_device_rotation**](docs/DevicesApi.md#put_device_rotation) | **PUT** /Devices/{device_id}/Rotation | PUT Rotation
*DevicesApi* | [**put_devices_led_index**](docs/DevicesApi.md#put_devices_led_index) | **PUT** /Devices/{device_id}/Leds/{led_index} | PUT state of LED
*DevicesApi* | [**put_devices_ports**](docs/DevicesApi.md#put_devices_ports) | **PUT** /Devices/{device_id}/Ports/{port_index} | PUT state of port
*DevicesApi* | [**put_port_led_state**](docs/DevicesApi.md#put_port_led_state) | **PUT** /Devices/{device_id}/Ports/{port_index}/Leds/{led_index} | PUT state of Port LED
*DevicesApi* | [**put_port_port_id_label**](docs/DevicesApi.md#put_port_port_id_label) | **PUT** /Port/{port_id}/Label | PUT the label for a Port
*DevicesApi* | [**put_port_port_id_state_label**](docs/DevicesApi.md#put_port_port_id_state_label) | **PUT** /Port/{port_id}/StateLabel | PUT state label
*DevicesApi* | [**put_port_states_port_id**](docs/DevicesApi.md#put_port_states_port_id) | **PUT** /PortStates/{port_id} | 
*DevicesApi* | [**put_ports_pulse**](docs/DevicesApi.md#put_ports_pulse) | **PUT** /Devices/{device_id}/Ports/{port_index}/Pulse | PUT port into state for period of time
*DevicesApi* | [**put_relay_state**](docs/DevicesApi.md#put_relay_state) | **PUT** /Devices/{device_id}/Relay | 
*DevicesApi* | [**put_serial_test_message**](docs/DevicesApi.md#put_serial_test_message) | **PUT** /Devices/{device_id}/Ports/{port_index}/SerialMessage | Serial Message Test
*DevicesApi* | [**put_state_by_port_id**](docs/DevicesApi.md#put_state_by_port_id) | **PUT** /Port/{port_id} | PUT state of port


## Documentation For Models

 - [DbButtonState](docs/DbButtonState.md)
 - [DbDeviceButton](docs/DbDeviceButton.md)
 - [DbDeviceLed](docs/DbDeviceLed.md)
 - [DbDevicePort](docs/DbDevicePort.md)
 - [DbDeviceTemperaturePort](docs/DbDeviceTemperaturePort.md)
 - [DbLedState](docs/DbLedState.md)
 - [DbPortState](docs/DbPortState.md)
 - [Device](docs/Device.md)
 - [DeviceButton](docs/DeviceButton.md)
 - [DeviceLed](docs/DeviceLed.md)
 - [DevicePort](docs/DevicePort.md)
 - [DeviceRxBuffer](docs/DeviceRxBuffer.md)
 - [DeviceTemperaturePort](docs/DeviceTemperaturePort.md)
 - [DeviceTxBuffer](docs/DeviceTxBuffer.md)
 - [GetAttenuatorState200Response](docs/GetAttenuatorState200Response.md)
 - [GetDevicesLed200Response](docs/GetDevicesLed200Response.md)
 - [GetFanSpeed200Response](docs/GetFanSpeed200Response.md)
 - [GetFanTargetTemperature200Response](docs/GetFanTargetTemperature200Response.md)
 - [GetFanTemperature200Response](docs/GetFanTemperature200Response.md)
 - [GetFirmwareVersion200Response](docs/GetFirmwareVersion200Response.md)
 - [HostConfig](docs/HostConfig.md)
 - [PortState](docs/PortState.md)
 - [TempRange](docs/TempRange.md)
 - [Temperature](docs/Temperature.md)


## Documentation For Authorization

 All endpoints do not require authorization.

## Author

david@3adesign.co.uk


