import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement } from "../shared";
/**
 * (experimental) Statement provider for service [wellarchitected](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awswell-architectedtool.html).
 *
 * @experimental
 */
export declare class Wellarchitected extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [wellarchitected](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awswell-architectedtool.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Grants permission to associate a lens to the specified workload.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_AssociateLenses.html
     *
     * @experimental
     */
    toAssociateLenses(): this;
    /**
     * (experimental) Grants permission to create a new milestone for the specified workload.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_CreateMilestone.html
     *
     * @experimental
     */
    toCreateMilestone(): this;
    /**
     * (experimental) Grants permission to create a new workload.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_CreateWorkload.html
     *
     * @experimental
     */
    toCreateWorkload(): this;
    /**
     * (experimental) Grants permission to share a workload with another account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_CreateWorkloadShare.html
     *
     * @experimental
     */
    toCreateWorkloadShare(): this;
    /**
     * (experimental) Grants permission to delete an existing workload.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_DeleteWorkload.html
     *
     * @experimental
     */
    toDeleteWorkload(): this;
    /**
     * (experimental) Grants permission to delete an existing workload share.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_DeleteWorkloadShare.html
     *
     * @experimental
     */
    toDeleteWorkloadShare(): this;
    /**
     * (experimental) Grants permission to disassociate a lens from the specified workload.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_DisassociateLenses.html
     *
     * @experimental
     */
    toDisassociateLenses(): this;
    /**
     * (experimental) Grants permission to retrieve the specified answer from the specified lens review.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_GetAnswer.html
     *
     * @experimental
     */
    toGetAnswer(): this;
    /**
     * (experimental) Grants permission to retrieve the specified lens review of the specified workload.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_GetLensReview.html
     *
     * @experimental
     */
    toGetLensReview(): this;
    /**
     * (experimental) Grants permission to retrieve the report for the specified lens review.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_GetLensReviewReport.html
     *
     * @experimental
     */
    toGetLensReviewReport(): this;
    /**
     * (experimental) Grants permission to get the difference between the specified lens version and latest available lens version.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_GetLensVersionDifference.html
     *
     * @experimental
     */
    toGetLensVersionDifference(): this;
    /**
     * (experimental) Grants permission to retrieve the specified milestone of the specified workload.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_GetMilestone.html
     *
     * @experimental
     */
    toGetMilestone(): this;
    /**
     * (experimental) Grants permission to retrieve the specified workload.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_GetWorkload.html
     *
     * @experimental
     */
    toGetWorkload(): this;
    /**
     * (experimental) Grants permission to list the answers from the specified lens review.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_ListAnswers.html
     *
     * @experimental
     */
    toListAnswers(): this;
    /**
     * (experimental) Grants permission to list the improvements of the specified lens review.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_ListLensReviewImprovements.html
     *
     * @experimental
     */
    toListLensReviewImprovements(): this;
    /**
     * (experimental) Grants permission to list the lens reviews of the specified workload.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_ListLensReviews.html
     *
     * @experimental
     */
    toListLensReviews(): this;
    /**
     * (experimental) Grants permission to list the lenses available to this account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_ListLenses.html
     *
     * @experimental
     */
    toListLenses(): this;
    /**
     * (experimental) Grants permission to list the milestones of the specified workload.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_ListMilestones.html
     *
     * @experimental
     */
    toListMilestones(): this;
    /**
     * (experimental) Grants permission to list notifications related to the account or specified resource.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_ListNotifications.html
     *
     * @experimental
     */
    toListNotifications(): this;
    /**
     * (experimental) Grants permission to list the workload share invitations of the specified account or user.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_ListShareInvitations.html
     *
     * @experimental
     */
    toListShareInvitations(): this;
    /**
     * (experimental) Grants permission to list tags for a Well-Architected resource.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_ListTagsForResource.html
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) Grants permission to list the workload shares of the specified workload.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_ListWorkloadShares.html
     *
     * @experimental
     */
    toListWorkloadShares(): this;
    /**
     * (experimental) Grants permission to list the workloads in this account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_ListWorkloads.html
     *
     * @experimental
     */
    toListWorkloads(): this;
    /**
     * (experimental) Grants permission to tag a Well-Architected resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_TagResource.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Grants permission to untag a Well-Architected resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_UntagResource.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Grants permission to update properties of the specified answer.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_UpdateAnswer.html
     *
     * @experimental
     */
    toUpdateAnswer(): this;
    /**
     * (experimental) Grants permission to update properties of the specified lens review.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_UpdateLensReview.html
     *
     * @experimental
     */
    toUpdateLensReview(): this;
    /**
     * (experimental) Grants permission to update status of the specified workload share invitation.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_UpdateShareInvitation.html
     *
     * @experimental
     */
    toUpdateShareInvitation(): this;
    /**
     * (experimental) Grants permission to update properties of the specified workload.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_UpdateWorkload.html
     *
     * @experimental
     */
    toUpdateWorkload(): this;
    /**
     * (experimental) Grants permission to update properties of the specified workload.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_UpdateWorkloadShare.html
     *
     * @experimental
     */
    toUpdateWorkloadShare(): this;
    /**
     * (experimental) Grants permission to upgrade the specified lens review to use the latest version of the associated lens.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_UpgradeLensReview.html
     *
     * @experimental
     */
    toUpgradeLensReview(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type workload to the statement.
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_Workload.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onWorkload(resourceId: string, account?: string, region?: string, partition?: string): this;
}
