#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['pydemic',
 'pydemic.api',
 'pydemic.cli',
 'pydemic.clinical_models',
 'pydemic.diseases',
 'pydemic.fitting',
 'pydemic.formulas',
 'pydemic.mixins',
 'pydemic.model_group',
 'pydemic.models',
 'pydemic.params',
 'pydemic.plot',
 'pydemic.properties',
 'pydemic.region',
 'pydemic.reports',
 'pydemic.utils']

package_data = \
{'': ['*'],
 'pydemic': ['databases/*',
             'databases/diseases/*',
             'databases/diseases/covid-19/*',
             'databases/diseases/empty/*'],
 'pydemic.models': ['.idea/*', '.idea/inspectionProfiles/*']}

install_requires = \
['mundi',
 'mundi-demography',
 'mundi-healthcare',
 'joblib',
 'click~=7.0',
 'matplotlib~=3.0',
 'numpy~=1.0',
 'pandas~=1.0',
 'requests~=2.0',
 'seaborn~=0.10',
 'statsmodels']

extras_require = \
{'dev': ['black', 'invoke~=1.4', 'flake8', 'pytest~=5.4', 'pytest-cov~=2.8']}

setup(name='pydemic-models',
      version='0.1.11',
      description='Pydemic',
      author='Fábio Macêdo Mendes',
      author_email='fabiomacedomendes@gmail.com',
      url='http://github.com/pydemic/pydemic',
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
     )
