# AUTOGENERATED! DO NOT EDIT! File to edit: 02_robot.ipynb (unless otherwise specified).

__all__ = ['ToyRobot', 'Table']

# Cell
from .direction import Direction
import numpy as np
from numpy import sin, cos, pi

# Cell
class ToyRobot:
    def __init__(self, x, y, idx=None, th=5, tw=5):
        self.f = Direction(idx=idx)
        self.x = x
        self.y = y
        self.table = Table(th, tw)

    def __repr__(self):
        return f"{self.__class__.__name__}, located at ({self.x}, {self.y}) and facing {self.f}!"

    def report(self): print(self)

    def left(self):
        self.f = self.f.left()

    def right(self):
        self.f = self.f.right()

    def move(self):
        idx = self.f.get_idx()
        new_x = self.x + (sin(idx*(pi/2)).astype(int))
        new_y = self.y + (cos(idx*(pi/2)).astype(int))
        if (new_x, new_y) in self.table:
            self.x = new_x
            self.y = new_y

    @classmethod
    def from_placement(cls, x, y, idx):
        return cls(x, y, idx=idx)

# Cell
class Table:
    def __init__(self, h=5, w=5):
        self.h = h
        self.w = w

    def __contains__(self, o):
        if isinstance(o, ToyRobot):
            return min(self.h, self.w) >= max(o.x, o.y)
        else:
            return min(self.h, self.w) >= max(o[0], o[1])