from expressmoney.api import *

__all__ = ('OrderAPI',)

SERVICE_NAME = 'loans'


class AmountLimitContract(Contract):
    amount = serializers.DecimalField(max_digits=7, decimal_places=0)
    credit_score = serializers.DecimalField(max_digits=3, decimal_places=2)


class ProductContract(Contract):
    created = serializers.DateTimeField()
    updated = serializers.DateTimeField()
    is_active = serializers.BooleanField()
    free_period = serializers.IntegerField(min_value=0)
    interests = serializers.DecimalField(max_digits=3, decimal_places=2)


class OrdersContract(Contract):
    NEW = 'NEW'
    LOAN_CREATED = 'LOAN_CREATED'
    CANCELED = "CANCELED"
    EXPIRED = 'EXPIRED'
    STATUS_CHOICES = (
        (NEW, gettext_lazy('New order')),
        (LOAN_CREATED, gettext_lazy('Loan created')),
        (CANCELED, gettext_lazy('Order canceled')),
        (EXPIRED, gettext_lazy('Order expired')),
    )

    id = serializers.IntegerField(min_value=1)
    created = serializers.DateTimeField()
    updated = serializers.DateTimeField()
    user_id = serializers.IntegerField(min_value=1)
    amount_requested = serializers.DecimalField(max_digits=7,
                                                decimal_places=0,
                                                min_value=1000,
                                                max_value=15000,
                                                )
    amount_approved = serializers.DecimalField(max_digits=7,
                                               decimal_places=0,
                                               allow_null=True,
                                               )
    period_requested = serializers.IntegerField(min_value=3, max_value=30)
    period_approved = serializers.IntegerField(allow_null=True)
    product = ProductContract()
    amount_limit = AmountLimitContract()
    bank_card_id = serializers.IntegerField(min_value=1)
    status = serializers.ChoiceField(choices=STATUS_CHOICES)
    promocode_code = serializers.CharField(max_length=16, allow_blank=True)
    contract_demo = serializers.CharField(max_length=256, allow_blank=True)


class OrderAPI(API):
    _contract = OrdersContract
    _service_name = SERVICE_NAME
    _app = 'orders'
    _point = 'order'
