/**
 * The MIT License (MIT)
 *
 * Copyright (c) 2018-2019 Erik Moqvist
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

/**
 * This file was generated by asn1tools version 0.154.0 Mon Jan 11 17:43:48 2021.
 */

#include <stdint.h>
#include <stdbool.h>
#include <stddef.h>
#include <string.h>
#include <stdio.h>

#include "oer.h"

static void assert_first_encode(ssize_t res)
{
    if (res < 0) {
        printf("First encode failed with %ld.\n", res);
        __builtin_trap();
    }
}

static void assert_second_decode(ssize_t res)
{
    if (res < 0) {
        printf("Second decode failed with %ld.\n", res);
        __builtin_trap();
    }
}

static void assert_second_decode_data(const void *decoded_p,
                                      const void *decoded2_p,
                                      size_t size)
{
    if (memcmp(decoded_p, decoded2_p, size) != 0) {
        printf("Second decode data does not match first decoded data.\n");
        __builtin_trap();
    }
}

static void assert_second_encode(ssize_t res, ssize_t res2)
{
    if (res != res2) {
        printf("Second encode result %ld does not match first pack "
               "result %ld.\n",
               res,
               res2);
        __builtin_trap();
    }
}

static void assert_second_encode_data(const uint8_t *encoded_p,
                                      const uint8_t *encoded2_p,
                                      ssize_t size)
{
    ssize_t i;

    if (memcmp(encoded_p, encoded2_p, size) != 0) {
        for (i = 0; i < size; i++) {
            printf("[%04ld]: 0x%02x 0x%02x\n", i, encoded_p[i], encoded2_p[i]);
        }

        __builtin_trap();
    }
}


static void test_oer_c_ref_referenced_enum(
    const uint8_t *encoded_p,
    size_t size)
{
    ssize_t res;
    ssize_t res2;
    ssize_t i;
    uint8_t encoded[size];
    uint8_t encoded2[size];
    struct oer_c_ref_referenced_enum_t decoded;
    struct oer_c_ref_referenced_enum_t decoded2;

    memset(&decoded, 0, sizeof(decoded));

    res = oer_c_ref_referenced_enum_decode(
        &decoded,
        encoded_p,
        size);

    if (res >= 0) {
        res = oer_c_ref_referenced_enum_encode(
            &encoded[0],
            sizeof(encoded),
            &decoded);

        assert_first_encode(res);

        memset(&decoded2, 0, sizeof(decoded2));

        res2 = oer_c_ref_referenced_enum_decode(
            &decoded2,
            &encoded[0],
            res);

        assert_second_decode(res2);
        assert_second_decode_data(&decoded,
                                  &decoded2,
                                  sizeof(decoded));

        res2 = oer_c_ref_referenced_enum_encode(
            &encoded2[0],
            sizeof(encoded2),
            &decoded);

        assert_second_encode(res, res2);
        assert_second_encode_data(&encoded[0], &encoded2[0], res);
    }
}

static void test_oer_c_ref_referenced_int(
    const uint8_t *encoded_p,
    size_t size)
{
    ssize_t res;
    ssize_t res2;
    ssize_t i;
    uint8_t encoded[size];
    uint8_t encoded2[size];
    struct oer_c_ref_referenced_int_t decoded;
    struct oer_c_ref_referenced_int_t decoded2;

    memset(&decoded, 0, sizeof(decoded));

    res = oer_c_ref_referenced_int_decode(
        &decoded,
        encoded_p,
        size);

    if (res >= 0) {
        res = oer_c_ref_referenced_int_encode(
            &encoded[0],
            sizeof(encoded),
            &decoded);

        assert_first_encode(res);

        memset(&decoded2, 0, sizeof(decoded2));

        res2 = oer_c_ref_referenced_int_decode(
            &decoded2,
            &encoded[0],
            res);

        assert_second_decode(res2);
        assert_second_decode_data(&decoded,
                                  &decoded2,
                                  sizeof(decoded));

        res2 = oer_c_ref_referenced_int_encode(
            &encoded2[0],
            sizeof(encoded2),
            &decoded);

        assert_second_encode(res, res2);
        assert_second_encode_data(&encoded[0], &encoded2[0], res);
    }
}

static void test_oer_c_ref_referenced_sequence(
    const uint8_t *encoded_p,
    size_t size)
{
    ssize_t res;
    ssize_t res2;
    ssize_t i;
    uint8_t encoded[size];
    uint8_t encoded2[size];
    struct oer_c_ref_referenced_sequence_t decoded;
    struct oer_c_ref_referenced_sequence_t decoded2;

    memset(&decoded, 0, sizeof(decoded));

    res = oer_c_ref_referenced_sequence_decode(
        &decoded,
        encoded_p,
        size);

    if (res >= 0) {
        res = oer_c_ref_referenced_sequence_encode(
            &encoded[0],
            sizeof(encoded),
            &decoded);

        assert_first_encode(res);

        memset(&decoded2, 0, sizeof(decoded2));

        res2 = oer_c_ref_referenced_sequence_decode(
            &decoded2,
            &encoded[0],
            res);

        assert_second_decode(res2);
        assert_second_decode_data(&decoded,
                                  &decoded2,
                                  sizeof(decoded));

        res2 = oer_c_ref_referenced_sequence_encode(
            &encoded2[0],
            sizeof(encoded2),
            &decoded);

        assert_second_encode(res, res2);
        assert_second_encode_data(&encoded[0], &encoded2[0], res);
    }
}

static void test_oer_c_source_a(
    const uint8_t *encoded_p,
    size_t size)
{
    ssize_t res;
    ssize_t res2;
    ssize_t i;
    uint8_t encoded[size];
    uint8_t encoded2[size];
    struct oer_c_source_a_t decoded;
    struct oer_c_source_a_t decoded2;

    memset(&decoded, 0, sizeof(decoded));

    res = oer_c_source_a_decode(
        &decoded,
        encoded_p,
        size);

    if (res >= 0) {
        res = oer_c_source_a_encode(
            &encoded[0],
            sizeof(encoded),
            &decoded);

        assert_first_encode(res);

        memset(&decoded2, 0, sizeof(decoded2));

        res2 = oer_c_source_a_decode(
            &decoded2,
            &encoded[0],
            res);

        assert_second_decode(res2);
        assert_second_decode_data(&decoded,
                                  &decoded2,
                                  sizeof(decoded));

        res2 = oer_c_source_a_encode(
            &encoded2[0],
            sizeof(encoded2),
            &decoded);

        assert_second_encode(res, res2);
        assert_second_encode_data(&encoded[0], &encoded2[0], res);
    }
}

static void test_oer_c_source_ab(
    const uint8_t *encoded_p,
    size_t size)
{
    ssize_t res;
    ssize_t res2;
    ssize_t i;
    uint8_t encoded[size];
    uint8_t encoded2[size];
    struct oer_c_source_ab_t decoded;
    struct oer_c_source_ab_t decoded2;

    memset(&decoded, 0, sizeof(decoded));

    res = oer_c_source_ab_decode(
        &decoded,
        encoded_p,
        size);

    if (res >= 0) {
        res = oer_c_source_ab_encode(
            &encoded[0],
            sizeof(encoded),
            &decoded);

        assert_first_encode(res);

        memset(&decoded2, 0, sizeof(decoded2));

        res2 = oer_c_source_ab_decode(
            &decoded2,
            &encoded[0],
            res);

        assert_second_decode(res2);
        assert_second_decode_data(&decoded,
                                  &decoded2,
                                  sizeof(decoded));

        res2 = oer_c_source_ab_encode(
            &encoded2[0],
            sizeof(encoded2),
            &decoded);

        assert_second_encode(res, res2);
        assert_second_encode_data(&encoded[0], &encoded2[0], res);
    }
}

static void test_oer_c_source_ac(
    const uint8_t *encoded_p,
    size_t size)
{
    ssize_t res;
    ssize_t res2;
    ssize_t i;
    uint8_t encoded[size];
    uint8_t encoded2[size];
    struct oer_c_source_ac_t decoded;
    struct oer_c_source_ac_t decoded2;

    memset(&decoded, 0, sizeof(decoded));

    res = oer_c_source_ac_decode(
        &decoded,
        encoded_p,
        size);

    if (res >= 0) {
        res = oer_c_source_ac_encode(
            &encoded[0],
            sizeof(encoded),
            &decoded);

        assert_first_encode(res);

        memset(&decoded2, 0, sizeof(decoded2));

        res2 = oer_c_source_ac_decode(
            &decoded2,
            &encoded[0],
            res);

        assert_second_decode(res2);
        assert_second_decode_data(&decoded,
                                  &decoded2,
                                  sizeof(decoded));

        res2 = oer_c_source_ac_encode(
            &encoded2[0],
            sizeof(encoded2),
            &decoded);

        assert_second_encode(res, res2);
        assert_second_encode_data(&encoded[0], &encoded2[0], res);
    }
}

static void test_oer_c_source_ad(
    const uint8_t *encoded_p,
    size_t size)
{
    ssize_t res;
    ssize_t res2;
    ssize_t i;
    uint8_t encoded[size];
    uint8_t encoded2[size];
    struct oer_c_source_ad_t decoded;
    struct oer_c_source_ad_t decoded2;

    memset(&decoded, 0, sizeof(decoded));

    res = oer_c_source_ad_decode(
        &decoded,
        encoded_p,
        size);

    if (res >= 0) {
        res = oer_c_source_ad_encode(
            &encoded[0],
            sizeof(encoded),
            &decoded);

        assert_first_encode(res);

        memset(&decoded2, 0, sizeof(decoded2));

        res2 = oer_c_source_ad_decode(
            &decoded2,
            &encoded[0],
            res);

        assert_second_decode(res2);
        assert_second_decode_data(&decoded,
                                  &decoded2,
                                  sizeof(decoded));

        res2 = oer_c_source_ad_encode(
            &encoded2[0],
            sizeof(encoded2),
            &decoded);

        assert_second_encode(res, res2);
        assert_second_encode_data(&encoded[0], &encoded2[0], res);
    }
}

static void test_oer_c_source_ae(
    const uint8_t *encoded_p,
    size_t size)
{
    ssize_t res;
    ssize_t res2;
    ssize_t i;
    uint8_t encoded[size];
    uint8_t encoded2[size];
    struct oer_c_source_ae_t decoded;
    struct oer_c_source_ae_t decoded2;

    memset(&decoded, 0, sizeof(decoded));

    res = oer_c_source_ae_decode(
        &decoded,
        encoded_p,
        size);

    if (res >= 0) {
        res = oer_c_source_ae_encode(
            &encoded[0],
            sizeof(encoded),
            &decoded);

        assert_first_encode(res);

        memset(&decoded2, 0, sizeof(decoded2));

        res2 = oer_c_source_ae_decode(
            &decoded2,
            &encoded[0],
            res);

        assert_second_decode(res2);
        assert_second_decode_data(&decoded,
                                  &decoded2,
                                  sizeof(decoded));

        res2 = oer_c_source_ae_encode(
            &encoded2[0],
            sizeof(encoded2),
            &decoded);

        assert_second_encode(res, res2);
        assert_second_encode_data(&encoded[0], &encoded2[0], res);
    }
}

static void test_oer_c_source_af(
    const uint8_t *encoded_p,
    size_t size)
{
    ssize_t res;
    ssize_t res2;
    ssize_t i;
    uint8_t encoded[size];
    uint8_t encoded2[size];
    struct oer_c_source_af_t decoded;
    struct oer_c_source_af_t decoded2;

    memset(&decoded, 0, sizeof(decoded));

    res = oer_c_source_af_decode(
        &decoded,
        encoded_p,
        size);

    if (res >= 0) {
        res = oer_c_source_af_encode(
            &encoded[0],
            sizeof(encoded),
            &decoded);

        assert_first_encode(res);

        memset(&decoded2, 0, sizeof(decoded2));

        res2 = oer_c_source_af_decode(
            &decoded2,
            &encoded[0],
            res);

        assert_second_decode(res2);
        assert_second_decode_data(&decoded,
                                  &decoded2,
                                  sizeof(decoded));

        res2 = oer_c_source_af_encode(
            &encoded2[0],
            sizeof(encoded2),
            &decoded);

        assert_second_encode(res, res2);
        assert_second_encode_data(&encoded[0], &encoded2[0], res);
    }
}

static void test_oer_c_source_ag(
    const uint8_t *encoded_p,
    size_t size)
{
    ssize_t res;
    ssize_t res2;
    ssize_t i;
    uint8_t encoded[size];
    uint8_t encoded2[size];
    struct oer_c_source_ag_t decoded;
    struct oer_c_source_ag_t decoded2;

    memset(&decoded, 0, sizeof(decoded));

    res = oer_c_source_ag_decode(
        &decoded,
        encoded_p,
        size);

    if (res >= 0) {
        res = oer_c_source_ag_encode(
            &encoded[0],
            sizeof(encoded),
            &decoded);

        assert_first_encode(res);

        memset(&decoded2, 0, sizeof(decoded2));

        res2 = oer_c_source_ag_decode(
            &decoded2,
            &encoded[0],
            res);

        assert_second_decode(res2);
        assert_second_decode_data(&decoded,
                                  &decoded2,
                                  sizeof(decoded));

        res2 = oer_c_source_ag_encode(
            &encoded2[0],
            sizeof(encoded2),
            &decoded);

        assert_second_encode(res, res2);
        assert_second_encode_data(&encoded[0], &encoded2[0], res);
    }
}

static void test_oer_c_source_ah(
    const uint8_t *encoded_p,
    size_t size)
{
    ssize_t res;
    ssize_t res2;
    ssize_t i;
    uint8_t encoded[size];
    uint8_t encoded2[size];
    struct oer_c_source_ah_t decoded;
    struct oer_c_source_ah_t decoded2;

    memset(&decoded, 0, sizeof(decoded));

    res = oer_c_source_ah_decode(
        &decoded,
        encoded_p,
        size);

    if (res >= 0) {
        res = oer_c_source_ah_encode(
            &encoded[0],
            sizeof(encoded),
            &decoded);

        assert_first_encode(res);

        memset(&decoded2, 0, sizeof(decoded2));

        res2 = oer_c_source_ah_decode(
            &decoded2,
            &encoded[0],
            res);

        assert_second_decode(res2);
        assert_second_decode_data(&decoded,
                                  &decoded2,
                                  sizeof(decoded));

        res2 = oer_c_source_ah_encode(
            &encoded2[0],
            sizeof(encoded2),
            &decoded);

        assert_second_encode(res, res2);
        assert_second_encode_data(&encoded[0], &encoded2[0], res);
    }
}

static void test_oer_c_source_ai(
    const uint8_t *encoded_p,
    size_t size)
{
    ssize_t res;
    ssize_t res2;
    ssize_t i;
    uint8_t encoded[size];
    uint8_t encoded2[size];
    struct oer_c_source_ai_t decoded;
    struct oer_c_source_ai_t decoded2;

    memset(&decoded, 0, sizeof(decoded));

    res = oer_c_source_ai_decode(
        &decoded,
        encoded_p,
        size);

    if (res >= 0) {
        res = oer_c_source_ai_encode(
            &encoded[0],
            sizeof(encoded),
            &decoded);

        assert_first_encode(res);

        memset(&decoded2, 0, sizeof(decoded2));

        res2 = oer_c_source_ai_decode(
            &decoded2,
            &encoded[0],
            res);

        assert_second_decode(res2);
        assert_second_decode_data(&decoded,
                                  &decoded2,
                                  sizeof(decoded));

        res2 = oer_c_source_ai_encode(
            &encoded2[0],
            sizeof(encoded2),
            &decoded);

        assert_second_encode(res, res2);
        assert_second_encode_data(&encoded[0], &encoded2[0], res);
    }
}

static void test_oer_c_source_aj(
    const uint8_t *encoded_p,
    size_t size)
{
    ssize_t res;
    ssize_t res2;
    ssize_t i;
    uint8_t encoded[size];
    uint8_t encoded2[size];
    struct oer_c_source_aj_t decoded;
    struct oer_c_source_aj_t decoded2;

    memset(&decoded, 0, sizeof(decoded));

    res = oer_c_source_aj_decode(
        &decoded,
        encoded_p,
        size);

    if (res >= 0) {
        res = oer_c_source_aj_encode(
            &encoded[0],
            sizeof(encoded),
            &decoded);

        assert_first_encode(res);

        memset(&decoded2, 0, sizeof(decoded2));

        res2 = oer_c_source_aj_decode(
            &decoded2,
            &encoded[0],
            res);

        assert_second_decode(res2);
        assert_second_decode_data(&decoded,
                                  &decoded2,
                                  sizeof(decoded));

        res2 = oer_c_source_aj_encode(
            &encoded2[0],
            sizeof(encoded2),
            &decoded);

        assert_second_encode(res, res2);
        assert_second_encode_data(&encoded[0], &encoded2[0], res);
    }
}

static void test_oer_c_source_ak(
    const uint8_t *encoded_p,
    size_t size)
{
    ssize_t res;
    ssize_t res2;
    ssize_t i;
    uint8_t encoded[size];
    uint8_t encoded2[size];
    struct oer_c_source_ak_t decoded;
    struct oer_c_source_ak_t decoded2;

    memset(&decoded, 0, sizeof(decoded));

    res = oer_c_source_ak_decode(
        &decoded,
        encoded_p,
        size);

    if (res >= 0) {
        res = oer_c_source_ak_encode(
            &encoded[0],
            sizeof(encoded),
            &decoded);

        assert_first_encode(res);

        memset(&decoded2, 0, sizeof(decoded2));

        res2 = oer_c_source_ak_decode(
            &decoded2,
            &encoded[0],
            res);

        assert_second_decode(res2);
        assert_second_decode_data(&decoded,
                                  &decoded2,
                                  sizeof(decoded));

        res2 = oer_c_source_ak_encode(
            &encoded2[0],
            sizeof(encoded2),
            &decoded);

        assert_second_encode(res, res2);
        assert_second_encode_data(&encoded[0], &encoded2[0], res);
    }
}

static void test_oer_c_source_al(
    const uint8_t *encoded_p,
    size_t size)
{
    ssize_t res;
    ssize_t res2;
    ssize_t i;
    uint8_t encoded[size];
    uint8_t encoded2[size];
    struct oer_c_source_al_t decoded;
    struct oer_c_source_al_t decoded2;

    memset(&decoded, 0, sizeof(decoded));

    res = oer_c_source_al_decode(
        &decoded,
        encoded_p,
        size);

    if (res >= 0) {
        res = oer_c_source_al_encode(
            &encoded[0],
            sizeof(encoded),
            &decoded);

        assert_first_encode(res);

        memset(&decoded2, 0, sizeof(decoded2));

        res2 = oer_c_source_al_decode(
            &decoded2,
            &encoded[0],
            res);

        assert_second_decode(res2);
        assert_second_decode_data(&decoded,
                                  &decoded2,
                                  sizeof(decoded));

        res2 = oer_c_source_al_encode(
            &encoded2[0],
            sizeof(encoded2),
            &decoded);

        assert_second_encode(res, res2);
        assert_second_encode_data(&encoded[0], &encoded2[0], res);
    }
}

static void test_oer_c_source_am(
    const uint8_t *encoded_p,
    size_t size)
{
    ssize_t res;
    ssize_t res2;
    ssize_t i;
    uint8_t encoded[size];
    uint8_t encoded2[size];
    struct oer_c_source_am_t decoded;
    struct oer_c_source_am_t decoded2;

    memset(&decoded, 0, sizeof(decoded));

    res = oer_c_source_am_decode(
        &decoded,
        encoded_p,
        size);

    if (res >= 0) {
        res = oer_c_source_am_encode(
            &encoded[0],
            sizeof(encoded),
            &decoded);

        assert_first_encode(res);

        memset(&decoded2, 0, sizeof(decoded2));

        res2 = oer_c_source_am_decode(
            &decoded2,
            &encoded[0],
            res);

        assert_second_decode(res2);
        assert_second_decode_data(&decoded,
                                  &decoded2,
                                  sizeof(decoded));

        res2 = oer_c_source_am_encode(
            &encoded2[0],
            sizeof(encoded2),
            &decoded);

        assert_second_encode(res, res2);
        assert_second_encode_data(&encoded[0], &encoded2[0], res);
    }
}

static void test_oer_c_source_an(
    const uint8_t *encoded_p,
    size_t size)
{
    ssize_t res;
    ssize_t res2;
    ssize_t i;
    uint8_t encoded[size];
    uint8_t encoded2[size];
    struct oer_c_source_an_t decoded;
    struct oer_c_source_an_t decoded2;

    memset(&decoded, 0, sizeof(decoded));

    res = oer_c_source_an_decode(
        &decoded,
        encoded_p,
        size);

    if (res >= 0) {
        res = oer_c_source_an_encode(
            &encoded[0],
            sizeof(encoded),
            &decoded);

        assert_first_encode(res);

        memset(&decoded2, 0, sizeof(decoded2));

        res2 = oer_c_source_an_decode(
            &decoded2,
            &encoded[0],
            res);

        assert_second_decode(res2);
        assert_second_decode_data(&decoded,
                                  &decoded2,
                                  sizeof(decoded));

        res2 = oer_c_source_an_encode(
            &encoded2[0],
            sizeof(encoded2),
            &decoded);

        assert_second_encode(res, res2);
        assert_second_encode_data(&encoded[0], &encoded2[0], res);
    }
}

static void test_oer_c_source_ao(
    const uint8_t *encoded_p,
    size_t size)
{
    ssize_t res;
    ssize_t res2;
    ssize_t i;
    uint8_t encoded[size];
    uint8_t encoded2[size];
    struct oer_c_source_ao_t decoded;
    struct oer_c_source_ao_t decoded2;

    memset(&decoded, 0, sizeof(decoded));

    res = oer_c_source_ao_decode(
        &decoded,
        encoded_p,
        size);

    if (res >= 0) {
        res = oer_c_source_ao_encode(
            &encoded[0],
            sizeof(encoded),
            &decoded);

        assert_first_encode(res);

        memset(&decoded2, 0, sizeof(decoded2));

        res2 = oer_c_source_ao_decode(
            &decoded2,
            &encoded[0],
            res);

        assert_second_decode(res2);
        assert_second_decode_data(&decoded,
                                  &decoded2,
                                  sizeof(decoded));

        res2 = oer_c_source_ao_encode(
            &encoded2[0],
            sizeof(encoded2),
            &decoded);

        assert_second_encode(res, res2);
        assert_second_encode_data(&encoded[0], &encoded2[0], res);
    }
}

static void test_oer_c_source_ap(
    const uint8_t *encoded_p,
    size_t size)
{
    ssize_t res;
    ssize_t res2;
    ssize_t i;
    uint8_t encoded[size];
    uint8_t encoded2[size];
    struct oer_c_source_ap_t decoded;
    struct oer_c_source_ap_t decoded2;

    memset(&decoded, 0, sizeof(decoded));

    res = oer_c_source_ap_decode(
        &decoded,
        encoded_p,
        size);

    if (res >= 0) {
        res = oer_c_source_ap_encode(
            &encoded[0],
            sizeof(encoded),
            &decoded);

        assert_first_encode(res);

        memset(&decoded2, 0, sizeof(decoded2));

        res2 = oer_c_source_ap_decode(
            &decoded2,
            &encoded[0],
            res);

        assert_second_decode(res2);
        assert_second_decode_data(&decoded,
                                  &decoded2,
                                  sizeof(decoded));

        res2 = oer_c_source_ap_encode(
            &encoded2[0],
            sizeof(encoded2),
            &decoded);

        assert_second_encode(res, res2);
        assert_second_encode_data(&encoded[0], &encoded2[0], res);
    }
}

static void test_oer_c_source_aq(
    const uint8_t *encoded_p,
    size_t size)
{
    ssize_t res;
    ssize_t res2;
    ssize_t i;
    uint8_t encoded[size];
    uint8_t encoded2[size];
    struct oer_c_source_aq_t decoded;
    struct oer_c_source_aq_t decoded2;

    memset(&decoded, 0, sizeof(decoded));

    res = oer_c_source_aq_decode(
        &decoded,
        encoded_p,
        size);

    if (res >= 0) {
        res = oer_c_source_aq_encode(
            &encoded[0],
            sizeof(encoded),
            &decoded);

        assert_first_encode(res);

        memset(&decoded2, 0, sizeof(decoded2));

        res2 = oer_c_source_aq_decode(
            &decoded2,
            &encoded[0],
            res);

        assert_second_decode(res2);
        assert_second_decode_data(&decoded,
                                  &decoded2,
                                  sizeof(decoded));

        res2 = oer_c_source_aq_encode(
            &encoded2[0],
            sizeof(encoded2),
            &decoded);

        assert_second_encode(res, res2);
        assert_second_encode_data(&encoded[0], &encoded2[0], res);
    }
}

static void test_oer_c_source_b(
    const uint8_t *encoded_p,
    size_t size)
{
    ssize_t res;
    ssize_t res2;
    ssize_t i;
    uint8_t encoded[size];
    uint8_t encoded2[size];
    struct oer_c_source_b_t decoded;
    struct oer_c_source_b_t decoded2;

    memset(&decoded, 0, sizeof(decoded));

    res = oer_c_source_b_decode(
        &decoded,
        encoded_p,
        size);

    if (res >= 0) {
        res = oer_c_source_b_encode(
            &encoded[0],
            sizeof(encoded),
            &decoded);

        assert_first_encode(res);

        memset(&decoded2, 0, sizeof(decoded2));

        res2 = oer_c_source_b_decode(
            &decoded2,
            &encoded[0],
            res);

        assert_second_decode(res2);
        assert_second_decode_data(&decoded,
                                  &decoded2,
                                  sizeof(decoded));

        res2 = oer_c_source_b_encode(
            &encoded2[0],
            sizeof(encoded2),
            &decoded);

        assert_second_encode(res, res2);
        assert_second_encode_data(&encoded[0], &encoded2[0], res);
    }
}

static void test_oer_c_source_c(
    const uint8_t *encoded_p,
    size_t size)
{
    ssize_t res;
    ssize_t res2;
    ssize_t i;
    uint8_t encoded[size];
    uint8_t encoded2[size];
    struct oer_c_source_c_t decoded;
    struct oer_c_source_c_t decoded2;

    memset(&decoded, 0, sizeof(decoded));

    res = oer_c_source_c_decode(
        &decoded,
        encoded_p,
        size);

    if (res >= 0) {
        res = oer_c_source_c_encode(
            &encoded[0],
            sizeof(encoded),
            &decoded);

        assert_first_encode(res);

        memset(&decoded2, 0, sizeof(decoded2));

        res2 = oer_c_source_c_decode(
            &decoded2,
            &encoded[0],
            res);

        assert_second_decode(res2);
        assert_second_decode_data(&decoded,
                                  &decoded2,
                                  sizeof(decoded));

        res2 = oer_c_source_c_encode(
            &encoded2[0],
            sizeof(encoded2),
            &decoded);

        assert_second_encode(res, res2);
        assert_second_encode_data(&encoded[0], &encoded2[0], res);
    }
}

static void test_oer_c_source_d(
    const uint8_t *encoded_p,
    size_t size)
{
    ssize_t res;
    ssize_t res2;
    ssize_t i;
    uint8_t encoded[size];
    uint8_t encoded2[size];
    struct oer_c_source_d_t decoded;
    struct oer_c_source_d_t decoded2;

    memset(&decoded, 0, sizeof(decoded));

    res = oer_c_source_d_decode(
        &decoded,
        encoded_p,
        size);

    if (res >= 0) {
        res = oer_c_source_d_encode(
            &encoded[0],
            sizeof(encoded),
            &decoded);

        assert_first_encode(res);

        memset(&decoded2, 0, sizeof(decoded2));

        res2 = oer_c_source_d_decode(
            &decoded2,
            &encoded[0],
            res);

        assert_second_decode(res2);
        assert_second_decode_data(&decoded,
                                  &decoded2,
                                  sizeof(decoded));

        res2 = oer_c_source_d_encode(
            &encoded2[0],
            sizeof(encoded2),
            &decoded);

        assert_second_encode(res, res2);
        assert_second_encode_data(&encoded[0], &encoded2[0], res);
    }
}

static void test_oer_c_source_e(
    const uint8_t *encoded_p,
    size_t size)
{
    ssize_t res;
    ssize_t res2;
    ssize_t i;
    uint8_t encoded[size];
    uint8_t encoded2[size];
    struct oer_c_source_e_t decoded;
    struct oer_c_source_e_t decoded2;

    memset(&decoded, 0, sizeof(decoded));

    res = oer_c_source_e_decode(
        &decoded,
        encoded_p,
        size);

    if (res >= 0) {
        res = oer_c_source_e_encode(
            &encoded[0],
            sizeof(encoded),
            &decoded);

        assert_first_encode(res);

        memset(&decoded2, 0, sizeof(decoded2));

        res2 = oer_c_source_e_decode(
            &decoded2,
            &encoded[0],
            res);

        assert_second_decode(res2);
        assert_second_decode_data(&decoded,
                                  &decoded2,
                                  sizeof(decoded));

        res2 = oer_c_source_e_encode(
            &encoded2[0],
            sizeof(encoded2),
            &decoded);

        assert_second_encode(res, res2);
        assert_second_encode_data(&encoded[0], &encoded2[0], res);
    }
}

static void test_oer_c_source_f(
    const uint8_t *encoded_p,
    size_t size)
{
    ssize_t res;
    ssize_t res2;
    ssize_t i;
    uint8_t encoded[size];
    uint8_t encoded2[size];
    struct oer_c_source_f_t decoded;
    struct oer_c_source_f_t decoded2;

    memset(&decoded, 0, sizeof(decoded));

    res = oer_c_source_f_decode(
        &decoded,
        encoded_p,
        size);

    if (res >= 0) {
        res = oer_c_source_f_encode(
            &encoded[0],
            sizeof(encoded),
            &decoded);

        assert_first_encode(res);

        memset(&decoded2, 0, sizeof(decoded2));

        res2 = oer_c_source_f_decode(
            &decoded2,
            &encoded[0],
            res);

        assert_second_decode(res2);
        assert_second_decode_data(&decoded,
                                  &decoded2,
                                  sizeof(decoded));

        res2 = oer_c_source_f_encode(
            &encoded2[0],
            sizeof(encoded2),
            &decoded);

        assert_second_encode(res, res2);
        assert_second_encode_data(&encoded[0], &encoded2[0], res);
    }
}

static void test_oer_c_source_g(
    const uint8_t *encoded_p,
    size_t size)
{
    ssize_t res;
    ssize_t res2;
    ssize_t i;
    uint8_t encoded[size];
    uint8_t encoded2[size];
    struct oer_c_source_g_t decoded;
    struct oer_c_source_g_t decoded2;

    memset(&decoded, 0, sizeof(decoded));

    res = oer_c_source_g_decode(
        &decoded,
        encoded_p,
        size);

    if (res >= 0) {
        res = oer_c_source_g_encode(
            &encoded[0],
            sizeof(encoded),
            &decoded);

        assert_first_encode(res);

        memset(&decoded2, 0, sizeof(decoded2));

        res2 = oer_c_source_g_decode(
            &decoded2,
            &encoded[0],
            res);

        assert_second_decode(res2);
        assert_second_decode_data(&decoded,
                                  &decoded2,
                                  sizeof(decoded));

        res2 = oer_c_source_g_encode(
            &encoded2[0],
            sizeof(encoded2),
            &decoded);

        assert_second_encode(res, res2);
        assert_second_encode_data(&encoded[0], &encoded2[0], res);
    }
}

static void test_oer_c_source_h(
    const uint8_t *encoded_p,
    size_t size)
{
    ssize_t res;
    ssize_t res2;
    ssize_t i;
    uint8_t encoded[size];
    uint8_t encoded2[size];
    struct oer_c_source_h_t decoded;
    struct oer_c_source_h_t decoded2;

    memset(&decoded, 0, sizeof(decoded));

    res = oer_c_source_h_decode(
        &decoded,
        encoded_p,
        size);

    if (res >= 0) {
        res = oer_c_source_h_encode(
            &encoded[0],
            sizeof(encoded),
            &decoded);

        assert_first_encode(res);

        memset(&decoded2, 0, sizeof(decoded2));

        res2 = oer_c_source_h_decode(
            &decoded2,
            &encoded[0],
            res);

        assert_second_decode(res2);
        assert_second_decode_data(&decoded,
                                  &decoded2,
                                  sizeof(decoded));

        res2 = oer_c_source_h_encode(
            &encoded2[0],
            sizeof(encoded2),
            &decoded);

        assert_second_encode(res, res2);
        assert_second_encode_data(&encoded[0], &encoded2[0], res);
    }
}

static void test_oer_c_source_i(
    const uint8_t *encoded_p,
    size_t size)
{
    ssize_t res;
    ssize_t res2;
    ssize_t i;
    uint8_t encoded[size];
    uint8_t encoded2[size];
    struct oer_c_source_i_t decoded;
    struct oer_c_source_i_t decoded2;

    memset(&decoded, 0, sizeof(decoded));

    res = oer_c_source_i_decode(
        &decoded,
        encoded_p,
        size);

    if (res >= 0) {
        res = oer_c_source_i_encode(
            &encoded[0],
            sizeof(encoded),
            &decoded);

        assert_first_encode(res);

        memset(&decoded2, 0, sizeof(decoded2));

        res2 = oer_c_source_i_decode(
            &decoded2,
            &encoded[0],
            res);

        assert_second_decode(res2);
        assert_second_decode_data(&decoded,
                                  &decoded2,
                                  sizeof(decoded));

        res2 = oer_c_source_i_encode(
            &encoded2[0],
            sizeof(encoded2),
            &decoded);

        assert_second_encode(res, res2);
        assert_second_encode_data(&encoded[0], &encoded2[0], res);
    }
}

static void test_oer_c_source_j(
    const uint8_t *encoded_p,
    size_t size)
{
    ssize_t res;
    ssize_t res2;
    ssize_t i;
    uint8_t encoded[size];
    uint8_t encoded2[size];
    struct oer_c_source_j_t decoded;
    struct oer_c_source_j_t decoded2;

    memset(&decoded, 0, sizeof(decoded));

    res = oer_c_source_j_decode(
        &decoded,
        encoded_p,
        size);

    if (res >= 0) {
        res = oer_c_source_j_encode(
            &encoded[0],
            sizeof(encoded),
            &decoded);

        assert_first_encode(res);

        memset(&decoded2, 0, sizeof(decoded2));

        res2 = oer_c_source_j_decode(
            &decoded2,
            &encoded[0],
            res);

        assert_second_decode(res2);
        assert_second_decode_data(&decoded,
                                  &decoded2,
                                  sizeof(decoded));

        res2 = oer_c_source_j_encode(
            &encoded2[0],
            sizeof(encoded2),
            &decoded);

        assert_second_encode(res, res2);
        assert_second_encode_data(&encoded[0], &encoded2[0], res);
    }
}

static void test_oer_c_source_k(
    const uint8_t *encoded_p,
    size_t size)
{
    ssize_t res;
    ssize_t res2;
    ssize_t i;
    uint8_t encoded[size];
    uint8_t encoded2[size];
    struct oer_c_source_k_t decoded;
    struct oer_c_source_k_t decoded2;

    memset(&decoded, 0, sizeof(decoded));

    res = oer_c_source_k_decode(
        &decoded,
        encoded_p,
        size);

    if (res >= 0) {
        res = oer_c_source_k_encode(
            &encoded[0],
            sizeof(encoded),
            &decoded);

        assert_first_encode(res);

        memset(&decoded2, 0, sizeof(decoded2));

        res2 = oer_c_source_k_decode(
            &decoded2,
            &encoded[0],
            res);

        assert_second_decode(res2);
        assert_second_decode_data(&decoded,
                                  &decoded2,
                                  sizeof(decoded));

        res2 = oer_c_source_k_encode(
            &encoded2[0],
            sizeof(encoded2),
            &decoded);

        assert_second_encode(res, res2);
        assert_second_encode_data(&encoded[0], &encoded2[0], res);
    }
}

static void test_oer_c_source_l(
    const uint8_t *encoded_p,
    size_t size)
{
    ssize_t res;
    ssize_t res2;
    ssize_t i;
    uint8_t encoded[size];
    uint8_t encoded2[size];
    struct oer_c_source_l_t decoded;
    struct oer_c_source_l_t decoded2;

    memset(&decoded, 0, sizeof(decoded));

    res = oer_c_source_l_decode(
        &decoded,
        encoded_p,
        size);

    if (res >= 0) {
        res = oer_c_source_l_encode(
            &encoded[0],
            sizeof(encoded),
            &decoded);

        assert_first_encode(res);

        memset(&decoded2, 0, sizeof(decoded2));

        res2 = oer_c_source_l_decode(
            &decoded2,
            &encoded[0],
            res);

        assert_second_decode(res2);
        assert_second_decode_data(&decoded,
                                  &decoded2,
                                  sizeof(decoded));

        res2 = oer_c_source_l_encode(
            &encoded2[0],
            sizeof(encoded2),
            &decoded);

        assert_second_encode(res, res2);
        assert_second_encode_data(&encoded[0], &encoded2[0], res);
    }
}

static void test_oer_c_source_m(
    const uint8_t *encoded_p,
    size_t size)
{
    ssize_t res;
    ssize_t res2;
    ssize_t i;
    uint8_t encoded[size];
    uint8_t encoded2[size];
    struct oer_c_source_m_t decoded;
    struct oer_c_source_m_t decoded2;

    memset(&decoded, 0, sizeof(decoded));

    res = oer_c_source_m_decode(
        &decoded,
        encoded_p,
        size);

    if (res >= 0) {
        res = oer_c_source_m_encode(
            &encoded[0],
            sizeof(encoded),
            &decoded);

        assert_first_encode(res);

        memset(&decoded2, 0, sizeof(decoded2));

        res2 = oer_c_source_m_decode(
            &decoded2,
            &encoded[0],
            res);

        assert_second_decode(res2);
        assert_second_decode_data(&decoded,
                                  &decoded2,
                                  sizeof(decoded));

        res2 = oer_c_source_m_encode(
            &encoded2[0],
            sizeof(encoded2),
            &decoded);

        assert_second_encode(res, res2);
        assert_second_encode_data(&encoded[0], &encoded2[0], res);
    }
}

static void test_oer_c_source_n(
    const uint8_t *encoded_p,
    size_t size)
{
    ssize_t res;
    ssize_t res2;
    ssize_t i;
    uint8_t encoded[size];
    uint8_t encoded2[size];
    struct oer_c_source_n_t decoded;
    struct oer_c_source_n_t decoded2;

    memset(&decoded, 0, sizeof(decoded));

    res = oer_c_source_n_decode(
        &decoded,
        encoded_p,
        size);

    if (res >= 0) {
        res = oer_c_source_n_encode(
            &encoded[0],
            sizeof(encoded),
            &decoded);

        assert_first_encode(res);

        memset(&decoded2, 0, sizeof(decoded2));

        res2 = oer_c_source_n_decode(
            &decoded2,
            &encoded[0],
            res);

        assert_second_decode(res2);
        assert_second_decode_data(&decoded,
                                  &decoded2,
                                  sizeof(decoded));

        res2 = oer_c_source_n_encode(
            &encoded2[0],
            sizeof(encoded2),
            &decoded);

        assert_second_encode(res, res2);
        assert_second_encode_data(&encoded[0], &encoded2[0], res);
    }
}

static void test_oer_c_source_o(
    const uint8_t *encoded_p,
    size_t size)
{
    ssize_t res;
    ssize_t res2;
    ssize_t i;
    uint8_t encoded[size];
    uint8_t encoded2[size];
    struct oer_c_source_o_t decoded;
    struct oer_c_source_o_t decoded2;

    memset(&decoded, 0, sizeof(decoded));

    res = oer_c_source_o_decode(
        &decoded,
        encoded_p,
        size);

    if (res >= 0) {
        res = oer_c_source_o_encode(
            &encoded[0],
            sizeof(encoded),
            &decoded);

        assert_first_encode(res);

        memset(&decoded2, 0, sizeof(decoded2));

        res2 = oer_c_source_o_decode(
            &decoded2,
            &encoded[0],
            res);

        assert_second_decode(res2);
        assert_second_decode_data(&decoded,
                                  &decoded2,
                                  sizeof(decoded));

        res2 = oer_c_source_o_encode(
            &encoded2[0],
            sizeof(encoded2),
            &decoded);

        assert_second_encode(res, res2);
        assert_second_encode_data(&encoded[0], &encoded2[0], res);
    }
}

static void test_oer_c_source_p(
    const uint8_t *encoded_p,
    size_t size)
{
    ssize_t res;
    ssize_t res2;
    ssize_t i;
    uint8_t encoded[size];
    uint8_t encoded2[size];
    struct oer_c_source_p_t decoded;
    struct oer_c_source_p_t decoded2;

    memset(&decoded, 0, sizeof(decoded));

    res = oer_c_source_p_decode(
        &decoded,
        encoded_p,
        size);

    if (res >= 0) {
        res = oer_c_source_p_encode(
            &encoded[0],
            sizeof(encoded),
            &decoded);

        assert_first_encode(res);

        memset(&decoded2, 0, sizeof(decoded2));

        res2 = oer_c_source_p_decode(
            &decoded2,
            &encoded[0],
            res);

        assert_second_decode(res2);
        assert_second_decode_data(&decoded,
                                  &decoded2,
                                  sizeof(decoded));

        res2 = oer_c_source_p_encode(
            &encoded2[0],
            sizeof(encoded2),
            &decoded);

        assert_second_encode(res, res2);
        assert_second_encode_data(&encoded[0], &encoded2[0], res);
    }
}

static void test_oer_c_source_q(
    const uint8_t *encoded_p,
    size_t size)
{
    ssize_t res;
    ssize_t res2;
    ssize_t i;
    uint8_t encoded[size];
    uint8_t encoded2[size];
    struct oer_c_source_q_t decoded;
    struct oer_c_source_q_t decoded2;

    memset(&decoded, 0, sizeof(decoded));

    res = oer_c_source_q_decode(
        &decoded,
        encoded_p,
        size);

    if (res >= 0) {
        res = oer_c_source_q_encode(
            &encoded[0],
            sizeof(encoded),
            &decoded);

        assert_first_encode(res);

        memset(&decoded2, 0, sizeof(decoded2));

        res2 = oer_c_source_q_decode(
            &decoded2,
            &encoded[0],
            res);

        assert_second_decode(res2);
        assert_second_decode_data(&decoded,
                                  &decoded2,
                                  sizeof(decoded));

        res2 = oer_c_source_q_encode(
            &encoded2[0],
            sizeof(encoded2),
            &decoded);

        assert_second_encode(res, res2);
        assert_second_encode_data(&encoded[0], &encoded2[0], res);
    }
}

static void test_oer_c_source_r(
    const uint8_t *encoded_p,
    size_t size)
{
    ssize_t res;
    ssize_t res2;
    ssize_t i;
    uint8_t encoded[size];
    uint8_t encoded2[size];
    struct oer_c_source_r_t decoded;
    struct oer_c_source_r_t decoded2;

    memset(&decoded, 0, sizeof(decoded));

    res = oer_c_source_r_decode(
        &decoded,
        encoded_p,
        size);

    if (res >= 0) {
        res = oer_c_source_r_encode(
            &encoded[0],
            sizeof(encoded),
            &decoded);

        assert_first_encode(res);

        memset(&decoded2, 0, sizeof(decoded2));

        res2 = oer_c_source_r_decode(
            &decoded2,
            &encoded[0],
            res);

        assert_second_decode(res2);
        assert_second_decode_data(&decoded,
                                  &decoded2,
                                  sizeof(decoded));

        res2 = oer_c_source_r_encode(
            &encoded2[0],
            sizeof(encoded2),
            &decoded);

        assert_second_encode(res, res2);
        assert_second_encode_data(&encoded[0], &encoded2[0], res);
    }
}

static void test_oer_c_source_s(
    const uint8_t *encoded_p,
    size_t size)
{
    ssize_t res;
    ssize_t res2;
    ssize_t i;
    uint8_t encoded[size];
    uint8_t encoded2[size];
    struct oer_c_source_s_t decoded;
    struct oer_c_source_s_t decoded2;

    memset(&decoded, 0, sizeof(decoded));

    res = oer_c_source_s_decode(
        &decoded,
        encoded_p,
        size);

    if (res >= 0) {
        res = oer_c_source_s_encode(
            &encoded[0],
            sizeof(encoded),
            &decoded);

        assert_first_encode(res);

        memset(&decoded2, 0, sizeof(decoded2));

        res2 = oer_c_source_s_decode(
            &decoded2,
            &encoded[0],
            res);

        assert_second_decode(res2);
        assert_second_decode_data(&decoded,
                                  &decoded2,
                                  sizeof(decoded));

        res2 = oer_c_source_s_encode(
            &encoded2[0],
            sizeof(encoded2),
            &decoded);

        assert_second_encode(res, res2);
        assert_second_encode_data(&encoded[0], &encoded2[0], res);
    }
}

static void test_oer_c_source_t(
    const uint8_t *encoded_p,
    size_t size)
{
    ssize_t res;
    ssize_t res2;
    ssize_t i;
    uint8_t encoded[size];
    uint8_t encoded2[size];
    struct oer_c_source_t_t decoded;
    struct oer_c_source_t_t decoded2;

    memset(&decoded, 0, sizeof(decoded));

    res = oer_c_source_t_decode(
        &decoded,
        encoded_p,
        size);

    if (res >= 0) {
        res = oer_c_source_t_encode(
            &encoded[0],
            sizeof(encoded),
            &decoded);

        assert_first_encode(res);

        memset(&decoded2, 0, sizeof(decoded2));

        res2 = oer_c_source_t_decode(
            &decoded2,
            &encoded[0],
            res);

        assert_second_decode(res2);
        assert_second_decode_data(&decoded,
                                  &decoded2,
                                  sizeof(decoded));

        res2 = oer_c_source_t_encode(
            &encoded2[0],
            sizeof(encoded2),
            &decoded);

        assert_second_encode(res, res2);
        assert_second_encode_data(&encoded[0], &encoded2[0], res);
    }
}

static void test_oer_c_source_u(
    const uint8_t *encoded_p,
    size_t size)
{
    ssize_t res;
    ssize_t res2;
    ssize_t i;
    uint8_t encoded[size];
    uint8_t encoded2[size];
    struct oer_c_source_u_t decoded;
    struct oer_c_source_u_t decoded2;

    memset(&decoded, 0, sizeof(decoded));

    res = oer_c_source_u_decode(
        &decoded,
        encoded_p,
        size);

    if (res >= 0) {
        res = oer_c_source_u_encode(
            &encoded[0],
            sizeof(encoded),
            &decoded);

        assert_first_encode(res);

        memset(&decoded2, 0, sizeof(decoded2));

        res2 = oer_c_source_u_decode(
            &decoded2,
            &encoded[0],
            res);

        assert_second_decode(res2);
        assert_second_decode_data(&decoded,
                                  &decoded2,
                                  sizeof(decoded));

        res2 = oer_c_source_u_encode(
            &encoded2[0],
            sizeof(encoded2),
            &decoded);

        assert_second_encode(res, res2);
        assert_second_encode_data(&encoded[0], &encoded2[0], res);
    }
}

static void test_oer_c_source_v(
    const uint8_t *encoded_p,
    size_t size)
{
    ssize_t res;
    ssize_t res2;
    ssize_t i;
    uint8_t encoded[size];
    uint8_t encoded2[size];
    struct oer_c_source_v_t decoded;
    struct oer_c_source_v_t decoded2;

    memset(&decoded, 0, sizeof(decoded));

    res = oer_c_source_v_decode(
        &decoded,
        encoded_p,
        size);

    if (res >= 0) {
        res = oer_c_source_v_encode(
            &encoded[0],
            sizeof(encoded),
            &decoded);

        assert_first_encode(res);

        memset(&decoded2, 0, sizeof(decoded2));

        res2 = oer_c_source_v_decode(
            &decoded2,
            &encoded[0],
            res);

        assert_second_decode(res2);
        assert_second_decode_data(&decoded,
                                  &decoded2,
                                  sizeof(decoded));

        res2 = oer_c_source_v_encode(
            &encoded2[0],
            sizeof(encoded2),
            &decoded);

        assert_second_encode(res, res2);
        assert_second_encode_data(&encoded[0], &encoded2[0], res);
    }
}

static void test_oer_c_source_w(
    const uint8_t *encoded_p,
    size_t size)
{
    ssize_t res;
    ssize_t res2;
    ssize_t i;
    uint8_t encoded[size];
    uint8_t encoded2[size];
    struct oer_c_source_w_t decoded;
    struct oer_c_source_w_t decoded2;

    memset(&decoded, 0, sizeof(decoded));

    res = oer_c_source_w_decode(
        &decoded,
        encoded_p,
        size);

    if (res >= 0) {
        res = oer_c_source_w_encode(
            &encoded[0],
            sizeof(encoded),
            &decoded);

        assert_first_encode(res);

        memset(&decoded2, 0, sizeof(decoded2));

        res2 = oer_c_source_w_decode(
            &decoded2,
            &encoded[0],
            res);

        assert_second_decode(res2);
        assert_second_decode_data(&decoded,
                                  &decoded2,
                                  sizeof(decoded));

        res2 = oer_c_source_w_encode(
            &encoded2[0],
            sizeof(encoded2),
            &decoded);

        assert_second_encode(res, res2);
        assert_second_encode_data(&encoded[0], &encoded2[0], res);
    }
}

static void test_oer_c_source_x(
    const uint8_t *encoded_p,
    size_t size)
{
    ssize_t res;
    ssize_t res2;
    ssize_t i;
    uint8_t encoded[size];
    uint8_t encoded2[size];
    struct oer_c_source_x_t decoded;
    struct oer_c_source_x_t decoded2;

    memset(&decoded, 0, sizeof(decoded));

    res = oer_c_source_x_decode(
        &decoded,
        encoded_p,
        size);

    if (res >= 0) {
        res = oer_c_source_x_encode(
            &encoded[0],
            sizeof(encoded),
            &decoded);

        assert_first_encode(res);

        memset(&decoded2, 0, sizeof(decoded2));

        res2 = oer_c_source_x_decode(
            &decoded2,
            &encoded[0],
            res);

        assert_second_decode(res2);
        assert_second_decode_data(&decoded,
                                  &decoded2,
                                  sizeof(decoded));

        res2 = oer_c_source_x_encode(
            &encoded2[0],
            sizeof(encoded2),
            &decoded);

        assert_second_encode(res, res2);
        assert_second_encode_data(&encoded[0], &encoded2[0], res);
    }
}

static void test_oer_c_source_y(
    const uint8_t *encoded_p,
    size_t size)
{
    ssize_t res;
    ssize_t res2;
    ssize_t i;
    uint8_t encoded[size];
    uint8_t encoded2[size];
    struct oer_c_source_y_t decoded;
    struct oer_c_source_y_t decoded2;

    memset(&decoded, 0, sizeof(decoded));

    res = oer_c_source_y_decode(
        &decoded,
        encoded_p,
        size);

    if (res >= 0) {
        res = oer_c_source_y_encode(
            &encoded[0],
            sizeof(encoded),
            &decoded);

        assert_first_encode(res);

        memset(&decoded2, 0, sizeof(decoded2));

        res2 = oer_c_source_y_decode(
            &decoded2,
            &encoded[0],
            res);

        assert_second_decode(res2);
        assert_second_decode_data(&decoded,
                                  &decoded2,
                                  sizeof(decoded));

        res2 = oer_c_source_y_encode(
            &encoded2[0],
            sizeof(encoded2),
            &decoded);

        assert_second_encode(res, res2);
        assert_second_encode_data(&encoded[0], &encoded2[0], res);
    }
}

static void test_oer_c_source_z(
    const uint8_t *encoded_p,
    size_t size)
{
    ssize_t res;
    ssize_t res2;
    ssize_t i;
    uint8_t encoded[size];
    uint8_t encoded2[size];
    struct oer_c_source_z_t decoded;
    struct oer_c_source_z_t decoded2;

    memset(&decoded, 0, sizeof(decoded));

    res = oer_c_source_z_decode(
        &decoded,
        encoded_p,
        size);

    if (res >= 0) {
        res = oer_c_source_z_encode(
            &encoded[0],
            sizeof(encoded),
            &decoded);

        assert_first_encode(res);

        memset(&decoded2, 0, sizeof(decoded2));

        res2 = oer_c_source_z_decode(
            &decoded2,
            &encoded[0],
            res);

        assert_second_decode(res2);
        assert_second_decode_data(&decoded,
                                  &decoded2,
                                  sizeof(decoded));

        res2 = oer_c_source_z_encode(
            &encoded2[0],
            sizeof(encoded2),
            &decoded);

        assert_second_encode(res, res2);
        assert_second_encode_data(&encoded[0], &encoded2[0], res);
    }
}

static void test_oer_programming_types_bool(
    const uint8_t *encoded_p,
    size_t size)
{
    ssize_t res;
    ssize_t res2;
    ssize_t i;
    uint8_t encoded[size];
    uint8_t encoded2[size];
    struct oer_programming_types_bool_t decoded;
    struct oer_programming_types_bool_t decoded2;

    memset(&decoded, 0, sizeof(decoded));

    res = oer_programming_types_bool_decode(
        &decoded,
        encoded_p,
        size);

    if (res >= 0) {
        res = oer_programming_types_bool_encode(
            &encoded[0],
            sizeof(encoded),
            &decoded);

        assert_first_encode(res);

        memset(&decoded2, 0, sizeof(decoded2));

        res2 = oer_programming_types_bool_decode(
            &decoded2,
            &encoded[0],
            res);

        assert_second_decode(res2);
        assert_second_decode_data(&decoded,
                                  &decoded2,
                                  sizeof(decoded));

        res2 = oer_programming_types_bool_encode(
            &encoded2[0],
            sizeof(encoded2),
            &decoded);

        assert_second_encode(res, res2);
        assert_second_encode_data(&encoded[0], &encoded2[0], res);
    }
}

static void test_oer_programming_types_double(
    const uint8_t *encoded_p,
    size_t size)
{
    ssize_t res;
    ssize_t res2;
    ssize_t i;
    uint8_t encoded[size];
    uint8_t encoded2[size];
    struct oer_programming_types_double_t decoded;
    struct oer_programming_types_double_t decoded2;

    memset(&decoded, 0, sizeof(decoded));

    res = oer_programming_types_double_decode(
        &decoded,
        encoded_p,
        size);

    if (res >= 0) {
        res = oer_programming_types_double_encode(
            &encoded[0],
            sizeof(encoded),
            &decoded);

        assert_first_encode(res);

        memset(&decoded2, 0, sizeof(decoded2));

        res2 = oer_programming_types_double_decode(
            &decoded2,
            &encoded[0],
            res);

        assert_second_decode(res2);
        assert_second_decode_data(&decoded,
                                  &decoded2,
                                  sizeof(decoded));

        res2 = oer_programming_types_double_encode(
            &encoded2[0],
            sizeof(encoded2),
            &decoded);

        assert_second_encode(res, res2);
        assert_second_encode_data(&encoded[0], &encoded2[0], res);
    }
}

static void test_oer_programming_types_float(
    const uint8_t *encoded_p,
    size_t size)
{
    ssize_t res;
    ssize_t res2;
    ssize_t i;
    uint8_t encoded[size];
    uint8_t encoded2[size];
    struct oer_programming_types_float_t decoded;
    struct oer_programming_types_float_t decoded2;

    memset(&decoded, 0, sizeof(decoded));

    res = oer_programming_types_float_decode(
        &decoded,
        encoded_p,
        size);

    if (res >= 0) {
        res = oer_programming_types_float_encode(
            &encoded[0],
            sizeof(encoded),
            &decoded);

        assert_first_encode(res);

        memset(&decoded2, 0, sizeof(decoded2));

        res2 = oer_programming_types_float_decode(
            &decoded2,
            &encoded[0],
            res);

        assert_second_decode(res2);
        assert_second_decode_data(&decoded,
                                  &decoded2,
                                  sizeof(decoded));

        res2 = oer_programming_types_float_encode(
            &encoded2[0],
            sizeof(encoded2),
            &decoded);

        assert_second_encode(res, res2);
        assert_second_encode_data(&encoded[0], &encoded2[0], res);
    }
}

static void test_oer_programming_types_int16(
    const uint8_t *encoded_p,
    size_t size)
{
    ssize_t res;
    ssize_t res2;
    ssize_t i;
    uint8_t encoded[size];
    uint8_t encoded2[size];
    struct oer_programming_types_int16_t decoded;
    struct oer_programming_types_int16_t decoded2;

    memset(&decoded, 0, sizeof(decoded));

    res = oer_programming_types_int16_decode(
        &decoded,
        encoded_p,
        size);

    if (res >= 0) {
        res = oer_programming_types_int16_encode(
            &encoded[0],
            sizeof(encoded),
            &decoded);

        assert_first_encode(res);

        memset(&decoded2, 0, sizeof(decoded2));

        res2 = oer_programming_types_int16_decode(
            &decoded2,
            &encoded[0],
            res);

        assert_second_decode(res2);
        assert_second_decode_data(&decoded,
                                  &decoded2,
                                  sizeof(decoded));

        res2 = oer_programming_types_int16_encode(
            &encoded2[0],
            sizeof(encoded2),
            &decoded);

        assert_second_encode(res, res2);
        assert_second_encode_data(&encoded[0], &encoded2[0], res);
    }
}

static void test_oer_programming_types_int32(
    const uint8_t *encoded_p,
    size_t size)
{
    ssize_t res;
    ssize_t res2;
    ssize_t i;
    uint8_t encoded[size];
    uint8_t encoded2[size];
    struct oer_programming_types_int32_t decoded;
    struct oer_programming_types_int32_t decoded2;

    memset(&decoded, 0, sizeof(decoded));

    res = oer_programming_types_int32_decode(
        &decoded,
        encoded_p,
        size);

    if (res >= 0) {
        res = oer_programming_types_int32_encode(
            &encoded[0],
            sizeof(encoded),
            &decoded);

        assert_first_encode(res);

        memset(&decoded2, 0, sizeof(decoded2));

        res2 = oer_programming_types_int32_decode(
            &decoded2,
            &encoded[0],
            res);

        assert_second_decode(res2);
        assert_second_decode_data(&decoded,
                                  &decoded2,
                                  sizeof(decoded));

        res2 = oer_programming_types_int32_encode(
            &encoded2[0],
            sizeof(encoded2),
            &decoded);

        assert_second_encode(res, res2);
        assert_second_encode_data(&encoded[0], &encoded2[0], res);
    }
}

static void test_oer_programming_types_int64(
    const uint8_t *encoded_p,
    size_t size)
{
    ssize_t res;
    ssize_t res2;
    ssize_t i;
    uint8_t encoded[size];
    uint8_t encoded2[size];
    struct oer_programming_types_int64_t decoded;
    struct oer_programming_types_int64_t decoded2;

    memset(&decoded, 0, sizeof(decoded));

    res = oer_programming_types_int64_decode(
        &decoded,
        encoded_p,
        size);

    if (res >= 0) {
        res = oer_programming_types_int64_encode(
            &encoded[0],
            sizeof(encoded),
            &decoded);

        assert_first_encode(res);

        memset(&decoded2, 0, sizeof(decoded2));

        res2 = oer_programming_types_int64_decode(
            &decoded2,
            &encoded[0],
            res);

        assert_second_decode(res2);
        assert_second_decode_data(&decoded,
                                  &decoded2,
                                  sizeof(decoded));

        res2 = oer_programming_types_int64_encode(
            &encoded2[0],
            sizeof(encoded2),
            &decoded);

        assert_second_encode(res, res2);
        assert_second_encode_data(&encoded[0], &encoded2[0], res);
    }
}

static void test_oer_programming_types_int8(
    const uint8_t *encoded_p,
    size_t size)
{
    ssize_t res;
    ssize_t res2;
    ssize_t i;
    uint8_t encoded[size];
    uint8_t encoded2[size];
    struct oer_programming_types_int8_t decoded;
    struct oer_programming_types_int8_t decoded2;

    memset(&decoded, 0, sizeof(decoded));

    res = oer_programming_types_int8_decode(
        &decoded,
        encoded_p,
        size);

    if (res >= 0) {
        res = oer_programming_types_int8_encode(
            &encoded[0],
            sizeof(encoded),
            &decoded);

        assert_first_encode(res);

        memset(&decoded2, 0, sizeof(decoded2));

        res2 = oer_programming_types_int8_decode(
            &decoded2,
            &encoded[0],
            res);

        assert_second_decode(res2);
        assert_second_decode_data(&decoded,
                                  &decoded2,
                                  sizeof(decoded));

        res2 = oer_programming_types_int8_encode(
            &encoded2[0],
            sizeof(encoded2),
            &decoded);

        assert_second_encode(res, res2);
        assert_second_encode_data(&encoded[0], &encoded2[0], res);
    }
}

static void test_oer_programming_types_uint16(
    const uint8_t *encoded_p,
    size_t size)
{
    ssize_t res;
    ssize_t res2;
    ssize_t i;
    uint8_t encoded[size];
    uint8_t encoded2[size];
    struct oer_programming_types_uint16_t decoded;
    struct oer_programming_types_uint16_t decoded2;

    memset(&decoded, 0, sizeof(decoded));

    res = oer_programming_types_uint16_decode(
        &decoded,
        encoded_p,
        size);

    if (res >= 0) {
        res = oer_programming_types_uint16_encode(
            &encoded[0],
            sizeof(encoded),
            &decoded);

        assert_first_encode(res);

        memset(&decoded2, 0, sizeof(decoded2));

        res2 = oer_programming_types_uint16_decode(
            &decoded2,
            &encoded[0],
            res);

        assert_second_decode(res2);
        assert_second_decode_data(&decoded,
                                  &decoded2,
                                  sizeof(decoded));

        res2 = oer_programming_types_uint16_encode(
            &encoded2[0],
            sizeof(encoded2),
            &decoded);

        assert_second_encode(res, res2);
        assert_second_encode_data(&encoded[0], &encoded2[0], res);
    }
}

static void test_oer_programming_types_uint32(
    const uint8_t *encoded_p,
    size_t size)
{
    ssize_t res;
    ssize_t res2;
    ssize_t i;
    uint8_t encoded[size];
    uint8_t encoded2[size];
    struct oer_programming_types_uint32_t decoded;
    struct oer_programming_types_uint32_t decoded2;

    memset(&decoded, 0, sizeof(decoded));

    res = oer_programming_types_uint32_decode(
        &decoded,
        encoded_p,
        size);

    if (res >= 0) {
        res = oer_programming_types_uint32_encode(
            &encoded[0],
            sizeof(encoded),
            &decoded);

        assert_first_encode(res);

        memset(&decoded2, 0, sizeof(decoded2));

        res2 = oer_programming_types_uint32_decode(
            &decoded2,
            &encoded[0],
            res);

        assert_second_decode(res2);
        assert_second_decode_data(&decoded,
                                  &decoded2,
                                  sizeof(decoded));

        res2 = oer_programming_types_uint32_encode(
            &encoded2[0],
            sizeof(encoded2),
            &decoded);

        assert_second_encode(res, res2);
        assert_second_encode_data(&encoded[0], &encoded2[0], res);
    }
}

static void test_oer_programming_types_uint64(
    const uint8_t *encoded_p,
    size_t size)
{
    ssize_t res;
    ssize_t res2;
    ssize_t i;
    uint8_t encoded[size];
    uint8_t encoded2[size];
    struct oer_programming_types_uint64_t decoded;
    struct oer_programming_types_uint64_t decoded2;

    memset(&decoded, 0, sizeof(decoded));

    res = oer_programming_types_uint64_decode(
        &decoded,
        encoded_p,
        size);

    if (res >= 0) {
        res = oer_programming_types_uint64_encode(
            &encoded[0],
            sizeof(encoded),
            &decoded);

        assert_first_encode(res);

        memset(&decoded2, 0, sizeof(decoded2));

        res2 = oer_programming_types_uint64_decode(
            &decoded2,
            &encoded[0],
            res);

        assert_second_decode(res2);
        assert_second_decode_data(&decoded,
                                  &decoded2,
                                  sizeof(decoded));

        res2 = oer_programming_types_uint64_encode(
            &encoded2[0],
            sizeof(encoded2),
            &decoded);

        assert_second_encode(res, res2);
        assert_second_encode_data(&encoded[0], &encoded2[0], res);
    }
}

static void test_oer_programming_types_uint8(
    const uint8_t *encoded_p,
    size_t size)
{
    ssize_t res;
    ssize_t res2;
    ssize_t i;
    uint8_t encoded[size];
    uint8_t encoded2[size];
    struct oer_programming_types_uint8_t decoded;
    struct oer_programming_types_uint8_t decoded2;

    memset(&decoded, 0, sizeof(decoded));

    res = oer_programming_types_uint8_decode(
        &decoded,
        encoded_p,
        size);

    if (res >= 0) {
        res = oer_programming_types_uint8_encode(
            &encoded[0],
            sizeof(encoded),
            &decoded);

        assert_first_encode(res);

        memset(&decoded2, 0, sizeof(decoded2));

        res2 = oer_programming_types_uint8_decode(
            &decoded2,
            &encoded[0],
            res);

        assert_second_decode(res2);
        assert_second_decode_data(&decoded,
                                  &decoded2,
                                  sizeof(decoded));

        res2 = oer_programming_types_uint8_encode(
            &encoded2[0],
            sizeof(encoded2),
            &decoded);

        assert_second_encode(res, res2);
        assert_second_encode_data(&encoded[0], &encoded2[0], res);
    }
}

int LLVMFuzzerTestOneInput(const uint8_t *data_p, size_t size)
{
    test_oer_c_ref_referenced_enum(data_p, size);
    test_oer_c_ref_referenced_int(data_p, size);
    test_oer_c_ref_referenced_sequence(data_p, size);
    test_oer_c_source_a(data_p, size);
    test_oer_c_source_ab(data_p, size);
    test_oer_c_source_ac(data_p, size);
    test_oer_c_source_ad(data_p, size);
    test_oer_c_source_ae(data_p, size);
    test_oer_c_source_af(data_p, size);
    test_oer_c_source_ag(data_p, size);
    test_oer_c_source_ah(data_p, size);
    test_oer_c_source_ai(data_p, size);
    test_oer_c_source_aj(data_p, size);
    test_oer_c_source_ak(data_p, size);
    test_oer_c_source_al(data_p, size);
    test_oer_c_source_am(data_p, size);
    test_oer_c_source_an(data_p, size);
    test_oer_c_source_ao(data_p, size);
    test_oer_c_source_ap(data_p, size);
    test_oer_c_source_aq(data_p, size);
    test_oer_c_source_b(data_p, size);
    test_oer_c_source_c(data_p, size);
    test_oer_c_source_d(data_p, size);
    test_oer_c_source_e(data_p, size);
    test_oer_c_source_f(data_p, size);
    test_oer_c_source_g(data_p, size);
    test_oer_c_source_h(data_p, size);
    test_oer_c_source_i(data_p, size);
    test_oer_c_source_j(data_p, size);
    test_oer_c_source_k(data_p, size);
    test_oer_c_source_l(data_p, size);
    test_oer_c_source_m(data_p, size);
    test_oer_c_source_n(data_p, size);
    test_oer_c_source_o(data_p, size);
    test_oer_c_source_p(data_p, size);
    test_oer_c_source_q(data_p, size);
    test_oer_c_source_r(data_p, size);
    test_oer_c_source_s(data_p, size);
    test_oer_c_source_t(data_p, size);
    test_oer_c_source_u(data_p, size);
    test_oer_c_source_v(data_p, size);
    test_oer_c_source_w(data_p, size);
    test_oer_c_source_x(data_p, size);
    test_oer_c_source_y(data_p, size);
    test_oer_c_source_z(data_p, size);
    test_oer_programming_types_bool(data_p, size);
    test_oer_programming_types_double(data_p, size);
    test_oer_programming_types_float(data_p, size);
    test_oer_programming_types_int16(data_p, size);
    test_oer_programming_types_int32(data_p, size);
    test_oer_programming_types_int64(data_p, size);
    test_oer_programming_types_int8(data_p, size);
    test_oer_programming_types_uint16(data_p, size);
    test_oer_programming_types_uint32(data_p, size);
    test_oer_programming_types_uint64(data_p, size);
    test_oer_programming_types_uint8(data_p, size);

    return (0);
}
