EXPECTED = {'SUPL-AUTH-REQ': {'extensibility-implied': False,
                   'imports': {'SUPL-START': ['SETCapabilities'],
                               'ULP-Components': ['Ver']},
                   'object-classes': {},
                   'object-sets': {},
                   'tags': 'AUTOMATIC',
                   'types': {'SUPLAUTHREQ': {'members': [{'name': 'ver',
                                                          'optional': True,
                                                          'type': 'Ver'},
                                                         {'name': 'sETCapabilities',
                                                          'optional': True,
                                                          'type': 'SETCapabilities'},
                                                         None],
                                             'type': 'SEQUENCE'}},
                   'values': {}},
 'SUPL-AUTH-RESP': {'extensibility-implied': False,
                    'imports': {'Ver2-ULP-Components': ['SPCSETKey',
                                                        'SPCSETKeylifetime',
                                                        'SPCTID']},
                    'object-classes': {},
                    'object-sets': {},
                    'tags': 'AUTOMATIC',
                    'types': {'SUPLAUTHRESP': {'members': [{'name': 'sPCSETKey',
                                                            'type': 'SPCSETKey'},
                                                           {'name': 'sPCTID',
                                                            'type': 'SPCTID'},
                                                           {'name': 'sPCSETKeylifetime',
                                                            'optional': True,
                                                            'type': 'SPCSETKeylifetime'},
                                                           None],
                                               'type': 'SEQUENCE'}},
                    'values': {}},
 'SUPL-END': {'extensibility-implied': False,
              'imports': {'ULP-Components': ['Position', 'StatusCode', 'Ver'],
                          'ULP-Version-2-message-extensions': ['Ver2-SUPL-END-extension']},
              'object-classes': {},
              'object-sets': {},
              'tags': 'AUTOMATIC',
              'types': {'SUPLEND': {'members': [{'name': 'position',
                                                 'optional': True,
                                                 'type': 'Position'},
                                                {'name': 'statusCode',
                                                 'optional': True,
                                                 'type': 'StatusCode'},
                                                {'name': 'ver',
                                                 'optional': True,
                                                 'type': 'Ver'},
                                                None,
                                                {'name': 'ver2-SUPL-END-extension',
                                                 'optional': True,
                                                 'type': 'Ver2-SUPL-END-extension'}],
                                    'type': 'SEQUENCE'}},
              'values': {}},
 'SUPL-INIT': {'extensibility-implied': False,
               'imports': {'ULP-Components': ['PosMethod', 'QoP', 'SLPAddress'],
                           'ULP-Version-2-message-extensions': ['Ver2-SUPL-INIT-extension'],
                           'ULP-Version-2-parameter-extensions': ['Ver2-Notification-extension']},
               'object-classes': {},
               'object-sets': {},
               'tags': 'AUTOMATIC',
               'types': {'EncodingType': {'type': 'ENUMERATED',
                                          'values': [('ucs2', 0),
                                                     ('gsmDefault', 1),
                                                     ('utf8', 2),
                                                     None]},
                         'FormatIndicator': {'type': 'ENUMERATED',
                                             'values': [('logicalName', 0),
                                                        ('e-mailAddress', 1),
                                                        ('msisdn', 2),
                                                        ('url', 3),
                                                        ('sipUrl', 4),
                                                        ('min', 5),
                                                        ('mdn', 6),
                                                        ('iMSPublicidentity',
                                                         7),
                                                        None]},
                         'KeyIdentity': {'size': [128], 'type': 'BIT STRING'},
                         'MAC': {'size': [64], 'type': 'BIT STRING'},
                         'Notification': {'members': [{'name': 'notificationType',
                                                       'type': 'NotificationType'},
                                                      {'name': 'encodingType',
                                                       'optional': True,
                                                       'type': 'EncodingType'},
                                                      {'name': 'requestorId',
                                                       'optional': True,
                                                       'size': [(1,
                                                                 'maxReqLength')],
                                                       'type': 'OCTET STRING'},
                                                      {'name': 'requestorIdType',
                                                       'optional': True,
                                                       'type': 'FormatIndicator'},
                                                      {'name': 'clientName',
                                                       'optional': True,
                                                       'size': [(1,
                                                                 'maxClientLength')],
                                                       'type': 'OCTET STRING'},
                                                      {'name': 'clientNameType',
                                                       'optional': True,
                                                       'type': 'FormatIndicator'},
                                                      None,
                                                      {'name': 'ver2-Notification-extension',
                                                       'optional': True,
                                                       'type': 'Ver2-Notification-extension'}],
                                          'type': 'SEQUENCE'},
                         'NotificationType': {'type': 'ENUMERATED',
                                              'values': [('noNotificationNoVerification',
                                                          0),
                                                         ('notificationOnly',
                                                          1),
                                                         ('notificationAndVerficationAllowedNA',
                                                          2),
                                                         ('notificationAndVerficationDeniedNA',
                                                          3),
                                                         ('privacyOverride', 4),
                                                         None]},
                         'SLPMode': {'type': 'ENUMERATED',
                                     'values': [('proxy', 0), ('nonProxy', 1)]},
                         'SUPLINIT': {'members': [{'name': 'posMethod',
                                                   'type': 'PosMethod'},
                                                  {'name': 'notification',
                                                   'optional': True,
                                                   'type': 'Notification'},
                                                  {'name': 'sLPAddress',
                                                   'optional': True,
                                                   'type': 'SLPAddress'},
                                                  {'name': 'qoP',
                                                   'optional': True,
                                                   'type': 'QoP'},
                                                  {'name': 'sLPMode',
                                                   'type': 'SLPMode'},
                                                  {'name': 'mAC',
                                                   'optional': True,
                                                   'type': 'MAC'},
                                                  {'name': 'keyIdentity',
                                                   'optional': True,
                                                   'type': 'KeyIdentity'},
                                                  None,
                                                  {'name': 'ver2-SUPL-INIT-extension',
                                                   'optional': True,
                                                   'type': 'Ver2-SUPL-INIT-extension'}],
                                      'type': 'SEQUENCE'}},
               'values': {'maxClientLength': {'type': 'INTEGER', 'value': 50},
                          'maxReqLength': {'type': 'INTEGER', 'value': 50}}},
 'SUPL-NOTIFY': {'extensibility-implied': False,
                 'imports': {'SUPL-INIT': ['Notification']},
                 'object-classes': {},
                 'object-sets': {},
                 'tags': 'AUTOMATIC',
                 'types': {'Ver2-SUPLNOTIFY': {'members': [{'name': 'notification',
                                                            'type': 'Notification'},
                                                           None],
                                               'type': 'SEQUENCE'}},
                 'values': {}},
 'SUPL-NOTIFY-RESPONSE': {'extensibility-implied': False,
                          'imports': {},
                          'object-classes': {},
                          'object-sets': {},
                          'tags': 'AUTOMATIC',
                          'types': {'NotificationResponse': {'type': 'ENUMERATED',
                                                             'values': [('allowed',
                                                                         0),
                                                                        ('notAllowed',
                                                                         1),
                                                                        None]},
                                    'Ver2-SUPLNOTIFYRESPONSE': {'members': [{'name': 'notificationResponse',
                                                                             'optional': True,
                                                                             'type': 'NotificationResponse'},
                                                                            None],
                                                                'type': 'SEQUENCE'}},
                          'values': {}},
 'SUPL-POS': {'extensibility-implied': False,
              'imports': {'ULP-Components': ['Velocity'],
                          'ULP-Version-2-message-extensions': ['Ver2-SUPL-POS-extension'],
                          'ULP-Version-2-parameter-extensions': ['Ver2-PosPayLoad-extension']},
              'object-classes': {},
              'object-sets': {},
              'tags': 'AUTOMATIC',
              'types': {'PosPayLoad': {'members': [{'name': 'tia801payload',
                                                    'size': [(1, 8192)],
                                                    'type': 'OCTET STRING'},
                                                   {'name': 'rrcPayload',
                                                    'size': [(1, 8192)],
                                                    'type': 'OCTET STRING'},
                                                   {'name': 'rrlpPayload',
                                                    'size': [(1, 8192)],
                                                    'type': 'OCTET STRING'},
                                                   None,
                                                   {'name': 'ver2-PosPayLoad-extension',
                                                    'type': 'Ver2-PosPayLoad-extension'}],
                                       'type': 'CHOICE'},
                        'SUPLPOS': {'members': [{'name': 'posPayLoad',
                                                 'type': 'PosPayLoad'},
                                                {'name': 'velocity',
                                                 'optional': True,
                                                 'type': 'Velocity'},
                                                None,
                                                {'name': 'ver2-SUPL-POS-extension',
                                                 'optional': True,
                                                 'type': 'Ver2-SUPL-POS-extension'}],
                                    'type': 'SEQUENCE'}},
              'values': {}},
 'SUPL-POS-INIT': {'extensibility-implied': False,
                   'imports': {'SUPL-POS': ['SUPLPOS'],
                               'SUPL-START': ['SETCapabilities'],
                               'ULP-Components': ['LocationId',
                                                  'Position',
                                                  'Ver'],
                               'ULP-Version-2-message-extensions': ['Ver2-SUPL-POS-INIT-extension'],
                               'ULP-Version-2-parameter-extensions': ['Ver2-RequestedAssistData-extension']},
                   'object-classes': {},
                   'object-sets': {},
                   'tags': 'AUTOMATIC',
                   'types': {'NavigationModel': {'members': [{'name': 'gpsWeek',
                                                              'restricted-to': [(0,
                                                                                 1023)],
                                                              'type': 'INTEGER'},
                                                             {'name': 'gpsToe',
                                                              'restricted-to': [(0,
                                                                                 167)],
                                                              'type': 'INTEGER'},
                                                             {'name': 'nSAT',
                                                              'restricted-to': [(0,
                                                                                 31)],
                                                              'type': 'INTEGER'},
                                                             {'name': 'toeLimit',
                                                              'restricted-to': [(0,
                                                                                 10)],
                                                              'type': 'INTEGER'},
                                                             {'name': 'satInfo',
                                                              'optional': True,
                                                              'type': 'SatelliteInfo'},
                                                             None],
                                                 'type': 'SEQUENCE'},
                             'RequestedAssistData': {'members': [{'name': 'almanacRequested',
                                                                  'type': 'BOOLEAN'},
                                                                 {'name': 'utcModelRequested',
                                                                  'type': 'BOOLEAN'},
                                                                 {'name': 'ionosphericModelRequested',
                                                                  'type': 'BOOLEAN'},
                                                                 {'name': 'dgpsCorrectionsRequested',
                                                                  'type': 'BOOLEAN'},
                                                                 {'name': 'referenceLocationRequested',
                                                                  'type': 'BOOLEAN'},
                                                                 {'name': 'referenceTimeRequested',
                                                                  'type': 'BOOLEAN'},
                                                                 {'name': 'acquisitionAssistanceRequested',
                                                                  'type': 'BOOLEAN'},
                                                                 {'name': 'realTimeIntegrityRequested',
                                                                  'type': 'BOOLEAN'},
                                                                 {'name': 'navigationModelRequested',
                                                                  'type': 'BOOLEAN'},
                                                                 {'name': 'navigationModelData',
                                                                  'optional': True,
                                                                  'type': 'NavigationModel'},
                                                                 None,
                                                                 {'name': 'ver2-RequestedAssistData-extension',
                                                                  'optional': True,
                                                                  'type': 'Ver2-RequestedAssistData-extension'}],
                                                     'type': 'SEQUENCE'},
                             'SUPLPOSINIT': {'members': [{'name': 'sETCapabilities',
                                                          'type': 'SETCapabilities'},
                                                         {'name': 'requestedAssistData',
                                                          'optional': True,
                                                          'type': 'RequestedAssistData'},
                                                         {'name': 'locationId',
                                                          'type': 'LocationId'},
                                                         {'name': 'position',
                                                          'optional': True,
                                                          'type': 'Position'},
                                                         {'name': 'sUPLPOS',
                                                          'optional': True,
                                                          'type': 'SUPLPOS'},
                                                         {'name': 'ver',
                                                          'optional': True,
                                                          'type': 'Ver'},
                                                         None,
                                                         {'name': 'ver2-SUPL-POS-INIT-extension',
                                                          'optional': True,
                                                          'type': 'Ver2-SUPL-POS-INIT-extension'}],
                                             'type': 'SEQUENCE'},
                             'SatelliteInfo': {'element': {'type': 'SatelliteInfoElement'},
                                               'size': [(1, 31)],
                                               'type': 'SEQUENCE OF'},
                             'SatelliteInfoElement': {'members': [{'name': 'satId',
                                                                   'restricted-to': [(0,
                                                                                      63)],
                                                                   'type': 'INTEGER'},
                                                                  {'name': 'iODE',
                                                                   'restricted-to': [(0,
                                                                                      255)],
                                                                   'type': 'INTEGER'},
                                                                  None],
                                                      'type': 'SEQUENCE'}},
                   'values': {}},
 'SUPL-REPORT': {'extensibility-implied': False,
                 'imports': {'SUPL-START': ['SETCapabilities'],
                             'ULP-Components': ['PosMethod',
                                                'Position',
                                                'SessionID',
                                                'Ver'],
                             'ULP-Version-2-parameter-extensions': ['maxGANSS'],
                             'Ver2-ULP-Components': ['GANSSSignals',
                                                     'GNSSPosTechnology',
                                                     'MultipleLocationIds']},
                 'object-classes': {},
                 'object-sets': {},
                 'tags': 'AUTOMATIC',
                 'types': {'GANSSSignalsDescription': {'members': [{'name': 'ganssId',
                                                                    'restricted-to': [(0,
                                                                                       15)],
                                                                    'type': 'INTEGER'},
                                                                   {'name': 'gANSSSignals',
                                                                    'type': 'GANSSSignals'},
                                                                   None],
                                                       'type': 'SEQUENCE'},
                           'GANSSsignalsInfo': {'element': {'type': 'GANSSSignalsDescription'},
                                                'size': [(1, 'maxGANSS')],
                                                'type': 'SEQUENCE OF'},
                           'PositionData': {'members': [{'name': 'position',
                                                         'type': 'Position'},
                                                        {'name': 'posMethod',
                                                         'optional': True,
                                                         'type': 'PosMethod'},
                                                        {'name': 'gnssPosTechnology',
                                                         'optional': True,
                                                         'type': 'GNSSPosTechnology'},
                                                        {'name': 'ganssSignalsInfo',
                                                         'optional': True,
                                                         'type': 'GANSSsignalsInfo'},
                                                        None],
                                            'type': 'SEQUENCE'},
                           'ReportData': {'members': [{'name': 'positionData',
                                                       'optional': True,
                                                       'type': 'PositionData'},
                                                      {'name': 'multipleLocationIds',
                                                       'optional': True,
                                                       'type': 'MultipleLocationIds'},
                                                      {'name': 'resultCode',
                                                       'optional': True,
                                                       'type': 'ResultCode'},
                                                      {'name': 'timestamp',
                                                       'optional': True,
                                                       'type': 'TimeStamp'},
                                                      None],
                                          'type': 'SEQUENCE'},
                           'ReportDataList': {'element': {'type': 'ReportData'},
                                              'size': [(1, 1024)],
                                              'type': 'SEQUENCE OF'},
                           'ResultCode': {'type': 'ENUMERATED',
                                          'values': [('outofradiocoverage', 1),
                                                     ('noposition', 2),
                                                     ('nomeasurement', 3),
                                                     ('nopositionnomeasurement',
                                                      4),
                                                     ('outofmemory', 5),
                                                     ('outofmemoryintermediatereporting',
                                                      6),
                                                     ('other', 7),
                                                     None]},
                           'SessionInformation': {'members': [{'name': 'sessionID',
                                                               'type': 'SessionID'},
                                                              None],
                                                  'type': 'SEQUENCE'},
                           'SessionList': {'element': {'type': 'SessionInformation'},
                                           'size': [(1, 'maxnumSessions')],
                                           'type': 'SEQUENCE OF'},
                           'TimeStamp': {'members': [{'name': 'absoluteTime',
                                                      'type': 'UTCTime'},
                                                     {'name': 'relativeTime',
                                                      'restricted-to': [(0,
                                                                         31536000)],
                                                      'type': 'INTEGER'}],
                                         'type': 'CHOICE'},
                           'Ver2-SUPLREPORT': {'members': [{'name': 'sessionList',
                                                            'optional': True,
                                                            'type': 'SessionList'},
                                                           {'name': 'sETCapabilities',
                                                            'optional': True,
                                                            'type': 'SETCapabilities'},
                                                           {'name': 'reportDataList',
                                                            'optional': True,
                                                            'type': 'ReportDataList'},
                                                           {'name': 'ver',
                                                            'optional': True,
                                                            'type': 'Ver'},
                                                           {'name': 'moreComponents',
                                                            'optional': True,
                                                            'type': 'NULL'},
                                                           None],
                                               'type': 'SEQUENCE'}},
                 'values': {'maxnumSessions': {'type': 'INTEGER',
                                               'value': 64}}},
 'SUPL-RESPONSE': {'extensibility-implied': False,
                   'imports': {'ULP-Components': ['PosMethod', 'SLPAddress'],
                               'ULP-Version-2-message-extensions': ['Ver2-SUPL-RESPONSE-extension']},
                   'object-classes': {},
                   'object-sets': {},
                   'tags': 'AUTOMATIC',
                   'types': {'KeyIdentity4': {'size': [128],
                                              'type': 'BIT STRING'},
                             'SETAuthKey': {'members': [{'name': 'shortKey',
                                                         'size': [128],
                                                         'type': 'BIT STRING'},
                                                        {'name': 'longKey',
                                                         'size': [256],
                                                         'type': 'BIT STRING'},
                                                        None],
                                            'type': 'CHOICE'},
                             'SUPLRESPONSE': {'members': [{'name': 'posMethod',
                                                           'type': 'PosMethod'},
                                                          {'name': 'sLPAddress',
                                                           'optional': True,
                                                           'type': 'SLPAddress'},
                                                          {'name': 'sETAuthKey',
                                                           'optional': True,
                                                           'type': 'SETAuthKey'},
                                                          {'name': 'keyIdentity4',
                                                           'optional': True,
                                                           'type': 'KeyIdentity4'},
                                                          None,
                                                          {'name': 'ver2-SUPL-RESPONSE-extension',
                                                           'optional': True,
                                                           'type': 'Ver2-SUPL-RESPONSE-extension'}],
                                              'type': 'SEQUENCE'}},
                   'values': {}},
 'SUPL-SET-INIT': {'extensibility-implied': False,
                   'imports': {'ULP-Components': ['QoP', 'SETId'],
                               'Ver2-ULP-Components': ['ApplicationID']},
                   'object-classes': {},
                   'object-sets': {},
                   'tags': 'AUTOMATIC',
                   'types': {'Ver2-SUPLSETINIT': {'members': [{'name': 'targetSETID',
                                                               'type': 'SETId'},
                                                              {'name': 'qoP',
                                                               'optional': True,
                                                               'type': 'QoP'},
                                                              {'name': 'applicationID',
                                                               'optional': True,
                                                               'type': 'ApplicationID'}],
                                                  'type': 'SEQUENCE'}},
                   'values': {}},
 'SUPL-START': {'extensibility-implied': False,
                'imports': {'ULP-Components': ['LocationId', 'QoP'],
                            'ULP-Version-2-message-extensions': ['Ver2-SUPL-START-extension'],
                            'ULP-Version-2-parameter-extensions': ['Ver2-PosProtocol-extension',
                                                                   'Ver2-PosTechnology-extension',
                                                                   'Ver2-SETCapabilities-extension']},
                'object-classes': {},
                'object-sets': {},
                'tags': 'AUTOMATIC',
                'types': {'PosProtocol': {'members': [{'name': 'tia801',
                                                       'type': 'BOOLEAN'},
                                                      {'name': 'rrlp',
                                                       'type': 'BOOLEAN'},
                                                      {'name': 'rrc',
                                                       'type': 'BOOLEAN'},
                                                      None,
                                                      {'name': 'ver2-PosProtocol-extension',
                                                       'optional': True,
                                                       'type': 'Ver2-PosProtocol-extension'}],
                                          'type': 'SEQUENCE'},
                          'PosTechnology': {'members': [{'name': 'agpsSETassisted',
                                                         'type': 'BOOLEAN'},
                                                        {'name': 'agpsSETBased',
                                                         'type': 'BOOLEAN'},
                                                        {'name': 'autonomousGPS',
                                                         'type': 'BOOLEAN'},
                                                        {'name': 'aFLT',
                                                         'type': 'BOOLEAN'},
                                                        {'name': 'eCID',
                                                         'type': 'BOOLEAN'},
                                                        {'name': 'eOTD',
                                                         'type': 'BOOLEAN'},
                                                        {'name': 'oTDOA',
                                                         'type': 'BOOLEAN'},
                                                        None,
                                                        {'name': 'ver2-PosTechnology-extension',
                                                         'optional': True,
                                                         'type': 'Ver2-PosTechnology-extension'}],
                                            'type': 'SEQUENCE'},
                          'PrefMethod': {'type': 'ENUMERATED',
                                         'values': [('agpsSETassistedPreferred',
                                                     0),
                                                    ('agpsSETBasedPreferred',
                                                     1),
                                                    ('noPreference', 2)]},
                          'SETCapabilities': {'members': [{'name': 'posTechnology',
                                                           'type': 'PosTechnology'},
                                                          {'name': 'prefMethod',
                                                           'type': 'PrefMethod'},
                                                          {'name': 'posProtocol',
                                                           'type': 'PosProtocol'},
                                                          None,
                                                          {'name': 'ver2-SETCapabilities-extension',
                                                           'optional': True,
                                                           'type': 'Ver2-SETCapabilities-extension'}],
                                              'type': 'SEQUENCE'},
                          'SUPLSTART': {'members': [{'name': 'sETCapabilities',
                                                     'type': 'SETCapabilities'},
                                                    {'name': 'locationId',
                                                     'type': 'LocationId'},
                                                    {'name': 'qoP',
                                                     'optional': True,
                                                     'type': 'QoP'},
                                                    None,
                                                    {'name': 'ver2-SUPL-START-extension',
                                                     'optional': True,
                                                     'type': 'Ver2-SUPL-START-extension'}],
                                        'type': 'SEQUENCE'}},
                'values': {}},
 'SUPL-TRIGGERED-RESPONSE': {'extensibility-implied': False,
                             'imports': {'SUPL-TRIGGERED-START': ['TriggerParams'],
                                         'ULP-Components': ['PosMethod',
                                                            'SLPAddress'],
                                         'Ver2-ULP-Components': ['GNSSPosTechnology',
                                                                 'SPCSETKey',
                                                                 'SPCSETKeylifetime',
                                                                 'SPCTID',
                                                                 'SupportedNetworkInformation']},
                             'object-classes': {},
                             'object-sets': {},
                             'tags': 'AUTOMATIC',
                             'types': {'BatchRepConditions': {'members': [{'name': 'num-interval',
                                                                           'restricted-to': [(1,
                                                                                              1024)],
                                                                           'type': 'INTEGER'},
                                                                          {'name': 'num-minutes',
                                                                           'restricted-to': [(1,
                                                                                              2048)],
                                                                           'type': 'INTEGER'},
                                                                          {'name': 'endofsession',
                                                                           'type': 'NULL'},
                                                                          None],
                                                              'type': 'CHOICE'},
                                       'BatchRepType': {'members': [{'name': 'reportPosition',
                                                                     'type': 'BOOLEAN'},
                                                                    {'name': 'reportMeasurements',
                                                                     'type': 'BOOLEAN'},
                                                                    {'name': 'intermediateReports',
                                                                     'type': 'BOOLEAN'},
                                                                    {'name': 'discardOldest',
                                                                     'optional': True,
                                                                     'type': 'BOOLEAN'},
                                                                    None],
                                                        'type': 'SEQUENCE'},
                                       'RepModee': {'type': 'ENUMERATED',
                                                    'values': [('realtime', 1),
                                                               ('quasirealtime',
                                                                2),
                                                               ('batch', 3),
                                                               None]},
                                       'ReportingMode': {'members': [{'name': 'repMode',
                                                                      'type': 'RepModee'},
                                                                     {'name': 'batchRepConditions',
                                                                      'optional': True,
                                                                      'type': 'BatchRepConditions'},
                                                                     {'name': 'batchRepType',
                                                                      'optional': True,
                                                                      'type': 'BatchRepType'},
                                                                     None],
                                                         'type': 'SEQUENCE'},
                                       'Ver2-SUPLTRIGGEREDRESPONSE': {'members': [{'name': 'posMethod',
                                                                                   'type': 'PosMethod'},
                                                                                  {'name': 'triggerParams',
                                                                                   'optional': True,
                                                                                   'type': 'TriggerParams'},
                                                                                  {'name': 'sLPAddress',
                                                                                   'optional': True,
                                                                                   'type': 'SLPAddress'},
                                                                                  {'name': 'supportedNetworkInformation',
                                                                                   'optional': True,
                                                                                   'type': 'SupportedNetworkInformation'},
                                                                                  {'name': 'reportingMode',
                                                                                   'optional': True,
                                                                                   'type': 'ReportingMode'},
                                                                                  {'name': 'sPCSETKey',
                                                                                   'optional': True,
                                                                                   'type': 'SPCSETKey'},
                                                                                  {'name': 'sPCTID',
                                                                                   'optional': True,
                                                                                   'type': 'SPCTID'},
                                                                                  {'name': 'sPCSETKeylifetime',
                                                                                   'optional': True,
                                                                                   'type': 'SPCSETKeylifetime'},
                                                                                  {'name': 'gnssPosTechnology',
                                                                                   'optional': True,
                                                                                   'type': 'GNSSPosTechnology'},
                                                                                  None],
                                                                      'type': 'SEQUENCE'}},
                             'values': {}},
 'SUPL-TRIGGERED-START': {'extensibility-implied': False,
                          'imports': {'SUPL-START': ['SETCapabilities'],
                                      'ULP-Components': ['LocationId',
                                                         'Position',
                                                         'QoP',
                                                         'Ver'],
                                      'Ver2-ULP-Components': ['ApplicationID',
                                                              'CauseCode',
                                                              'CircularArea',
                                                              'Coordinate',
                                                              'EllipticalArea',
                                                              'MultipleLocationIds',
                                                              'PolygonArea',
                                                              'ReportingCap',
                                                              'ThirdParty']},
                          'object-classes': {},
                          'object-sets': {},
                          'tags': 'AUTOMATIC',
                          'types': {'AreaEventParams': {'members': [{'name': 'areaEventType',
                                                                     'type': 'AreaEventType'},
                                                                    {'name': 'locationEstimate',
                                                                     'type': 'BOOLEAN'},
                                                                    {'name': 'repeatedReportingParams',
                                                                     'optional': True,
                                                                     'type': 'RepeatedReportingParams'},
                                                                    {'name': 'startTime',
                                                                     'optional': True,
                                                                     'restricted-to': [(0,
                                                                                        2678400)],
                                                                     'type': 'INTEGER'},
                                                                    {'name': 'stopTime',
                                                                     'optional': True,
                                                                     'restricted-to': [(0,
                                                                                        11318399)],
                                                                     'type': 'INTEGER'},
                                                                    {'name': 'geographicTargetAreaList',
                                                                     'optional': True,
                                                                     'type': 'GeographicTargetAreaList'},
                                                                    {'element': {'type': 'AreaIdList'},
                                                                     'name': 'areaIdLists',
                                                                     'optional': True,
                                                                     'size': [(1,
                                                                               'maxAreaIdList')],
                                                                     'type': 'SEQUENCE '
                                                                             'OF'},
                                                                    None],
                                                        'type': 'SEQUENCE'},
                                    'AreaEventType': {'type': 'ENUMERATED',
                                                      'values': [('enteringArea',
                                                                  0),
                                                                 ('insideArea',
                                                                  1),
                                                                 ('outsideArea',
                                                                  2),
                                                                 ('leavingArea',
                                                                  3),
                                                                 None]},
                                    'AreaId': {'members': [{'name': 'gSMAreaId',
                                                            'type': 'GSMAreaId'},
                                                           {'name': 'wCDMAAreaId',
                                                            'type': 'WCDMAAreaId'},
                                                           {'name': 'cDMAAreaId',
                                                            'type': 'CDMAAreaId'},
                                                           {'name': 'hRPDAreaId',
                                                            'type': 'HRPDAreaId'},
                                                           {'name': 'uMBAreaId',
                                                            'type': 'UMBAreaId'},
                                                           {'name': 'lTEAreaId',
                                                            'type': 'LTEAreaId'},
                                                           {'name': 'wLANAreaId',
                                                            'type': 'WLANAreaId'},
                                                           {'name': 'wiMAXAreaId',
                                                            'type': 'WimaxAreaId'},
                                                           None],
                                               'type': 'CHOICE'},
                                    'AreaIdList': {'members': [{'name': 'areaIdSet',
                                                                'type': 'AreaIdSet'},
                                                               {'name': 'areaIdSetType',
                                                                'optional': True,
                                                                'type': 'AreaIdSetType'},
                                                               {'name': 'geoAreaMappingList',
                                                                'optional': True,
                                                                'type': 'GeoAreaMappingList'}],
                                                   'type': 'SEQUENCE'},
                                    'AreaIdSet': {'element': {'type': 'AreaId'},
                                                  'size': [(1, 'maxAreaId')],
                                                  'type': 'SEQUENCE OF'},
                                    'AreaIdSetType': {'type': 'ENUMERATED',
                                                      'values': [('border', 0),
                                                                 ('within', 1),
                                                                 None]},
                                    'CDMAAreaId': {'members': [{'name': 'refSID',
                                                                'optional': True,
                                                                'restricted-to': [(0,
                                                                                   65535)],
                                                                'type': 'INTEGER'},
                                                               {'name': 'refNID',
                                                                'optional': True,
                                                                'restricted-to': [(0,
                                                                                   32767)],
                                                                'type': 'INTEGER'},
                                                               {'name': 'refBASEID',
                                                                'optional': True,
                                                                'restricted-to': [(0,
                                                                                   65535)],
                                                                'type': 'INTEGER'},
                                                               None],
                                                   'type': 'SEQUENCE'},
                                    'GSMAreaId': {'members': [{'name': 'refMCC',
                                                               'optional': True,
                                                               'restricted-to': [(0,
                                                                                  999)],
                                                               'type': 'INTEGER'},
                                                              {'name': 'refMNC',
                                                               'optional': True,
                                                               'restricted-to': [(0,
                                                                                  999)],
                                                               'type': 'INTEGER'},
                                                              {'name': 'refLAC',
                                                               'optional': True,
                                                               'restricted-to': [(0,
                                                                                  65535)],
                                                               'type': 'INTEGER'},
                                                              {'name': 'refCI',
                                                               'optional': True,
                                                               'restricted-to': [(0,
                                                                                  65535)],
                                                               'type': 'INTEGER'},
                                                              None],
                                                  'type': 'SEQUENCE'},
                                    'GeoAreaIndex': {'restricted-to': [(1,
                                                                        'maxNumGeoArea')],
                                                     'type': 'INTEGER'},
                                    'GeoAreaMappingList': {'element': {'type': 'GeoAreaIndex'},
                                                           'size': [(1,
                                                                     'maxNumGeoArea')],
                                                           'type': 'SEQUENCE '
                                                                   'OF'},
                                    'GeographicTargetArea': {'members': [{'name': 'circularArea',
                                                                          'type': 'CircularArea'},
                                                                         {'name': 'ellipticalArea',
                                                                          'type': 'EllipticalArea'},
                                                                         {'name': 'polygonArea',
                                                                          'type': 'PolygonArea'},
                                                                         None],
                                                             'type': 'CHOICE'},
                                    'GeographicTargetAreaList': {'element': {'type': 'GeographicTargetArea'},
                                                                 'size': [(1,
                                                                           'maxNumGeoArea')],
                                                                 'type': 'SEQUENCE '
                                                                         'OF'},
                                    'HRPDAreaId': {'members': [{'name': 'refSECTORID',
                                                                'size': [128],
                                                                'type': 'BIT '
                                                                        'STRING'},
                                                               None],
                                                   'type': 'SEQUENCE'},
                                    'LTEAreaId': {'members': [{'name': 'refMCC',
                                                               'optional': True,
                                                               'restricted-to': [(0,
                                                                                  999)],
                                                               'type': 'INTEGER'},
                                                              {'name': 'refMNC',
                                                               'optional': True,
                                                               'restricted-to': [(0,
                                                                                  999)],
                                                               'type': 'INTEGER'},
                                                              {'name': 'refCI',
                                                               'optional': True,
                                                               'size': [29],
                                                               'type': 'BIT '
                                                                       'STRING'},
                                                              None],
                                                  'type': 'SEQUENCE'},
                                    'PeriodicParams': {'members': [{'name': 'numberOfFixes',
                                                                    'restricted-to': [(1,
                                                                                       8639999)],
                                                                    'type': 'INTEGER'},
                                                                   {'name': 'intervalBetweenFixes',
                                                                    'restricted-to': [(1,
                                                                                       8639999)],
                                                                    'type': 'INTEGER'},
                                                                   {'name': 'startTime',
                                                                    'optional': True,
                                                                    'restricted-to': [(0,
                                                                                       2678400)],
                                                                    'type': 'INTEGER'},
                                                                   None],
                                                       'type': 'SEQUENCE'},
                                    'RepeatedReportingParams': {'members': [{'name': 'minimumIntervalTime',
                                                                             'restricted-to': [(1,
                                                                                                604800)],
                                                                             'type': 'INTEGER'},
                                                                            {'name': 'maximumNumberOfReports',
                                                                             'restricted-to': [(1,
                                                                                                1024)],
                                                                             'type': 'INTEGER'},
                                                                            None],
                                                                'type': 'SEQUENCE'},
                                    'TriggerParams': {'members': [{'name': 'periodicParams',
                                                                   'type': 'PeriodicParams'},
                                                                  {'name': 'areaEventParams',
                                                                   'type': 'AreaEventParams'},
                                                                  None],
                                                      'type': 'CHOICE'},
                                    'TriggerType': {'type': 'ENUMERATED',
                                                    'values': [('periodic', 0),
                                                               ('areaEvent', 1),
                                                               None]},
                                    'UMBAreaId': {'members': [{'name': 'refMCC',
                                                               'optional': True,
                                                               'restricted-to': [(0,
                                                                                  999)],
                                                               'type': 'INTEGER'},
                                                              {'name': 'refMNC',
                                                               'optional': True,
                                                               'restricted-to': [(0,
                                                                                  999)],
                                                               'type': 'INTEGER'},
                                                              {'name': 'refSECTORID',
                                                               'optional': True,
                                                               'size': [128],
                                                               'type': 'BIT '
                                                                       'STRING'},
                                                              None],
                                                  'type': 'SEQUENCE'},
                                    'Ver2-SUPLTRIGGEREDSTART': {'members': [{'name': 'sETCapabilities',
                                                                             'type': 'SETCapabilities'},
                                                                            {'name': 'locationId',
                                                                             'type': 'LocationId'},
                                                                            {'name': 'ver',
                                                                             'optional': True,
                                                                             'type': 'Ver'},
                                                                            {'name': 'qoP',
                                                                             'optional': True,
                                                                             'type': 'QoP'},
                                                                            {'name': 'multipleLocationIds',
                                                                             'optional': True,
                                                                             'type': 'MultipleLocationIds'},
                                                                            {'name': 'thirdParty',
                                                                             'optional': True,
                                                                             'type': 'ThirdParty'},
                                                                            {'name': 'applicationID',
                                                                             'optional': True,
                                                                             'type': 'ApplicationID'},
                                                                            {'name': 'triggerType',
                                                                             'optional': True,
                                                                             'type': 'TriggerType'},
                                                                            {'name': 'triggerParams',
                                                                             'optional': True,
                                                                             'type': 'TriggerParams'},
                                                                            {'name': 'position',
                                                                             'optional': True,
                                                                             'type': 'Position'},
                                                                            {'name': 'reportingCap',
                                                                             'optional': True,
                                                                             'type': 'ReportingCap'},
                                                                            {'name': 'causeCode',
                                                                             'optional': True,
                                                                             'type': 'CauseCode'},
                                                                            None],
                                                                'type': 'SEQUENCE'},
                                    'WCDMAAreaId': {'members': [{'name': 'refMCC',
                                                                 'optional': True,
                                                                 'restricted-to': [(0,
                                                                                    999)],
                                                                 'type': 'INTEGER'},
                                                                {'name': 'refMNC',
                                                                 'optional': True,
                                                                 'restricted-to': [(0,
                                                                                    999)],
                                                                 'type': 'INTEGER'},
                                                                {'name': 'refLAC',
                                                                 'optional': True,
                                                                 'restricted-to': [(0,
                                                                                    65535)],
                                                                 'type': 'INTEGER'},
                                                                {'name': 'refUC',
                                                                 'optional': True,
                                                                 'restricted-to': [(0,
                                                                                    268435455)],
                                                                 'type': 'INTEGER'},
                                                                None],
                                                    'type': 'SEQUENCE'},
                                    'WLANAreaId': {'members': [{'name': 'apMACAddress',
                                                                'size': [48],
                                                                'type': 'BIT '
                                                                        'STRING'},
                                                               None],
                                                   'type': 'SEQUENCE'},
                                    'WimaxAreaId': {'members': [{'name': 'bsID-MSB',
                                                                 'optional': True,
                                                                 'size': [24],
                                                                 'type': 'BIT '
                                                                         'STRING'},
                                                                {'name': 'bsID-LSB',
                                                                 'size': [24],
                                                                 'type': 'BIT '
                                                                         'STRING'}],
                                                    'type': 'SEQUENCE'}},
                          'values': {'maxAreaId': {'type': 'INTEGER',
                                                   'value': 256},
                                     'maxAreaIdList': {'type': 'INTEGER',
                                                       'value': 32},
                                     'maxNumGeoArea': {'type': 'INTEGER',
                                                       'value': 32}}},
 'SUPL-TRIGGERED-STOP': {'extensibility-implied': False,
                         'imports': {'ULP-Components': ['StatusCode']},
                         'object-classes': {},
                         'object-sets': {},
                         'tags': 'AUTOMATIC',
                         'types': {'Ver2-SUPLTRIGGEREDSTOP': {'members': [{'name': 'statusCode',
                                                                           'optional': True,
                                                                           'type': 'StatusCode'},
                                                                          None],
                                                              'type': 'SEQUENCE'}},
                         'values': {}},
 'ULP': {'extensibility-implied': False,
         'imports': {'SUPL-AUTH-REQ': ['SUPLAUTHREQ'],
                     'SUPL-AUTH-RESP': ['SUPLAUTHRESP'],
                     'SUPL-END': ['SUPLEND'],
                     'SUPL-INIT': ['SUPLINIT'],
                     'SUPL-NOTIFY': ['Ver2-SUPLNOTIFY'],
                     'SUPL-NOTIFY-RESPONSE': ['Ver2-SUPLNOTIFYRESPONSE'],
                     'SUPL-POS': ['SUPLPOS'],
                     'SUPL-POS-INIT': ['SUPLPOSINIT'],
                     'SUPL-REPORT': ['Ver2-SUPLREPORT'],
                     'SUPL-RESPONSE': ['SUPLRESPONSE'],
                     'SUPL-SET-INIT': ['Ver2-SUPLSETINIT'],
                     'SUPL-START': ['SUPLSTART'],
                     'SUPL-TRIGGERED-RESPONSE': ['Ver2-SUPLTRIGGEREDRESPONSE'],
                     'SUPL-TRIGGERED-START': ['Ver2-SUPLTRIGGEREDSTART'],
                     'SUPL-TRIGGERED-STOP': ['Ver2-SUPLTRIGGEREDSTOP'],
                     'ULP-Components': ['SessionID', 'Version']},
         'object-classes': {},
         'object-sets': {},
         'tags': 'AUTOMATIC',
         'types': {'ULP-PDU': {'members': [{'name': 'length',
                                            'restricted-to': [(0, 65535)],
                                            'type': 'INTEGER'},
                                           {'name': 'version',
                                            'type': 'Version'},
                                           {'name': 'sessionID',
                                            'type': 'SessionID'},
                                           {'name': 'message',
                                            'type': 'UlpMessage'}],
                               'type': 'SEQUENCE'},
                   'UlpMessage': {'members': [{'name': 'msSUPLINIT',
                                               'type': 'SUPLINIT'},
                                              {'name': 'msSUPLSTART',
                                               'type': 'SUPLSTART'},
                                              {'name': 'msSUPLRESPONSE',
                                               'type': 'SUPLRESPONSE'},
                                              {'name': 'msSUPLPOSINIT',
                                               'type': 'SUPLPOSINIT'},
                                              {'name': 'msSUPLPOS',
                                               'type': 'SUPLPOS'},
                                              {'name': 'msSUPLEND',
                                               'type': 'SUPLEND'},
                                              {'name': 'msSUPLAUTHREQ',
                                               'type': 'SUPLAUTHREQ'},
                                              {'name': 'msSUPLAUTHRESP',
                                               'type': 'SUPLAUTHRESP'},
                                              None,
                                              {'name': 'msSUPLTRIGGEREDSTART',
                                               'type': 'Ver2-SUPLTRIGGEREDSTART'},
                                              {'name': 'msSUPLTRIGGEREDRESPONSE',
                                               'type': 'Ver2-SUPLTRIGGEREDRESPONSE'},
                                              {'name': 'msSUPLTRIGGEREDSTOP',
                                               'type': 'Ver2-SUPLTRIGGEREDSTOP'},
                                              {'name': 'msSUPLNOTIFY',
                                               'type': 'Ver2-SUPLNOTIFY'},
                                              {'name': 'msSUPLNOTIFYRESPONSE',
                                               'type': 'Ver2-SUPLNOTIFYRESPONSE'},
                                              {'name': 'msSUPLSETINIT',
                                               'type': 'Ver2-SUPLSETINIT'},
                                              {'name': 'msSUPLREPORT',
                                               'type': 'Ver2-SUPLREPORT'}],
                                  'type': 'CHOICE'}},
         'values': {}},
 'ULP-Components': {'extensibility-implied': False,
                    'imports': {'Ver2-ULP-Components': ['Ver2-CellInfo-extension']},
                    'object-classes': {},
                    'object-sets': {},
                    'tags': 'AUTOMATIC',
                    'types': {'AltitudeInfo': {'members': [{'name': 'altitudeDirection',
                                                            'type': 'ENUMERATED',
                                                            'values': [('height',
                                                                        0),
                                                                       ('depth',
                                                                        1)]},
                                                           {'name': 'altitude',
                                                            'restricted-to': [(0,
                                                                               32767)],
                                                            'type': 'INTEGER'},
                                                           {'name': 'altUncertainty',
                                                            'restricted-to': [(0,
                                                                               127)],
                                                            'type': 'INTEGER'},
                                                           None],
                                               'type': 'SEQUENCE'},
                              'CPICH-Ec-N0': {'restricted-to': [(0, 63)],
                                              'type': 'INTEGER'},
                              'CPICH-RSCP': {'restricted-to': [(0, 127)],
                                             'type': 'INTEGER'},
                              'CdmaCellInformation': {'members': [{'name': 'refNID',
                                                                   'restricted-to': [(0,
                                                                                      65535)],
                                                                   'type': 'INTEGER'},
                                                                  {'name': 'refSID',
                                                                   'restricted-to': [(0,
                                                                                      32767)],
                                                                   'type': 'INTEGER'},
                                                                  {'name': 'refBASEID',
                                                                   'restricted-to': [(0,
                                                                                      65535)],
                                                                   'type': 'INTEGER'},
                                                                  {'name': 'refBASELAT',
                                                                   'restricted-to': [(0,
                                                                                      4194303)],
                                                                   'type': 'INTEGER'},
                                                                  {'name': 'reBASELONG',
                                                                   'restricted-to': [(0,
                                                                                      8388607)],
                                                                   'type': 'INTEGER'},
                                                                  {'name': 'refREFPN',
                                                                   'restricted-to': [(0,
                                                                                      511)],
                                                                   'type': 'INTEGER'},
                                                                  {'name': 'refWeekNumber',
                                                                   'restricted-to': [(0,
                                                                                      65535)],
                                                                   'type': 'INTEGER'},
                                                                  {'name': 'refSeconds',
                                                                   'restricted-to': [(0,
                                                                                      4194303)],
                                                                   'type': 'INTEGER'},
                                                                  None],
                                                      'type': 'SEQUENCE'},
                              'CellInfo': {'members': [{'name': 'gsmCell',
                                                        'type': 'GsmCellInformation'},
                                                       {'name': 'wcdmaCell',
                                                        'type': 'WcdmaCellInformation'},
                                                       {'name': 'cdmaCell',
                                                        'type': 'CdmaCellInformation'},
                                                       None,
                                                       {'name': 'ver2-CellInfo-extension',
                                                        'type': 'Ver2-CellInfo-extension'}],
                                           'type': 'CHOICE'},
                              'CellMeasuredResults': {'members': [{'name': 'cellIdentity',
                                                                   'optional': True,
                                                                   'restricted-to': [(0,
                                                                                      268435455)],
                                                                   'type': 'INTEGER'},
                                                                  {'members': [{'members': [{'name': 'primaryCPICH-Info',
                                                                                             'type': 'PrimaryCPICH-Info'},
                                                                                            {'name': 'cpich-Ec-N0',
                                                                                             'optional': True,
                                                                                             'type': 'CPICH-Ec-N0'},
                                                                                            {'name': 'cpich-RSCP',
                                                                                             'optional': True,
                                                                                             'type': 'CPICH-RSCP'},
                                                                                            {'name': 'pathloss',
                                                                                             'optional': True,
                                                                                             'type': 'Pathloss'}],
                                                                                'name': 'fdd',
                                                                                'type': 'SEQUENCE'},
                                                                               {'members': [{'name': 'cellParametersID',
                                                                                             'type': 'CellParametersID'},
                                                                                            {'name': 'proposedTGSN',
                                                                                             'optional': True,
                                                                                             'type': 'TGSN'},
                                                                                            {'name': 'primaryCCPCH-RSCP',
                                                                                             'optional': True,
                                                                                             'type': 'PrimaryCCPCH-RSCP'},
                                                                                            {'name': 'pathloss',
                                                                                             'optional': True,
                                                                                             'type': 'Pathloss'},
                                                                                            {'name': 'timeslotISCP-List',
                                                                                             'optional': True,
                                                                                             'type': 'TimeslotISCP-List'}],
                                                                                'name': 'tdd',
                                                                                'type': 'SEQUENCE'}],
                                                                   'name': 'modeSpecificInfo',
                                                                   'type': 'CHOICE'}],
                                                      'type': 'SEQUENCE'},
                              'CellMeasuredResultsList': {'element': {'type': 'CellMeasuredResults'},
                                                          'size': [(1,
                                                                    'maxCellMeas')],
                                                          'type': 'SEQUENCE '
                                                                  'OF'},
                              'CellParametersID': {'restricted-to': [(0, 127)],
                                                   'type': 'INTEGER'},
                              'ChipRate': {'type': 'ENUMERATED',
                                           'values': [('tdd128', 0),
                                                      ('tdd384', 1),
                                                      ('tdd768', 2),
                                                      None]},
                              'FQDN': {'from': [('a', 'z'),
                                                ('A', 'Z'),
                                                ('0', '9'),
                                                ('.', '.'),
                                                ('-', '-')],
                                       'size': [(1, 255)],
                                       'type': 'VisibleString'},
                              'FrequencyInfo': {'members': [{'members': [{'name': 'fdd',
                                                                          'type': 'FrequencyInfoFDD'},
                                                                         {'name': 'tdd',
                                                                          'type': 'FrequencyInfoTDD'},
                                                                         None],
                                                             'name': 'modeSpecificInfo',
                                                             'type': 'CHOICE'},
                                                            None],
                                                'type': 'SEQUENCE'},
                              'FrequencyInfoFDD': {'members': [{'name': 'uarfcn-UL',
                                                                'optional': True,
                                                                'type': 'UARFCN'},
                                                               {'name': 'uarfcn-DL',
                                                                'type': 'UARFCN'},
                                                               None],
                                                   'type': 'SEQUENCE'},
                              'FrequencyInfoTDD': {'members': [{'name': 'uarfcn-Nt',
                                                                'type': 'UARFCN'},
                                                               None],
                                                   'type': 'SEQUENCE'},
                              'GsmCellInformation': {'members': [{'name': 'refMCC',
                                                                  'restricted-to': [(0,
                                                                                     999)],
                                                                  'type': 'INTEGER'},
                                                                 {'name': 'refMNC',
                                                                  'restricted-to': [(0,
                                                                                     999)],
                                                                  'type': 'INTEGER'},
                                                                 {'name': 'refLAC',
                                                                  'restricted-to': [(0,
                                                                                     65535)],
                                                                  'type': 'INTEGER'},
                                                                 {'name': 'refCI',
                                                                  'restricted-to': [(0,
                                                                                     65535)],
                                                                  'type': 'INTEGER'},
                                                                 {'name': 'nMR',
                                                                  'optional': True,
                                                                  'type': 'NMR'},
                                                                 {'name': 'tA',
                                                                  'optional': True,
                                                                  'restricted-to': [(0,
                                                                                     255)],
                                                                  'type': 'INTEGER'},
                                                                 None],
                                                     'type': 'SEQUENCE'},
                              'Horandveruncert': {'members': [{'name': 'verdirect',
                                                               'size': [1],
                                                               'type': 'BIT '
                                                                       'STRING'},
                                                              {'name': 'bearing',
                                                               'size': [9],
                                                               'type': 'BIT '
                                                                       'STRING'},
                                                              {'name': 'horspeed',
                                                               'size': [16],
                                                               'type': 'BIT '
                                                                       'STRING'},
                                                              {'name': 'verspeed',
                                                               'size': [8],
                                                               'type': 'BIT '
                                                                       'STRING'},
                                                              {'name': 'horuncertspeed',
                                                               'size': [8],
                                                               'type': 'BIT '
                                                                       'STRING'},
                                                              {'name': 'veruncertspeed',
                                                               'size': [8],
                                                               'type': 'BIT '
                                                                       'STRING'},
                                                              None],
                                                  'type': 'SEQUENCE'},
                              'Horandvervel': {'members': [{'name': 'verdirect',
                                                            'size': [1],
                                                            'type': 'BIT '
                                                                    'STRING'},
                                                           {'name': 'bearing',
                                                            'size': [9],
                                                            'type': 'BIT '
                                                                    'STRING'},
                                                           {'name': 'horspeed',
                                                            'size': [16],
                                                            'type': 'BIT '
                                                                    'STRING'},
                                                           {'name': 'verspeed',
                                                            'size': [8],
                                                            'type': 'BIT '
                                                                    'STRING'},
                                                           None],
                                               'type': 'SEQUENCE'},
                              'Horvel': {'members': [{'name': 'bearing',
                                                      'size': [9],
                                                      'type': 'BIT STRING'},
                                                     {'name': 'horspeed',
                                                      'size': [16],
                                                      'type': 'BIT STRING'},
                                                     None],
                                         'type': 'SEQUENCE'},
                              'Horveluncert': {'members': [{'name': 'bearing',
                                                            'size': [9],
                                                            'type': 'BIT '
                                                                    'STRING'},
                                                           {'name': 'horspeed',
                                                            'size': [16],
                                                            'type': 'BIT '
                                                                    'STRING'},
                                                           {'name': 'uncertspeed',
                                                            'size': [8],
                                                            'type': 'BIT '
                                                                    'STRING'},
                                                           None],
                                               'type': 'SEQUENCE'},
                              'IPAddress': {'members': [{'name': 'ipv4Address',
                                                         'size': [4],
                                                         'type': 'OCTET '
                                                                 'STRING'},
                                                        {'name': 'ipv6Address',
                                                         'size': [16],
                                                         'type': 'OCTET '
                                                                 'STRING'}],
                                            'type': 'CHOICE'},
                              'LocationId': {'members': [{'name': 'cellInfo',
                                                          'type': 'CellInfo'},
                                                         {'name': 'status',
                                                          'type': 'Status'},
                                                         None],
                                             'type': 'SEQUENCE'},
                              'MeasuredResults': {'members': [{'name': 'frequencyInfo',
                                                               'optional': True,
                                                               'type': 'FrequencyInfo'},
                                                              {'name': 'utra-CarrierRSSI',
                                                               'optional': True,
                                                               'type': 'UTRA-CarrierRSSI'},
                                                              {'name': 'cellMeasuredResultsList',
                                                               'optional': True,
                                                               'type': 'CellMeasuredResultsList'}],
                                                  'type': 'SEQUENCE'},
                              'MeasuredResultsList': {'element': {'type': 'MeasuredResults'},
                                                      'size': [(1, 'maxFreq')],
                                                      'type': 'SEQUENCE OF'},
                              'NMR': {'element': {'type': 'NMRelement'},
                                      'size': [(1, 15)],
                                      'type': 'SEQUENCE OF'},
                              'NMRelement': {'members': [{'name': 'aRFCN',
                                                          'restricted-to': [(0,
                                                                             1023)],
                                                          'type': 'INTEGER'},
                                                         {'name': 'bSIC',
                                                          'restricted-to': [(0,
                                                                             63)],
                                                          'type': 'INTEGER'},
                                                         {'name': 'rxLev',
                                                          'restricted-to': [(0,
                                                                             63)],
                                                          'type': 'INTEGER'},
                                                         None],
                                             'type': 'SEQUENCE'},
                              'Pathloss': {'restricted-to': [(46, 173)],
                                           'type': 'INTEGER'},
                              'PosMethod': {'type': 'ENUMERATED',
                                            'values': [('agpsSETassisted', 0),
                                                       ('agpsSETbased', 1),
                                                       ('agpsSETassistedpref',
                                                        2),
                                                       ('agpsSETbasedpref', 3),
                                                       ('autonomousGPS', 4),
                                                       ('aFLT', 5),
                                                       ('eCID', 6),
                                                       ('eOTD', 7),
                                                       ('oTDOA', 8),
                                                       ('noPosition', 9),
                                                       None,
                                                       ('ver2-historicalDataRetrieval',
                                                        10),
                                                       ('ver2-agnssSETassisted',
                                                        11),
                                                       ('ver2-agnssSETbased',
                                                        12),
                                                       ('ver2-agnssSETassistedpref',
                                                        13),
                                                       ('ver2-agnssSETbasedpref',
                                                        14),
                                                       ('ver2-autonomousGNSS',
                                                        15),
                                                       ('ver2-sessioninfoquery',
                                                        16),
                                                       ('ver2-mbs', 17)]},
                              'Position': {'members': [{'name': 'timestamp',
                                                        'type': 'UTCTime'},
                                                       {'name': 'positionEstimate',
                                                        'type': 'PositionEstimate'},
                                                       {'name': 'velocity',
                                                        'optional': True,
                                                        'type': 'Velocity'},
                                                       None],
                                           'type': 'SEQUENCE'},
                              'PositionEstimate': {'members': [{'name': 'latitudeSign',
                                                                'type': 'ENUMERATED',
                                                                'values': [('north',
                                                                            0),
                                                                           ('south',
                                                                            1)]},
                                                               {'name': 'latitude',
                                                                'restricted-to': [(0,
                                                                                   8388607)],
                                                                'type': 'INTEGER'},
                                                               {'name': 'longitude',
                                                                'restricted-to': [(-8388608,
                                                                                   8388607)],
                                                                'type': 'INTEGER'},
                                                               {'members': [{'name': 'uncertaintySemiMajor',
                                                                             'restricted-to': [(0,
                                                                                                127)],
                                                                             'type': 'INTEGER'},
                                                                            {'name': 'uncertaintySemiMinor',
                                                                             'restricted-to': [(0,
                                                                                                127)],
                                                                             'type': 'INTEGER'},
                                                                            {'name': 'orientationMajorAxis',
                                                                             'restricted-to': [(0,
                                                                                                180)],
                                                                             'type': 'INTEGER'}],
                                                                'name': 'uncertainty',
                                                                'optional': True,
                                                                'type': 'SEQUENCE'},
                                                               {'name': 'confidence',
                                                                'optional': True,
                                                                'restricted-to': [(0,
                                                                                   100)],
                                                                'type': 'INTEGER'},
                                                               {'name': 'altitudeInfo',
                                                                'optional': True,
                                                                'type': 'AltitudeInfo'},
                                                               None],
                                                   'type': 'SEQUENCE'},
                              'PrimaryCCPCH-RSCP': {'restricted-to': [(0, 127)],
                                                    'type': 'INTEGER'},
                              'PrimaryCPICH-Info': {'members': [{'name': 'primaryScramblingCode',
                                                                 'restricted-to': [(0,
                                                                                    511)],
                                                                 'type': 'INTEGER'}],
                                                    'type': 'SEQUENCE'},
                              'QoP': {'members': [{'name': 'horacc',
                                                   'restricted-to': [(0, 127)],
                                                   'type': 'INTEGER'},
                                                  {'name': 'veracc',
                                                   'optional': True,
                                                   'restricted-to': [(0, 127)],
                                                   'type': 'INTEGER'},
                                                  {'name': 'maxLocAge',
                                                   'optional': True,
                                                   'restricted-to': [(0,
                                                                      65535)],
                                                   'type': 'INTEGER'},
                                                  {'name': 'delay',
                                                   'optional': True,
                                                   'restricted-to': [(0, 7)],
                                                   'type': 'INTEGER'},
                                                  None],
                                      'type': 'SEQUENCE'},
                              'SETId': {'members': [{'name': 'msisdn',
                                                     'size': [8],
                                                     'type': 'OCTET STRING'},
                                                    {'name': 'mdn',
                                                     'size': [8],
                                                     'type': 'OCTET STRING'},
                                                    {'name': 'min',
                                                     'size': [34],
                                                     'type': 'BIT STRING'},
                                                    {'name': 'imsi',
                                                     'size': [8],
                                                     'type': 'OCTET STRING'},
                                                    {'name': 'nai',
                                                     'size': [(1, 1000)],
                                                     'type': 'IA5String'},
                                                    {'name': 'iPAddress',
                                                     'type': 'IPAddress'},
                                                    None,
                                                    {'name': 'imei',
                                                     'size': [8],
                                                     'type': 'OCTET STRING'}],
                                        'type': 'CHOICE'},
                              'SLPAddress': {'members': [{'name': 'iPAddress',
                                                          'type': 'IPAddress'},
                                                         {'name': 'fQDN',
                                                          'type': 'FQDN'},
                                                         None],
                                             'type': 'CHOICE'},
                              'SessionID': {'members': [{'name': 'setSessionID',
                                                         'optional': True,
                                                         'type': 'SetSessionID'},
                                                        {'name': 'slpSessionID',
                                                         'optional': True,
                                                         'type': 'SlpSessionID'}],
                                            'type': 'SEQUENCE'},
                              'SetSessionID': {'members': [{'name': 'sessionId',
                                                            'restricted-to': [(0,
                                                                               65535)],
                                                            'type': 'INTEGER'},
                                                           {'name': 'setId',
                                                            'type': 'SETId'}],
                                               'type': 'SEQUENCE'},
                              'SlpSessionID': {'members': [{'name': 'sessionID',
                                                            'size': [4],
                                                            'type': 'OCTET '
                                                                    'STRING'},
                                                           {'name': 'slpId',
                                                            'type': 'SLPAddress'}],
                                               'type': 'SEQUENCE'},
                              'Status': {'type': 'ENUMERATED',
                                         'values': [('stale', 0),
                                                    ('current', 1),
                                                    ('unknown', 2),
                                                    None]},
                              'StatusCode': {'type': 'ENUMERATED',
                                             'values': [('unspecified', 0),
                                                        ('systemFailure', 1),
                                                        ('unexpectedMessage',
                                                         2),
                                                        ('protocolError', 3),
                                                        ('dataMissing', 4),
                                                        ('unexpectedDataValue',
                                                         5),
                                                        ('posMethodFailure', 6),
                                                        ('posMethodMismatch',
                                                         7),
                                                        ('posProtocolMismatch',
                                                         8),
                                                        ('targetSETnotReachable',
                                                         9),
                                                        ('versionNotSupported',
                                                         10),
                                                        ('resourceShortage',
                                                         11),
                                                        ('invalidSessionId',
                                                         12),
                                                        ('nonProxyModeNotSupported',
                                                         13),
                                                        ('proxyModeNotSupported',
                                                         14),
                                                        ('positioningNotPermitted',
                                                         15),
                                                        ('authNetFailure', 16),
                                                        ('authSuplinitFailure',
                                                         17),
                                                        ('consentDeniedByUser',
                                                         100),
                                                        ('consentGrantedByUser',
                                                         101),
                                                        None,
                                                        ('ver2-incompatibleProtectionLevel',
                                                         18),
                                                        ('ver2-serviceNotSupported',
                                                         19),
                                                        ('ver2-insufficientInterval',
                                                         20),
                                                        ('ver2-noSUPLCoverage',
                                                         21),
                                                        ('ver2-sessionStopped',
                                                         102),
                                                        ('ver2-appIdDenied',
                                                         103)]},
                              'TAResolution': {'type': 'ENUMERATED',
                                               'values': [('res10chip', 0),
                                                          ('res05chip', 1),
                                                          ('res0125chip', 2),
                                                          None]},
                              'TGSN': {'restricted-to': [(0, 14)],
                                       'type': 'INTEGER'},
                              'TimeslotISCP': {'restricted-to': [(0, 127)],
                                               'type': 'INTEGER'},
                              'TimeslotISCP-List': {'element': {'type': 'TimeslotISCP'},
                                                    'size': [(1, 'maxTS')],
                                                    'type': 'SEQUENCE OF'},
                              'TimingAdvance': {'members': [{'name': 'tA',
                                                             'restricted-to': [(0,
                                                                                8191)],
                                                             'type': 'INTEGER'},
                                                            {'name': 'tAResolution',
                                                             'optional': True,
                                                             'type': 'TAResolution'},
                                                            {'name': 'chipRate',
                                                             'optional': True,
                                                             'type': 'ChipRate'},
                                                            None],
                                                'type': 'SEQUENCE'},
                              'UARFCN': {'restricted-to': [(0, 16383)],
                                         'type': 'INTEGER'},
                              'UTRA-CarrierRSSI': {'restricted-to': [(0, 127)],
                                                   'type': 'INTEGER'},
                              'Velocity': {'members': [{'name': 'horvel',
                                                        'type': 'Horvel'},
                                                       {'name': 'horandvervel',
                                                        'type': 'Horandvervel'},
                                                       {'name': 'horveluncert',
                                                        'type': 'Horveluncert'},
                                                       {'name': 'horandveruncert',
                                                        'type': 'Horandveruncert'},
                                                       None],
                                           'type': 'CHOICE'},
                              'Ver': {'size': [64], 'type': 'BIT STRING'},
                              'Version': {'members': [{'name': 'maj',
                                                       'restricted-to': [(0,
                                                                          255)],
                                                       'type': 'INTEGER'},
                                                      {'name': 'min',
                                                       'restricted-to': [(0,
                                                                          255)],
                                                       'type': 'INTEGER'},
                                                      {'name': 'servind',
                                                       'restricted-to': [(0,
                                                                          255)],
                                                       'type': 'INTEGER'}],
                                          'type': 'SEQUENCE'},
                              'WcdmaCellInformation': {'members': [{'name': 'refMCC',
                                                                    'restricted-to': [(0,
                                                                                       999)],
                                                                    'type': 'INTEGER'},
                                                                   {'name': 'refMNC',
                                                                    'restricted-to': [(0,
                                                                                       999)],
                                                                    'type': 'INTEGER'},
                                                                   {'name': 'refUC',
                                                                    'restricted-to': [(0,
                                                                                       268435455)],
                                                                    'type': 'INTEGER'},
                                                                   {'name': 'frequencyInfo',
                                                                    'optional': True,
                                                                    'type': 'FrequencyInfo'},
                                                                   {'name': 'primaryScramblingCode',
                                                                    'optional': True,
                                                                    'restricted-to': [(0,
                                                                                       511)],
                                                                    'type': 'INTEGER'},
                                                                   {'name': 'measuredResultsList',
                                                                    'optional': True,
                                                                    'type': 'MeasuredResultsList'},
                                                                   None,
                                                                   {'name': 'cellParametersId',
                                                                    'optional': True,
                                                                    'restricted-to': [(0,
                                                                                       127)],
                                                                    'type': 'INTEGER'},
                                                                   {'name': 'timingAdvance',
                                                                    'optional': True,
                                                                    'type': 'TimingAdvance'}],
                                                       'type': 'SEQUENCE'}},
                    'values': {'maxCellMeas': {'type': 'INTEGER', 'value': 32},
                               'maxFreq': {'type': 'INTEGER', 'value': 8},
                               'maxTS': {'type': 'INTEGER', 'value': 14}}},
 'ULP-Version-2-message-extensions': {'extensibility-implied': False,
                                      'imports': {'SUPL-START': ['SETCapabilities'],
                                                  'SUPL-TRIGGERED-START': ['TriggerType'],
                                                  'ULP-Components': ['Position',
                                                                     'SLPAddress',
                                                                     'Ver'],
                                                  'Ver2-ULP-Components': ['ApplicationID',
                                                                          'GNSSPosTechnology',
                                                                          'MultipleLocationIds',
                                                                          'SPCSETKey',
                                                                          'SPCSETKeylifetime',
                                                                          'SPCTID',
                                                                          'SupportedNetworkInformation',
                                                                          'ThirdParty',
                                                                          'UTRAN-GANSSReferenceTimeAssistance',
                                                                          'UTRAN-GANSSReferenceTimeResult',
                                                                          'UTRAN-GPSReferenceTimeAssistance',
                                                                          'UTRAN-GPSReferenceTimeResult']},
                                      'object-classes': {},
                                      'object-sets': {},
                                      'tags': 'AUTOMATIC',
                                      'types': {'AllowedReportingType': {'type': 'ENUMERATED',
                                                                         'values': [('positionsOnly',
                                                                                     0),
                                                                                    ('measurementsOnly',
                                                                                     1),
                                                                                    ('positionsAndMeasurements',
                                                                                     2),
                                                                                    None]},
                                                'BasicProtectionParams': {'members': [{'name': 'keyIdentifier',
                                                                                       'size': [8],
                                                                                       'type': 'OCTET '
                                                                                               'STRING'},
                                                                                      {'name': 'basicReplayCounter',
                                                                                       'restricted-to': [(0,
                                                                                                          65535)],
                                                                                       'type': 'INTEGER'},
                                                                                      {'name': 'basicMAC',
                                                                                       'size': [32],
                                                                                       'type': 'BIT '
                                                                                               'STRING'},
                                                                                      None],
                                                                          'type': 'SEQUENCE'},
                                                'HistoricReporting': {'members': [{'name': 'allowedReportingType',
                                                                                   'type': 'AllowedReportingType'},
                                                                                  {'name': 'reportingCriteria',
                                                                                   'optional': True,
                                                                                   'type': 'ReportingCriteria'},
                                                                                  None],
                                                                      'type': 'SEQUENCE'},
                                                'NotificationMode': {'type': 'ENUMERATED',
                                                                     'values': [('normal',
                                                                                 0),
                                                                                ('basedOnLocation',
                                                                                 1),
                                                                                None]},
                                                'ProtLevel': {'type': 'ENUMERATED',
                                                              'values': [('nullProtection',
                                                                          0),
                                                                         ('basicProtection',
                                                                          1),
                                                                         None]},
                                                'ProtectionLevel': {'members': [{'name': 'protlevel',
                                                                                 'type': 'ProtLevel'},
                                                                                {'name': 'basicProtectionParams',
                                                                                 'optional': True,
                                                                                 'type': 'BasicProtectionParams'},
                                                                                None],
                                                                    'type': 'SEQUENCE'},
                                                'ReportingCriteria': {'members': [{'name': 'timeWindow',
                                                                                   'optional': True,
                                                                                   'type': 'TimeWindow'},
                                                                                  {'name': 'maxNumberofReports',
                                                                                   'optional': True,
                                                                                   'restricted-to': [(1,
                                                                                                      65536)],
                                                                                   'type': 'INTEGER'},
                                                                                  {'name': 'minTimeInterval',
                                                                                   'optional': True,
                                                                                   'restricted-to': [(1,
                                                                                                      86400)],
                                                                                   'type': 'INTEGER'},
                                                                                  None],
                                                                      'type': 'SEQUENCE'},
                                                'TimeWindow': {'members': [{'name': 'startTime',
                                                                            'restricted-to': [(-525600,
                                                                                               -1)],
                                                                            'type': 'INTEGER'},
                                                                           {'name': 'stopTime',
                                                                            'restricted-to': [(-525599,
                                                                                               0)],
                                                                            'type': 'INTEGER'}],
                                                               'type': 'SEQUENCE'},
                                                'Ver2-SUPL-END-extension': {'members': [{'name': 'sETCapabilities',
                                                                                         'optional': True,
                                                                                         'type': 'SETCapabilities'},
                                                                                        None],
                                                                            'type': 'SEQUENCE'},
                                                'Ver2-SUPL-INIT-extension': {'members': [{'name': 'notificationMode',
                                                                                          'optional': True,
                                                                                          'type': 'NotificationMode'},
                                                                                         {'name': 'supportedNetworkInformation',
                                                                                          'optional': True,
                                                                                          'type': 'SupportedNetworkInformation'},
                                                                                         {'name': 'triggerType',
                                                                                          'optional': True,
                                                                                          'type': 'TriggerType'},
                                                                                         {'name': 'e-SLPAddress',
                                                                                          'optional': True,
                                                                                          'type': 'SLPAddress'},
                                                                                         {'name': 'historicReporting',
                                                                                          'optional': True,
                                                                                          'type': 'HistoricReporting'},
                                                                                         {'name': 'protectionLevel',
                                                                                          'optional': True,
                                                                                          'type': 'ProtectionLevel'},
                                                                                         {'name': 'gnssPosTechnology',
                                                                                          'optional': True,
                                                                                          'type': 'GNSSPosTechnology'},
                                                                                         {'name': 'minimumMajorVersion',
                                                                                          'optional': True,
                                                                                          'restricted-to': [(0,
                                                                                                             255)],
                                                                                          'type': 'INTEGER'},
                                                                                         None],
                                                                             'type': 'SEQUENCE'},
                                                'Ver2-SUPL-POS-INIT-extension': {'members': [{'name': 'multipleLocationIds',
                                                                                              'optional': True,
                                                                                              'type': 'MultipleLocationIds'},
                                                                                             {'name': 'utran-GPSReferenceTimeResult',
                                                                                              'optional': True,
                                                                                              'type': 'UTRAN-GPSReferenceTimeResult'},
                                                                                             {'name': 'utran-GANSSReferenceTimeResult',
                                                                                              'optional': True,
                                                                                              'type': 'UTRAN-GANSSReferenceTimeResult'},
                                                                                             None],
                                                                                 'type': 'SEQUENCE'},
                                                'Ver2-SUPL-POS-extension': {'members': [{'name': 'utran-GPSReferenceTimeAssistance',
                                                                                         'optional': True,
                                                                                         'type': 'UTRAN-GPSReferenceTimeAssistance'},
                                                                                        {'name': 'utran-GPSReferenceTimeResult',
                                                                                         'optional': True,
                                                                                         'type': 'UTRAN-GPSReferenceTimeResult'},
                                                                                        {'name': 'utran-GANSSReferenceTimeAssistance',
                                                                                         'optional': True,
                                                                                         'type': 'UTRAN-GANSSReferenceTimeAssistance'},
                                                                                        {'name': 'utran-GANSSReferenceTimeResult',
                                                                                         'optional': True,
                                                                                         'type': 'UTRAN-GANSSReferenceTimeResult'},
                                                                                        None],
                                                                            'type': 'SEQUENCE'},
                                                'Ver2-SUPL-RESPONSE-extension': {'members': [{'name': 'supportedNetworkInformation',
                                                                                              'optional': True,
                                                                                              'type': 'SupportedNetworkInformation'},
                                                                                             {'name': 'sPCSETKey',
                                                                                              'optional': True,
                                                                                              'type': 'SPCSETKey'},
                                                                                             {'name': 'sPCTID',
                                                                                              'optional': True,
                                                                                              'type': 'SPCTID'},
                                                                                             {'name': 'sPCSETKeylifetime',
                                                                                              'optional': True,
                                                                                              'type': 'SPCSETKeylifetime'},
                                                                                             {'name': 'initialApproximateposition',
                                                                                              'optional': True,
                                                                                              'type': 'Position'},
                                                                                             {'name': 'gnssPosTechnology',
                                                                                              'optional': True,
                                                                                              'type': 'GNSSPosTechnology'},
                                                                                             None],
                                                                                 'type': 'SEQUENCE'},
                                                'Ver2-SUPL-START-extension': {'members': [{'name': 'multipleLocationIds',
                                                                                           'optional': True,
                                                                                           'type': 'MultipleLocationIds'},
                                                                                          {'name': 'thirdParty',
                                                                                           'optional': True,
                                                                                           'type': 'ThirdParty'},
                                                                                          {'name': 'applicationID',
                                                                                           'optional': True,
                                                                                           'type': 'ApplicationID'},
                                                                                          {'name': 'position',
                                                                                           'optional': True,
                                                                                           'type': 'Position'},
                                                                                          None],
                                                                              'type': 'SEQUENCE'}},
                                      'values': {}},
 'ULP-Version-2-parameter-extensions': {'extensibility-implied': False,
                                        'imports': {'SUPL-TRIGGERED-START': ['maxAreaId',
                                                                             'maxAreaIdList',
                                                                             'maxNumGeoArea'],
                                                    'Ver2-ULP-Components': ['GANSSSignals',
                                                                            'ReportingCap']},
                                        'object-classes': {},
                                        'object-sets': {},
                                        'tags': 'AUTOMATIC',
                                        'types': {'AddPosSupport-Element': {'members': [{'name': 'addPosID',
                                                                                         'type': 'ENUMERATED',
                                                                                         'values': [('mBS',
                                                                                                     0),
                                                                                                    None]},
                                                                                        {'name': 'addPosMode',
                                                                                         'named-bits': [('standalone',
                                                                                                         '0'),
                                                                                                        ('setBased',
                                                                                                         '1'),
                                                                                                        ('setAssisted',
                                                                                                         '2')],
                                                                                         'optional': True,
                                                                                         'size': [(1,
                                                                                                   8)],
                                                                                         'type': 'BIT '
                                                                                                 'STRING'},
                                                                                        None],
                                                                            'type': 'SEQUENCE'},
                                                  'AdditionalPositioningMethods': {'element': {'type': 'AddPosSupport-Element'},
                                                                                   'size': [(1,
                                                                                             8)],
                                                                                   'type': 'SEQUENCE '
                                                                                           'OF'},
                                                  'BDS-Sig-Id-Req': {'size': [8],
                                                                     'type': 'BIT '
                                                                             'STRING'},
                                                  'DGANSS-Sig-Id-Req': {'size': [8],
                                                                        'type': 'BIT '
                                                                                'STRING'},
                                                  'EventTriggerCapabilities': {'members': [{'name': 'geoAreaShapesSupported',
                                                                                            'type': 'GeoAreaShapesSupported'},
                                                                                           {'name': 'maxNumGeoAreaSupported',
                                                                                            'optional': True,
                                                                                            'restricted-to': [(0,
                                                                                                               'maxNumGeoArea')],
                                                                                            'type': 'INTEGER'},
                                                                                           {'name': 'maxAreaIdListSupported',
                                                                                            'optional': True,
                                                                                            'restricted-to': [(0,
                                                                                                               'maxAreaIdList')],
                                                                                            'type': 'INTEGER'},
                                                                                           {'name': 'maxAreaIdSupportedPerList',
                                                                                            'optional': True,
                                                                                            'restricted-to': [(0,
                                                                                                               'maxAreaId')],
                                                                                            'type': 'INTEGER'},
                                                                                           None],
                                                                               'type': 'SEQUENCE'},
                                                  'ExtendedEphCheck': {'members': [{'name': 'beginTime',
                                                                                    'type': 'GPSTime'},
                                                                                   {'name': 'endTime',
                                                                                    'type': 'GPSTime'},
                                                                                   None],
                                                                       'type': 'SEQUENCE'},
                                                  'ExtendedEphemeris': {'members': [{'name': 'validity',
                                                                                     'restricted-to': [(1,
                                                                                                        256)],
                                                                                     'type': 'INTEGER'},
                                                                                    None],
                                                                        'type': 'SEQUENCE'},
                                                  'GANSSPositionMethod': {'members': [{'name': 'ganssId',
                                                                                       'restricted-to': [(0,
                                                                                                          15)],
                                                                                       'type': 'INTEGER'},
                                                                                      {'name': 'ganssSBASid',
                                                                                       'optional': True,
                                                                                       'size': [3],
                                                                                       'type': 'BIT '
                                                                                               'STRING'},
                                                                                      {'name': 'gANSSPositioningMethodTypes',
                                                                                       'type': 'GANSSPositioningMethodTypes'},
                                                                                      {'name': 'gANSSSignals',
                                                                                       'type': 'GANSSSignals'},
                                                                                      None],
                                                                          'type': 'SEQUENCE'},
                                                  'GANSSPositionMethods': {'element': {'type': 'GANSSPositionMethod'},
                                                                           'size': [(1,
                                                                                     16)],
                                                                           'type': 'SEQUENCE '
                                                                                   'OF'},
                                                  'GANSSPositioningMethodTypes': {'members': [{'name': 'setAssisted',
                                                                                               'type': 'BOOLEAN'},
                                                                                              {'name': 'setBased',
                                                                                               'type': 'BOOLEAN'},
                                                                                              {'name': 'autonomous',
                                                                                               'type': 'BOOLEAN'},
                                                                                              None],
                                                                                  'type': 'SEQUENCE'},
                                                  'GANSSextEphTime': {'members': [{'name': 'gANSSday',
                                                                                   'restricted-to': [(0,
                                                                                                      8191)],
                                                                                   'type': 'INTEGER'},
                                                                                  {'name': 'gANSSTODhour',
                                                                                   'restricted-to': [(0,
                                                                                                      23)],
                                                                                   'type': 'INTEGER'},
                                                                                  None],
                                                                      'type': 'SEQUENCE'},
                                                  'GPSTime': {'members': [{'name': 'gPSWeek',
                                                                           'restricted-to': [(0,
                                                                                              1023)],
                                                                           'type': 'INTEGER'},
                                                                          {'name': 'gPSTOWhour',
                                                                           'restricted-to': [(0,
                                                                                              167)],
                                                                           'type': 'INTEGER'},
                                                                          None],
                                                              'type': 'SEQUENCE'},
                                                  'GanssAdditionalDataChoices': {'members': [{'name': 'orbitModelID',
                                                                                              'optional': True,
                                                                                              'restricted-to': [(0,
                                                                                                                 7)],
                                                                                              'type': 'INTEGER'},
                                                                                             {'name': 'clockModelID',
                                                                                              'optional': True,
                                                                                              'restricted-to': [(0,
                                                                                                                 7)],
                                                                                              'type': 'INTEGER'},
                                                                                             {'name': 'utcModelID',
                                                                                              'optional': True,
                                                                                              'restricted-to': [(0,
                                                                                                                 7)],
                                                                                              'type': 'INTEGER'},
                                                                                             {'name': 'almanacModelID',
                                                                                              'optional': True,
                                                                                              'restricted-to': [(0,
                                                                                                                 7)],
                                                                                              'type': 'INTEGER'},
                                                                                             None],
                                                                                 'type': 'SEQUENCE'},
                                                  'GanssDataBits': {'members': [{'name': 'ganssTODmin',
                                                                                 'restricted-to': [(0,
                                                                                                    59)],
                                                                                 'type': 'INTEGER'},
                                                                                {'name': 'reqDataBitAssistanceList',
                                                                                 'type': 'ReqDataBitAssistanceList'},
                                                                                None],
                                                                    'type': 'SEQUENCE'},
                                                  'GanssExtendedEphCheck': {'members': [{'name': 'beginTime',
                                                                                         'type': 'GANSSextEphTime'},
                                                                                        {'name': 'endTime',
                                                                                         'type': 'GANSSextEphTime'},
                                                                                        None],
                                                                            'type': 'SEQUENCE'},
                                                  'GanssNavigationModelData': {'members': [{'name': 'ganssWeek',
                                                                                            'restricted-to': [(0,
                                                                                                               4095)],
                                                                                            'type': 'INTEGER'},
                                                                                           {'name': 'ganssToe',
                                                                                            'restricted-to': [(0,
                                                                                                               167)],
                                                                                            'type': 'INTEGER'},
                                                                                           {'name': 't-toeLimit',
                                                                                            'restricted-to': [(0,
                                                                                                               15)],
                                                                                            'type': 'INTEGER'},
                                                                                           {'name': 'satellitesListRelatedDataList',
                                                                                            'optional': True,
                                                                                            'type': 'SatellitesListRelatedDataList'},
                                                                                           None],
                                                                               'type': 'SEQUENCE'},
                                                  'GanssReqGenericData': {'members': [{'name': 'ganssId',
                                                                                       'restricted-to': [(0,
                                                                                                          15)],
                                                                                       'type': 'INTEGER'},
                                                                                      {'name': 'ganssSBASid',
                                                                                       'optional': True,
                                                                                       'size': [3],
                                                                                       'type': 'BIT '
                                                                                               'STRING'},
                                                                                      {'name': 'ganssRealTimeIntegrity',
                                                                                       'type': 'BOOLEAN'},
                                                                                      {'name': 'ganssDifferentialCorrection',
                                                                                       'optional': True,
                                                                                       'type': 'DGANSS-Sig-Id-Req'},
                                                                                      {'name': 'ganssAlmanac',
                                                                                       'type': 'BOOLEAN'},
                                                                                      {'name': 'ganssNavigationModelData',
                                                                                       'optional': True,
                                                                                       'type': 'GanssNavigationModelData'},
                                                                                      {'name': 'ganssTimeModels',
                                                                                       'optional': True,
                                                                                       'size': [16],
                                                                                       'type': 'BIT '
                                                                                               'STRING'},
                                                                                      {'name': 'ganssReferenceMeasurementInfo',
                                                                                       'type': 'BOOLEAN'},
                                                                                      {'name': 'ganssDataBits',
                                                                                       'optional': True,
                                                                                       'type': 'GanssDataBits'},
                                                                                      {'name': 'ganssUTCModel',
                                                                                       'type': 'BOOLEAN'},
                                                                                      {'name': 'ganssAdditionalDataChoices',
                                                                                       'optional': True,
                                                                                       'type': 'GanssAdditionalDataChoices'},
                                                                                      {'name': 'ganssAuxiliaryInformation',
                                                                                       'type': 'BOOLEAN'},
                                                                                      {'name': 'ganssExtendedEphemeris',
                                                                                       'optional': True,
                                                                                       'type': 'ExtendedEphemeris'},
                                                                                      {'name': 'ganssExtendedEphemerisCheck',
                                                                                       'optional': True,
                                                                                       'type': 'GanssExtendedEphCheck'},
                                                                                      None,
                                                                                      {'name': 'bds-DifferentialCorrection',
                                                                                       'optional': True,
                                                                                       'type': 'BDS-Sig-Id-Req'},
                                                                                      {'name': 'bds-GridModelReq',
                                                                                       'optional': True,
                                                                                       'type': 'BOOLEAN'}],
                                                                          'type': 'SEQUENCE'},
                                                  'GanssRequestedCommonAssistanceDataList': {'members': [{'name': 'ganssReferenceTime',
                                                                                                          'type': 'BOOLEAN'},
                                                                                                         {'name': 'ganssIonosphericModel',
                                                                                                          'type': 'BOOLEAN'},
                                                                                                         {'name': 'ganssAdditionalIonosphericModelForDataID00',
                                                                                                          'type': 'BOOLEAN'},
                                                                                                         {'name': 'ganssAdditionalIonosphericModelForDataID11',
                                                                                                          'type': 'BOOLEAN'},
                                                                                                         {'name': 'ganssEarthOrientationParameters',
                                                                                                          'type': 'BOOLEAN'},
                                                                                                         None,
                                                                                                         {'name': 'ganssAdditionalIonosphericModelForDataID01',
                                                                                                          'optional': True,
                                                                                                          'type': 'BOOLEAN'}],
                                                                                             'type': 'SEQUENCE'},
                                                  'GanssRequestedGenericAssistanceDataList': {'element': {'type': 'GanssReqGenericData'},
                                                                                              'size': [(1,
                                                                                                        'maxGANSS')],
                                                                                              'type': 'SEQUENCE '
                                                                                                      'OF'},
                                                  'GeoAreaShapesSupported': {'members': [{'name': 'ellipticalArea',
                                                                                          'type': 'BOOLEAN'},
                                                                                         {'name': 'polygonArea',
                                                                                          'type': 'BOOLEAN'},
                                                                                         None],
                                                                             'type': 'SEQUENCE'},
                                                  'PosProtocolVersion3GPP': {'members': [{'name': 'majorVersionField',
                                                                                          'restricted-to': [(0,
                                                                                                             255)],
                                                                                          'type': 'INTEGER'},
                                                                                         {'name': 'technicalVersionField',
                                                                                          'restricted-to': [(0,
                                                                                                             255)],
                                                                                          'type': 'INTEGER'},
                                                                                         {'name': 'editorialVersionField',
                                                                                          'restricted-to': [(0,
                                                                                                             255)],
                                                                                          'type': 'INTEGER'},
                                                                                         None],
                                                                             'type': 'SEQUENCE'},
                                                  'PosProtocolVersion3GPP2': {'element': {'type': 'Supported3GPP2PosProtocolVersion'},
                                                                              'size': [(1,
                                                                                        8)],
                                                                              'type': 'SEQUENCE '
                                                                                      'OF'},
                                                  'PosProtocolVersionOMA': {'members': [{'name': 'majorVersionField',
                                                                                         'restricted-to': [(0,
                                                                                                            255)],
                                                                                         'type': 'INTEGER'},
                                                                                        {'name': 'minorVersionField',
                                                                                         'restricted-to': [(0,
                                                                                                            255)],
                                                                                         'type': 'INTEGER'},
                                                                                        None],
                                                                            'type': 'SEQUENCE'},
                                                  'ReqDataBitAssistanceList': {'members': [{'name': 'gnssSignals',
                                                                                            'type': 'GANSSSignals'},
                                                                                           {'name': 'ganssDataBitInterval',
                                                                                            'restricted-to': [(0,
                                                                                                               15)],
                                                                                            'type': 'INTEGER'},
                                                                                           {'element': {'restricted-to': [(0,
                                                                                                                           63)],
                                                                                                        'type': 'INTEGER'},
                                                                                            'name': 'ganssDataBitSatList',
                                                                                            'optional': True,
                                                                                            'size': [(1,
                                                                                                      'maxGANSSSat')],
                                                                                            'type': 'SEQUENCE '
                                                                                                    'OF'},
                                                                                           None],
                                                                               'type': 'SEQUENCE'},
                                                  'SatellitesListRelatedData': {'members': [{'name': 'satId',
                                                                                             'restricted-to': [(0,
                                                                                                                63)],
                                                                                             'type': 'INTEGER'},
                                                                                            {'name': 'iod',
                                                                                             'restricted-to': [(0,
                                                                                                                1023)],
                                                                                             'type': 'INTEGER'},
                                                                                            None],
                                                                                'type': 'SEQUENCE'},
                                                  'SatellitesListRelatedDataList': {'element': {'type': 'SatellitesListRelatedData'},
                                                                                    'size': [(0,
                                                                                              'maxGANSSSat')],
                                                                                    'type': 'SEQUENCE '
                                                                                            'OF'},
                                                  'ServiceCapabilities': {'members': [{'name': 'servicesSupported',
                                                                                       'type': 'ServicesSupported'},
                                                                                      {'name': 'reportingCapabilities',
                                                                                       'optional': True,
                                                                                       'type': 'ReportingCap'},
                                                                                      {'name': 'eventTriggerCapabilities',
                                                                                       'optional': True,
                                                                                       'type': 'EventTriggerCapabilities'},
                                                                                      {'name': 'sessionCapabilities',
                                                                                       'type': 'SessionCapabilities'},
                                                                                      None],
                                                                          'type': 'SEQUENCE'},
                                                  'ServicesSupported': {'members': [{'name': 'periodicTrigger',
                                                                                     'type': 'BOOLEAN'},
                                                                                    {'name': 'areaEventTrigger',
                                                                                     'type': 'BOOLEAN'},
                                                                                    None],
                                                                        'type': 'SEQUENCE'},
                                                  'SessionCapabilities': {'members': [{'name': 'maxNumberTotalSessions',
                                                                                       'restricted-to': [(1,
                                                                                                          128)],
                                                                                       'type': 'INTEGER'},
                                                                                      {'name': 'maxNumberPeriodicSessions',
                                                                                       'restricted-to': [(1,
                                                                                                          32)],
                                                                                       'type': 'INTEGER'},
                                                                                      {'name': 'maxNumberTriggeredSessions',
                                                                                       'restricted-to': [(1,
                                                                                                          32)],
                                                                                       'type': 'INTEGER'},
                                                                                      None],
                                                                          'type': 'SEQUENCE'},
                                                  'Supported3GPP2PosProtocolVersion': {'members': [{'name': 'revisionNumber',
                                                                                                    'size': [6],
                                                                                                    'type': 'BIT '
                                                                                                            'STRING'},
                                                                                                   {'name': 'pointReleaseNumber',
                                                                                                    'restricted-to': [(0,
                                                                                                                       255)],
                                                                                                    'type': 'INTEGER'},
                                                                                                   {'name': 'internalEditLevel',
                                                                                                    'restricted-to': [(0,
                                                                                                                       255)],
                                                                                                    'type': 'INTEGER'},
                                                                                                   None],
                                                                                       'type': 'SEQUENCE'},
                                                  'SupportedBearers': {'members': [{'name': 'gsm',
                                                                                    'type': 'BOOLEAN'},
                                                                                   {'name': 'wcdma',
                                                                                    'type': 'BOOLEAN'},
                                                                                   {'name': 'lte',
                                                                                    'type': 'BOOLEAN'},
                                                                                   {'name': 'cdma',
                                                                                    'type': 'BOOLEAN'},
                                                                                   {'name': 'hprd',
                                                                                    'type': 'BOOLEAN'},
                                                                                   {'name': 'umb',
                                                                                    'type': 'BOOLEAN'},
                                                                                   {'name': 'wlan',
                                                                                    'type': 'BOOLEAN'},
                                                                                   {'name': 'wiMAX',
                                                                                    'type': 'BOOLEAN'},
                                                                                   None],
                                                                       'type': 'SEQUENCE'},
                                                  'Ver2-Notification-extension': {'members': [{'name': 'emergencyCallLocation',
                                                                                               'optional': True,
                                                                                               'type': 'NULL'},
                                                                                              None],
                                                                                  'type': 'SEQUENCE'},
                                                  'Ver2-PosPayLoad-extension': {'members': [{'element': {'size': [(1,
                                                                                                                   60000)],
                                                                                                         'type': 'OCTET '
                                                                                                                 'STRING'},
                                                                                             'name': 'lPPPayload',
                                                                                             'optional': True,
                                                                                             'size': [(1,
                                                                                                       3)],
                                                                                             'type': 'SEQUENCE '
                                                                                                     'OF'},
                                                                                            {'element': {'size': [(1,
                                                                                                                   60000)],
                                                                                                         'type': 'OCTET '
                                                                                                                 'STRING'},
                                                                                             'name': 'tIA801Payload',
                                                                                             'optional': True,
                                                                                             'size': [(1,
                                                                                                       3)],
                                                                                             'type': 'SEQUENCE '
                                                                                                     'OF'},
                                                                                            None],
                                                                                'type': 'SEQUENCE'},
                                                  'Ver2-PosProtocol-extension': {'members': [{'name': 'lpp',
                                                                                              'type': 'BOOLEAN'},
                                                                                             {'name': 'posProtocolVersionRRLP',
                                                                                              'optional': True,
                                                                                              'type': 'PosProtocolVersion3GPP'},
                                                                                             {'name': 'posProtocolVersionRRC',
                                                                                              'optional': True,
                                                                                              'type': 'PosProtocolVersion3GPP'},
                                                                                             {'name': 'posProtocolVersionTIA801',
                                                                                              'optional': True,
                                                                                              'type': 'PosProtocolVersion3GPP2'},
                                                                                             {'name': 'posProtocolVersionLPP',
                                                                                              'optional': True,
                                                                                              'type': 'PosProtocolVersion3GPP'},
                                                                                             None,
                                                                                             {'name': 'lppe',
                                                                                              'optional': True,
                                                                                              'type': 'BOOLEAN'},
                                                                                             {'name': 'posProtocolVersionLPPe',
                                                                                              'optional': True,
                                                                                              'type': 'PosProtocolVersionOMA'}],
                                                                                 'type': 'SEQUENCE'},
                                                  'Ver2-PosTechnology-extension': {'members': [{'name': 'gANSSPositionMethods',
                                                                                                'optional': True,
                                                                                                'type': 'GANSSPositionMethods'},
                                                                                               None,
                                                                                               {'name': 'additionalPositioningMethods',
                                                                                                'optional': True,
                                                                                                'type': 'AdditionalPositioningMethods'}],
                                                                                   'type': 'SEQUENCE'},
                                                  'Ver2-RequestedAssistData-extension': {'members': [{'name': 'ganssRequestedCommonAssistanceDataList',
                                                                                                      'optional': True,
                                                                                                      'type': 'GanssRequestedCommonAssistanceDataList'},
                                                                                                     {'name': 'ganssRequestedGenericAssistanceDataList',
                                                                                                      'optional': True,
                                                                                                      'type': 'GanssRequestedGenericAssistanceDataList'},
                                                                                                     {'name': 'extendedEphemeris',
                                                                                                      'optional': True,
                                                                                                      'type': 'ExtendedEphemeris'},
                                                                                                     {'name': 'extendedEphemerisCheck',
                                                                                                      'optional': True,
                                                                                                      'type': 'ExtendedEphCheck'},
                                                                                                     None],
                                                                                         'type': 'SEQUENCE'},
                                                  'Ver2-SETCapabilities-extension': {'members': [{'name': 'serviceCapabilities',
                                                                                                  'optional': True,
                                                                                                  'type': 'ServiceCapabilities'},
                                                                                                 None,
                                                                                                 {'name': 'supportedBearers',
                                                                                                  'optional': True,
                                                                                                  'type': 'SupportedBearers'}],
                                                                                     'type': 'SEQUENCE'}},
                                        'values': {'maxGANSS': {'type': 'INTEGER',
                                                                'value': 16},
                                                   'maxGANSSSat': {'type': 'INTEGER',
                                                                   'value': 32}}},
 'Ver2-ULP-Components': {'extensibility-implied': False,
                         'imports': {'ULP-Components': ['CellParametersID',
                                                        'FQDN',
                                                        'LocationId',
                                                        'PrimaryCPICH-Info']},
                         'object-classes': {},
                         'object-sets': {},
                         'tags': 'AUTOMATIC',
                         'types': {'ApplicationID': {'members': [{'name': 'appProvider',
                                                                  'size': [(1,
                                                                            24)],
                                                                  'type': 'IA5String'},
                                                                 {'name': 'appName',
                                                                  'size': [(1,
                                                                            32)],
                                                                  'type': 'IA5String'},
                                                                 {'name': 'appVersion',
                                                                  'optional': True,
                                                                  'size': [(1,
                                                                            8)],
                                                                  'type': 'IA5String'},
                                                                 None],
                                                     'type': 'SEQUENCE'},
                                   'BatchRepCap': {'members': [{'name': 'report-position',
                                                                'type': 'BOOLEAN'},
                                                               {'name': 'report-measurements',
                                                                'type': 'BOOLEAN'},
                                                               {'name': 'max-num-positions',
                                                                'optional': True,
                                                                'restricted-to': [(1,
                                                                                   1024)],
                                                                'type': 'INTEGER'},
                                                               {'name': 'max-num-measurements',
                                                                'optional': True,
                                                                'restricted-to': [(1,
                                                                                   1024)],
                                                                'type': 'INTEGER'},
                                                               None],
                                                   'type': 'SEQUENCE'},
                                   'CauseCode': {'type': 'ENUMERATED',
                                                 'values': [('servingNetWorkNotInAreaIdList',
                                                             0),
                                                            ('sETCapabilitiesChanged',
                                                             1),
                                                            ('noSUPLCoverage',
                                                             2),
                                                            None]},
                                   'CellGlobalIdEUTRA': {'members': [{'name': 'plmn-Identity',
                                                                      'type': 'PLMN-Identity'},
                                                                     {'name': 'cellIdentity',
                                                                      'type': 'CellIdentity'},
                                                                     None],
                                                         'type': 'SEQUENCE'},
                                   'CellIdentity': {'size': [28],
                                                    'type': 'BIT STRING'},
                                   'CircularArea': {'members': [{'name': 'coordinate',
                                                                 'type': 'Coordinate'},
                                                                {'name': 'radius',
                                                                 'restricted-to': [(1,
                                                                                    1000000)],
                                                                 'type': 'INTEGER'},
                                                                {'name': 'radius-min',
                                                                 'optional': True,
                                                                 'restricted-to': [(1,
                                                                                    1000000)],
                                                                 'type': 'INTEGER'},
                                                                {'name': 'radius-max',
                                                                 'optional': True,
                                                                 'restricted-to': [(1,
                                                                                    1500000)],
                                                                 'type': 'INTEGER'}],
                                                    'type': 'SEQUENCE'},
                                   'Coordinate': {'members': [{'name': 'latitudeSign',
                                                               'type': 'ENUMERATED',
                                                               'values': [('north',
                                                                           0),
                                                                          ('south',
                                                                           1)]},
                                                              {'name': 'latitude',
                                                               'restricted-to': [(0,
                                                                                  8388607)],
                                                               'type': 'INTEGER'},
                                                              {'name': 'longitude',
                                                               'restricted-to': [(-8388608,
                                                                                  8388607)],
                                                               'type': 'INTEGER'}],
                                                  'type': 'SEQUENCE'},
                                   'EllipticalArea': {'members': [{'name': 'coordinate',
                                                                   'type': 'Coordinate'},
                                                                  {'name': 'semiMajor',
                                                                   'restricted-to': [(1,
                                                                                      1000000)],
                                                                   'type': 'INTEGER'},
                                                                  {'name': 'semiMajor-min',
                                                                   'optional': True,
                                                                   'restricted-to': [(1,
                                                                                      1000000)],
                                                                   'type': 'INTEGER'},
                                                                  {'name': 'semiMajor-max',
                                                                   'optional': True,
                                                                   'restricted-to': [(1,
                                                                                      1500000)],
                                                                   'type': 'INTEGER'},
                                                                  {'name': 'semiMinor',
                                                                   'restricted-to': [(1,
                                                                                      1000000)],
                                                                   'type': 'INTEGER'},
                                                                  {'name': 'semiMinor-min',
                                                                   'optional': True,
                                                                   'restricted-to': [(1,
                                                                                      1000000)],
                                                                   'type': 'INTEGER'},
                                                                  {'name': 'semiMinor-max',
                                                                   'optional': True,
                                                                   'restricted-to': [(1,
                                                                                      1500000)],
                                                                   'type': 'INTEGER'},
                                                                  {'name': 'angle',
                                                                   'restricted-to': [(0,
                                                                                      179)],
                                                                   'type': 'INTEGER'}],
                                                      'type': 'SEQUENCE'},
                                   'GANSSSignals': {'named-bits': [('signal1',
                                                                    '0'),
                                                                   ('signal2',
                                                                    '1'),
                                                                   ('signal3',
                                                                    '2'),
                                                                   ('signal4',
                                                                    '3'),
                                                                   ('signal5',
                                                                    '4'),
                                                                   ('signal6',
                                                                    '5'),
                                                                   ('signal7',
                                                                    '6'),
                                                                   ('signal8',
                                                                    '7')],
                                                    'size': [(1, 8)],
                                                    'type': 'BIT STRING'},
                                   'GNSSPosTechnology': {'members': [{'name': 'gps',
                                                                      'type': 'BOOLEAN'},
                                                                     {'name': 'galileo',
                                                                      'type': 'BOOLEAN'},
                                                                     {'name': 'sbas',
                                                                      'type': 'BOOLEAN'},
                                                                     {'name': 'modernized-gps',
                                                                      'type': 'BOOLEAN'},
                                                                     {'name': 'qzss',
                                                                      'type': 'BOOLEAN'},
                                                                     {'name': 'glonass',
                                                                      'type': 'BOOLEAN'},
                                                                     None,
                                                                     {'name': 'bds',
                                                                      'optional': True,
                                                                      'type': 'BOOLEAN'}],
                                                         'type': 'SEQUENCE'},
                                   'HrpdCellInformation': {'members': [{'name': 'refSECTORID',
                                                                        'optional': True,
                                                                        'size': [128],
                                                                        'type': 'BIT '
                                                                                'STRING'},
                                                                       {'name': 'refBASELAT',
                                                                        'restricted-to': [(0,
                                                                                           4194303)],
                                                                        'type': 'INTEGER'},
                                                                       {'name': 'reBASELONG',
                                                                        'restricted-to': [(0,
                                                                                           8388607)],
                                                                        'type': 'INTEGER'},
                                                                       {'name': 'refWeekNumber',
                                                                        'restricted-to': [(0,
                                                                                           65535)],
                                                                        'type': 'INTEGER'},
                                                                       {'name': 'refSeconds',
                                                                        'restricted-to': [(0,
                                                                                           4194303)],
                                                                        'type': 'INTEGER'},
                                                                       None],
                                                           'type': 'SEQUENCE'},
                                   'LciLocData': {'members': [{'name': 'locationDataLCI',
                                                               'optional': True,
                                                               'type': 'LocationDataLCI'},
                                                              None],
                                                  'type': 'SEQUENCE'},
                                   'LocationData': {'members': [{'name': 'locationAccuracy',
                                                                 'optional': True,
                                                                 'restricted-to': [(0,
                                                                                    4294967295)],
                                                                 'type': 'INTEGER'},
                                                                {'name': 'locationValue',
                                                                 'size': [(1,
                                                                           128)],
                                                                 'type': 'OCTET '
                                                                         'STRING'},
                                                                None],
                                                    'type': 'SEQUENCE'},
                                   'LocationDataLCI': {'members': [{'name': 'latitudeResolution',
                                                                    'size': [6],
                                                                    'type': 'BIT '
                                                                            'STRING'},
                                                                   {'name': 'latitude',
                                                                    'size': [34],
                                                                    'type': 'BIT '
                                                                            'STRING'},
                                                                   {'name': 'longitudeResolution',
                                                                    'size': [6],
                                                                    'type': 'BIT '
                                                                            'STRING'},
                                                                   {'name': 'longitude',
                                                                    'size': [34],
                                                                    'type': 'BIT '
                                                                            'STRING'},
                                                                   {'name': 'altitudeType',
                                                                    'size': [4],
                                                                    'type': 'BIT '
                                                                            'STRING'},
                                                                   {'name': 'altitudeResolution',
                                                                    'size': [6],
                                                                    'type': 'BIT '
                                                                            'STRING'},
                                                                   {'name': 'altitude',
                                                                    'size': [30],
                                                                    'type': 'BIT '
                                                                            'STRING'},
                                                                   {'name': 'datum',
                                                                    'size': [8],
                                                                    'type': 'BIT '
                                                                            'STRING'},
                                                                   None],
                                                       'type': 'SEQUENCE'},
                                   'LocationEncodingDescriptor': {'type': 'ENUMERATED',
                                                                  'values': [('lCI',
                                                                              0),
                                                                             ('aSN1',
                                                                              1),
                                                                             None]},
                                   'LocationIdData': {'members': [{'name': 'locationId',
                                                                   'type': 'LocationId'},
                                                                  {'name': 'relativetimestamp',
                                                                   'optional': True,
                                                                   'type': 'RelativeTime'},
                                                                  {'name': 'servingFlag',
                                                                   'type': 'BOOLEAN'},
                                                                  None],
                                                      'type': 'SEQUENCE'},
                                   'LteCellInformation': {'members': [{'name': 'cellGlobalIdEUTRA',
                                                                       'type': 'CellGlobalIdEUTRA'},
                                                                      {'name': 'physCellId',
                                                                       'type': 'PhysCellId'},
                                                                      {'name': 'trackingAreaCode',
                                                                       'type': 'TrackingAreaCode'},
                                                                      {'name': 'rsrpResult',
                                                                       'optional': True,
                                                                       'type': 'RSRP-Range'},
                                                                      {'name': 'rsrqResult',
                                                                       'optional': True,
                                                                       'type': 'RSRQ-Range'},
                                                                      {'name': 'tA',
                                                                       'optional': True,
                                                                       'restricted-to': [(0,
                                                                                          1282)],
                                                                       'type': 'INTEGER'},
                                                                      {'name': 'measResultListEUTRA',
                                                                       'optional': True,
                                                                       'type': 'MeasResultListEUTRA'},
                                                                      None,
                                                                      {'name': 'earfcn',
                                                                       'optional': True,
                                                                       'restricted-to': [(0,
                                                                                          65535)],
                                                                       'type': 'INTEGER'},
                                                                      {'name': 'earfcn-ext',
                                                                       'optional': True,
                                                                       'restricted-to': [(65536,
                                                                                          262143)],
                                                                       'type': 'INTEGER'}],
                                                          'type': 'SEQUENCE'},
                                   'MCC': {'element': {'type': 'MCC-MNC-Digit'},
                                           'size': [3],
                                           'type': 'SEQUENCE OF'},
                                   'MCC-MNC-Digit': {'restricted-to': [(0, 9)],
                                                     'type': 'INTEGER'},
                                   'MNC': {'element': {'type': 'MCC-MNC-Digit'},
                                           'size': [(2, 3)],
                                           'type': 'SEQUENCE OF'},
                                   'MeasResultEUTRA': {'members': [{'name': 'physCellId',
                                                                    'type': 'PhysCellId'},
                                                                   {'members': [{'name': 'cellGlobalId',
                                                                                 'type': 'CellGlobalIdEUTRA'},
                                                                                {'name': 'trackingAreaCode',
                                                                                 'type': 'TrackingAreaCode'}],
                                                                    'name': 'cgi-Info',
                                                                    'optional': True,
                                                                    'type': 'SEQUENCE'},
                                                                   {'members': [{'name': 'rsrpResult',
                                                                                 'optional': True,
                                                                                 'type': 'RSRP-Range'},
                                                                                {'name': 'rsrqResult',
                                                                                 'optional': True,
                                                                                 'type': 'RSRQ-Range'},
                                                                                None,
                                                                                {'name': 'earfcn',
                                                                                 'optional': True,
                                                                                 'restricted-to': [(0,
                                                                                                    65535)],
                                                                                 'type': 'INTEGER'},
                                                                                {'name': 'earfcn-ext',
                                                                                 'optional': True,
                                                                                 'restricted-to': [(65536,
                                                                                                    262143)],
                                                                                 'type': 'INTEGER'}],
                                                                    'name': 'measResult',
                                                                    'type': 'SEQUENCE'}],
                                                       'type': 'SEQUENCE'},
                                   'MeasResultListEUTRA': {'element': {'type': 'MeasResultEUTRA'},
                                                           'size': [(1,
                                                                     'maxCellReport')],
                                                           'type': 'SEQUENCE '
                                                                   'OF'},
                                   'MultipleLocationIds': {'element': {'type': 'LocationIdData'},
                                                           'size': [(1,
                                                                     'maxLidSize')],
                                                           'type': 'SEQUENCE '
                                                                   'OF'},
                                   'PLMN-Identity': {'members': [{'name': 'mcc',
                                                                  'optional': True,
                                                                  'type': 'MCC'},
                                                                 {'name': 'mnc',
                                                                  'type': 'MNC'}],
                                                     'type': 'SEQUENCE'},
                                   'PhysCellId': {'restricted-to': [(0, 503)],
                                                  'type': 'INTEGER'},
                                   'PolygonArea': {'members': [{'name': 'polygonDescription',
                                                                'type': 'PolygonDescription'},
                                                               {'name': 'polygonHysteresis',
                                                                'optional': True,
                                                                'restricted-to': [(1,
                                                                                   100000)],
                                                                'type': 'INTEGER'}],
                                                   'type': 'SEQUENCE'},
                                   'PolygonDescription': {'element': {'type': 'Coordinate'},
                                                          'size': [(3, 15)],
                                                          'type': 'SEQUENCE '
                                                                  'OF'},
                                   'RSRP-Range': {'restricted-to': [(0, 97)],
                                                  'type': 'INTEGER'},
                                   'RSRQ-Range': {'restricted-to': [(0, 34)],
                                                  'type': 'INTEGER'},
                                   'RTD': {'members': [{'name': 'rTDValue',
                                                        'restricted-to': [(0,
                                                                           16777216)],
                                                        'type': 'INTEGER'},
                                                       {'name': 'rTDUnits',
                                                        'type': 'RTDUnits'},
                                                       {'name': 'rTDAccuracy',
                                                        'optional': True,
                                                        'restricted-to': [(0,
                                                                           255)],
                                                        'type': 'INTEGER'},
                                                       None],
                                           'type': 'SEQUENCE'},
                                   'RTDUnits': {'type': 'ENUMERATED',
                                                'values': [('microseconds', 0),
                                                           ('hundredsofnanoseconds',
                                                            1),
                                                           ('tensofnanoseconds',
                                                            2),
                                                           ('nanoseconds', 3),
                                                           ('tenthsofnanoseconds',
                                                            4),
                                                           None]},
                                   'RelativeTime': {'restricted-to': [(0,
                                                                       65535)],
                                                    'type': 'INTEGER'},
                                   'RepLocation': {'members': [{'name': 'lciLocData',
                                                                'type': 'LciLocData'},
                                                               None],
                                                   'type': 'CHOICE'},
                                   'RepMode': {'members': [{'name': 'realtime',
                                                            'type': 'BOOLEAN'},
                                                           {'name': 'quasirealtime',
                                                            'type': 'BOOLEAN'},
                                                           {'name': 'batch',
                                                            'type': 'BOOLEAN'},
                                                           None],
                                               'type': 'SEQUENCE'},
                                   'ReportedLocation': {'members': [{'name': 'locationEncodingDescriptor',
                                                                     'type': 'LocationEncodingDescriptor'},
                                                                    {'name': 'locationData',
                                                                     'type': 'LocationData'},
                                                                    None],
                                                        'type': 'SEQUENCE'},
                                   'ReportingCap': {'members': [{'name': 'minInt',
                                                                 'restricted-to': [(1,
                                                                                    3600)],
                                                                 'type': 'INTEGER'},
                                                                {'name': 'maxInt',
                                                                 'optional': True,
                                                                 'restricted-to': [(1,
                                                                                    1440)],
                                                                 'type': 'INTEGER'},
                                                                {'name': 'repMode',
                                                                 'type': 'RepMode'},
                                                                {'name': 'batchRepCap',
                                                                 'optional': True,
                                                                 'type': 'BatchRepCap'},
                                                                None],
                                                    'type': 'SEQUENCE'},
                                   'SET-GANSSReferenceTime': {'members': [{'members': [{'name': 'ms-part',
                                                                                        'restricted-to': [(0,
                                                                                                           80)],
                                                                                        'type': 'INTEGER'},
                                                                                       {'name': 'ls-part',
                                                                                        'restricted-to': [(0,
                                                                                                           4294967295)],
                                                                                        'type': 'INTEGER'}],
                                                                           'name': 'set-GANSSTimingOfCell',
                                                                           'optional': True,
                                                                           'type': 'SEQUENCE'},
                                                                          {'members': [{'members': [{'name': 'referenceIdentity',
                                                                                                     'type': 'PrimaryCPICH-Info'}],
                                                                                        'name': 'fdd',
                                                                                        'type': 'SEQUENCE'},
                                                                                       {'members': [{'name': 'referenceIdentity',
                                                                                                     'type': 'CellParametersID'}],
                                                                                        'name': 'tdd',
                                                                                        'type': 'SEQUENCE'}],
                                                                           'name': 'modeSpecificInfo',
                                                                           'optional': True,
                                                                           'type': 'CHOICE'},
                                                                          {'name': 'sfn',
                                                                           'restricted-to': [(0,
                                                                                              4095)],
                                                                           'type': 'INTEGER'},
                                                                          {'name': 'ganss-TODUncertainty',
                                                                           'optional': True,
                                                                           'restricted-to': [(0,
                                                                                              127)],
                                                                           'type': 'INTEGER'},
                                                                          None],
                                                              'type': 'SEQUENCE'},
                                   'SPCSETKey': {'size': [128],
                                                 'type': 'BIT STRING'},
                                   'SPCSETKeylifetime': {'restricted-to': [(1,
                                                                            24)],
                                                         'type': 'INTEGER'},
                                   'SPCTID': {'members': [{'name': 'rAND',
                                                           'size': [128],
                                                           'type': 'BIT '
                                                                   'STRING'},
                                                          {'name': 'slpFQDN',
                                                           'type': 'FQDN'},
                                                          None],
                                              'type': 'SEQUENCE'},
                                   'SupportedNetworkInformation': {'members': [{'name': 'wLAN',
                                                                                'type': 'BOOLEAN'},
                                                                               {'name': 'supportedWLANInfo',
                                                                                'optional': True,
                                                                                'type': 'SupportedWLANInfo'},
                                                                               {'name': 'supportedWLANApsList',
                                                                                'optional': True,
                                                                                'type': 'SupportedWLANApsList'},
                                                                               {'name': 'gSM',
                                                                                'type': 'BOOLEAN'},
                                                                               {'name': 'wCDMA',
                                                                                'type': 'BOOLEAN'},
                                                                               {'name': 'supportedWCDMAInfo',
                                                                                'optional': True,
                                                                                'type': 'SupportedWCDMAInfo'},
                                                                               {'name': 'cDMA',
                                                                                'type': 'BOOLEAN'},
                                                                               {'name': 'hRDP',
                                                                                'type': 'BOOLEAN'},
                                                                               {'name': 'uMB',
                                                                                'type': 'BOOLEAN'},
                                                                               {'name': 'lTE',
                                                                                'type': 'BOOLEAN'},
                                                                               {'name': 'wIMAX',
                                                                                'type': 'BOOLEAN'},
                                                                               {'name': 'historic',
                                                                                'type': 'BOOLEAN'},
                                                                               {'name': 'nonServing',
                                                                                'type': 'BOOLEAN'},
                                                                               {'name': 'uTRANGPSReferenceTime',
                                                                                'type': 'BOOLEAN'},
                                                                               {'name': 'uTRANGANSSReferenceTime',
                                                                                'type': 'BOOLEAN'},
                                                                               None],
                                                                   'type': 'SEQUENCE'},
                                   'SupportedWCDMAInfo': {'members': [{'name': 'mRL',
                                                                       'type': 'BOOLEAN'},
                                                                      None],
                                                          'type': 'SEQUENCE'},
                                   'SupportedWLANApData': {'members': [{'name': 'apMACAddress',
                                                                        'size': [48],
                                                                        'type': 'BIT '
                                                                                'STRING'},
                                                                       {'name': 'apDevType',
                                                                        'type': 'ENUMERATED',
                                                                        'values': [('wlan802-11a',
                                                                                    0),
                                                                                   ('wlan802-11b',
                                                                                    1),
                                                                                   ('wlan802-11g',
                                                                                    2),
                                                                                   None]},
                                                                       None],
                                                           'type': 'SEQUENCE'},
                                   'SupportedWLANApsChannel11a': {'members': [{'name': 'ch34',
                                                                               'type': 'BOOLEAN'},
                                                                              {'name': 'ch36',
                                                                               'type': 'BOOLEAN'},
                                                                              {'name': 'ch38',
                                                                               'type': 'BOOLEAN'},
                                                                              {'name': 'ch40',
                                                                               'type': 'BOOLEAN'},
                                                                              {'name': 'ch42',
                                                                               'type': 'BOOLEAN'},
                                                                              {'name': 'ch44',
                                                                               'type': 'BOOLEAN'},
                                                                              {'name': 'ch46',
                                                                               'type': 'BOOLEAN'},
                                                                              {'name': 'ch48',
                                                                               'type': 'BOOLEAN'},
                                                                              {'name': 'ch52',
                                                                               'type': 'BOOLEAN'},
                                                                              {'name': 'ch56',
                                                                               'type': 'BOOLEAN'},
                                                                              {'name': 'ch60',
                                                                               'type': 'BOOLEAN'},
                                                                              {'name': 'ch64',
                                                                               'type': 'BOOLEAN'},
                                                                              {'name': 'ch149',
                                                                               'type': 'BOOLEAN'},
                                                                              {'name': 'ch153',
                                                                               'type': 'BOOLEAN'},
                                                                              {'name': 'ch157',
                                                                               'type': 'BOOLEAN'},
                                                                              {'name': 'ch161',
                                                                               'type': 'BOOLEAN'}],
                                                                  'type': 'SEQUENCE'},
                                   'SupportedWLANApsChannel11bg': {'members': [{'name': 'ch1',
                                                                                'type': 'BOOLEAN'},
                                                                               {'name': 'ch2',
                                                                                'type': 'BOOLEAN'},
                                                                               {'name': 'ch3',
                                                                                'type': 'BOOLEAN'},
                                                                               {'name': 'ch4',
                                                                                'type': 'BOOLEAN'},
                                                                               {'name': 'ch5',
                                                                                'type': 'BOOLEAN'},
                                                                               {'name': 'ch6',
                                                                                'type': 'BOOLEAN'},
                                                                               {'name': 'ch7',
                                                                                'type': 'BOOLEAN'},
                                                                               {'name': 'ch8',
                                                                                'type': 'BOOLEAN'},
                                                                               {'name': 'ch9',
                                                                                'type': 'BOOLEAN'},
                                                                               {'name': 'ch10',
                                                                                'type': 'BOOLEAN'},
                                                                               {'name': 'ch11',
                                                                                'type': 'BOOLEAN'},
                                                                               {'name': 'ch12',
                                                                                'type': 'BOOLEAN'},
                                                                               {'name': 'ch13',
                                                                                'type': 'BOOLEAN'},
                                                                               {'name': 'ch14',
                                                                                'type': 'BOOLEAN'}],
                                                                   'type': 'SEQUENCE'},
                                   'SupportedWLANApsList': {'members': [{'element': {'type': 'SupportedWLANApData'},
                                                                         'name': 'supportedWLANApDataList',
                                                                         'size': [(1,
                                                                                   'maxWLANApDataSize')],
                                                                         'type': 'SEQUENCE '
                                                                                 'OF'},
                                                                        {'name': 'supportedWLANapsChannel11a',
                                                                         'optional': True,
                                                                         'type': 'SupportedWLANApsChannel11a'},
                                                                        {'name': 'supportedWLANapsChannel11bg',
                                                                         'optional': True,
                                                                         'type': 'SupportedWLANApsChannel11bg'},
                                                                        None],
                                                            'type': 'SEQUENCE'},
                                   'SupportedWLANInfo': {'members': [{'name': 'apTP',
                                                                      'type': 'BOOLEAN'},
                                                                     {'name': 'apAG',
                                                                      'type': 'BOOLEAN'},
                                                                     {'name': 'apSN',
                                                                      'type': 'BOOLEAN'},
                                                                     {'name': 'apDevType',
                                                                      'type': 'BOOLEAN'},
                                                                     {'name': 'apRSSI',
                                                                      'type': 'BOOLEAN'},
                                                                     {'name': 'apChanFreq',
                                                                      'type': 'BOOLEAN'},
                                                                     {'name': 'apRTD',
                                                                      'type': 'BOOLEAN'},
                                                                     {'name': 'setTP',
                                                                      'type': 'BOOLEAN'},
                                                                     {'name': 'setAG',
                                                                      'type': 'BOOLEAN'},
                                                                     {'name': 'setSN',
                                                                      'type': 'BOOLEAN'},
                                                                     {'name': 'setRSSI',
                                                                      'type': 'BOOLEAN'},
                                                                     {'name': 'apRepLoc',
                                                                      'type': 'BOOLEAN'},
                                                                     None],
                                                         'type': 'SEQUENCE'},
                                   'ThirdParty': {'element': {'type': 'ThirdPartyID'},
                                                  'size': [(1, 64)],
                                                  'type': 'SEQUENCE OF'},
                                   'ThirdPartyID': {'members': [{'name': 'logicalName',
                                                                 'size': [(1,
                                                                           1000)],
                                                                 'type': 'IA5String'},
                                                                {'name': 'msisdn',
                                                                 'size': [8],
                                                                 'type': 'OCTET '
                                                                         'STRING'},
                                                                {'name': 'emailaddr',
                                                                 'size': [(1,
                                                                           1000)],
                                                                 'type': 'IA5String'},
                                                                {'from': [('a',
                                                                           'z'),
                                                                          ('A',
                                                                           'Z'),
                                                                          ('0',
                                                                           '9'),
                                                                          (':',
                                                                           ':'),
                                                                          ('.',
                                                                           '.'),
                                                                          ('/',
                                                                           '/'),
                                                                          ('-',
                                                                           '-'),
                                                                          ('_',
                                                                           '_'),
                                                                          ('~',
                                                                           '~'),
                                                                          ('%',
                                                                           '%'),
                                                                          ('#',
                                                                           '#'),
                                                                          ('@',
                                                                           '@'),
                                                                          ('?',
                                                                           '?')],
                                                                 'name': 'sip-uri',
                                                                 'size': [(1,
                                                                           255)],
                                                                 'type': 'VisibleString'},
                                                                {'from': [('a',
                                                                           'z'),
                                                                          ('A',
                                                                           'Z'),
                                                                          ('0',
                                                                           '9'),
                                                                          (':',
                                                                           ':'),
                                                                          ('.',
                                                                           '.'),
                                                                          ('/',
                                                                           '/'),
                                                                          ('-',
                                                                           '-'),
                                                                          ('_',
                                                                           '_'),
                                                                          ('~',
                                                                           '~'),
                                                                          ('%',
                                                                           '%'),
                                                                          ('#',
                                                                           '#'),
                                                                          ('@',
                                                                           '@'),
                                                                          ('?',
                                                                           '?')],
                                                                 'name': 'ims-public-identity',
                                                                 'size': [(1,
                                                                           255)],
                                                                 'type': 'VisibleString'},
                                                                {'name': 'min',
                                                                 'size': [34],
                                                                 'type': 'BIT '
                                                                         'STRING'},
                                                                {'name': 'mdn',
                                                                 'size': [8],
                                                                 'type': 'OCTET '
                                                                         'STRING'},
                                                                {'from': [('a',
                                                                           'z'),
                                                                          ('A',
                                                                           'Z'),
                                                                          ('0',
                                                                           '9'),
                                                                          ('.',
                                                                           '.'),
                                                                          ('/',
                                                                           '/'),
                                                                          ('-',
                                                                           '-'),
                                                                          ('_',
                                                                           '_'),
                                                                          ('~',
                                                                           '~'),
                                                                          ('%',
                                                                           '%'),
                                                                          ('#',
                                                                           '#')],
                                                                 'name': 'uri',
                                                                 'size': [(1,
                                                                           255)],
                                                                 'type': 'VisibleString'},
                                                                None],
                                                    'type': 'CHOICE'},
                                   'TrackingAreaCode': {'size': [16],
                                                        'type': 'BIT STRING'},
                                   'UTRAN-GANSSReferenceTime': {'members': [{'name': 'ganssTOD',
                                                                             'restricted-to': [(0,
                                                                                                86399)],
                                                                             'type': 'INTEGER'},
                                                                            {'name': 'utran-GANSSTimingOfCell',
                                                                             'optional': True,
                                                                             'restricted-to': [(0,
                                                                                                3999999)],
                                                                             'type': 'INTEGER'},
                                                                            {'members': [{'members': [{'name': 'referenceIdentity',
                                                                                                       'type': 'PrimaryCPICH-Info'}],
                                                                                          'name': 'fdd',
                                                                                          'type': 'SEQUENCE'},
                                                                                         {'members': [{'name': 'referenceIdentity',
                                                                                                       'type': 'CellParametersID'}],
                                                                                          'name': 'tdd',
                                                                                          'type': 'SEQUENCE'}],
                                                                             'name': 'modeSpecificInfo',
                                                                             'optional': True,
                                                                             'type': 'CHOICE'},
                                                                            {'name': 'sfn',
                                                                             'restricted-to': [(0,
                                                                                                4095)],
                                                                             'type': 'INTEGER'},
                                                                            {'name': 'ganss-TODUncertainty',
                                                                             'optional': True,
                                                                             'restricted-to': [(0,
                                                                                                127)],
                                                                             'type': 'INTEGER'},
                                                                            None],
                                                                'type': 'SEQUENCE'},
                                   'UTRAN-GANSSReferenceTimeAssistance': {'members': [{'name': 'ganssDay',
                                                                                       'optional': True,
                                                                                       'restricted-to': [(0,
                                                                                                          8191)],
                                                                                       'type': 'INTEGER'},
                                                                                      {'name': 'ganssTimeID',
                                                                                       'restricted-to': [(0,
                                                                                                          15)],
                                                                                       'type': 'INTEGER'},
                                                                                      {'name': 'utran-GANSSReferenceTime',
                                                                                       'type': 'UTRAN-GANSSReferenceTime'},
                                                                                      {'name': 'utranGANSSDriftRate',
                                                                                       'optional': True,
                                                                                       'type': 'UTRANGANSSDriftRate'}],
                                                                          'type': 'SEQUENCE'},
                                   'UTRAN-GANSSReferenceTimeResult': {'members': [{'name': 'ganssTimeID',
                                                                                   'restricted-to': [(0,
                                                                                                      15)],
                                                                                   'type': 'INTEGER'},
                                                                                  {'name': 'set-GANSSReferenceTime',
                                                                                   'type': 'SET-GANSSReferenceTime'},
                                                                                  None],
                                                                      'type': 'SEQUENCE'},
                                   'UTRAN-GPSReferenceTime': {'members': [{'members': [{'name': 'ms-part',
                                                                                        'restricted-to': [(0,
                                                                                                           1023)],
                                                                                        'type': 'INTEGER'},
                                                                                       {'name': 'ls-part',
                                                                                        'restricted-to': [(0,
                                                                                                           4294967295)],
                                                                                        'type': 'INTEGER'}],
                                                                           'name': 'utran-GPSTimingOfCell',
                                                                           'type': 'SEQUENCE'},
                                                                          {'members': [{'members': [{'name': 'referenceIdentity',
                                                                                                     'type': 'PrimaryCPICH-Info'}],
                                                                                        'name': 'fdd',
                                                                                        'type': 'SEQUENCE'},
                                                                                       {'members': [{'name': 'referenceIdentity',
                                                                                                     'type': 'CellParametersID'}],
                                                                                        'name': 'tdd',
                                                                                        'type': 'SEQUENCE'}],
                                                                           'name': 'modeSpecificInfo',
                                                                           'optional': True,
                                                                           'type': 'CHOICE'},
                                                                          {'name': 'sfn',
                                                                           'restricted-to': [(0,
                                                                                              4095)],
                                                                           'type': 'INTEGER'}],
                                                              'type': 'SEQUENCE'},
                                   'UTRAN-GPSReferenceTimeAssistance': {'members': [{'name': 'utran-GPSReferenceTime',
                                                                                     'type': 'UTRAN-GPSReferenceTime'},
                                                                                    {'name': 'gpsReferenceTimeUncertainty',
                                                                                     'optional': True,
                                                                                     'restricted-to': [(0,
                                                                                                        127)],
                                                                                     'type': 'INTEGER'},
                                                                                    {'name': 'utranGPSDriftRate',
                                                                                     'optional': True,
                                                                                     'type': 'UTRANGPSDriftRate'}],
                                                                        'type': 'SEQUENCE'},
                                   'UTRAN-GPSReferenceTimeResult': {'members': [{'members': [{'name': 'ms-part',
                                                                                              'restricted-to': [(0,
                                                                                                                 16383)],
                                                                                              'type': 'INTEGER'},
                                                                                             {'name': 'ls-part',
                                                                                              'restricted-to': [(0,
                                                                                                                 4294967295)],
                                                                                              'type': 'INTEGER'}],
                                                                                 'name': 'set-GPSTimingOfCell',
                                                                                 'type': 'SEQUENCE'},
                                                                                {'members': [{'members': [{'name': 'referenceIdentity',
                                                                                                           'type': 'PrimaryCPICH-Info'}],
                                                                                              'name': 'fdd',
                                                                                              'type': 'SEQUENCE'},
                                                                                             {'members': [{'name': 'referenceIdentity',
                                                                                                           'type': 'CellParametersID'}],
                                                                                              'name': 'tdd',
                                                                                              'type': 'SEQUENCE'}],
                                                                                 'name': 'modeSpecificInfo',
                                                                                 'optional': True,
                                                                                 'type': 'CHOICE'},
                                                                                {'name': 'sfn',
                                                                                 'restricted-to': [(0,
                                                                                                    4095)],
                                                                                 'type': 'INTEGER'},
                                                                                {'name': 'gpsReferenceTimeUncertainty',
                                                                                 'optional': True,
                                                                                 'restricted-to': [(0,
                                                                                                    127)],
                                                                                 'type': 'INTEGER'},
                                                                                None],
                                                                    'type': 'SEQUENCE'},
                                   'UTRANGANSSDriftRate': {'type': 'ENUMERATED',
                                                           'values': [('utran-GANSSDrift0',
                                                                       0),
                                                                      ('utran-GANSSDrift1',
                                                                       1),
                                                                      ('utran-GANSSDrift2',
                                                                       2),
                                                                      ('utran-GANSSDrift5',
                                                                       3),
                                                                      ('utran-GANSSDrift10',
                                                                       4),
                                                                      ('utran-GANSSDrift15',
                                                                       5),
                                                                      ('utran-GANSSDrift25',
                                                                       6),
                                                                      ('utran-GANSSDrift50',
                                                                       7),
                                                                      ('utran-GANSSDrift-1',
                                                                       8),
                                                                      ('utran-GANSSDrift-2',
                                                                       9),
                                                                      ('utran-GANSSDrift-5',
                                                                       10),
                                                                      ('utran-GANSSDrift-10',
                                                                       11),
                                                                      ('utran-GANSSDrift-15',
                                                                       12),
                                                                      ('utran-GANSSDrift-25',
                                                                       13),
                                                                      ('utran-GANSSDrift-50',
                                                                       14)]},
                                   'UTRANGPSDriftRate': {'type': 'ENUMERATED',
                                                         'values': [('utran-GPSDrift0',
                                                                     0),
                                                                    ('utran-GPSDrift1',
                                                                     1),
                                                                    ('utran-GPSDrift2',
                                                                     2),
                                                                    ('utran-GPSDrift5',
                                                                     3),
                                                                    ('utran-GPSDrift10',
                                                                     4),
                                                                    ('utran-GPSDrift15',
                                                                     5),
                                                                    ('utran-GPSDrift25',
                                                                     6),
                                                                    ('utran-GPSDrift50',
                                                                     7),
                                                                    ('utran-GPSDrift-1',
                                                                     8),
                                                                    ('utran-GPSDrift-2',
                                                                     9),
                                                                    ('utran-GPSDrift-5',
                                                                     10),
                                                                    ('utran-GPSDrift-10',
                                                                     11),
                                                                    ('utran-GPSDrift-15',
                                                                     12),
                                                                    ('utran-GPSDrift-25',
                                                                     13),
                                                                    ('utran-GPSDrift-50',
                                                                     14)]},
                                   'UmbCellInformation': {'members': [{'name': 'refSECTORID',
                                                                       'size': [128],
                                                                       'type': 'BIT '
                                                                               'STRING'},
                                                                      {'name': 'refMCC',
                                                                       'restricted-to': [(0,
                                                                                          999)],
                                                                       'type': 'INTEGER'},
                                                                      {'name': 'refMNC',
                                                                       'restricted-to': [(0,
                                                                                          999)],
                                                                       'type': 'INTEGER'},
                                                                      {'name': 'refBASELAT',
                                                                       'restricted-to': [(0,
                                                                                          4194303)],
                                                                       'type': 'INTEGER'},
                                                                      {'name': 'reBASELONG',
                                                                       'restricted-to': [(0,
                                                                                          8388607)],
                                                                       'type': 'INTEGER'},
                                                                      {'name': 'refWeekNumber',
                                                                       'restricted-to': [(0,
                                                                                          65535)],
                                                                       'type': 'INTEGER'},
                                                                      {'name': 'refSeconds',
                                                                       'restricted-to': [(0,
                                                                                          4194303)],
                                                                       'type': 'INTEGER'},
                                                                      None],
                                                          'type': 'SEQUENCE'},
                                   'Ver2-CellInfo-extension': {'members': [{'name': 'hrpdCell',
                                                                            'type': 'HrpdCellInformation'},
                                                                           {'name': 'umbCell',
                                                                            'type': 'UmbCellInformation'},
                                                                           {'name': 'lteCell',
                                                                            'type': 'LteCellInformation'},
                                                                           {'name': 'wlanAP',
                                                                            'type': 'WlanAPInformation'},
                                                                           {'name': 'wimaxBS',
                                                                            'type': 'WimaxBSInformation'},
                                                                           None],
                                                               'type': 'CHOICE'},
                                   'WimaxBSInformation': {'members': [{'name': 'wimaxBsID',
                                                                       'type': 'WimaxBsID'},
                                                                      {'name': 'wimaxRTD',
                                                                       'optional': True,
                                                                       'type': 'WimaxRTD'},
                                                                      {'name': 'wimaxNMRList',
                                                                       'optional': True,
                                                                       'type': 'WimaxNMRList'},
                                                                      None],
                                                          'type': 'SEQUENCE'},
                                   'WimaxBsID': {'members': [{'name': 'bsID-MSB',
                                                              'optional': True,
                                                              'size': [24],
                                                              'type': 'BIT '
                                                                      'STRING'},
                                                             {'name': 'bsID-LSB',
                                                              'size': [24],
                                                              'type': 'BIT '
                                                                      'STRING'},
                                                             None],
                                                 'type': 'SEQUENCE'},
                                   'WimaxNMR': {'members': [{'name': 'wimaxBsID',
                                                             'type': 'WimaxBsID'},
                                                            {'name': 'relDelay',
                                                             'optional': True,
                                                             'restricted-to': [(-32768,
                                                                                32767)],
                                                             'type': 'INTEGER'},
                                                            {'name': 'relDelaystd',
                                                             'optional': True,
                                                             'restricted-to': [(0,
                                                                                1023)],
                                                             'type': 'INTEGER'},
                                                            {'name': 'rSSI',
                                                             'optional': True,
                                                             'restricted-to': [(0,
                                                                                255)],
                                                             'type': 'INTEGER'},
                                                            {'name': 'rSSIstd',
                                                             'optional': True,
                                                             'restricted-to': [(0,
                                                                                63)],
                                                             'type': 'INTEGER'},
                                                            {'name': 'bSTxPower',
                                                             'optional': True,
                                                             'restricted-to': [(0,
                                                                                255)],
                                                             'type': 'INTEGER'},
                                                            {'name': 'cINR',
                                                             'optional': True,
                                                             'restricted-to': [(0,
                                                                                255)],
                                                             'type': 'INTEGER'},
                                                            {'name': 'cINRstd',
                                                             'optional': True,
                                                             'restricted-to': [(0,
                                                                                63)],
                                                             'type': 'INTEGER'},
                                                            {'name': 'bSLocation',
                                                             'optional': True,
                                                             'type': 'ReportedLocation'},
                                                            None],
                                                'type': 'SEQUENCE'},
                                   'WimaxNMRList': {'element': {'type': 'WimaxNMR'},
                                                    'size': [(1,
                                                              'maxWimaxBSMeas')],
                                                    'type': 'SEQUENCE OF'},
                                   'WimaxRTD': {'members': [{'name': 'rTD',
                                                             'restricted-to': [(0,
                                                                                65535)],
                                                             'type': 'INTEGER'},
                                                            {'name': 'rTDstd',
                                                             'optional': True,
                                                             'restricted-to': [(0,
                                                                                1023)],
                                                             'type': 'INTEGER'},
                                                            None],
                                                'type': 'SEQUENCE'},
                                   'WlanAPInformation': {'members': [{'name': 'apMACAddress',
                                                                      'size': [48],
                                                                      'type': 'BIT '
                                                                              'STRING'},
                                                                     {'name': 'apTransmitPower',
                                                                      'optional': True,
                                                                      'restricted-to': [(-127,
                                                                                         128)],
                                                                      'type': 'INTEGER'},
                                                                     {'name': 'apAntennaGain',
                                                                      'optional': True,
                                                                      'restricted-to': [(-127,
                                                                                         128)],
                                                                      'type': 'INTEGER'},
                                                                     {'name': 'apSignaltoNoise',
                                                                      'optional': True,
                                                                      'restricted-to': [(-127,
                                                                                         128)],
                                                                      'type': 'INTEGER'},
                                                                     {'name': 'apDeviceType',
                                                                      'optional': True,
                                                                      'type': 'ENUMERATED',
                                                                      'values': [('wlan802-11a',
                                                                                  0),
                                                                                 ('wlan802-11b',
                                                                                  1),
                                                                                 ('wlan802-11g',
                                                                                  2),
                                                                                 None,
                                                                                 ('wlan802-11n',
                                                                                  3),
                                                                                 ('wlan802-11ac',
                                                                                  4),
                                                                                 ('wlan802-11ad',
                                                                                  5)]},
                                                                     {'name': 'apSignalStrength',
                                                                      'optional': True,
                                                                      'restricted-to': [(-127,
                                                                                         128)],
                                                                      'type': 'INTEGER'},
                                                                     {'name': 'apChannelFrequency',
                                                                      'optional': True,
                                                                      'restricted-to': [(0,
                                                                                         256)],
                                                                      'type': 'INTEGER'},
                                                                     {'name': 'apRoundTripDelay',
                                                                      'optional': True,
                                                                      'type': 'RTD'},
                                                                     {'name': 'setTransmitPower',
                                                                      'optional': True,
                                                                      'restricted-to': [(-127,
                                                                                         128)],
                                                                      'type': 'INTEGER'},
                                                                     {'name': 'setAntennaGain',
                                                                      'optional': True,
                                                                      'restricted-to': [(-127,
                                                                                         128)],
                                                                      'type': 'INTEGER'},
                                                                     {'name': 'setSignaltoNoise',
                                                                      'optional': True,
                                                                      'restricted-to': [(-127,
                                                                                         128)],
                                                                      'type': 'INTEGER'},
                                                                     {'name': 'setSignalStrength',
                                                                      'optional': True,
                                                                      'restricted-to': [(-127,
                                                                                         128)],
                                                                      'type': 'INTEGER'},
                                                                     {'name': 'apReportedLocation',
                                                                      'optional': True,
                                                                      'type': 'ReportedLocation'},
                                                                     None,
                                                                     {'name': 'apRepLocation',
                                                                      'optional': True,
                                                                      'type': 'RepLocation'},
                                                                     {'name': 'apSignalStrengthDelta',
                                                                      'optional': True,
                                                                      'restricted-to': [(0,
                                                                                         1)],
                                                                      'type': 'INTEGER'},
                                                                     {'name': 'apSignaltoNoiseDelta',
                                                                      'optional': True,
                                                                      'restricted-to': [(0,
                                                                                         1)],
                                                                      'type': 'INTEGER'},
                                                                     {'name': 'setSignalStrengthDelta',
                                                                      'optional': True,
                                                                      'restricted-to': [(0,
                                                                                         1)],
                                                                      'type': 'INTEGER'},
                                                                     {'name': 'setSignaltoNoiseDelta',
                                                                      'optional': True,
                                                                      'restricted-to': [(0,
                                                                                         1)],
                                                                      'type': 'INTEGER'},
                                                                     {'name': 'operatingClass',
                                                                      'optional': True,
                                                                      'restricted-to': [(0,
                                                                                         255)],
                                                                      'type': 'INTEGER'},
                                                                     {'name': 'apSSID',
                                                                      'optional': True,
                                                                      'size': [(1,
                                                                                32)],
                                                                      'type': 'OCTET '
                                                                              'STRING'},
                                                                     {'name': 'apPHYType',
                                                                      'optional': True,
                                                                      'type': 'ENUMERATED',
                                                                      'values': [('unknown',
                                                                                  0),
                                                                                 ('any',
                                                                                  1),
                                                                                 ('fhss',
                                                                                  2),
                                                                                 ('dsss',
                                                                                  3),
                                                                                 ('irbaseband',
                                                                                  4),
                                                                                 ('ofdm',
                                                                                  5),
                                                                                 ('hrdsss',
                                                                                  6),
                                                                                 ('erp',
                                                                                  7),
                                                                                 ('ht',
                                                                                  8),
                                                                                 ('ihv',
                                                                                  9),
                                                                                 None]},
                                                                     {'name': 'setMACAddress',
                                                                      'optional': True,
                                                                      'size': [48],
                                                                      'type': 'BIT '
                                                                              'STRING'}],
                                                         'type': 'SEQUENCE'}},
                         'values': {'maxCellReport': {'type': 'INTEGER',
                                                      'value': 8},
                                    'maxLidSize': {'type': 'INTEGER',
                                                   'value': 64},
                                    'maxWLANApDataSize': {'type': 'INTEGER',
                                                          'value': 128},
                                    'maxWimaxBSMeas': {'type': 'INTEGER',
                                                       'value': 32}}}}