"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Operator = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const os = require("os");
const path = require("path");
const cdk8s_1 = require("cdk8s");
/**
 * A CDK8s app which allows implementing Kubernetes operators using CDK8s constructs.
 *
 * @stability stable
 */
class Operator extends cdk8s_1.App {
    /**
     * @stability stable
     */
    constructor(props = {}) {
        var _b, _c;
        const outdir = fs.mkdtempSync(path.join(os.tmpdir(), 'cdk8s'));
        super({ outdir });
        this.providers = [];
        this.inputFile = (_c = (_b = props.inputFile) !== null && _b !== void 0 ? _b : process.argv[2]) !== null && _c !== void 0 ? _c : '/dev/stdin';
        this.outputFile = props.outputFile;
    }
    /**
     * Adds a custom resource provider to this operator.
     *
     * @param provider The provider to add.
     * @stability stable
     */
    addProvider(provider) {
        this.providers.push(provider);
    }
    /**
     * Reads a Kubernetes manifest in JSON format from STDIN or the file specified as the first positional command-line argument.
     *
     * This manifest is expected to
     * include a single Kubernetes resource. Then, we match `apiVersion` and
     * `kind` to one of the registered providers and if we do, we invoke
     * `apply()`, passing it the `spec` of the input manifest and a chart as a
     * scope. The chart is then synthesized and the output manifest is written to
     * STDOUT.
     *
     * @stability stable
     */
    synth() {
        var _b, _c, _d;
        const input = JSON.parse(fs.readFileSync(this.inputFile, 'utf-8'));
        let write;
        if (this.outputFile) {
            const outfile = this.outputFile;
            write = (data) => fs.writeFileSync(outfile, data);
        }
        else {
            write = (data) => process.stdout.write(data);
        }
        if (typeof (input) !== 'object') {
            throw new Error('input must be a single kubernetes resource');
        }
        const provider = this.findProvider(input);
        const name = (_b = input.metadata) === null || _b === void 0 ? void 0 : _b.name;
        if (!name) {
            throw new Error('"metadata.name" must be defined');
        }
        const namespace = (_c = input.metadata) === null || _c === void 0 ? void 0 : _c.namespace;
        // TODO: namespace
        const spec = (_d = input.spec) !== null && _d !== void 0 ? _d : {};
        const chart = new cdk8s_1.Chart(this, name, { namespace });
        console.error(`Synthesizing ${input.kind}.${input.apiVersion}`);
        provider.handler.apply(chart, name, spec);
        super.synth();
        for (const file of fs.readdirSync(this.outdir)) {
            const filepath = path.join(this.outdir, file);
            const manifest = fs.readFileSync(filepath);
            write(manifest);
        }
    }
    findProvider(input) {
        const { apiVersion, kind } = input;
        if (!apiVersion) {
            throw new Error('"apiVersion" is required');
        }
        if (!kind) {
            throw new Error('"kind" is required');
        }
        for (const p of this.providers) {
            if (p.apiVersion === apiVersion && p.kind === kind) {
                return p;
            }
        }
        throw new Error(`No custom resource provider found for ${kind}.${apiVersion}`);
    }
}
exports.Operator = Operator;
_a = JSII_RTTI_SYMBOL_1;
Operator[_a] = { fqn: "cdk8s-operator.Operator", version: "0.0.129" };
//# sourceMappingURL=data:application/json;base64,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