from __future__ import annotations

from typing import overload

from pandas.core.arrays.datetimelike import TimelikeOps as TimelikeOps
from pandas.core.indexes.datetimelike import (
    DatetimeIndexOpsMixin as DatetimeIndexOpsMixin,
    DatetimelikeDelegateMixin as DatetimelikeDelegateMixin,
    DatetimeTimedeltaMixin as DatetimeTimedeltaMixin,
)
from pandas.core.indexes.datetimes import DatetimeIndex as DatetimeIndex
from pandas.core.series import TimedeltaSeries

from pandas._libs import Timedelta as Timedelta
from pandas._typing import num

class TimedeltaDelegateMixin(DatetimelikeDelegateMixin): ...

class TimedeltaIndex(DatetimeTimedeltaMixin, TimelikeOps, TimedeltaDelegateMixin):
    def __new__(
        cls,
        data=...,
        unit=...,
        freq=...,
        closed=...,
        dtype=...,
        copy: bool = ...,
        name=...,
    ): ...
    @overload
    def __add__(self, other: DatetimeIndex) -> DatetimeIndex: ...
    @overload
    def __add__(self, other: Timedelta | TimedeltaIndex) -> TimedeltaIndex: ...
    def __sub__(self, other: Timedelta | TimedeltaIndex) -> TimedeltaIndex: ...
    def __mul__(self, other: num) -> TimedeltaIndex: ...
    def __truediv__(self, other: num) -> TimedeltaIndex: ...
    def astype(self, dtype, copy: bool = ...): ...
    def get_value(self, series, key): ...
    def get_value_maybe_box(self, series, key: Timedelta): ...
    def get_loc(self, key, method=..., tolerance=...): ...
    def searchsorted(self, value, side: str = ..., sorter=...): ...
    def is_type_compatible(self, typ) -> bool: ...
    @property
    def inferred_type(self) -> str: ...
    def insert(self, loc, item): ...
    def to_series(self, index=..., name=...) -> TimedeltaSeries: ...

def timedelta_range(
    start=..., end=..., periods=..., freq=..., name=..., closed=...
) -> TimedeltaIndex: ...
