from __future__ import annotations

from typing import (
    Callable,
    Sequence,
)

class ExcelCell:
    __fields__ = ...
    row = ...
    col = ...
    val = ...
    style = ...
    mergestart = ...
    mergeend = ...
    def __init__(
        self, row: int, col: int, val, style=..., mergestart=..., mergeend=...
    ) -> None: ...

class CSSToExcelConverter:
    inherited = ...
    def __init__(self, inherited: str | None = ...) -> None: ...
    compute_css = ...
    def __call__(self, declarations_str: str) -> dict[str, dict[str, str]]: ...
    def build_xlstyle(self, props: dict[str, str]) -> dict[str, dict[str, str]]: ...
    VERTICAL_MAP = ...
    def build_alignment(self, props) -> dict[str, bool | str | None]: ...
    def build_border(self, props: dict) -> dict[str, dict[str, str]]: ...
    def build_fill(self, props: dict[str, str]): ...
    BOLD_MAP = ...
    ITALIC_MAP = ...
    def build_font(self, props) -> dict[str, bool | int | str | None]: ...
    NAMED_COLORS = ...
    def color_to_excel(self, val: str | None): ...
    def build_number_format(self, props: dict) -> dict[str, str | None]: ...

class ExcelFormatter:
    max_rows = ...
    max_cols = ...
    rowcounter: int = ...
    na_rep = ...
    styler = ...
    style_converter = ...
    df = ...
    columns = ...
    float_format = ...
    index = ...
    index_label = ...
    header = ...
    merge_cells = ...
    inf_rep = ...
    def __init__(
        self,
        df,
        na_rep: str = ...,
        float_format: str | None = ...,
        cols: Sequence | None = ...,
        header: bool | list[str] = ...,
        index: bool = ...,
        index_label: str | Sequence | None = ...,
        merge_cells: bool = ...,
        inf_rep: str = ...,
        style_converter: Callable | None = ...,
    ) -> None: ...
    @property
    def header_style(self): ...
    def get_formatted_cells(self) -> None: ...
    def write(
        self,
        writer,
        sheet_name: str = ...,
        startrow: int = ...,
        startcol: int = ...,
        freeze_panes=...,
        engine=...,
    ) -> None: ...
