from __future__ import annotations

from typing import (
    IO,
    Callable,
    Iterable,
    Mapping,
    Sequence,
    Union,
)

import numpy as np
from pandas.core.arrays.categorical import Categorical
from pandas.core.arrays.datetimes import DatetimeArray
from pandas.core.frame import DataFrame
from pandas.core.indexes.api import Index
from pandas.core.indexes.datetimes import DatetimeIndex
from pandas.core.indexes.timedeltas import TimedeltaIndex
from pandas.core.series import Series

from pandas._typing import FilePathOrBuffer

formatters_type = Union[
    list[Callable], tuple[Callable, ...], Mapping[Union[str, int], Callable]
]
FloatFormatType = Union[str, Callable, EngFormatter]
common_docstring: str = ...
return_docstring: str = ...

class CategoricalFormatter:
    categorical = ...
    buf = ...
    na_rep = ...
    length = ...
    footer = ...
    def __init__(
        self,
        categorical: Categorical,
        buf: IO[str] | None = ...,
        length: bool = ...,
        na_rep: str = ...,
        footer: bool = ...,
    ) -> None: ...
    def to_string(self) -> str: ...

class SeriesFormatter:
    series = ...
    buf = ...
    name = ...
    na_rep = ...
    header = ...
    length = ...
    index = ...
    max_rows = ...
    min_rows = ...
    float_format = ...
    dtype = ...
    adj = ...
    def __init__(
        self,
        series: Series,
        buf: IO[str] | None = ...,
        length: bool | str = ...,
        header: bool = ...,
        index: bool = ...,
        na_rep: str = ...,
        name: bool = ...,
        float_format: str | None = ...,
        dtype: bool = ...,
        max_rows: int | None = ...,
        min_rows: int | None = ...,
    ) -> None: ...
    def to_string(self) -> str: ...

class TextAdjustment:
    encoding = ...
    def __init__(self) -> None: ...
    def len(self, text: str) -> int: ...
    def justify(self, texts, max_len: int, mode: str = ...) -> list[str]: ...
    def adjoin(self, space: int, *lists, **kwargs) -> str: ...

class EastAsianTextAdjustment(TextAdjustment):
    ambiguous_width: int = ...
    def __init__(self) -> None: ...
    def len(self, text: str) -> int: ...
    def justify(
        self, texts: Iterable[str], max_len: int, mode: str = ...
    ) -> list[str]: ...

class TableFormatter:
    show_dimensions: bool | str
    is_truncated: bool
    formatters: formatters_type
    columns: Index
    @property
    def should_show_dimensions(self) -> bool: ...
    def get_buffer(
        self, buf: FilePathOrBuffer[str] | None, encoding: str | None = ...
    ): ...
    def write_result(self, buf: IO[str]) -> None: ...
    def get_result(
        self, buf: FilePathOrBuffer[str] | None = ..., encoding: str | None = ...
    ) -> str | None: ...

class DataFrameFormatter(TableFormatter):
    frame = ...
    show_index_names = ...
    sparsify = ...
    float_format = ...
    na_rep = ...
    decimal = ...
    col_space = ...
    header = ...
    index = ...
    line_width = ...
    max_rows = ...
    min_rows = ...
    max_cols = ...
    max_rows_displayed = ...
    table_id = ...
    render_links = ...
    justify = ...
    bold_rows = ...
    escape = ...
    adj = ...
    def __init__(
        self,
        frame: DataFrame,
        columns: Sequence[str] | None = ...,
        col_space: str | int | None = ...,
        header: bool | Sequence[str] = ...,
        index: bool = ...,
        na_rep: str = ...,
        formatters: formatters_type | None = ...,
        justify: str | None = ...,
        float_format: FloatFormatType | None = ...,
        sparsify: bool | None = ...,
        index_names: bool = ...,
        line_width: int | None = ...,
        max_rows: int | None = ...,
        min_rows: int | None = ...,
        max_cols: int | None = ...,
        show_dimensions: bool | str = ...,
        decimal: str = ...,
        table_id: str | None = ...,
        render_links: bool = ...,
        bold_rows: bool = ...,
        escape: bool = ...,
    ) -> None: ...
    max_cols_adj = ...
    def write_result(self, buf: IO[str]) -> None: ...
    def to_string(
        self, buf: FilePathOrBuffer[str] | None = ..., encoding: str | None = ...
    ) -> str | None: ...
    def to_latex(
        self,
        buf: FilePathOrBuffer[str] | None = ...,
        column_format: str | None = ...,
        longtable: bool = ...,
        encoding: str | None = ...,
        multicolumn: bool = ...,
        multicolumn_format: str | None = ...,
        multirow: bool = ...,
        caption: str | None = ...,
        label: str | None = ...,
    ) -> str | None: ...
    def to_html(
        self,
        buf: FilePathOrBuffer[str] | None = ...,
        encoding: str | None = ...,
        classes: str | list | tuple | None = ...,
        notebook: bool = ...,
        border: int | None = ...,
    ) -> str | None: ...
    @property
    def has_index_names(self) -> bool: ...
    @property
    def has_column_names(self) -> bool: ...
    @property
    def show_row_idx_names(self) -> bool: ...
    @property
    def show_col_idx_names(self) -> bool: ...

def format_array(
    values,
    formatter: Callable | None,
    float_format: FloatFormatType | None = ...,
    na_rep: str = ...,
    digits: int | None = ...,
    space: str | int | None = ...,
    justify: str = ...,
    decimal: str = ...,
    leading_space: bool | None = ...,
) -> list[str]: ...

class GenericArrayFormatter:
    values = ...
    digits = ...
    na_rep = ...
    space = ...
    formatter = ...
    float_format = ...
    justify = ...
    decimal = ...
    quoting = ...
    fixed_width = ...
    leading_space = ...
    def __init__(
        self,
        values,
        digits: int = ...,
        formatter: Callable | None = ...,
        na_rep: str = ...,
        space: str | int = ...,
        float_format: FloatFormatType | None = ...,
        justify: str = ...,
        decimal: str = ...,
        quoting: int | None = ...,
        fixed_width: bool = ...,
        leading_space: bool | None = ...,
    ) -> None: ...
    def get_result(self) -> list[str]: ...

class FloatArrayFormatter(GenericArrayFormatter):
    formatter = ...
    float_format = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def get_result_as_array(self) -> np.ndarray: ...

class IntArrayFormatter(GenericArrayFormatter): ...

class Datetime64Formatter(GenericArrayFormatter):
    nat_rep = ...
    date_format = ...
    def __init__(
        self,
        values: np.ndarray | Series | DatetimeIndex | DatetimeArray,
        nat_rep: str = ...,
        date_format: None = ...,
        **kwargs,
    ) -> None: ...

class ExtensionArrayFormatter(GenericArrayFormatter): ...

def format_percentiles(
    percentiles: np.ndarray | list[int | float] | list[float] | list[str | float],
) -> list[str]: ...

class Datetime64TZFormatter(Datetime64Formatter): ...

class Timedelta64Formatter(GenericArrayFormatter):
    nat_rep = ...
    box = ...
    def __init__(
        self,
        values: np.ndarray | TimedeltaIndex,
        nat_rep: str = ...,
        box: bool = ...,
        **kwargs,
    ) -> None: ...

class EngFormatter:
    ENG_PREFIXES = ...
    accuracy = ...
    use_eng_prefix = ...
    def __init__(
        self, accuracy: int | None = ..., use_eng_prefix: bool = ...
    ) -> None: ...
    def __call__(self, num: int | float) -> str: ...

def set_eng_float_format(accuracy: int = ..., use_eng_prefix: bool = ...) -> None: ...
def get_level_lengths(
    levels, sentinel: bool | object | str = ...
) -> list[dict[int, int]]: ...
def buffer_put_lines(buf: IO[str], lines: list[str]) -> None: ...
