# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['dotdict_bench']

package_data = \
{'': ['*']}

install_requires = \
['PyGithub>=1.55,<2.0',
 'addict>=2.4.0,<3.0.0',
 'benchwork>=0.0.1,<0.0.2',
 'dictlib>=1.1.5,<2.0.0',
 'diot>=0.1.6,<0.2.0',
 'dotmap>=1.3.30,<2.0.0',
 'dotsi>=0.0.3,<0.0.4',
 'dotwiz>=0.4.0,<0.5.0',
 'easydict>=1.9,<2.0',
 'importlib-metadata>=4.12.0,<5.0.0',
 'pyparam>=0.5.3,<0.6.0',
 'python-box>=6.0.2,<7.0.0']

setup_kwargs = {
    'name': 'dotdict-bench',
    'version': '0.0.0',
    'description': 'Benchmarking for dot-accessible dict packages in python',
    'long_description': '# dotdict-bench\n\nBenchmarking for dot-accessible dict packages in python\n\n[![deps](https://img.shields.io/librariesio/release/pypi/dotdict-bench?style=flat-square)](https://libraries.io/github/pwwang/dotdict-bench#repository_dependencies)\n\nMore test ideas? [Submit an issue](https://github.com/pwwang/dotdict-bench/issues)!\n\n\n## Package Information\n\nAs of 2022-09-21 23:11:19.354375\n\n|Package|Version|Last Commit|Stars|Forks|Description|\n|-------|-------|-----------|-----|-----|-----------|\n|<a target="_blank" href="https://github.com/mewwts/addict">addict</a>|2.4.0|Tue, 05 Jan 2021 07:16:38 GMT|2277|137|[(i)](# "The Python Dict that\'s better than heroin.")|\n|<a target="_blank" href="https://github.com/cdgriffith/Box">python-box</a>|6.0.2|Sat, 02 Apr 2022 02:24:21 GMT|2062|89|[(i)](# "Python dictionaries with advanced dot notation access")|\n|<a target="_blank" href="https://github.com/drgrib/dotmap">dotmap</a>|1.3.30|Wed, 06 Apr 2022 16:26:33 GMT|366|43|[(i)](# "Dot access dictionary with dynamic hierarchy creation and ordered iteration")|\n|<a target="_blank" href="https://github.com/rnag/dotwiz">dotwiz</a>|0.4.0|Wed, 21 Sep 2022 22:23:19 GMT|20|1|[(i)](# "A blazing fast dict subclass that supports dot access notation.")|\n|<a target="_blank" href="https://github.com/makinacorpus/easydict">easydict</a>|1.9|Sun, 28 Feb 2021 10:26:53 GMT|207|39|[(i)](# "Access dict values as attributes (works recursively)")|\n|<a target="_blank" href="https://github.com/polydojo/dotsi">dotsi</a>|0.0.3|Sun, 22 Nov 2020 16:48:22 GMT|18|1|[(i)](# "Dot-accessible, update-aware Python dicts (& lists). Works recursively, like a charm.")|\n|<a target="_blank" href="https://github.com/srevenant/dictlib">dictlib</a>|1.1.5|Thu, 15 Aug 2019 23:10:47 GMT|14|3|[(i)](# "python: a lightweight add-on for dictionaries, featuring deep dictionary union, dictionary keys as object attributes (in code dict.key.sub.value notation) as well as a separate string dig/dug for using strings with dot notation on native dictionaries")|\n|<a target="_blank" href="https://github.com/pwwang/diot">diot</a>|0.1.6|Thu, 12 May 2022 20:37:59 GMT|7|2|[(i)](# "Python dictionary with dot notation")|\n\n## Creating an object of the dict subclass\n\nHow the packages create an object of the dict subclass\n\n| |Created|\n|-|-----------------------|\n|<a target="_blank" href="https://github.com/mewwts/addict">addict</a>|`{\'a\': {\'b\': {\'c\': 1}}}` **Type**: `Dict`|\n|<a target="_blank" href="https://github.com/cdgriffith/Box">python-box</a>|`{\'a\': {\'b\': {\'c\': 1}}}` **Type**: `Box`|\n|<a target="_blank" href="https://github.com/drgrib/dotmap">dotmap</a>|`DotMap(a=DotMap(b=DotMap(c=1)))` **Type**: `DotMap`|\n|<a target="_blank" href="https://github.com/rnag/dotwiz">dotwiz</a>|`✫(a=✫(b=✫(c=1)))` **Type**: `DotWiz`|\n|<a target="_blank" href="https://github.com/makinacorpus/easydict">easydict</a>|`{\'a\': {\'b\': {\'c\': 1}}}` **Type**: `EasyDict`|\n|<a target="_blank" href="https://github.com/polydojo/dotsi">dotsi</a>|`{\'a\': {\'b\': {\'c\': 1}}}` **Type**: `DotsiDict`|\n|<a target="_blank" href="https://github.com/srevenant/dictlib">dictlib</a>|`{\'a\': {\'b\': {\'c\': 1}}}` **Type**: `Dict`|\n|<a target="_blank" href="https://github.com/pwwang/diot">diot</a>|`{\'a\': Diot({\'b\': Diot({\'c\': 1})})}` **Type**: `Diot`|\n\n## Creating a dict with preserved keys\n\nHow the packages create a dict with preserved keys\n(e.g. `keys`, `values`, `items`, etc)\n\nLiterally, `{"keys": 1}`\n\n\n| |Created or error|\n|-|-----------------------|\n|<a target="_blank" href="https://github.com/mewwts/addict">addict</a>|{\'keys\': 1}|\n|<a target="_blank" href="https://github.com/cdgriffith/Box">python-box</a>|{\'keys\': 1}|\n|<a target="_blank" href="https://github.com/drgrib/dotmap">dotmap</a>|DotMap(keys=1)|\n|<a target="_blank" href="https://github.com/rnag/dotwiz">dotwiz</a>|✫(keys=1)|\n|<a target="_blank" href="https://github.com/makinacorpus/easydict">easydict</a>|{\'keys\': 1}|\n|<a target="_blank" href="https://github.com/polydojo/dotsi">dotsi</a>|{\'keys\': 1}|\n|<a target="_blank" href="https://github.com/srevenant/dictlib">dictlib</a>|Key \'keys\' conflicts with reserved word|\n|<a target="_blank" href="https://github.com/pwwang/diot">diot</a>|{\'keys\': 1}|\n\n## Creating a dict with magic keys\n\nHow the packages create a dict with magic keys\n(e.g. `__name__`, `__class__`, etc)\n\nLiterally, `{"__name__": 1}`\n\n\n| |Created or error|\n|-|-----------------------|\n|<a target="_blank" href="https://github.com/mewwts/addict">addict</a>|`{\'__name__\': 1}`|\n|<a target="_blank" href="https://github.com/cdgriffith/Box">python-box</a>|`{\'__name__\': 1}`|\n|<a target="_blank" href="https://github.com/drgrib/dotmap">dotmap</a>|`DotMap(__name__=1)`|\n|<a target="_blank" href="https://github.com/rnag/dotwiz">dotwiz</a>|`✫(__name__=1)`|\n|<a target="_blank" href="https://github.com/makinacorpus/easydict">easydict</a>|`{\'__name__\': 1}`|\n|<a target="_blank" href="https://github.com/polydojo/dotsi">dotsi</a>|`{\'__name__\': 1}`|\n|<a target="_blank" href="https://github.com/srevenant/dictlib">dictlib</a>|`{\'__name__\': 1}`|\n|<a target="_blank" href="https://github.com/pwwang/diot">diot</a>|`{\'__name__\': 1}`|\n\n## Accessing values\n\nHow the packages to access values\n\nLiterally `1` from `{"a": {"b": {"c": 1}}}`\n\n\n| |Way to access value|\n|-|-----------------------|\n|<a target="_blank" href="https://github.com/mewwts/addict">addict</a>|`<dict>.a.b.c` or `<dict>[\'a\'][\'b\'][\'c\']`|\n|<a target="_blank" href="https://github.com/cdgriffith/Box">python-box</a>|`<dict>.a.b.c` or `<dict>[\'a\'][\'b\'][\'c\']`|\n|<a target="_blank" href="https://github.com/drgrib/dotmap">dotmap</a>|`<dict>.a.b.c` or `<dict>[\'a\'][\'b\'][\'c\']`|\n|<a target="_blank" href="https://github.com/rnag/dotwiz">dotwiz</a>|`<dict>.a.b.c` or `<dict>[\'a\'][\'b\'][\'c\']`|\n|<a target="_blank" href="https://github.com/makinacorpus/easydict">easydict</a>|`<dict>.a.b.c` or `<dict>[\'a\'][\'b\'][\'c\']`|\n|<a target="_blank" href="https://github.com/polydojo/dotsi">dotsi</a>|`<dict>.a.b.c` or `<dict>[\'a\'][\'b\'][\'c\']`|\n|<a target="_blank" href="https://github.com/srevenant/dictlib">dictlib</a>|`dictlib.dig(<dict>, \'a.b.c\')` or `dictlib.Dict(<dict>).a.b.c`|\n|<a target="_blank" href="https://github.com/pwwang/diot">diot</a>|`<dict>.a.b.c` or `<dict>[\'a\'][\'b\'][\'c\']`|\n\n## Recursive Dot Access\n\nWhether recursive dot access is supported when there are lists\nin the dict\n\nLiterally `<dict>.a.b[0].c` from `{"a": {"b": [{"c": 1}, {"d": 2}]}}`\n\n\n| |Value or error|\n|-|-----------------------|\n|<a target="_blank" href="https://github.com/mewwts/addict">addict</a>|`1`|\n|<a target="_blank" href="https://github.com/cdgriffith/Box">python-box</a>|`1`|\n|<a target="_blank" href="https://github.com/drgrib/dotmap">dotmap</a>|`1`|\n|<a target="_blank" href="https://github.com/rnag/dotwiz">dotwiz</a>|`1`|\n|<a target="_blank" href="https://github.com/makinacorpus/easydict">easydict</a>|`1`|\n|<a target="_blank" href="https://github.com/polydojo/dotsi">dotsi</a>|`1`|\n|<a target="_blank" href="https://github.com/srevenant/dictlib">dictlib</a>|AttributeError: \'dict\' object has no attribute \'c\'|\n|<a target="_blank" href="https://github.com/pwwang/diot">diot</a>|`1`|\n\n## Automatic Hierarchy\n\nWhether a hierarchical structure is created by dot notation\n\nLiterally `<dict>.a.b.c = 1` creates `{"a": {"b": {"c": 1}}}`\n\n\n| |Created or error|\n|-|-----------------------|\n|<a target="_blank" href="https://github.com/mewwts/addict">addict</a>|`{\'a\': {\'b\': {\'c\': 1}}}`|\n|<a target="_blank" href="https://github.com/cdgriffith/Box">python-box</a>|KeyError: "\'Box\' object has no attribute \'a\'"|\n|<a target="_blank" href="https://github.com/drgrib/dotmap">dotmap</a>|`DotMap(a=DotMap(b=DotMap(c=1)))`|\n|<a target="_blank" href="https://github.com/rnag/dotwiz">dotwiz</a>|AttributeError: \'DotWiz\' object has no attribute \'a\'|\n|<a target="_blank" href="https://github.com/makinacorpus/easydict">easydict</a>|AttributeError: \'EasyDict\' object has no attribute \'a\'|\n|<a target="_blank" href="https://github.com/polydojo/dotsi">dotsi</a>|KeyError: \'a\'|\n|<a target="_blank" href="https://github.com/srevenant/dictlib">dictlib</a>|KeyError: \'a\'|\n|<a target="_blank" href="https://github.com/pwwang/diot">diot</a>|AttributeError: a|\n\n## Accessing values with preserved keys\n\nHow to access values with conflict keys\n\nLiterally, accessing values from `{"keys": 1, "__name__": 2}`\n\n\n|Package|`obj.keys`|`obj[\'keys\']`|`obj.__name__`|`obj[\'__name__\']`|\n|---|---|---|---|---|\n|<a target="_blank" href="https://github.com/mewwts/addict">addict</a>|`<built-in method keys of Dict object at 0x7f4455a49c70>`|`1`|`2`|`2`|\n|<a target="_blank" href="https://github.com/cdgriffith/Box">python-box</a>|`<bound method Box.keys of Box({\'keys\': 1, \'__name__\': 2})>`|`1`|`2`|`2`|\n|<a target="_blank" href="https://github.com/drgrib/dotmap">dotmap</a>|`<bound method DotMap.keys of DotMap(keys=1, __name__=2)>`|`1`|`AttributeError: __name__`|`2`|\n|<a target="_blank" href="https://github.com/rnag/dotwiz">dotwiz</a>|`1`|`1`|`2`|`2`|\n|<a target="_blank" href="https://github.com/makinacorpus/easydict">easydict</a>|`1`|`1`|`2`|`2`|\n|<a target="_blank" href="https://github.com/polydojo/dotsi">dotsi</a>|`<built-in method keys of DotsiDict object at 0x7f4455a49c70>`|`1`|`2`|`2`|\n|<a target="_blank" href="https://github.com/srevenant/dictlib">dictlib</a>|`Can\'t create`|`Can\'t create`|`Can\'t create`|`Can\'t create`|\n|<a target="_blank" href="https://github.com/pwwang/diot">diot</a>|`<built-in method keys of Diot object at 0x7f4455a49c70>`|`1`|`2`|`2`|\n\n## Accessing dashed keys\n\nHow the values with keys with dash are accessed\n\nLiterally `<dict>.a_b` for `{"a-b": 1}`\n\n\n|Package|`obj.a_b`|`obj[\'a_b\']`|`obj[\'a-b\']`|\n|---|---|---|---|\n|<a target="_blank" href="https://github.com/mewwts/addict">addict</a>|`{}`|`{}`|`1`|\n|<a target="_blank" href="https://github.com/cdgriffith/Box">python-box</a>|`1`|`KeyError: "\'a_b\'"`|`1`|\n|<a target="_blank" href="https://github.com/drgrib/dotmap">dotmap</a>|`DotMap()`|`DotMap()`|`1`|\n|<a target="_blank" href="https://github.com/rnag/dotwiz">dotwiz</a>|`AttributeError: \'DotWiz\' object has no attribute \'a_b\'`|`KeyError: \'a_b\'`|`1`|\n|<a target="_blank" href="https://github.com/makinacorpus/easydict">easydict</a>|`AttributeError: \'EasyDict\' object has no attribute \'a_b\'`|`KeyError: \'a_b\'`|`1`|\n|<a target="_blank" href="https://github.com/polydojo/dotsi">dotsi</a>|`KeyError: \'a_b\'`|`KeyError: \'a_b\'`|`1`|\n|<a target="_blank" href="https://github.com/srevenant/dictlib">dictlib</a>|`1`|`1`|`1`|\n|<a target="_blank" href="https://github.com/pwwang/diot">diot</a>|`1`|`1`|`1`|\n\n## Frozen Dict Support\n\nWhether the packages support frozen dicts\n\n| |Support? and how?|\n|-|-----------------------|\n|<a target="_blank" href="https://github.com/mewwts/addict">addict</a>|`<dict>.freeze()/.unfreeze()`|\n|<a target="_blank" href="https://github.com/cdgriffith/Box">python-box</a>|`Box(<dict>, frozen_box=True)`|\n|<a target="_blank" href="https://github.com/drgrib/dotmap">dotmap</a>|Not supported|\n|<a target="_blank" href="https://github.com/rnag/dotwiz">dotwiz</a>|Not supported|\n|<a target="_blank" href="https://github.com/makinacorpus/easydict">easydict</a>|Not supported|\n|<a target="_blank" href="https://github.com/polydojo/dotsi">dotsi</a>|Not supported|\n|<a target="_blank" href="https://github.com/srevenant/dictlib">dictlib</a>|Not supported|\n|<a target="_blank" href="https://github.com/pwwang/diot">diot</a>|`FrozenDiot(<dict>)` or `Diot(<dict>, diot_frozen=True)`|\n\n## Key transformation support\n\nWhether the packages support key transformation for dot access\n\nFor example: making `<dict>.a_b` to access value from `{"a.b": 1}`\n\n\n| |Support? and how?|\n|-|-----------------------|\n|<a target="_blank" href="https://github.com/mewwts/addict">addict</a>|Not supported|\n|<a target="_blank" href="https://github.com/cdgriffith/Box">python-box</a>|Using Conversion Box or Camel Killer Box|\n|<a target="_blank" href="https://github.com/drgrib/dotmap">dotmap</a>|Not supported|\n|<a target="_blank" href="https://github.com/rnag/dotwiz">dotwiz</a>|`DotWizPlus` turns special-cased keys, such as names with spaces, into valid snake_case words|\n|<a target="_blank" href="https://github.com/makinacorpus/easydict">easydict</a>|Not supported|\n|<a target="_blank" href="https://github.com/polydojo/dotsi">dotsi</a>|Not supported|\n|<a target="_blank" href="https://github.com/srevenant/dictlib">dictlib</a>|Not supported|\n|<a target="_blank" href="https://github.com/pwwang/diot">diot</a>|Support custom transform function: `Diot(..., diot_transform =...)`|\n\n',
    'author': 'pwwang',
    'author_email': 'pwwang@pwwang.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
