"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TriggerInvalidation = exports.Trigger = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path_1 = require("path");
const core_1 = require("@aws-cdk/core");
const constructs_1 = require("constructs");
// keep this import separate from other imports to reduce chance for merge conflicts with v2-main
// eslint-disable-next-line no-duplicate-imports, import/order
const core_2 = require("@aws-cdk/core");
/**
 * Triggers an AWS Lambda function during deployment.
 */
class Trigger extends core_2.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_triggers_TriggerProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, Trigger);
            }
            throw error;
        }
        const handlerArn = this.determineHandlerArn(props);
        const provider = core_1.CustomResourceProvider.getOrCreateProvider(this, 'AWSCDK.TriggerCustomResourceProvider', {
            runtime: core_1.CustomResourceProviderRuntime.NODEJS_14_X,
            codeDirectory: path_1.join(__dirname, 'lambda'),
            policyStatements: [
                {
                    Effect: 'Allow',
                    Action: ['lambda:InvokeFunction'],
                    Resource: [handlerArn],
                },
            ],
        });
        new core_1.CustomResource(this, 'Default', {
            resourceType: 'Custom::Trigger',
            serviceToken: provider.serviceToken,
            properties: {
                HandlerArn: handlerArn,
            },
        });
        this.executeAfter(...props.executeAfter ?? []);
        this.executeBefore(...props.executeBefore ?? []);
    }
    executeAfter(...scopes) {
        constructs_1.Node.of(this).addDependency(...scopes);
    }
    executeBefore(...scopes) {
        for (const s of scopes) {
            constructs_1.Node.of(s).addDependency(this);
        }
    }
    determineHandlerArn(props) {
        return props.handler.currentVersion.functionArn;
    }
}
exports.Trigger = Trigger;
_a = JSII_RTTI_SYMBOL_1;
Trigger[_a] = { fqn: "@aws-cdk/triggers.Trigger", version: "1.193.0" };
/**
 * Determines
 */
var TriggerInvalidation;
(function (TriggerInvalidation) {
    /**
     * The trigger will be executed every time the handler (or its configuration)
     * changes. This is implemented by associated the trigger with the `currentVersion`
     * of the AWS Lambda function, which gets recreated every time the handler changes.
     */
    TriggerInvalidation["HANDLER_CHANGE"] = "WHEN_FUNCTION_CHANGES";
})(TriggerInvalidation = exports.TriggerInvalidation || (exports.TriggerInvalidation = {}));
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidHJpZ2dlci5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInRyaWdnZXIudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQUEsK0JBQTRCO0FBRTVCLHdDQUFrSDtBQUVsSCwyQ0FBNkM7QUFFN0MsaUdBQWlHO0FBQ2pHLDhEQUE4RDtBQUM5RCx3Q0FBMkQ7QUFzRTNEOztHQUVHO0FBQ0gsTUFBYSxPQUFRLFNBQVEsZ0JBQWE7SUFDeEMsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUFtQjtRQUMzRCxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDOzs7Ozs7K0NBRlIsT0FBTzs7OztRQUloQixNQUFNLFVBQVUsR0FBRyxJQUFJLENBQUMsbUJBQW1CLENBQUMsS0FBSyxDQUFDLENBQUM7UUFDbkQsTUFBTSxRQUFRLEdBQUcsNkJBQXNCLENBQUMsbUJBQW1CLENBQUMsSUFBSSxFQUFFLHNDQUFzQyxFQUFFO1lBQ3hHLE9BQU8sRUFBRSxvQ0FBNkIsQ0FBQyxXQUFXO1lBQ2xELGFBQWEsRUFBRSxXQUFJLENBQUMsU0FBUyxFQUFFLFFBQVEsQ0FBQztZQUN4QyxnQkFBZ0IsRUFBRTtnQkFDaEI7b0JBQ0UsTUFBTSxFQUFFLE9BQU87b0JBQ2YsTUFBTSxFQUFFLENBQUMsdUJBQXVCLENBQUM7b0JBQ2pDLFFBQVEsRUFBRSxDQUFDLFVBQVUsQ0FBQztpQkFDdkI7YUFDRjtTQUNGLENBQUMsQ0FBQztRQUVILElBQUkscUJBQWMsQ0FBQyxJQUFJLEVBQUUsU0FBUyxFQUFFO1lBQ2xDLFlBQVksRUFBRSxpQkFBaUI7WUFDL0IsWUFBWSxFQUFFLFFBQVEsQ0FBQyxZQUFZO1lBQ25DLFVBQVUsRUFBRTtnQkFDVixVQUFVLEVBQUUsVUFBVTthQUN2QjtTQUNGLENBQUMsQ0FBQztRQUVILElBQUksQ0FBQyxZQUFZLENBQUMsR0FBRyxLQUFLLENBQUMsWUFBWSxJQUFJLEVBQUUsQ0FBQyxDQUFDO1FBQy9DLElBQUksQ0FBQyxhQUFhLENBQUMsR0FBRyxLQUFLLENBQUMsYUFBYSxJQUFJLEVBQUUsQ0FBQyxDQUFDO0tBQ2xEO0lBRU0sWUFBWSxDQUFDLEdBQUcsTUFBbUI7UUFDeEMsaUJBQUksQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLENBQUMsYUFBYSxDQUFDLEdBQUcsTUFBTSxDQUFDLENBQUM7S0FDeEM7SUFFTSxhQUFhLENBQUMsR0FBRyxNQUFtQjtRQUN6QyxLQUFLLE1BQU0sQ0FBQyxJQUFJLE1BQU0sRUFBRTtZQUN0QixpQkFBSSxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxhQUFhLENBQUMsSUFBSSxDQUFDLENBQUM7U0FDaEM7S0FDRjtJQUVPLG1CQUFtQixDQUFDLEtBQW1CO1FBQzdDLE9BQU8sS0FBSyxDQUFDLE9BQU8sQ0FBQyxjQUFjLENBQUMsV0FBVyxDQUFDO0tBTWpEOztBQTlDSCwwQkErQ0M7OztBQUVEOztHQUVHO0FBQ0gsSUFBWSxtQkFPWDtBQVBELFdBQVksbUJBQW1CO0lBQzdCOzs7O09BSUc7SUFDSCwrREFBd0MsQ0FBQTtBQUMxQyxDQUFDLEVBUFcsbUJBQW1CLEdBQW5CLDJCQUFtQixLQUFuQiwyQkFBbUIsUUFPOUIiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBqb2luIH0gZnJvbSAncGF0aCc7XG5pbXBvcnQgKiBhcyBsYW1iZGEgZnJvbSAnQGF3cy1jZGsvYXdzLWxhbWJkYSc7XG5pbXBvcnQgeyBDdXN0b21SZXNvdXJjZSwgQ3VzdG9tUmVzb3VyY2VQcm92aWRlciwgQ3VzdG9tUmVzb3VyY2VQcm92aWRlclJ1bnRpbWUsIElDb25zdHJ1Y3QgfSBmcm9tICdAYXdzLWNkay9jb3JlJztcblxuaW1wb3J0IHsgQ29uc3RydWN0LCBOb2RlIH0gZnJvbSAnY29uc3RydWN0cyc7XG5cbi8vIGtlZXAgdGhpcyBpbXBvcnQgc2VwYXJhdGUgZnJvbSBvdGhlciBpbXBvcnRzIHRvIHJlZHVjZSBjaGFuY2UgZm9yIG1lcmdlIGNvbmZsaWN0cyB3aXRoIHYyLW1haW5cbi8vIGVzbGludC1kaXNhYmxlLW5leHQtbGluZSBuby1kdXBsaWNhdGUtaW1wb3J0cywgaW1wb3J0L29yZGVyXG5pbXBvcnQgeyBDb25zdHJ1Y3QgYXMgQ29yZUNvbnN0cnVjdCB9IGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuXG4vKipcbiAqIEludGVyZmFjZSBmb3IgdHJpZ2dlcnMuXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgSVRyaWdnZXIgZXh0ZW5kcyBJQ29uc3RydWN0IHtcbiAgLyoqXG4gICAqIEFkZHMgdHJpZ2dlciBkZXBlbmRlbmNpZXMuIEV4ZWN1dGUgdGhpcyB0cmlnZ2VyIG9ubHkgYWZ0ZXIgdGhlc2UgY29uc3RydWN0XG4gICAqIHNjb3BlcyBoYXZlIGJlZW4gcHJvdmlzaW9uZWQuXG4gICAqXG4gICAqIEBwYXJhbSBzY29wZXMgQSBsaXN0IG9mIGNvbnN0cnVjdCBzY29wZXMgd2hpY2ggdGhpcyB0cmlnZ2VyIHdpbGwgZGVwZW5kIG9uLlxuICAgKi9cbiAgZXhlY3V0ZUFmdGVyKC4uLnNjb3BlczogQ29uc3RydWN0W10pOiB2b2lkO1xuXG4gIC8qKlxuICAgKiBBZGRzIHRoaXMgdHJpZ2dlciBhcyBhIGRlcGVuZGVuY3kgb24gb3RoZXIgY29uc3RydWN0cy4gVGhpcyBtZWFucyB0aGF0IHRoaXNcbiAgICogdHJpZ2dlciB3aWxsIGdldCBleGVjdXRlZCAqYmVmb3JlKiB0aGUgZ2l2ZW4gY29uc3RydWN0KHMpLlxuICAgKlxuICAgKiBAcGFyYW0gc2NvcGVzIEEgbGlzdCBvZiBjb25zdHJ1Y3Qgc2NvcGVzIHdoaWNoIHdpbGwgdGFrZSBhIGRlcGVuZGVuY3kgb25cbiAgICogdGhpcyB0cmlnZ2VyLlxuICAgKi9cbiAgZXhlY3V0ZUJlZm9yZSguLi5zY29wZXM6IENvbnN0cnVjdFtdKTogdm9pZDtcbn1cblxuLyoqXG4gKiBPcHRpb25zIGZvciBgVHJpZ2dlcmAuXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgVHJpZ2dlck9wdGlvbnMge1xuICAvKipcbiAgICogQWRkcyB0cmlnZ2VyIGRlcGVuZGVuY2llcy4gRXhlY3V0ZSB0aGlzIHRyaWdnZXIgb25seSBhZnRlciB0aGVzZSBjb25zdHJ1Y3RcbiAgICogc2NvcGVzIGhhdmUgYmVlbiBwcm92aXNpb25lZC5cbiAgICpcbiAgICogWW91IGNhbiBhbHNvIHVzZSBgdHJpZ2dlci5leGVjdXRlQWZ0ZXIoKWAgdG8gYWRkIGFkZGl0aW9uYWwgZGVwZW5kZW5jaWVzLlxuICAgKlxuICAgKiBAZGVmYXVsdCBbXVxuICAgKi9cbiAgcmVhZG9ubHkgZXhlY3V0ZUFmdGVyPzogQ29uc3RydWN0W107XG5cbiAgLyoqXG4gICAqIEFkZHMgdGhpcyB0cmlnZ2VyIGFzIGEgZGVwZW5kZW5jeSBvbiBvdGhlciBjb25zdHJ1Y3RzLiBUaGlzIG1lYW5zIHRoYXQgdGhpc1xuICAgKiB0cmlnZ2VyIHdpbGwgZ2V0IGV4ZWN1dGVkICpiZWZvcmUqIHRoZSBnaXZlbiBjb25zdHJ1Y3QocykuXG4gICAqXG4gICAqIFlvdSBjYW4gYWxzbyB1c2UgYHRyaWdnZXIuZXhlY3V0ZUJlZm9yZSgpYCB0byBhZGQgYWRkaXRpb25hbCBkZXBlbmRhbnRzLlxuICAgKlxuICAgKiBAZGVmYXVsdCBbXVxuICAgKi9cbiAgcmVhZG9ubHkgZXhlY3V0ZUJlZm9yZT86IENvbnN0cnVjdFtdO1xuXG4gIC8qKlxuICAgKiBSZS1leGVjdXRlcyB0aGUgdHJpZ2dlciBldmVyeSB0aW1lIHRoZSBoYW5kbGVyIGNoYW5nZXMuXG4gICAqXG4gICAqIFRoaXMgaW1wbGllcyB0aGF0IHRoZSB0cmlnZ2VyIGlzIGFzc29jaWF0ZWQgd2l0aCB0aGUgYGN1cnJlbnRWZXJzaW9uYCBvZlxuICAgKiB0aGUgaGFuZGxlciwgd2hpY2ggZ2V0cyByZWNyZWF0ZWQgZXZlcnkgdGltZSB0aGUgaGFuZGxlciBvciBpdHNcbiAgICogY29uZmlndXJhdGlvbiBpcyB1cGRhdGVkLlxuICAgKlxuICAgKiBAZGVmYXVsdCB0cnVlXG4gICAqL1xuICByZWFkb25seSBleGVjdXRlT25IYW5kbGVyQ2hhbmdlPzogYm9vbGVhbjtcbn1cblxuLyoqXG4gKiBQcm9wcyBmb3IgYFRyaWdnZXJgLlxuICovXG5leHBvcnQgaW50ZXJmYWNlIFRyaWdnZXJQcm9wcyBleHRlbmRzIFRyaWdnZXJPcHRpb25zIHtcbiAgLyoqXG4gICAqIFRoZSBBV1MgTGFtYmRhIGZ1bmN0aW9uIG9mIHRoZSBoYW5kbGVyIHRvIGV4ZWN1dGUuXG4gICAqL1xuICByZWFkb25seSBoYW5kbGVyOiBsYW1iZGEuRnVuY3Rpb247XG59XG5cbi8qKlxuICogVHJpZ2dlcnMgYW4gQVdTIExhbWJkYSBmdW5jdGlvbiBkdXJpbmcgZGVwbG95bWVudC5cbiAqL1xuZXhwb3J0IGNsYXNzIFRyaWdnZXIgZXh0ZW5kcyBDb3JlQ29uc3RydWN0IGltcGxlbWVudHMgSVRyaWdnZXIge1xuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogVHJpZ2dlclByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcblxuICAgIGNvbnN0IGhhbmRsZXJBcm4gPSB0aGlzLmRldGVybWluZUhhbmRsZXJBcm4ocHJvcHMpO1xuICAgIGNvbnN0IHByb3ZpZGVyID0gQ3VzdG9tUmVzb3VyY2VQcm92aWRlci5nZXRPckNyZWF0ZVByb3ZpZGVyKHRoaXMsICdBV1NDREsuVHJpZ2dlckN1c3RvbVJlc291cmNlUHJvdmlkZXInLCB7XG4gICAgICBydW50aW1lOiBDdXN0b21SZXNvdXJjZVByb3ZpZGVyUnVudGltZS5OT0RFSlNfMTRfWCxcbiAgICAgIGNvZGVEaXJlY3Rvcnk6IGpvaW4oX19kaXJuYW1lLCAnbGFtYmRhJyksXG4gICAgICBwb2xpY3lTdGF0ZW1lbnRzOiBbXG4gICAgICAgIHtcbiAgICAgICAgICBFZmZlY3Q6ICdBbGxvdycsXG4gICAgICAgICAgQWN0aW9uOiBbJ2xhbWJkYTpJbnZva2VGdW5jdGlvbiddLFxuICAgICAgICAgIFJlc291cmNlOiBbaGFuZGxlckFybl0sXG4gICAgICAgIH0sXG4gICAgICBdLFxuICAgIH0pO1xuXG4gICAgbmV3IEN1c3RvbVJlc291cmNlKHRoaXMsICdEZWZhdWx0Jywge1xuICAgICAgcmVzb3VyY2VUeXBlOiAnQ3VzdG9tOjpUcmlnZ2VyJyxcbiAgICAgIHNlcnZpY2VUb2tlbjogcHJvdmlkZXIuc2VydmljZVRva2VuLFxuICAgICAgcHJvcGVydGllczoge1xuICAgICAgICBIYW5kbGVyQXJuOiBoYW5kbGVyQXJuLFxuICAgICAgfSxcbiAgICB9KTtcblxuICAgIHRoaXMuZXhlY3V0ZUFmdGVyKC4uLnByb3BzLmV4ZWN1dGVBZnRlciA/PyBbXSk7XG4gICAgdGhpcy5leGVjdXRlQmVmb3JlKC4uLnByb3BzLmV4ZWN1dGVCZWZvcmUgPz8gW10pO1xuICB9XG5cbiAgcHVibGljIGV4ZWN1dGVBZnRlciguLi5zY29wZXM6IENvbnN0cnVjdFtdKTogdm9pZCB7XG4gICAgTm9kZS5vZih0aGlzKS5hZGREZXBlbmRlbmN5KC4uLnNjb3Blcyk7XG4gIH1cblxuICBwdWJsaWMgZXhlY3V0ZUJlZm9yZSguLi5zY29wZXM6IENvbnN0cnVjdFtdKTogdm9pZCB7XG4gICAgZm9yIChjb25zdCBzIG9mIHNjb3Blcykge1xuICAgICAgTm9kZS5vZihzKS5hZGREZXBlbmRlbmN5KHRoaXMpO1xuICAgIH1cbiAgfVxuXG4gIHByaXZhdGUgZGV0ZXJtaW5lSGFuZGxlckFybihwcm9wczogVHJpZ2dlclByb3BzKSB7XG4gICAgcmV0dXJuIHByb3BzLmhhbmRsZXIuY3VycmVudFZlcnNpb24uZnVuY3Rpb25Bcm47XG4gICAgLy8gY29uc3QgZXhlY3V0ZU9uSGFuZGxlckNoYW5nZSA9IHByb3BzLmV4ZWN1dGVPbkhhbmRsZXJDaGFuZ2UgPz8gdHJ1ZTtcbiAgICAvLyBpZiAoZXhlY3V0ZU9uSGFuZGxlckNoYW5nZSkge1xuICAgIC8vIH1cblxuICAgIC8vIHJldHVybiBwcm9wcy5oYW5kbGVyLmZ1bmN0aW9uQXJuO1xuICB9XG59XG5cbi8qKlxuICogRGV0ZXJtaW5lc1xuICovXG5leHBvcnQgZW51bSBUcmlnZ2VySW52YWxpZGF0aW9uIHtcbiAgLyoqXG4gICAqIFRoZSB0cmlnZ2VyIHdpbGwgYmUgZXhlY3V0ZWQgZXZlcnkgdGltZSB0aGUgaGFuZGxlciAob3IgaXRzIGNvbmZpZ3VyYXRpb24pXG4gICAqIGNoYW5nZXMuIFRoaXMgaXMgaW1wbGVtZW50ZWQgYnkgYXNzb2NpYXRlZCB0aGUgdHJpZ2dlciB3aXRoIHRoZSBgY3VycmVudFZlcnNpb25gXG4gICAqIG9mIHRoZSBBV1MgTGFtYmRhIGZ1bmN0aW9uLCB3aGljaCBnZXRzIHJlY3JlYXRlZCBldmVyeSB0aW1lIHRoZSBoYW5kbGVyIGNoYW5nZXMuXG4gICAqL1xuICBIQU5ETEVSX0NIQU5HRSA9ICdXSEVOX0ZVTkNUSU9OX0NIQU5HRVMnLFxufSJdfQ==