"""
    Dropbox Sign API

    Dropbox Sign v3 API  # noqa: E501

    The version of the OpenAPI document: 3.0.0
    Contact: apisupport@hellosign.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from typing import TYPE_CHECKING, Optional, List, Dict, Union
import json  # noqa: F401
import re  # noqa: F401
import sys  # noqa: F401

from dropbox_sign import ApiClient
from dropbox_sign.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from dropbox_sign.exceptions import ApiAttributeError
if TYPE_CHECKING:
    from dropbox_sign.model.signature_request_response import SignatureRequestResponse
    from dropbox_sign.model.signature_request_response_attachment import SignatureRequestResponseAttachment
    from dropbox_sign.model.signature_request_response_custom_field_base import SignatureRequestResponseCustomFieldBase
    from dropbox_sign.model.signature_request_response_data_base import SignatureRequestResponseDataBase
    from dropbox_sign.model.signature_request_response_signatures import SignatureRequestResponseSignatures


def lazy_import():
    from dropbox_sign.model.signature_request_response import SignatureRequestResponse
    from dropbox_sign.model.signature_request_response_attachment import SignatureRequestResponseAttachment
    from dropbox_sign.model.signature_request_response_custom_field_base import SignatureRequestResponseCustomFieldBase
    from dropbox_sign.model.signature_request_response_data_base import SignatureRequestResponseDataBase
    from dropbox_sign.model.signature_request_response_signatures import SignatureRequestResponseSignatures
    globals()['SignatureRequestResponse'] = SignatureRequestResponse
    globals()['SignatureRequestResponseAttachment'] = SignatureRequestResponseAttachment
    globals()['SignatureRequestResponseCustomFieldBase'] = SignatureRequestResponseCustomFieldBase
    globals()['SignatureRequestResponseDataBase'] = SignatureRequestResponseDataBase
    globals()['SignatureRequestResponseSignatures'] = SignatureRequestResponseSignatures


class BulkSendJobGetResponseSignatureRequests(ModelComposed):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'test_mode': (bool, none_type,),  # noqa: E501
            'signature_request_id': (str,),  # noqa: E501
            'requester_email_address': (str,),  # noqa: E501
            'title': (str,),  # noqa: E501
            'original_title': (str,),  # noqa: E501
            'subject': (str, none_type,),  # noqa: E501
            'message': (str, none_type,),  # noqa: E501
            'metadata': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),  # noqa: E501
            'created_at': (int,),  # noqa: E501
            'expires_at': (int,),  # noqa: E501
            'is_complete': (bool,),  # noqa: E501
            'is_declined': (bool,),  # noqa: E501
            'has_error': (bool,),  # noqa: E501
            'files_url': (str,),  # noqa: E501
            'signing_url': (str, none_type,),  # noqa: E501
            'details_url': (str,),  # noqa: E501
            'cc_email_addresses': ([str],),  # noqa: E501
            'signing_redirect_url': (str, none_type,),  # noqa: E501
            'template_ids': ([str], none_type,),  # noqa: E501
            'custom_fields': ([SignatureRequestResponseCustomFieldBase], none_type,),  # noqa: E501
            'attachments': ([SignatureRequestResponseAttachment], none_type,),  # noqa: E501
            'response_data': ([SignatureRequestResponseDataBase], none_type,),  # noqa: E501
            'signatures': ([SignatureRequestResponseSignatures],),  # noqa: E501
            'bulk_send_job_id': (str,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None

    @staticmethod
    def init(data: any) -> BulkSendJobGetResponseSignatureRequests:
        """
        Attempt to instantiate and hydrate a new instance of this class
        """
        try:
            obj_data = json.dumps(data)
        except TypeError:
            obj_data = data

        return ApiClient().deserialize(
            response=type('obj_dict', (object,), {'data': obj_data}),
            response_type=[BulkSendJobGetResponseSignatureRequests],
            _check_type=True,
        )


    attribute_map = {
        'test_mode': 'test_mode',  # noqa: E501
        'signature_request_id': 'signature_request_id',  # noqa: E501
        'requester_email_address': 'requester_email_address',  # noqa: E501
        'title': 'title',  # noqa: E501
        'original_title': 'original_title',  # noqa: E501
        'subject': 'subject',  # noqa: E501
        'message': 'message',  # noqa: E501
        'metadata': 'metadata',  # noqa: E501
        'created_at': 'created_at',  # noqa: E501
        'expires_at': 'expires_at',  # noqa: E501
        'is_complete': 'is_complete',  # noqa: E501
        'is_declined': 'is_declined',  # noqa: E501
        'has_error': 'has_error',  # noqa: E501
        'files_url': 'files_url',  # noqa: E501
        'signing_url': 'signing_url',  # noqa: E501
        'details_url': 'details_url',  # noqa: E501
        'cc_email_addresses': 'cc_email_addresses',  # noqa: E501
        'signing_redirect_url': 'signing_redirect_url',  # noqa: E501
        'template_ids': 'template_ids',  # noqa: E501
        'custom_fields': 'custom_fields',  # noqa: E501
        'attachments': 'attachments',  # noqa: E501
        'response_data': 'response_data',  # noqa: E501
        'signatures': 'signatures',  # noqa: E501
        'bulk_send_job_id': 'bulk_send_job_id',  # noqa: E501
    }

    read_only_vars = {
    }

    @property
    def test_mode(self) -> Optional[bool]:
        return self.get("test_mode")

    @test_mode.setter
    def test_mode(self, value: Optional[bool]):
        setattr(self, "test_mode", value)

    @property
    def signature_request_id(self) -> str:
        return self.get("signature_request_id")

    @signature_request_id.setter
    def signature_request_id(self, value: str):
        setattr(self, "signature_request_id", value)

    @property
    def requester_email_address(self) -> str:
        return self.get("requester_email_address")

    @requester_email_address.setter
    def requester_email_address(self, value: str):
        setattr(self, "requester_email_address", value)

    @property
    def title(self) -> str:
        return self.get("title")

    @title.setter
    def title(self, value: str):
        setattr(self, "title", value)

    @property
    def original_title(self) -> str:
        return self.get("original_title")

    @original_title.setter
    def original_title(self, value: str):
        setattr(self, "original_title", value)

    @property
    def subject(self) -> Optional[str]:
        return self.get("subject")

    @subject.setter
    def subject(self, value: Optional[str]):
        setattr(self, "subject", value)

    @property
    def message(self) -> Optional[str]:
        return self.get("message")

    @message.setter
    def message(self, value: Optional[str]):
        setattr(self, "message", value)

    @property
    def metadata(self) -> Dict[str, Union[bool, date, datetime, dict, float, int, list, str, none_type]]:
        return self.get("metadata")

    @metadata.setter
    def metadata(self, value: Dict[str, Union[bool, date, datetime, dict, float, int, list, str, none_type]]):
        setattr(self, "metadata", value)

    @property
    def created_at(self) -> int:
        return self.get("created_at")

    @created_at.setter
    def created_at(self, value: int):
        setattr(self, "created_at", value)

    @property
    def expires_at(self) -> int:
        return self.get("expires_at")

    @expires_at.setter
    def expires_at(self, value: int):
        setattr(self, "expires_at", value)

    @property
    def is_complete(self) -> bool:
        return self.get("is_complete")

    @is_complete.setter
    def is_complete(self, value: bool):
        setattr(self, "is_complete", value)

    @property
    def is_declined(self) -> bool:
        return self.get("is_declined")

    @is_declined.setter
    def is_declined(self, value: bool):
        setattr(self, "is_declined", value)

    @property
    def has_error(self) -> bool:
        return self.get("has_error")

    @has_error.setter
    def has_error(self, value: bool):
        setattr(self, "has_error", value)

    @property
    def files_url(self) -> str:
        return self.get("files_url")

    @files_url.setter
    def files_url(self, value: str):
        setattr(self, "files_url", value)

    @property
    def signing_url(self) -> Optional[str]:
        return self.get("signing_url")

    @signing_url.setter
    def signing_url(self, value: Optional[str]):
        setattr(self, "signing_url", value)

    @property
    def details_url(self) -> str:
        return self.get("details_url")

    @details_url.setter
    def details_url(self, value: str):
        setattr(self, "details_url", value)

    @property
    def cc_email_addresses(self) -> List[str]:
        return self.get("cc_email_addresses")

    @cc_email_addresses.setter
    def cc_email_addresses(self, value: List[str]):
        setattr(self, "cc_email_addresses", value)

    @property
    def signing_redirect_url(self) -> Optional[str]:
        return self.get("signing_redirect_url")

    @signing_redirect_url.setter
    def signing_redirect_url(self, value: Optional[str]):
        setattr(self, "signing_redirect_url", value)

    @property
    def template_ids(self) -> Optional[List[str]]:
        return self.get("template_ids")

    @template_ids.setter
    def template_ids(self, value: Optional[List[str]]):
        setattr(self, "template_ids", value)

    @property
    def custom_fields(self) -> Optional[List[SignatureRequestResponseCustomFieldBase]]:
        return self.get("custom_fields")

    @custom_fields.setter
    def custom_fields(self, value: Optional[List[SignatureRequestResponseCustomFieldBase]]):
        setattr(self, "custom_fields", value)

    @property
    def attachments(self) -> Optional[List[SignatureRequestResponseAttachment]]:
        return self.get("attachments")

    @attachments.setter
    def attachments(self, value: Optional[List[SignatureRequestResponseAttachment]]):
        setattr(self, "attachments", value)

    @property
    def response_data(self) -> Optional[List[SignatureRequestResponseDataBase]]:
        return self.get("response_data")

    @response_data.setter
    def response_data(self, value: Optional[List[SignatureRequestResponseDataBase]]):
        setattr(self, "response_data", value)

    @property
    def signatures(self) -> List[SignatureRequestResponseSignatures]:
        return self.get("signatures")

    @signatures.setter
    def signatures(self, value: List[SignatureRequestResponseSignatures]):
        setattr(self, "signatures", value)

    @property
    def bulk_send_job_id(self) -> str:
        return self.get("bulk_send_job_id")

    @bulk_send_job_id.setter
    def bulk_send_job_id(self, value: str):
        setattr(self, "bulk_send_job_id", value)

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """BulkSendJobGetResponseSignatureRequests - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            test_mode (bool, none_type): Whether this is a test signature request. Test requests have no legal value. Defaults to `false`.. [optional] if omitted the server will use the default value of False  # noqa: E501
            signature_request_id (str): The id of the SignatureRequest.. [optional]  # noqa: E501
            requester_email_address (str): The email address of the initiator of the SignatureRequest.. [optional]  # noqa: E501
            title (str): The title the specified Account uses for the SignatureRequest.. [optional]  # noqa: E501
            original_title (str): Default Label for account.. [optional]  # noqa: E501
            subject (str, none_type): The subject in the email that was initially sent to the signers.. [optional]  # noqa: E501
            message (str, none_type): The custom message in the email that was initially sent to the signers.. [optional]  # noqa: E501
            metadata ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): The metadata attached to the signature request.. [optional]  # noqa: E501
            created_at (int): Time the signature request was created.. [optional]  # noqa: E501
            expires_at (int): The time when the signature request will expire unsigned signatures. See [Signature Request Expiration Date](https://developers.hellosign.com/docs/signature-request/expiration/) for details.. [optional]  # noqa: E501
            is_complete (bool): Whether or not the SignatureRequest has been fully executed by all signers.. [optional]  # noqa: E501
            is_declined (bool): Whether or not the SignatureRequest has been declined by a signer.. [optional]  # noqa: E501
            has_error (bool): Whether or not an error occurred (either during the creation of the SignatureRequest or during one of the signings).. [optional]  # noqa: E501
            files_url (str): The URL where a copy of the request's documents can be downloaded.. [optional]  # noqa: E501
            signing_url (str, none_type): The URL where a signer, after authenticating, can sign the documents. This should only be used by users with existing Dropbox Sign accounts as they will be required to log in before signing.. [optional]  # noqa: E501
            details_url (str): The URL where the requester and the signers can view the current status of the SignatureRequest.. [optional]  # noqa: E501
            cc_email_addresses ([str]): A list of email addresses that were CCed on the SignatureRequest. They will receive a copy of the final PDF once all the signers have signed.. [optional]  # noqa: E501
            signing_redirect_url (str, none_type): The URL you want the signer redirected to after they successfully sign.. [optional]  # noqa: E501
            template_ids ([str], none_type): Templates IDs used in this SignatureRequest (if any).. [optional]  # noqa: E501
            custom_fields ([SignatureRequestResponseCustomFieldBase], none_type): An array of Custom Field objects containing the name and type of each custom field.  * Text Field uses `SignatureRequestResponseCustomFieldText` * Checkbox Field uses `SignatureRequestResponseCustomFieldCheckbox`. [optional]  # noqa: E501
            attachments ([SignatureRequestResponseAttachment], none_type): Signer attachments.. [optional]  # noqa: E501
            response_data ([SignatureRequestResponseDataBase], none_type): An array of form field objects containing the name, value, and type of each textbox or checkmark field filled in by the signers.. [optional]  # noqa: E501
            signatures ([SignatureRequestResponseSignatures]): An array of signature objects, 1 for each signer.. [optional]  # noqa: E501
            bulk_send_job_id (str): The id of the BulkSendJob.. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        constant_args = {
            '_check_type': _check_type,
            '_path_to_item': _path_to_item,
            '_spec_property_naming': _spec_property_naming,
            '_configuration': _configuration,
            '_visited_composed_classes': self._visited_composed_classes,
        }
        composed_info = validate_get_composed_info(
            constant_args, kwargs, self)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        discarded_args = composed_info[3]

        for var_name, var_value in kwargs.items():
            if var_name in discarded_args and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self._additional_properties_model_instances:
                # discard variable.
                continue
            setattr(self, var_name, var_value)

        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
        '_composed_instances',
        '_var_name_to_model_instances',
        '_additional_properties_model_instances',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """BulkSendJobGetResponseSignatureRequests - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            test_mode (bool, none_type): Whether this is a test signature request. Test requests have no legal value. Defaults to `false`.. [optional] if omitted the server will use the default value of False  # noqa: E501
            signature_request_id (str): The id of the SignatureRequest.. [optional]  # noqa: E501
            requester_email_address (str): The email address of the initiator of the SignatureRequest.. [optional]  # noqa: E501
            title (str): The title the specified Account uses for the SignatureRequest.. [optional]  # noqa: E501
            original_title (str): Default Label for account.. [optional]  # noqa: E501
            subject (str, none_type): The subject in the email that was initially sent to the signers.. [optional]  # noqa: E501
            message (str, none_type): The custom message in the email that was initially sent to the signers.. [optional]  # noqa: E501
            metadata ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): The metadata attached to the signature request.. [optional]  # noqa: E501
            created_at (int): Time the signature request was created.. [optional]  # noqa: E501
            expires_at (int): The time when the signature request will expire unsigned signatures. See [Signature Request Expiration Date](https://developers.hellosign.com/docs/signature-request/expiration/) for details.. [optional]  # noqa: E501
            is_complete (bool): Whether or not the SignatureRequest has been fully executed by all signers.. [optional]  # noqa: E501
            is_declined (bool): Whether or not the SignatureRequest has been declined by a signer.. [optional]  # noqa: E501
            has_error (bool): Whether or not an error occurred (either during the creation of the SignatureRequest or during one of the signings).. [optional]  # noqa: E501
            files_url (str): The URL where a copy of the request's documents can be downloaded.. [optional]  # noqa: E501
            signing_url (str, none_type): The URL where a signer, after authenticating, can sign the documents. This should only be used by users with existing Dropbox Sign accounts as they will be required to log in before signing.. [optional]  # noqa: E501
            details_url (str): The URL where the requester and the signers can view the current status of the SignatureRequest.. [optional]  # noqa: E501
            cc_email_addresses ([str]): A list of email addresses that were CCed on the SignatureRequest. They will receive a copy of the final PDF once all the signers have signed.. [optional]  # noqa: E501
            signing_redirect_url (str, none_type): The URL you want the signer redirected to after they successfully sign.. [optional]  # noqa: E501
            template_ids ([str], none_type): Templates IDs used in this SignatureRequest (if any).. [optional]  # noqa: E501
            custom_fields ([SignatureRequestResponseCustomFieldBase], none_type): An array of Custom Field objects containing the name and type of each custom field.  * Text Field uses `SignatureRequestResponseCustomFieldText` * Checkbox Field uses `SignatureRequestResponseCustomFieldCheckbox`. [optional]  # noqa: E501
            attachments ([SignatureRequestResponseAttachment], none_type): Signer attachments.. [optional]  # noqa: E501
            response_data ([SignatureRequestResponseDataBase], none_type): An array of form field objects containing the name, value, and type of each textbox or checkmark field filled in by the signers.. [optional]  # noqa: E501
            signatures ([SignatureRequestResponseSignatures]): An array of signature objects, 1 for each signer.. [optional]  # noqa: E501
            bulk_send_job_id (str): The id of the BulkSendJob.. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        constant_args = {
            '_check_type': _check_type,
            '_path_to_item': _path_to_item,
            '_spec_property_naming': _spec_property_naming,
            '_configuration': _configuration,
            '_visited_composed_classes': self._visited_composed_classes,
        }
        composed_info = validate_get_composed_info(
            constant_args, kwargs, self)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        discarded_args = composed_info[3]

        for var_name, var_value in kwargs.items():
            if var_name in discarded_args and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self._additional_properties_model_instances:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")

    @cached_property
    def _composed_schemas():
        # we need this here to make our import statements work
        # we must store _composed_schemas in here so the code is only run
        # when we invoke this method. If we kept this at the class
        # level we would get an error because the class level
        # code would be run when this module is imported, and these composed
        # classes don't exist yet because their module has not finished
        # loading
        lazy_import()
        return {
          'anyOf': [
          ],
          'oneOf': [
          ],
        }
