"""
    Dropbox Sign API

    Dropbox Sign v3 API  # noqa: E501

    The version of the OpenAPI document: 3.0.0
    Contact: apisupport@hellosign.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from typing import TYPE_CHECKING, Optional, List, Dict, Union
import json  # noqa: F401
import re  # noqa: F401
import sys  # noqa: F401

from dropbox_sign import ApiClient
from dropbox_sign.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from dropbox_sign.exceptions import ApiAttributeError



class SignatureRequestResponseSignatures(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        return {
            'signature_id': (str,),  # noqa: E501
            'signer_group_guid': (str, none_type,),  # noqa: E501
            'signer_email_address': (str,),  # noqa: E501
            'signer_name': (str, none_type,),  # noqa: E501
            'signer_role': (str, none_type,),  # noqa: E501
            'order': (int, none_type,),  # noqa: E501
            'status_code': (str,),  # noqa: E501
            'decline_reason': (str, none_type,),  # noqa: E501
            'signed_at': (int, none_type,),  # noqa: E501
            'last_viewed_at': (int, none_type,),  # noqa: E501
            'last_reminded_at': (int, none_type,),  # noqa: E501
            'has_pin': (bool,),  # noqa: E501
            'has_sms_auth': (bool, none_type,),  # noqa: E501
            'has_sms_delivery': (bool, none_type,),  # noqa: E501
            'sms_phone_number': (str, none_type,),  # noqa: E501
            'reassigned_by': (str, none_type,),  # noqa: E501
            'reassignment_reason': (str, none_type,),  # noqa: E501
            'reassigned_from': (str, none_type,),  # noqa: E501
            'error': (str, none_type,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None

    @staticmethod
    def init(data: any) -> SignatureRequestResponseSignatures:
        """
        Attempt to instantiate and hydrate a new instance of this class
        """
        try:
            obj_data = json.dumps(data)
        except TypeError:
            obj_data = data

        return ApiClient().deserialize(
            response=type('obj_dict', (object,), {'data': obj_data}),
            response_type=[SignatureRequestResponseSignatures],
            _check_type=True,
        )

    attribute_map = {
        'signature_id': 'signature_id',  # noqa: E501
        'signer_group_guid': 'signer_group_guid',  # noqa: E501
        'signer_email_address': 'signer_email_address',  # noqa: E501
        'signer_name': 'signer_name',  # noqa: E501
        'signer_role': 'signer_role',  # noqa: E501
        'order': 'order',  # noqa: E501
        'status_code': 'status_code',  # noqa: E501
        'decline_reason': 'decline_reason',  # noqa: E501
        'signed_at': 'signed_at',  # noqa: E501
        'last_viewed_at': 'last_viewed_at',  # noqa: E501
        'last_reminded_at': 'last_reminded_at',  # noqa: E501
        'has_pin': 'has_pin',  # noqa: E501
        'has_sms_auth': 'has_sms_auth',  # noqa: E501
        'has_sms_delivery': 'has_sms_delivery',  # noqa: E501
        'sms_phone_number': 'sms_phone_number',  # noqa: E501
        'reassigned_by': 'reassigned_by',  # noqa: E501
        'reassignment_reason': 'reassignment_reason',  # noqa: E501
        'reassigned_from': 'reassigned_from',  # noqa: E501
        'error': 'error',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @property
    def signature_id(self) -> str:
        return self.get("signature_id")

    @signature_id.setter
    def signature_id(self, value: str):
        setattr(self, "signature_id", value)

    @property
    def signer_group_guid(self) -> Optional[str]:
        return self.get("signer_group_guid")

    @signer_group_guid.setter
    def signer_group_guid(self, value: Optional[str]):
        setattr(self, "signer_group_guid", value)

    @property
    def signer_email_address(self) -> str:
        return self.get("signer_email_address")

    @signer_email_address.setter
    def signer_email_address(self, value: str):
        setattr(self, "signer_email_address", value)

    @property
    def signer_name(self) -> Optional[str]:
        return self.get("signer_name")

    @signer_name.setter
    def signer_name(self, value: Optional[str]):
        setattr(self, "signer_name", value)

    @property
    def signer_role(self) -> Optional[str]:
        return self.get("signer_role")

    @signer_role.setter
    def signer_role(self, value: Optional[str]):
        setattr(self, "signer_role", value)

    @property
    def order(self) -> Optional[int]:
        return self.get("order")

    @order.setter
    def order(self, value: Optional[int]):
        setattr(self, "order", value)

    @property
    def status_code(self) -> str:
        return self.get("status_code")

    @status_code.setter
    def status_code(self, value: str):
        setattr(self, "status_code", value)

    @property
    def decline_reason(self) -> Optional[str]:
        return self.get("decline_reason")

    @decline_reason.setter
    def decline_reason(self, value: Optional[str]):
        setattr(self, "decline_reason", value)

    @property
    def signed_at(self) -> Optional[int]:
        return self.get("signed_at")

    @signed_at.setter
    def signed_at(self, value: Optional[int]):
        setattr(self, "signed_at", value)

    @property
    def last_viewed_at(self) -> Optional[int]:
        return self.get("last_viewed_at")

    @last_viewed_at.setter
    def last_viewed_at(self, value: Optional[int]):
        setattr(self, "last_viewed_at", value)

    @property
    def last_reminded_at(self) -> Optional[int]:
        return self.get("last_reminded_at")

    @last_reminded_at.setter
    def last_reminded_at(self, value: Optional[int]):
        setattr(self, "last_reminded_at", value)

    @property
    def has_pin(self) -> bool:
        return self.get("has_pin")

    @has_pin.setter
    def has_pin(self, value: bool):
        setattr(self, "has_pin", value)

    @property
    def has_sms_auth(self) -> Optional[bool]:
        return self.get("has_sms_auth")

    @has_sms_auth.setter
    def has_sms_auth(self, value: Optional[bool]):
        setattr(self, "has_sms_auth", value)

    @property
    def has_sms_delivery(self) -> Optional[bool]:
        return self.get("has_sms_delivery")

    @has_sms_delivery.setter
    def has_sms_delivery(self, value: Optional[bool]):
        setattr(self, "has_sms_delivery", value)

    @property
    def sms_phone_number(self) -> Optional[str]:
        return self.get("sms_phone_number")

    @sms_phone_number.setter
    def sms_phone_number(self, value: Optional[str]):
        setattr(self, "sms_phone_number", value)

    @property
    def reassigned_by(self) -> Optional[str]:
        return self.get("reassigned_by")

    @reassigned_by.setter
    def reassigned_by(self, value: Optional[str]):
        setattr(self, "reassigned_by", value)

    @property
    def reassignment_reason(self) -> Optional[str]:
        return self.get("reassignment_reason")

    @reassignment_reason.setter
    def reassignment_reason(self, value: Optional[str]):
        setattr(self, "reassignment_reason", value)

    @property
    def reassigned_from(self) -> Optional[str]:
        return self.get("reassigned_from")

    @reassigned_from.setter
    def reassigned_from(self, value: Optional[str]):
        setattr(self, "reassigned_from", value)

    @property
    def error(self) -> Optional[str]:
        return self.get("error")

    @error.setter
    def error(self, value: Optional[str]):
        setattr(self, "error", value)

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """SignatureRequestResponseSignatures - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            signature_id (str): Signature identifier.. [optional]  # noqa: E501
            signer_group_guid (str, none_type): Signer Group GUID. [optional]  # noqa: E501
            signer_email_address (str): The email address of the signer.. [optional]  # noqa: E501
            signer_name (str, none_type): The name of the signer.. [optional]  # noqa: E501
            signer_role (str, none_type): The role of the signer.. [optional]  # noqa: E501
            order (int, none_type): If signer order is assigned this is the 0-based index for this signer.. [optional]  # noqa: E501
            status_code (str): The current status of the signature. eg: awaiting_signature, signed, declined.. [optional]  # noqa: E501
            decline_reason (str, none_type): The reason provided by the signer for declining the request.. [optional]  # noqa: E501
            signed_at (int, none_type): Time that the document was signed or null.. [optional]  # noqa: E501
            last_viewed_at (int, none_type): The time that the document was last viewed by this signer or null.. [optional]  # noqa: E501
            last_reminded_at (int, none_type): The time the last reminder email was sent to the signer or null.. [optional]  # noqa: E501
            has_pin (bool): Boolean to indicate whether this signature requires a PIN to access.. [optional]  # noqa: E501
            has_sms_auth (bool, none_type): Boolean to indicate whether this signature has SMS authentication enabled.. [optional]  # noqa: E501
            has_sms_delivery (bool, none_type): Boolean to indicate whether this signature has SMS delivery enabled.. [optional]  # noqa: E501
            sms_phone_number (str, none_type): The SMS phone number used for authentication or signature request delivery.. [optional]  # noqa: E501
            reassigned_by (str, none_type): Email address of original signer who reassigned to this signer.. [optional]  # noqa: E501
            reassignment_reason (str, none_type): Reason provided by original signer who reassigned to this signer.. [optional]  # noqa: E501
            reassigned_from (str, none_type): Previous signature identifier.. [optional]  # noqa: E501
            error (str, none_type): Error message pertaining to this signer, or null.. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """SignatureRequestResponseSignatures - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            signature_id (str): Signature identifier.. [optional]  # noqa: E501
            signer_group_guid (str, none_type): Signer Group GUID. [optional]  # noqa: E501
            signer_email_address (str): The email address of the signer.. [optional]  # noqa: E501
            signer_name (str, none_type): The name of the signer.. [optional]  # noqa: E501
            signer_role (str, none_type): The role of the signer.. [optional]  # noqa: E501
            order (int, none_type): If signer order is assigned this is the 0-based index for this signer.. [optional]  # noqa: E501
            status_code (str): The current status of the signature. eg: awaiting_signature, signed, declined.. [optional]  # noqa: E501
            decline_reason (str, none_type): The reason provided by the signer for declining the request.. [optional]  # noqa: E501
            signed_at (int, none_type): Time that the document was signed or null.. [optional]  # noqa: E501
            last_viewed_at (int, none_type): The time that the document was last viewed by this signer or null.. [optional]  # noqa: E501
            last_reminded_at (int, none_type): The time the last reminder email was sent to the signer or null.. [optional]  # noqa: E501
            has_pin (bool): Boolean to indicate whether this signature requires a PIN to access.. [optional]  # noqa: E501
            has_sms_auth (bool, none_type): Boolean to indicate whether this signature has SMS authentication enabled.. [optional]  # noqa: E501
            has_sms_delivery (bool, none_type): Boolean to indicate whether this signature has SMS delivery enabled.. [optional]  # noqa: E501
            sms_phone_number (str, none_type): The SMS phone number used for authentication or signature request delivery.. [optional]  # noqa: E501
            reassigned_by (str, none_type): Email address of original signer who reassigned to this signer.. [optional]  # noqa: E501
            reassignment_reason (str, none_type): Reason provided by original signer who reassigned to this signer.. [optional]  # noqa: E501
            reassigned_from (str, none_type): Previous signature identifier.. [optional]  # noqa: E501
            error (str, none_type): Error message pertaining to this signer, or null.. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
