"""
    Dropbox Sign API

    Dropbox Sign v3 API  # noqa: E501

    The version of the OpenAPI document: 3.0.0
    Contact: apisupport@hellosign.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from typing import TYPE_CHECKING, Optional, List, Dict, Union
import json  # noqa: F401
import re  # noqa: F401
import sys  # noqa: F401

from dropbox_sign import ApiClient
from dropbox_sign.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from dropbox_sign.exceptions import ApiAttributeError
if TYPE_CHECKING:
    from dropbox_sign.model.sub_form_fields_per_document_base import SubFormFieldsPerDocumentBase


def lazy_import():
    from dropbox_sign.model.sub_form_fields_per_document_base import SubFormFieldsPerDocumentBase
    globals()['SubFormFieldsPerDocumentBase'] = SubFormFieldsPerDocumentBase


class SubFormFieldsPerDocumentText(ModelComposed):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('validation_type',): {
            'NUMBERS_ONLY': "numbers_only",
            'LETTERS_ONLY': "letters_only",
            'PHONE_NUMBER': "phone_number",
            'BANK_ROUTING_NUMBER': "bank_routing_number",
            'BANK_ACCOUNT_NUMBER': "bank_account_number",
            'EMAIL_ADDRESS': "email_address",
            'ZIP_CODE': "zip_code",
            'SOCIAL_SECURITY_NUMBER': "social_security_number",
            'EMPLOYER_IDENTIFICATION_NUMBER': "employer_identification_number",
            'CUSTOM_REGEX': "custom_regex",
        },
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'type': (str,),  # noqa: E501
            'document_index': (int,),  # noqa: E501
            'api_id': (str,),  # noqa: E501
            'height': (int,),  # noqa: E501
            'required': (bool,),  # noqa: E501
            'signer': (int, str,),  # noqa: E501
            'width': (int,),  # noqa: E501
            'x': (int,),  # noqa: E501
            'y': (int,),  # noqa: E501
            'placeholder': (str,),  # noqa: E501
            'auto_fill_type': (str,),  # noqa: E501
            'link_id': (str,),  # noqa: E501
            'masked': (bool,),  # noqa: E501
            'validation_type': (str,),  # noqa: E501
            'validation_custom_regex': (str,),  # noqa: E501
            'validation_custom_regex_format_label': (str,),  # noqa: E501
            'name': (str,),  # noqa: E501
            'page': (int, none_type,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None

    @staticmethod
    def init(data: any) -> SubFormFieldsPerDocumentText:
        """
        Attempt to instantiate and hydrate a new instance of this class
        """
        try:
            obj_data = json.dumps(data)
        except TypeError:
            obj_data = data

        return ApiClient().deserialize(
            response=type('obj_dict', (object,), {'data': obj_data}),
            response_type=[SubFormFieldsPerDocumentText],
            _check_type=True,
        )


    attribute_map = {
        'type': 'type',  # noqa: E501
        'document_index': 'document_index',  # noqa: E501
        'api_id': 'api_id',  # noqa: E501
        'height': 'height',  # noqa: E501
        'required': 'required',  # noqa: E501
        'signer': 'signer',  # noqa: E501
        'width': 'width',  # noqa: E501
        'x': 'x',  # noqa: E501
        'y': 'y',  # noqa: E501
        'placeholder': 'placeholder',  # noqa: E501
        'auto_fill_type': 'auto_fill_type',  # noqa: E501
        'link_id': 'link_id',  # noqa: E501
        'masked': 'masked',  # noqa: E501
        'validation_type': 'validation_type',  # noqa: E501
        'validation_custom_regex': 'validation_custom_regex',  # noqa: E501
        'validation_custom_regex_format_label': 'validation_custom_regex_format_label',  # noqa: E501
        'name': 'name',  # noqa: E501
        'page': 'page',  # noqa: E501
    }

    read_only_vars = {
    }

    @property
    def type(self) -> str:
        return self.get("type")

    @type.setter
    def type(self, value: str):
        setattr(self, "type", value)

    @property
    def document_index(self) -> int:
        return self.get("document_index")

    @document_index.setter
    def document_index(self, value: int):
        setattr(self, "document_index", value)

    @property
    def api_id(self) -> str:
        return self.get("api_id")

    @api_id.setter
    def api_id(self, value: str):
        setattr(self, "api_id", value)

    @property
    def height(self) -> int:
        return self.get("height")

    @height.setter
    def height(self, value: int):
        setattr(self, "height", value)

    @property
    def required(self) -> bool:
        return self.get("required")

    @required.setter
    def required(self, value: bool):
        setattr(self, "required", value)

    @property
    def signer(self) -> Union[int, str]:
        return self.get("signer")

    @signer.setter
    def signer(self, value: Union[int, str]):
        setattr(self, "signer", value)

    @property
    def width(self) -> int:
        return self.get("width")

    @width.setter
    def width(self, value: int):
        setattr(self, "width", value)

    @property
    def x(self) -> int:
        return self.get("x")

    @x.setter
    def x(self, value: int):
        setattr(self, "x", value)

    @property
    def y(self) -> int:
        return self.get("y")

    @y.setter
    def y(self, value: int):
        setattr(self, "y", value)

    @property
    def placeholder(self) -> str:
        return self.get("placeholder")

    @placeholder.setter
    def placeholder(self, value: str):
        setattr(self, "placeholder", value)

    @property
    def auto_fill_type(self) -> str:
        return self.get("auto_fill_type")

    @auto_fill_type.setter
    def auto_fill_type(self, value: str):
        setattr(self, "auto_fill_type", value)

    @property
    def link_id(self) -> str:
        return self.get("link_id")

    @link_id.setter
    def link_id(self, value: str):
        setattr(self, "link_id", value)

    @property
    def masked(self) -> bool:
        return self.get("masked")

    @masked.setter
    def masked(self, value: bool):
        setattr(self, "masked", value)

    @property
    def validation_type(self) -> str:
        return self.get("validation_type")

    @validation_type.setter
    def validation_type(self, value: str):
        setattr(self, "validation_type", value)

    @property
    def validation_custom_regex(self) -> str:
        return self.get("validation_custom_regex")

    @validation_custom_regex.setter
    def validation_custom_regex(self, value: str):
        setattr(self, "validation_custom_regex", value)

    @property
    def validation_custom_regex_format_label(self) -> str:
        return self.get("validation_custom_regex_format_label")

    @validation_custom_regex_format_label.setter
    def validation_custom_regex_format_label(self, value: str):
        setattr(self, "validation_custom_regex_format_label", value)

    @property
    def name(self) -> str:
        return self.get("name")

    @name.setter
    def name(self, value: str):
        setattr(self, "name", value)

    @property
    def page(self) -> Optional[int]:
        return self.get("page")

    @page.setter
    def page(self, value: Optional[int]):
        setattr(self, "page", value)

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """SubFormFieldsPerDocumentText - a model defined in OpenAPI

        Keyword Args:
            type (str): A text input field. Use the `SubFormFieldsPerDocumentText` class.. defaults to "text"  # noqa: E501
            document_index (int): Represents the integer index of the `file` or `file_url` document the field should be attached to.
            api_id (str): An identifier for the field that is unique across all documents in the request.
            height (int): Size of the field in pixels.
            required (bool): Whether this field is required.
            signer (str|int): Signer index identified by the offset in the signers parameter (0-based indexing), indicating which signer should fill out the field.  **NOTE**: If type is `text-merge` or `checkbox-merge`, you must set this to sender in order to use pre-filled data.
            width (int): Size of the field in pixels.
            x (int): Location coordinates of the field in pixels.
            y (int): Location coordinates of the field in pixels.
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            placeholder (str): Placeholder value for text field.. [optional]  # noqa: E501
            auto_fill_type (str): Auto fill type for populating fields automatically. Check out the list of [auto fill types](/api/reference/constants/#auto-fill-types) to learn more about the possible values.. [optional]  # noqa: E501
            link_id (str): Link two or more text fields. Enter data into one linked text field, which automatically fill all other linked text fields.. [optional]  # noqa: E501
            masked (bool): Masks entered data. For more information see [Masking sensitive information](https://faq.hellosign.com/hc/en-us/articles/360040742811-Masking-sensitive-information). `true` for masking the data in a text field, otherwise `false`.. [optional]  # noqa: E501
            validation_type (str): Each text field may contain a `validation_type` parameter. Check out the list of [validation types](https://faq.hellosign.com/hc/en-us/articles/217115577) to learn more about the possible values.  **NOTE**: When using `custom_regex` you are required to pass a second parameter `validation_custom_regex` and you can optionally provide `validation_custom_regex_format_label` for the error message the user will see in case of an invalid value.. [optional]  # noqa: E501
            validation_custom_regex (str): [optional]  # noqa: E501
            validation_custom_regex_format_label (str): [optional]  # noqa: E501
            name (str): Display name for the field.. [optional]  # noqa: E501
            page (int, none_type): Page in the document where the field should be placed (requires documents be PDF files).  - When the page number parameter is supplied, the API will use the new coordinate system. - Check out the differences between both [coordinate systems](https://faq.hellosign.com/hc/en-us/articles/217115577) and how to use them.. [optional]  # noqa: E501
        """

        type = kwargs.get('type', "text")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        constant_args = {
            '_check_type': _check_type,
            '_path_to_item': _path_to_item,
            '_spec_property_naming': _spec_property_naming,
            '_configuration': _configuration,
            '_visited_composed_classes': self._visited_composed_classes,
        }
        composed_info = validate_get_composed_info(
            constant_args, kwargs, self)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        discarded_args = composed_info[3]

        for var_name, var_value in kwargs.items():
            if var_name in discarded_args and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self._additional_properties_model_instances:
                # discard variable.
                continue
            setattr(self, var_name, var_value)

        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
        '_composed_instances',
        '_var_name_to_model_instances',
        '_additional_properties_model_instances',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """SubFormFieldsPerDocumentText - a model defined in OpenAPI

        Keyword Args:
            type (str): A text input field. Use the `SubFormFieldsPerDocumentText` class.. defaults to "text"  # noqa: E501
            document_index (int): Represents the integer index of the `file` or `file_url` document the field should be attached to.
            api_id (str): An identifier for the field that is unique across all documents in the request.
            height (int): Size of the field in pixels.
            required (bool): Whether this field is required.
            signer (str|int): Signer index identified by the offset in the signers parameter (0-based indexing), indicating which signer should fill out the field.  **NOTE**: If type is `text-merge` or `checkbox-merge`, you must set this to sender in order to use pre-filled data.
            width (int): Size of the field in pixels.
            x (int): Location coordinates of the field in pixels.
            y (int): Location coordinates of the field in pixels.
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            placeholder (str): Placeholder value for text field.. [optional]  # noqa: E501
            auto_fill_type (str): Auto fill type for populating fields automatically. Check out the list of [auto fill types](/api/reference/constants/#auto-fill-types) to learn more about the possible values.. [optional]  # noqa: E501
            link_id (str): Link two or more text fields. Enter data into one linked text field, which automatically fill all other linked text fields.. [optional]  # noqa: E501
            masked (bool): Masks entered data. For more information see [Masking sensitive information](https://faq.hellosign.com/hc/en-us/articles/360040742811-Masking-sensitive-information). `true` for masking the data in a text field, otherwise `false`.. [optional]  # noqa: E501
            validation_type (str): Each text field may contain a `validation_type` parameter. Check out the list of [validation types](https://faq.hellosign.com/hc/en-us/articles/217115577) to learn more about the possible values.  **NOTE**: When using `custom_regex` you are required to pass a second parameter `validation_custom_regex` and you can optionally provide `validation_custom_regex_format_label` for the error message the user will see in case of an invalid value.. [optional]  # noqa: E501
            validation_custom_regex (str): [optional]  # noqa: E501
            validation_custom_regex_format_label (str): [optional]  # noqa: E501
            name (str): Display name for the field.. [optional]  # noqa: E501
            page (int, none_type): Page in the document where the field should be placed (requires documents be PDF files).  - When the page number parameter is supplied, the API will use the new coordinate system. - Check out the differences between both [coordinate systems](https://faq.hellosign.com/hc/en-us/articles/217115577) and how to use them.. [optional]  # noqa: E501
        """

        type = kwargs.get('type', "text")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        constant_args = {
            '_check_type': _check_type,
            '_path_to_item': _path_to_item,
            '_spec_property_naming': _spec_property_naming,
            '_configuration': _configuration,
            '_visited_composed_classes': self._visited_composed_classes,
        }
        composed_info = validate_get_composed_info(
            constant_args, kwargs, self)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        discarded_args = composed_info[3]

        for var_name, var_value in kwargs.items():
            if var_name in discarded_args and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self._additional_properties_model_instances:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")

    @cached_property
    def _composed_schemas():
        # we need this here to make our import statements work
        # we must store _composed_schemas in here so the code is only run
        # when we invoke this method. If we kept this at the class
        # level we would get an error because the class level
        # code would be run when this module is imported, and these composed
        # classes don't exist yet because their module has not finished
        # loading
        lazy_import()
        return {
          'anyOf': [
          ],
          'oneOf': [
          ],
        }
