"""
    Dropbox Sign API

    Dropbox Sign v3 API  # noqa: E501

    The version of the OpenAPI document: 3.0.0
    Contact: apisupport@hellosign.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from typing import TYPE_CHECKING, Optional, List, Dict, Union
import json  # noqa: F401
import re  # noqa: F401
import sys  # noqa: F401

from dropbox_sign import ApiClient
from dropbox_sign.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from dropbox_sign.exceptions import ApiAttributeError
if TYPE_CHECKING:
    from dropbox_sign.model.template_response_account import TemplateResponseAccount
    from dropbox_sign.model.template_response_cc_role import TemplateResponseCCRole
    from dropbox_sign.model.template_response_document import TemplateResponseDocument
    from dropbox_sign.model.template_response_document_custom_field_base import TemplateResponseDocumentCustomFieldBase
    from dropbox_sign.model.template_response_document_form_field_base import TemplateResponseDocumentFormFieldBase
    from dropbox_sign.model.template_response_signer_role import TemplateResponseSignerRole


def lazy_import():
    from dropbox_sign.model.template_response_account import TemplateResponseAccount
    from dropbox_sign.model.template_response_cc_role import TemplateResponseCCRole
    from dropbox_sign.model.template_response_document import TemplateResponseDocument
    from dropbox_sign.model.template_response_document_custom_field_base import TemplateResponseDocumentCustomFieldBase
    from dropbox_sign.model.template_response_document_form_field_base import TemplateResponseDocumentFormFieldBase
    from dropbox_sign.model.template_response_signer_role import TemplateResponseSignerRole
    globals()['TemplateResponseAccount'] = TemplateResponseAccount
    globals()['TemplateResponseCCRole'] = TemplateResponseCCRole
    globals()['TemplateResponseDocument'] = TemplateResponseDocument
    globals()['TemplateResponseDocumentCustomFieldBase'] = TemplateResponseDocumentCustomFieldBase
    globals()['TemplateResponseDocumentFormFieldBase'] = TemplateResponseDocumentFormFieldBase
    globals()['TemplateResponseSignerRole'] = TemplateResponseSignerRole


class TemplateResponse(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'template_id': (str,),  # noqa: E501
            'title': (str,),  # noqa: E501
            'message': (str,),  # noqa: E501
            'updated_at': (int,),  # noqa: E501
            'is_embedded': (bool, none_type,),  # noqa: E501
            'is_creator': (bool, none_type,),  # noqa: E501
            'can_edit': (bool, none_type,),  # noqa: E501
            'is_locked': (bool, none_type,),  # noqa: E501
            'metadata': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),  # noqa: E501
            'signer_roles': ([TemplateResponseSignerRole],),  # noqa: E501
            'cc_roles': ([TemplateResponseCCRole],),  # noqa: E501
            'documents': ([TemplateResponseDocument],),  # noqa: E501
            'custom_fields': ([TemplateResponseDocumentCustomFieldBase], none_type,),  # noqa: E501
            'named_form_fields': ([TemplateResponseDocumentFormFieldBase], none_type,),  # noqa: E501
            'accounts': ([TemplateResponseAccount], none_type,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None

    @staticmethod
    def init(data: any) -> TemplateResponse:
        """
        Attempt to instantiate and hydrate a new instance of this class
        """
        try:
            obj_data = json.dumps(data)
        except TypeError:
            obj_data = data

        return ApiClient().deserialize(
            response=type('obj_dict', (object,), {'data': obj_data}),
            response_type=[TemplateResponse],
            _check_type=True,
        )

    attribute_map = {
        'template_id': 'template_id',  # noqa: E501
        'title': 'title',  # noqa: E501
        'message': 'message',  # noqa: E501
        'updated_at': 'updated_at',  # noqa: E501
        'is_embedded': 'is_embedded',  # noqa: E501
        'is_creator': 'is_creator',  # noqa: E501
        'can_edit': 'can_edit',  # noqa: E501
        'is_locked': 'is_locked',  # noqa: E501
        'metadata': 'metadata',  # noqa: E501
        'signer_roles': 'signer_roles',  # noqa: E501
        'cc_roles': 'cc_roles',  # noqa: E501
        'documents': 'documents',  # noqa: E501
        'custom_fields': 'custom_fields',  # noqa: E501
        'named_form_fields': 'named_form_fields',  # noqa: E501
        'accounts': 'accounts',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @property
    def template_id(self) -> str:
        return self.get("template_id")

    @template_id.setter
    def template_id(self, value: str):
        setattr(self, "template_id", value)

    @property
    def title(self) -> str:
        return self.get("title")

    @title.setter
    def title(self, value: str):
        setattr(self, "title", value)

    @property
    def message(self) -> str:
        return self.get("message")

    @message.setter
    def message(self, value: str):
        setattr(self, "message", value)

    @property
    def updated_at(self) -> int:
        return self.get("updated_at")

    @updated_at.setter
    def updated_at(self, value: int):
        setattr(self, "updated_at", value)

    @property
    def is_embedded(self) -> Optional[bool]:
        return self.get("is_embedded")

    @is_embedded.setter
    def is_embedded(self, value: Optional[bool]):
        setattr(self, "is_embedded", value)

    @property
    def is_creator(self) -> Optional[bool]:
        return self.get("is_creator")

    @is_creator.setter
    def is_creator(self, value: Optional[bool]):
        setattr(self, "is_creator", value)

    @property
    def can_edit(self) -> Optional[bool]:
        return self.get("can_edit")

    @can_edit.setter
    def can_edit(self, value: Optional[bool]):
        setattr(self, "can_edit", value)

    @property
    def is_locked(self) -> Optional[bool]:
        return self.get("is_locked")

    @is_locked.setter
    def is_locked(self, value: Optional[bool]):
        setattr(self, "is_locked", value)

    @property
    def metadata(self) -> Dict[str, Union[bool, date, datetime, dict, float, int, list, str, none_type]]:
        return self.get("metadata")

    @metadata.setter
    def metadata(self, value: Dict[str, Union[bool, date, datetime, dict, float, int, list, str, none_type]]):
        setattr(self, "metadata", value)

    @property
    def signer_roles(self) -> List[TemplateResponseSignerRole]:
        return self.get("signer_roles")

    @signer_roles.setter
    def signer_roles(self, value: List[TemplateResponseSignerRole]):
        setattr(self, "signer_roles", value)

    @property
    def cc_roles(self) -> List[TemplateResponseCCRole]:
        return self.get("cc_roles")

    @cc_roles.setter
    def cc_roles(self, value: List[TemplateResponseCCRole]):
        setattr(self, "cc_roles", value)

    @property
    def documents(self) -> List[TemplateResponseDocument]:
        return self.get("documents")

    @documents.setter
    def documents(self, value: List[TemplateResponseDocument]):
        setattr(self, "documents", value)

    @property
    def custom_fields(self) -> Optional[List[TemplateResponseDocumentCustomFieldBase]]:
        return self.get("custom_fields")

    @custom_fields.setter
    def custom_fields(self, value: Optional[List[TemplateResponseDocumentCustomFieldBase]]):
        setattr(self, "custom_fields", value)

    @property
    def named_form_fields(self) -> Optional[List[TemplateResponseDocumentFormFieldBase]]:
        return self.get("named_form_fields")

    @named_form_fields.setter
    def named_form_fields(self, value: Optional[List[TemplateResponseDocumentFormFieldBase]]):
        setattr(self, "named_form_fields", value)

    @property
    def accounts(self) -> Optional[List[TemplateResponseAccount]]:
        return self.get("accounts")

    @accounts.setter
    def accounts(self, value: Optional[List[TemplateResponseAccount]]):
        setattr(self, "accounts", value)

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """TemplateResponse - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            template_id (str): The id of the Template.. [optional]  # noqa: E501
            title (str): The title of the Template. This will also be the default subject of the message sent to signers when using this Template to send a SignatureRequest. This can be overridden when sending the SignatureRequest.. [optional]  # noqa: E501
            message (str): The default message that will be sent to signers when using this Template to send a SignatureRequest. This can be overridden when sending the SignatureRequest.. [optional]  # noqa: E501
            updated_at (int): Time the template was last updated.. [optional]  # noqa: E501
            is_embedded (bool, none_type): `true` if this template was created using an embedded flow, `false` if it was created on our website.. [optional]  # noqa: E501
            is_creator (bool, none_type): `true` if you are the owner of this template, `false` if it's been shared with you by a team member.. [optional]  # noqa: E501
            can_edit (bool, none_type): Indicates whether edit rights have been granted to you by the owner (always `true` if that's you).. [optional]  # noqa: E501
            is_locked (bool, none_type): Indicates whether the template is locked. If `true`, then the template was created outside your quota and can only be used in `test_mode`. If `false`, then the template is within your quota and can be used to create signature requests.. [optional]  # noqa: E501
            metadata ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): The metadata attached to the template.. [optional]  # noqa: E501
            signer_roles ([TemplateResponseSignerRole]): An array of the designated signer roles that must be specified when sending a SignatureRequest using this Template.. [optional]  # noqa: E501
            cc_roles ([TemplateResponseCCRole]): An array of the designated CC roles that must be specified when sending a SignatureRequest using this Template.. [optional]  # noqa: E501
            documents ([TemplateResponseDocument]): An array describing each document associated with this Template. Includes form field data for each document.. [optional]  # noqa: E501
            custom_fields ([TemplateResponseDocumentCustomFieldBase], none_type): Deprecated. Use `custom_fields` inside the [documents](https://developers.hellosign.com/api/reference/operation/templateGet/#!c=200&path=template/documents&t=response) array instead.. [optional]  # noqa: E501
            named_form_fields ([TemplateResponseDocumentFormFieldBase], none_type): Deprecated. Use `form_fields` inside the [documents](https://developers.hellosign.com/api/reference/operation/templateGet/#!c=200&path=template/documents&t=response) array instead.. [optional]  # noqa: E501
            accounts ([TemplateResponseAccount], none_type): An array of the Accounts that can use this Template.. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """TemplateResponse - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            template_id (str): The id of the Template.. [optional]  # noqa: E501
            title (str): The title of the Template. This will also be the default subject of the message sent to signers when using this Template to send a SignatureRequest. This can be overridden when sending the SignatureRequest.. [optional]  # noqa: E501
            message (str): The default message that will be sent to signers when using this Template to send a SignatureRequest. This can be overridden when sending the SignatureRequest.. [optional]  # noqa: E501
            updated_at (int): Time the template was last updated.. [optional]  # noqa: E501
            is_embedded (bool, none_type): `true` if this template was created using an embedded flow, `false` if it was created on our website.. [optional]  # noqa: E501
            is_creator (bool, none_type): `true` if you are the owner of this template, `false` if it's been shared with you by a team member.. [optional]  # noqa: E501
            can_edit (bool, none_type): Indicates whether edit rights have been granted to you by the owner (always `true` if that's you).. [optional]  # noqa: E501
            is_locked (bool, none_type): Indicates whether the template is locked. If `true`, then the template was created outside your quota and can only be used in `test_mode`. If `false`, then the template is within your quota and can be used to create signature requests.. [optional]  # noqa: E501
            metadata ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): The metadata attached to the template.. [optional]  # noqa: E501
            signer_roles ([TemplateResponseSignerRole]): An array of the designated signer roles that must be specified when sending a SignatureRequest using this Template.. [optional]  # noqa: E501
            cc_roles ([TemplateResponseCCRole]): An array of the designated CC roles that must be specified when sending a SignatureRequest using this Template.. [optional]  # noqa: E501
            documents ([TemplateResponseDocument]): An array describing each document associated with this Template. Includes form field data for each document.. [optional]  # noqa: E501
            custom_fields ([TemplateResponseDocumentCustomFieldBase], none_type): Deprecated. Use `custom_fields` inside the [documents](https://developers.hellosign.com/api/reference/operation/templateGet/#!c=200&path=template/documents&t=response) array instead.. [optional]  # noqa: E501
            named_form_fields ([TemplateResponseDocumentFormFieldBase], none_type): Deprecated. Use `form_fields` inside the [documents](https://developers.hellosign.com/api/reference/operation/templateGet/#!c=200&path=template/documents&t=response) array instead.. [optional]  # noqa: E501
            accounts ([TemplateResponseAccount], none_type): An array of the Accounts that can use this Template.. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
