"""Python package with helper functions for working with FAU's High Performance Cluster (HPC)."""

from hpc_helper._hpc_helper import (
    build_job_submit_slurm,
    build_job_submit_torque,
    check_hpc_status_file,
    check_interpreter,
    cleanup_hpc_status_files,
    get_running_jobs_slurm,
    get_running_jobs_torque,
    write_hpc_status_file,
)

__version__ = "0.3.0"

__all__ = [
    "build_job_submit_torque",
    "build_job_submit_slurm",
    "get_running_jobs_torque",
    "get_running_jobs_slurm",
    "check_hpc_status_file",
    "write_hpc_status_file",
    "check_interpreter",
    "cleanup_hpc_status_files",
]
