"""
All the SpirV constants. Generated by the Python file provided by Khronos at
https://raw.githubusercontent.com/KhronosGroup/SPIRV-Headers/master/include/spirv/unified1/spirv.py
"""

# NOTE: THIS CODE IS AUTOGENERATED; DO NOT EDIT

# Also see https://www.khronos.org/opengl/wiki/Built-in_Variable_(GLSL)
builtins = {}


class Enum(int):
    """ Enum (integer) with a meaningfull repr. """

    def __new__(cls, name, value):
        base = int.__new__(cls, value)
        base.name = name
        if name.startswith("BuiltIn_"):
            builtins[name[8:]] = base
        return base

    def __repr__(self):
        return self.name


MagicNumber = Enum("MagicNumber", 0x7230203)
Version = Enum("Version", 0x10500)
Revision = Enum("Revision", 1)
OpCodeMask = Enum("OpCodeMask", 0xFFFF)
WordCountShift = Enum("WordCountShift", 16)

SourceLanguage_Unknown = Enum("SourceLanguage_Unknown", 0)
SourceLanguage_ESSL = Enum("SourceLanguage_ESSL", 1)
SourceLanguage_GLSL = Enum("SourceLanguage_GLSL", 2)
SourceLanguage_OpenCL_C = Enum("SourceLanguage_OpenCL_C", 3)
SourceLanguage_OpenCL_CPP = Enum("SourceLanguage_OpenCL_CPP", 4)
SourceLanguage_HLSL = Enum("SourceLanguage_HLSL", 5)

ExecutionModel_Vertex = Enum("ExecutionModel_Vertex", 0)
ExecutionModel_TessellationControl = Enum("ExecutionModel_TessellationControl", 1)
ExecutionModel_TessellationEvaluation = Enum("ExecutionModel_TessellationEvaluation", 2)
ExecutionModel_Geometry = Enum("ExecutionModel_Geometry", 3)
ExecutionModel_Fragment = Enum("ExecutionModel_Fragment", 4)
ExecutionModel_GLCompute = Enum("ExecutionModel_GLCompute", 5)
ExecutionModel_Kernel = Enum("ExecutionModel_Kernel", 6)
ExecutionModel_TaskNV = Enum("ExecutionModel_TaskNV", 5267)
ExecutionModel_MeshNV = Enum("ExecutionModel_MeshNV", 5268)
ExecutionModel_RayGenerationNV = Enum("ExecutionModel_RayGenerationNV", 5313)
ExecutionModel_IntersectionNV = Enum("ExecutionModel_IntersectionNV", 5314)
ExecutionModel_AnyHitNV = Enum("ExecutionModel_AnyHitNV", 5315)
ExecutionModel_ClosestHitNV = Enum("ExecutionModel_ClosestHitNV", 5316)
ExecutionModel_MissNV = Enum("ExecutionModel_MissNV", 5317)
ExecutionModel_CallableNV = Enum("ExecutionModel_CallableNV", 5318)

AddressingModel_Logical = Enum("AddressingModel_Logical", 0)
AddressingModel_Physical32 = Enum("AddressingModel_Physical32", 1)
AddressingModel_Physical64 = Enum("AddressingModel_Physical64", 2)
AddressingModel_PhysicalStorageBuffer64 = Enum(
    "AddressingModel_PhysicalStorageBuffer64", 5348
)
AddressingModel_PhysicalStorageBuffer64EXT = Enum(
    "AddressingModel_PhysicalStorageBuffer64EXT", 5348
)

MemoryModel_Simple = Enum("MemoryModel_Simple", 0)
MemoryModel_GLSL450 = Enum("MemoryModel_GLSL450", 1)
MemoryModel_OpenCL = Enum("MemoryModel_OpenCL", 2)
MemoryModel_Vulkan = Enum("MemoryModel_Vulkan", 3)
MemoryModel_VulkanKHR = Enum("MemoryModel_VulkanKHR", 3)

ExecutionMode_Invocations = Enum("ExecutionMode_Invocations", 0)
ExecutionMode_SpacingEqual = Enum("ExecutionMode_SpacingEqual", 1)
ExecutionMode_SpacingFractionalEven = Enum("ExecutionMode_SpacingFractionalEven", 2)
ExecutionMode_SpacingFractionalOdd = Enum("ExecutionMode_SpacingFractionalOdd", 3)
ExecutionMode_VertexOrderCw = Enum("ExecutionMode_VertexOrderCw", 4)
ExecutionMode_VertexOrderCcw = Enum("ExecutionMode_VertexOrderCcw", 5)
ExecutionMode_PixelCenterInteger = Enum("ExecutionMode_PixelCenterInteger", 6)
ExecutionMode_OriginUpperLeft = Enum("ExecutionMode_OriginUpperLeft", 7)
ExecutionMode_OriginLowerLeft = Enum("ExecutionMode_OriginLowerLeft", 8)
ExecutionMode_EarlyFragmentTests = Enum("ExecutionMode_EarlyFragmentTests", 9)
ExecutionMode_PointMode = Enum("ExecutionMode_PointMode", 10)
ExecutionMode_Xfb = Enum("ExecutionMode_Xfb", 11)
ExecutionMode_DepthReplacing = Enum("ExecutionMode_DepthReplacing", 12)
ExecutionMode_DepthGreater = Enum("ExecutionMode_DepthGreater", 14)
ExecutionMode_DepthLess = Enum("ExecutionMode_DepthLess", 15)
ExecutionMode_DepthUnchanged = Enum("ExecutionMode_DepthUnchanged", 16)
ExecutionMode_LocalSize = Enum("ExecutionMode_LocalSize", 17)
ExecutionMode_LocalSizeHint = Enum("ExecutionMode_LocalSizeHint", 18)
ExecutionMode_InputPoints = Enum("ExecutionMode_InputPoints", 19)
ExecutionMode_InputLines = Enum("ExecutionMode_InputLines", 20)
ExecutionMode_InputLinesAdjacency = Enum("ExecutionMode_InputLinesAdjacency", 21)
ExecutionMode_Triangles = Enum("ExecutionMode_Triangles", 22)
ExecutionMode_InputTrianglesAdjacency = Enum(
    "ExecutionMode_InputTrianglesAdjacency", 23
)
ExecutionMode_Quads = Enum("ExecutionMode_Quads", 24)
ExecutionMode_Isolines = Enum("ExecutionMode_Isolines", 25)
ExecutionMode_OutputVertices = Enum("ExecutionMode_OutputVertices", 26)
ExecutionMode_OutputPoints = Enum("ExecutionMode_OutputPoints", 27)
ExecutionMode_OutputLineStrip = Enum("ExecutionMode_OutputLineStrip", 28)
ExecutionMode_OutputTriangleStrip = Enum("ExecutionMode_OutputTriangleStrip", 29)
ExecutionMode_VecTypeHint = Enum("ExecutionMode_VecTypeHint", 30)
ExecutionMode_ContractionOff = Enum("ExecutionMode_ContractionOff", 31)
ExecutionMode_Initializer = Enum("ExecutionMode_Initializer", 33)
ExecutionMode_Finalizer = Enum("ExecutionMode_Finalizer", 34)
ExecutionMode_SubgroupSize = Enum("ExecutionMode_SubgroupSize", 35)
ExecutionMode_SubgroupsPerWorkgroup = Enum("ExecutionMode_SubgroupsPerWorkgroup", 36)
ExecutionMode_SubgroupsPerWorkgroupId = Enum(
    "ExecutionMode_SubgroupsPerWorkgroupId", 37
)
ExecutionMode_LocalSizeId = Enum("ExecutionMode_LocalSizeId", 38)
ExecutionMode_LocalSizeHintId = Enum("ExecutionMode_LocalSizeHintId", 39)
ExecutionMode_PostDepthCoverage = Enum("ExecutionMode_PostDepthCoverage", 4446)
ExecutionMode_DenormPreserve = Enum("ExecutionMode_DenormPreserve", 4459)
ExecutionMode_DenormFlushToZero = Enum("ExecutionMode_DenormFlushToZero", 4460)
ExecutionMode_SignedZeroInfNanPreserve = Enum(
    "ExecutionMode_SignedZeroInfNanPreserve", 4461
)
ExecutionMode_RoundingModeRTE = Enum("ExecutionMode_RoundingModeRTE", 4462)
ExecutionMode_RoundingModeRTZ = Enum("ExecutionMode_RoundingModeRTZ", 4463)
ExecutionMode_StencilRefReplacingEXT = Enum(
    "ExecutionMode_StencilRefReplacingEXT", 5027
)
ExecutionMode_OutputLinesNV = Enum("ExecutionMode_OutputLinesNV", 5269)
ExecutionMode_OutputPrimitivesNV = Enum("ExecutionMode_OutputPrimitivesNV", 5270)
ExecutionMode_DerivativeGroupQuadsNV = Enum(
    "ExecutionMode_DerivativeGroupQuadsNV", 5289
)
ExecutionMode_DerivativeGroupLinearNV = Enum(
    "ExecutionMode_DerivativeGroupLinearNV", 5290
)
ExecutionMode_OutputTrianglesNV = Enum("ExecutionMode_OutputTrianglesNV", 5298)
ExecutionMode_PixelInterlockOrderedEXT = Enum(
    "ExecutionMode_PixelInterlockOrderedEXT", 5366
)
ExecutionMode_PixelInterlockUnorderedEXT = Enum(
    "ExecutionMode_PixelInterlockUnorderedEXT", 5367
)
ExecutionMode_SampleInterlockOrderedEXT = Enum(
    "ExecutionMode_SampleInterlockOrderedEXT", 5368
)
ExecutionMode_SampleInterlockUnorderedEXT = Enum(
    "ExecutionMode_SampleInterlockUnorderedEXT", 5369
)
ExecutionMode_ShadingRateInterlockOrderedEXT = Enum(
    "ExecutionMode_ShadingRateInterlockOrderedEXT", 5370
)
ExecutionMode_ShadingRateInterlockUnorderedEXT = Enum(
    "ExecutionMode_ShadingRateInterlockUnorderedEXT", 5371
)

StorageClass_UniformConstant = Enum("StorageClass_UniformConstant", 0)
StorageClass_Input = Enum("StorageClass_Input", 1)
StorageClass_Uniform = Enum("StorageClass_Uniform", 2)
StorageClass_Output = Enum("StorageClass_Output", 3)
StorageClass_Workgroup = Enum("StorageClass_Workgroup", 4)
StorageClass_CrossWorkgroup = Enum("StorageClass_CrossWorkgroup", 5)
StorageClass_Private = Enum("StorageClass_Private", 6)
StorageClass_Function = Enum("StorageClass_Function", 7)
StorageClass_Generic = Enum("StorageClass_Generic", 8)
StorageClass_PushConstant = Enum("StorageClass_PushConstant", 9)
StorageClass_AtomicCounter = Enum("StorageClass_AtomicCounter", 10)
StorageClass_Image = Enum("StorageClass_Image", 11)
StorageClass_StorageBuffer = Enum("StorageClass_StorageBuffer", 12)
StorageClass_CallableDataNV = Enum("StorageClass_CallableDataNV", 5328)
StorageClass_IncomingCallableDataNV = Enum("StorageClass_IncomingCallableDataNV", 5329)
StorageClass_RayPayloadNV = Enum("StorageClass_RayPayloadNV", 5338)
StorageClass_HitAttributeNV = Enum("StorageClass_HitAttributeNV", 5339)
StorageClass_IncomingRayPayloadNV = Enum("StorageClass_IncomingRayPayloadNV", 5342)
StorageClass_ShaderRecordBufferNV = Enum("StorageClass_ShaderRecordBufferNV", 5343)
StorageClass_PhysicalStorageBuffer = Enum("StorageClass_PhysicalStorageBuffer", 5349)
StorageClass_PhysicalStorageBufferEXT = Enum(
    "StorageClass_PhysicalStorageBufferEXT", 5349
)

Dim_Dim1D = Enum("Dim_Dim1D", 0)
Dim_Dim2D = Enum("Dim_Dim2D", 1)
Dim_Dim3D = Enum("Dim_Dim3D", 2)
Dim_Cube = Enum("Dim_Cube", 3)
Dim_Rect = Enum("Dim_Rect", 4)
Dim_Buffer = Enum("Dim_Buffer", 5)
Dim_SubpassData = Enum("Dim_SubpassData", 6)

SamplerAddressingMode_None = Enum("SamplerAddressingMode_None", 0)
SamplerAddressingMode_ClampToEdge = Enum("SamplerAddressingMode_ClampToEdge", 1)
SamplerAddressingMode_Clamp = Enum("SamplerAddressingMode_Clamp", 2)
SamplerAddressingMode_Repeat = Enum("SamplerAddressingMode_Repeat", 3)
SamplerAddressingMode_RepeatMirrored = Enum("SamplerAddressingMode_RepeatMirrored", 4)

SamplerFilterMode_Nearest = Enum("SamplerFilterMode_Nearest", 0)
SamplerFilterMode_Linear = Enum("SamplerFilterMode_Linear", 1)

ImageFormat_Unknown = Enum("ImageFormat_Unknown", 0)
ImageFormat_Rgba32f = Enum("ImageFormat_Rgba32f", 1)
ImageFormat_Rgba16f = Enum("ImageFormat_Rgba16f", 2)
ImageFormat_R32f = Enum("ImageFormat_R32f", 3)
ImageFormat_Rgba8 = Enum("ImageFormat_Rgba8", 4)
ImageFormat_Rgba8Snorm = Enum("ImageFormat_Rgba8Snorm", 5)
ImageFormat_Rg32f = Enum("ImageFormat_Rg32f", 6)
ImageFormat_Rg16f = Enum("ImageFormat_Rg16f", 7)
ImageFormat_R11fG11fB10f = Enum("ImageFormat_R11fG11fB10f", 8)
ImageFormat_R16f = Enum("ImageFormat_R16f", 9)
ImageFormat_Rgba16 = Enum("ImageFormat_Rgba16", 10)
ImageFormat_Rgb10A2 = Enum("ImageFormat_Rgb10A2", 11)
ImageFormat_Rg16 = Enum("ImageFormat_Rg16", 12)
ImageFormat_Rg8 = Enum("ImageFormat_Rg8", 13)
ImageFormat_R16 = Enum("ImageFormat_R16", 14)
ImageFormat_R8 = Enum("ImageFormat_R8", 15)
ImageFormat_Rgba16Snorm = Enum("ImageFormat_Rgba16Snorm", 16)
ImageFormat_Rg16Snorm = Enum("ImageFormat_Rg16Snorm", 17)
ImageFormat_Rg8Snorm = Enum("ImageFormat_Rg8Snorm", 18)
ImageFormat_R16Snorm = Enum("ImageFormat_R16Snorm", 19)
ImageFormat_R8Snorm = Enum("ImageFormat_R8Snorm", 20)
ImageFormat_Rgba32i = Enum("ImageFormat_Rgba32i", 21)
ImageFormat_Rgba16i = Enum("ImageFormat_Rgba16i", 22)
ImageFormat_Rgba8i = Enum("ImageFormat_Rgba8i", 23)
ImageFormat_R32i = Enum("ImageFormat_R32i", 24)
ImageFormat_Rg32i = Enum("ImageFormat_Rg32i", 25)
ImageFormat_Rg16i = Enum("ImageFormat_Rg16i", 26)
ImageFormat_Rg8i = Enum("ImageFormat_Rg8i", 27)
ImageFormat_R16i = Enum("ImageFormat_R16i", 28)
ImageFormat_R8i = Enum("ImageFormat_R8i", 29)
ImageFormat_Rgba32ui = Enum("ImageFormat_Rgba32ui", 30)
ImageFormat_Rgba16ui = Enum("ImageFormat_Rgba16ui", 31)
ImageFormat_Rgba8ui = Enum("ImageFormat_Rgba8ui", 32)
ImageFormat_R32ui = Enum("ImageFormat_R32ui", 33)
ImageFormat_Rgb10a2ui = Enum("ImageFormat_Rgb10a2ui", 34)
ImageFormat_Rg32ui = Enum("ImageFormat_Rg32ui", 35)
ImageFormat_Rg16ui = Enum("ImageFormat_Rg16ui", 36)
ImageFormat_Rg8ui = Enum("ImageFormat_Rg8ui", 37)
ImageFormat_R16ui = Enum("ImageFormat_R16ui", 38)
ImageFormat_R8ui = Enum("ImageFormat_R8ui", 39)

ImageChannelOrder_R = Enum("ImageChannelOrder_R", 0)
ImageChannelOrder_A = Enum("ImageChannelOrder_A", 1)
ImageChannelOrder_RG = Enum("ImageChannelOrder_RG", 2)
ImageChannelOrder_RA = Enum("ImageChannelOrder_RA", 3)
ImageChannelOrder_RGB = Enum("ImageChannelOrder_RGB", 4)
ImageChannelOrder_RGBA = Enum("ImageChannelOrder_RGBA", 5)
ImageChannelOrder_BGRA = Enum("ImageChannelOrder_BGRA", 6)
ImageChannelOrder_ARGB = Enum("ImageChannelOrder_ARGB", 7)
ImageChannelOrder_Intensity = Enum("ImageChannelOrder_Intensity", 8)
ImageChannelOrder_Luminance = Enum("ImageChannelOrder_Luminance", 9)
ImageChannelOrder_Rx = Enum("ImageChannelOrder_Rx", 10)
ImageChannelOrder_RGx = Enum("ImageChannelOrder_RGx", 11)
ImageChannelOrder_RGBx = Enum("ImageChannelOrder_RGBx", 12)
ImageChannelOrder_Depth = Enum("ImageChannelOrder_Depth", 13)
ImageChannelOrder_DepthStencil = Enum("ImageChannelOrder_DepthStencil", 14)
ImageChannelOrder_sRGB = Enum("ImageChannelOrder_sRGB", 15)
ImageChannelOrder_sRGBx = Enum("ImageChannelOrder_sRGBx", 16)
ImageChannelOrder_sRGBA = Enum("ImageChannelOrder_sRGBA", 17)
ImageChannelOrder_sBGRA = Enum("ImageChannelOrder_sBGRA", 18)
ImageChannelOrder_ABGR = Enum("ImageChannelOrder_ABGR", 19)

ImageChannelDataType_SnormInt8 = Enum("ImageChannelDataType_SnormInt8", 0)
ImageChannelDataType_SnormInt16 = Enum("ImageChannelDataType_SnormInt16", 1)
ImageChannelDataType_UnormInt8 = Enum("ImageChannelDataType_UnormInt8", 2)
ImageChannelDataType_UnormInt16 = Enum("ImageChannelDataType_UnormInt16", 3)
ImageChannelDataType_UnormShort565 = Enum("ImageChannelDataType_UnormShort565", 4)
ImageChannelDataType_UnormShort555 = Enum("ImageChannelDataType_UnormShort555", 5)
ImageChannelDataType_UnormInt101010 = Enum("ImageChannelDataType_UnormInt101010", 6)
ImageChannelDataType_SignedInt8 = Enum("ImageChannelDataType_SignedInt8", 7)
ImageChannelDataType_SignedInt16 = Enum("ImageChannelDataType_SignedInt16", 8)
ImageChannelDataType_SignedInt32 = Enum("ImageChannelDataType_SignedInt32", 9)
ImageChannelDataType_UnsignedInt8 = Enum("ImageChannelDataType_UnsignedInt8", 10)
ImageChannelDataType_UnsignedInt16 = Enum("ImageChannelDataType_UnsignedInt16", 11)
ImageChannelDataType_UnsignedInt32 = Enum("ImageChannelDataType_UnsignedInt32", 12)
ImageChannelDataType_HalfFloat = Enum("ImageChannelDataType_HalfFloat", 13)
ImageChannelDataType_Float = Enum("ImageChannelDataType_Float", 14)
ImageChannelDataType_UnormInt24 = Enum("ImageChannelDataType_UnormInt24", 15)
ImageChannelDataType_UnormInt101010_2 = Enum(
    "ImageChannelDataType_UnormInt101010_2", 16
)

ImageOperandsShift_Bias = Enum("ImageOperandsShift_Bias", 0)
ImageOperandsShift_Lod = Enum("ImageOperandsShift_Lod", 1)
ImageOperandsShift_Grad = Enum("ImageOperandsShift_Grad", 2)
ImageOperandsShift_ConstOffset = Enum("ImageOperandsShift_ConstOffset", 3)
ImageOperandsShift_Offset = Enum("ImageOperandsShift_Offset", 4)
ImageOperandsShift_ConstOffsets = Enum("ImageOperandsShift_ConstOffsets", 5)
ImageOperandsShift_Sample = Enum("ImageOperandsShift_Sample", 6)
ImageOperandsShift_MinLod = Enum("ImageOperandsShift_MinLod", 7)
ImageOperandsShift_MakeTexelAvailable = Enum("ImageOperandsShift_MakeTexelAvailable", 8)
ImageOperandsShift_MakeTexelAvailableKHR = Enum(
    "ImageOperandsShift_MakeTexelAvailableKHR", 8
)
ImageOperandsShift_MakeTexelVisible = Enum("ImageOperandsShift_MakeTexelVisible", 9)
ImageOperandsShift_MakeTexelVisibleKHR = Enum(
    "ImageOperandsShift_MakeTexelVisibleKHR", 9
)
ImageOperandsShift_NonPrivateTexel = Enum("ImageOperandsShift_NonPrivateTexel", 10)
ImageOperandsShift_NonPrivateTexelKHR = Enum(
    "ImageOperandsShift_NonPrivateTexelKHR", 10
)
ImageOperandsShift_VolatileTexel = Enum("ImageOperandsShift_VolatileTexel", 11)
ImageOperandsShift_VolatileTexelKHR = Enum("ImageOperandsShift_VolatileTexelKHR", 11)
ImageOperandsShift_SignExtend = Enum("ImageOperandsShift_SignExtend", 12)
ImageOperandsShift_ZeroExtend = Enum("ImageOperandsShift_ZeroExtend", 13)

ImageOperandsMask_MaskNone = Enum("ImageOperandsMask_MaskNone", 0)
ImageOperandsMask_Bias = Enum("ImageOperandsMask_Bias", 1)
ImageOperandsMask_Lod = Enum("ImageOperandsMask_Lod", 2)
ImageOperandsMask_Grad = Enum("ImageOperandsMask_Grad", 4)
ImageOperandsMask_ConstOffset = Enum("ImageOperandsMask_ConstOffset", 8)
ImageOperandsMask_Offset = Enum("ImageOperandsMask_Offset", 16)
ImageOperandsMask_ConstOffsets = Enum("ImageOperandsMask_ConstOffsets", 32)
ImageOperandsMask_Sample = Enum("ImageOperandsMask_Sample", 64)
ImageOperandsMask_MinLod = Enum("ImageOperandsMask_MinLod", 128)
ImageOperandsMask_MakeTexelAvailable = Enum("ImageOperandsMask_MakeTexelAvailable", 256)
ImageOperandsMask_MakeTexelAvailableKHR = Enum(
    "ImageOperandsMask_MakeTexelAvailableKHR", 256
)
ImageOperandsMask_MakeTexelVisible = Enum("ImageOperandsMask_MakeTexelVisible", 512)
ImageOperandsMask_MakeTexelVisibleKHR = Enum(
    "ImageOperandsMask_MakeTexelVisibleKHR", 512
)
ImageOperandsMask_NonPrivateTexel = Enum("ImageOperandsMask_NonPrivateTexel", 1024)
ImageOperandsMask_NonPrivateTexelKHR = Enum(
    "ImageOperandsMask_NonPrivateTexelKHR", 1024
)
ImageOperandsMask_VolatileTexel = Enum("ImageOperandsMask_VolatileTexel", 2048)
ImageOperandsMask_VolatileTexelKHR = Enum("ImageOperandsMask_VolatileTexelKHR", 2048)
ImageOperandsMask_SignExtend = Enum("ImageOperandsMask_SignExtend", 4096)
ImageOperandsMask_ZeroExtend = Enum("ImageOperandsMask_ZeroExtend", 8192)

FPFastMathModeShift_NotNaN = Enum("FPFastMathModeShift_NotNaN", 0)
FPFastMathModeShift_NotInf = Enum("FPFastMathModeShift_NotInf", 1)
FPFastMathModeShift_NSZ = Enum("FPFastMathModeShift_NSZ", 2)
FPFastMathModeShift_AllowRecip = Enum("FPFastMathModeShift_AllowRecip", 3)
FPFastMathModeShift_Fast = Enum("FPFastMathModeShift_Fast", 4)

FPFastMathModeMask_MaskNone = Enum("FPFastMathModeMask_MaskNone", 0)
FPFastMathModeMask_NotNaN = Enum("FPFastMathModeMask_NotNaN", 1)
FPFastMathModeMask_NotInf = Enum("FPFastMathModeMask_NotInf", 2)
FPFastMathModeMask_NSZ = Enum("FPFastMathModeMask_NSZ", 4)
FPFastMathModeMask_AllowRecip = Enum("FPFastMathModeMask_AllowRecip", 8)
FPFastMathModeMask_Fast = Enum("FPFastMathModeMask_Fast", 16)

FPRoundingMode_RTE = Enum("FPRoundingMode_RTE", 0)
FPRoundingMode_RTZ = Enum("FPRoundingMode_RTZ", 1)
FPRoundingMode_RTP = Enum("FPRoundingMode_RTP", 2)
FPRoundingMode_RTN = Enum("FPRoundingMode_RTN", 3)

LinkageType_Export = Enum("LinkageType_Export", 0)
LinkageType_Import = Enum("LinkageType_Import", 1)

AccessQualifier_ReadOnly = Enum("AccessQualifier_ReadOnly", 0)
AccessQualifier_WriteOnly = Enum("AccessQualifier_WriteOnly", 1)
AccessQualifier_ReadWrite = Enum("AccessQualifier_ReadWrite", 2)

FunctionParameterAttribute_Zext = Enum("FunctionParameterAttribute_Zext", 0)
FunctionParameterAttribute_Sext = Enum("FunctionParameterAttribute_Sext", 1)
FunctionParameterAttribute_ByVal = Enum("FunctionParameterAttribute_ByVal", 2)
FunctionParameterAttribute_Sret = Enum("FunctionParameterAttribute_Sret", 3)
FunctionParameterAttribute_NoAlias = Enum("FunctionParameterAttribute_NoAlias", 4)
FunctionParameterAttribute_NoCapture = Enum("FunctionParameterAttribute_NoCapture", 5)
FunctionParameterAttribute_NoWrite = Enum("FunctionParameterAttribute_NoWrite", 6)
FunctionParameterAttribute_NoReadWrite = Enum(
    "FunctionParameterAttribute_NoReadWrite", 7
)

Decoration_RelaxedPrecision = Enum("Decoration_RelaxedPrecision", 0)
Decoration_SpecId = Enum("Decoration_SpecId", 1)
Decoration_Block = Enum("Decoration_Block", 2)
Decoration_BufferBlock = Enum("Decoration_BufferBlock", 3)
Decoration_RowMajor = Enum("Decoration_RowMajor", 4)
Decoration_ColMajor = Enum("Decoration_ColMajor", 5)
Decoration_ArrayStride = Enum("Decoration_ArrayStride", 6)
Decoration_MatrixStride = Enum("Decoration_MatrixStride", 7)
Decoration_GLSLShared = Enum("Decoration_GLSLShared", 8)
Decoration_GLSLPacked = Enum("Decoration_GLSLPacked", 9)
Decoration_CPacked = Enum("Decoration_CPacked", 10)
Decoration_BuiltIn = Enum("Decoration_BuiltIn", 11)
Decoration_NoPerspective = Enum("Decoration_NoPerspective", 13)
Decoration_Flat = Enum("Decoration_Flat", 14)
Decoration_Patch = Enum("Decoration_Patch", 15)
Decoration_Centroid = Enum("Decoration_Centroid", 16)
Decoration_Sample = Enum("Decoration_Sample", 17)
Decoration_Invariant = Enum("Decoration_Invariant", 18)
Decoration_Restrict = Enum("Decoration_Restrict", 19)
Decoration_Aliased = Enum("Decoration_Aliased", 20)
Decoration_Volatile = Enum("Decoration_Volatile", 21)
Decoration_Constant = Enum("Decoration_Constant", 22)
Decoration_Coherent = Enum("Decoration_Coherent", 23)
Decoration_NonWritable = Enum("Decoration_NonWritable", 24)
Decoration_NonReadable = Enum("Decoration_NonReadable", 25)
Decoration_Uniform = Enum("Decoration_Uniform", 26)
Decoration_UniformId = Enum("Decoration_UniformId", 27)
Decoration_SaturatedConversion = Enum("Decoration_SaturatedConversion", 28)
Decoration_Stream = Enum("Decoration_Stream", 29)
Decoration_Location = Enum("Decoration_Location", 30)
Decoration_Component = Enum("Decoration_Component", 31)
Decoration_Index = Enum("Decoration_Index", 32)
Decoration_Binding = Enum("Decoration_Binding", 33)
Decoration_DescriptorSet = Enum("Decoration_DescriptorSet", 34)
Decoration_Offset = Enum("Decoration_Offset", 35)
Decoration_XfbBuffer = Enum("Decoration_XfbBuffer", 36)
Decoration_XfbStride = Enum("Decoration_XfbStride", 37)
Decoration_FuncParamAttr = Enum("Decoration_FuncParamAttr", 38)
Decoration_FPRoundingMode = Enum("Decoration_FPRoundingMode", 39)
Decoration_FPFastMathMode = Enum("Decoration_FPFastMathMode", 40)
Decoration_LinkageAttributes = Enum("Decoration_LinkageAttributes", 41)
Decoration_NoContraction = Enum("Decoration_NoContraction", 42)
Decoration_InputAttachmentIndex = Enum("Decoration_InputAttachmentIndex", 43)
Decoration_Alignment = Enum("Decoration_Alignment", 44)
Decoration_MaxByteOffset = Enum("Decoration_MaxByteOffset", 45)
Decoration_AlignmentId = Enum("Decoration_AlignmentId", 46)
Decoration_MaxByteOffsetId = Enum("Decoration_MaxByteOffsetId", 47)
Decoration_NoSignedWrap = Enum("Decoration_NoSignedWrap", 4469)
Decoration_NoUnsignedWrap = Enum("Decoration_NoUnsignedWrap", 4470)
Decoration_ExplicitInterpAMD = Enum("Decoration_ExplicitInterpAMD", 4999)
Decoration_OverrideCoverageNV = Enum("Decoration_OverrideCoverageNV", 5248)
Decoration_PassthroughNV = Enum("Decoration_PassthroughNV", 5250)
Decoration_ViewportRelativeNV = Enum("Decoration_ViewportRelativeNV", 5252)
Decoration_SecondaryViewportRelativeNV = Enum(
    "Decoration_SecondaryViewportRelativeNV", 5256
)
Decoration_PerPrimitiveNV = Enum("Decoration_PerPrimitiveNV", 5271)
Decoration_PerViewNV = Enum("Decoration_PerViewNV", 5272)
Decoration_PerTaskNV = Enum("Decoration_PerTaskNV", 5273)
Decoration_PerVertexNV = Enum("Decoration_PerVertexNV", 5285)
Decoration_NonUniform = Enum("Decoration_NonUniform", 5300)
Decoration_NonUniformEXT = Enum("Decoration_NonUniformEXT", 5300)
Decoration_RestrictPointer = Enum("Decoration_RestrictPointer", 5355)
Decoration_RestrictPointerEXT = Enum("Decoration_RestrictPointerEXT", 5355)
Decoration_AliasedPointer = Enum("Decoration_AliasedPointer", 5356)
Decoration_AliasedPointerEXT = Enum("Decoration_AliasedPointerEXT", 5356)
Decoration_CounterBuffer = Enum("Decoration_CounterBuffer", 5634)
Decoration_HlslCounterBufferGOOGLE = Enum("Decoration_HlslCounterBufferGOOGLE", 5634)
Decoration_HlslSemanticGOOGLE = Enum("Decoration_HlslSemanticGOOGLE", 5635)
Decoration_UserSemantic = Enum("Decoration_UserSemantic", 5635)
Decoration_UserTypeGOOGLE = Enum("Decoration_UserTypeGOOGLE", 5636)

BuiltIn_Position = Enum("BuiltIn_Position", 0)
BuiltIn_PointSize = Enum("BuiltIn_PointSize", 1)
BuiltIn_ClipDistance = Enum("BuiltIn_ClipDistance", 3)
BuiltIn_CullDistance = Enum("BuiltIn_CullDistance", 4)
BuiltIn_VertexId = Enum("BuiltIn_VertexId", 5)
BuiltIn_InstanceId = Enum("BuiltIn_InstanceId", 6)
BuiltIn_PrimitiveId = Enum("BuiltIn_PrimitiveId", 7)
BuiltIn_InvocationId = Enum("BuiltIn_InvocationId", 8)
BuiltIn_Layer = Enum("BuiltIn_Layer", 9)
BuiltIn_ViewportIndex = Enum("BuiltIn_ViewportIndex", 10)
BuiltIn_TessLevelOuter = Enum("BuiltIn_TessLevelOuter", 11)
BuiltIn_TessLevelInner = Enum("BuiltIn_TessLevelInner", 12)
BuiltIn_TessCoord = Enum("BuiltIn_TessCoord", 13)
BuiltIn_PatchVertices = Enum("BuiltIn_PatchVertices", 14)
BuiltIn_FragCoord = Enum("BuiltIn_FragCoord", 15)
BuiltIn_PointCoord = Enum("BuiltIn_PointCoord", 16)
BuiltIn_FrontFacing = Enum("BuiltIn_FrontFacing", 17)
BuiltIn_SampleId = Enum("BuiltIn_SampleId", 18)
BuiltIn_SamplePosition = Enum("BuiltIn_SamplePosition", 19)
BuiltIn_SampleMask = Enum("BuiltIn_SampleMask", 20)
BuiltIn_FragDepth = Enum("BuiltIn_FragDepth", 22)
BuiltIn_HelperInvocation = Enum("BuiltIn_HelperInvocation", 23)
BuiltIn_NumWorkgroups = Enum("BuiltIn_NumWorkgroups", 24)
BuiltIn_WorkgroupSize = Enum("BuiltIn_WorkgroupSize", 25)
BuiltIn_WorkgroupId = Enum("BuiltIn_WorkgroupId", 26)
BuiltIn_LocalInvocationId = Enum("BuiltIn_LocalInvocationId", 27)
BuiltIn_GlobalInvocationId = Enum("BuiltIn_GlobalInvocationId", 28)
BuiltIn_LocalInvocationIndex = Enum("BuiltIn_LocalInvocationIndex", 29)
BuiltIn_WorkDim = Enum("BuiltIn_WorkDim", 30)
BuiltIn_GlobalSize = Enum("BuiltIn_GlobalSize", 31)
BuiltIn_EnqueuedWorkgroupSize = Enum("BuiltIn_EnqueuedWorkgroupSize", 32)
BuiltIn_GlobalOffset = Enum("BuiltIn_GlobalOffset", 33)
BuiltIn_GlobalLinearId = Enum("BuiltIn_GlobalLinearId", 34)
BuiltIn_SubgroupSize = Enum("BuiltIn_SubgroupSize", 36)
BuiltIn_SubgroupMaxSize = Enum("BuiltIn_SubgroupMaxSize", 37)
BuiltIn_NumSubgroups = Enum("BuiltIn_NumSubgroups", 38)
BuiltIn_NumEnqueuedSubgroups = Enum("BuiltIn_NumEnqueuedSubgroups", 39)
BuiltIn_SubgroupId = Enum("BuiltIn_SubgroupId", 40)
BuiltIn_SubgroupLocalInvocationId = Enum("BuiltIn_SubgroupLocalInvocationId", 41)
BuiltIn_VertexIndex = Enum("BuiltIn_VertexIndex", 42)
BuiltIn_InstanceIndex = Enum("BuiltIn_InstanceIndex", 43)
BuiltIn_SubgroupEqMask = Enum("BuiltIn_SubgroupEqMask", 4416)
BuiltIn_SubgroupEqMaskKHR = Enum("BuiltIn_SubgroupEqMaskKHR", 4416)
BuiltIn_SubgroupGeMask = Enum("BuiltIn_SubgroupGeMask", 4417)
BuiltIn_SubgroupGeMaskKHR = Enum("BuiltIn_SubgroupGeMaskKHR", 4417)
BuiltIn_SubgroupGtMask = Enum("BuiltIn_SubgroupGtMask", 4418)
BuiltIn_SubgroupGtMaskKHR = Enum("BuiltIn_SubgroupGtMaskKHR", 4418)
BuiltIn_SubgroupLeMask = Enum("BuiltIn_SubgroupLeMask", 4419)
BuiltIn_SubgroupLeMaskKHR = Enum("BuiltIn_SubgroupLeMaskKHR", 4419)
BuiltIn_SubgroupLtMask = Enum("BuiltIn_SubgroupLtMask", 4420)
BuiltIn_SubgroupLtMaskKHR = Enum("BuiltIn_SubgroupLtMaskKHR", 4420)
BuiltIn_BaseVertex = Enum("BuiltIn_BaseVertex", 4424)
BuiltIn_BaseInstance = Enum("BuiltIn_BaseInstance", 4425)
BuiltIn_DrawIndex = Enum("BuiltIn_DrawIndex", 4426)
BuiltIn_DeviceIndex = Enum("BuiltIn_DeviceIndex", 4438)
BuiltIn_ViewIndex = Enum("BuiltIn_ViewIndex", 4440)
BuiltIn_BaryCoordNoPerspAMD = Enum("BuiltIn_BaryCoordNoPerspAMD", 4992)
BuiltIn_BaryCoordNoPerspCentroidAMD = Enum("BuiltIn_BaryCoordNoPerspCentroidAMD", 4993)
BuiltIn_BaryCoordNoPerspSampleAMD = Enum("BuiltIn_BaryCoordNoPerspSampleAMD", 4994)
BuiltIn_BaryCoordSmoothAMD = Enum("BuiltIn_BaryCoordSmoothAMD", 4995)
BuiltIn_BaryCoordSmoothCentroidAMD = Enum("BuiltIn_BaryCoordSmoothCentroidAMD", 4996)
BuiltIn_BaryCoordSmoothSampleAMD = Enum("BuiltIn_BaryCoordSmoothSampleAMD", 4997)
BuiltIn_BaryCoordPullModelAMD = Enum("BuiltIn_BaryCoordPullModelAMD", 4998)
BuiltIn_FragStencilRefEXT = Enum("BuiltIn_FragStencilRefEXT", 5014)
BuiltIn_ViewportMaskNV = Enum("BuiltIn_ViewportMaskNV", 5253)
BuiltIn_SecondaryPositionNV = Enum("BuiltIn_SecondaryPositionNV", 5257)
BuiltIn_SecondaryViewportMaskNV = Enum("BuiltIn_SecondaryViewportMaskNV", 5258)
BuiltIn_PositionPerViewNV = Enum("BuiltIn_PositionPerViewNV", 5261)
BuiltIn_ViewportMaskPerViewNV = Enum("BuiltIn_ViewportMaskPerViewNV", 5262)
BuiltIn_FullyCoveredEXT = Enum("BuiltIn_FullyCoveredEXT", 5264)
BuiltIn_TaskCountNV = Enum("BuiltIn_TaskCountNV", 5274)
BuiltIn_PrimitiveCountNV = Enum("BuiltIn_PrimitiveCountNV", 5275)
BuiltIn_PrimitiveIndicesNV = Enum("BuiltIn_PrimitiveIndicesNV", 5276)
BuiltIn_ClipDistancePerViewNV = Enum("BuiltIn_ClipDistancePerViewNV", 5277)
BuiltIn_CullDistancePerViewNV = Enum("BuiltIn_CullDistancePerViewNV", 5278)
BuiltIn_LayerPerViewNV = Enum("BuiltIn_LayerPerViewNV", 5279)
BuiltIn_MeshViewCountNV = Enum("BuiltIn_MeshViewCountNV", 5280)
BuiltIn_MeshViewIndicesNV = Enum("BuiltIn_MeshViewIndicesNV", 5281)
BuiltIn_BaryCoordNV = Enum("BuiltIn_BaryCoordNV", 5286)
BuiltIn_BaryCoordNoPerspNV = Enum("BuiltIn_BaryCoordNoPerspNV", 5287)
BuiltIn_FragSizeEXT = Enum("BuiltIn_FragSizeEXT", 5292)
BuiltIn_FragmentSizeNV = Enum("BuiltIn_FragmentSizeNV", 5292)
BuiltIn_FragInvocationCountEXT = Enum("BuiltIn_FragInvocationCountEXT", 5293)
BuiltIn_InvocationsPerPixelNV = Enum("BuiltIn_InvocationsPerPixelNV", 5293)
BuiltIn_LaunchIdNV = Enum("BuiltIn_LaunchIdNV", 5319)
BuiltIn_LaunchSizeNV = Enum("BuiltIn_LaunchSizeNV", 5320)
BuiltIn_WorldRayOriginNV = Enum("BuiltIn_WorldRayOriginNV", 5321)
BuiltIn_WorldRayDirectionNV = Enum("BuiltIn_WorldRayDirectionNV", 5322)
BuiltIn_ObjectRayOriginNV = Enum("BuiltIn_ObjectRayOriginNV", 5323)
BuiltIn_ObjectRayDirectionNV = Enum("BuiltIn_ObjectRayDirectionNV", 5324)
BuiltIn_RayTminNV = Enum("BuiltIn_RayTminNV", 5325)
BuiltIn_RayTmaxNV = Enum("BuiltIn_RayTmaxNV", 5326)
BuiltIn_InstanceCustomIndexNV = Enum("BuiltIn_InstanceCustomIndexNV", 5327)
BuiltIn_ObjectToWorldNV = Enum("BuiltIn_ObjectToWorldNV", 5330)
BuiltIn_WorldToObjectNV = Enum("BuiltIn_WorldToObjectNV", 5331)
BuiltIn_HitTNV = Enum("BuiltIn_HitTNV", 5332)
BuiltIn_HitKindNV = Enum("BuiltIn_HitKindNV", 5333)
BuiltIn_IncomingRayFlagsNV = Enum("BuiltIn_IncomingRayFlagsNV", 5351)
BuiltIn_WarpsPerSMNV = Enum("BuiltIn_WarpsPerSMNV", 5374)
BuiltIn_SMCountNV = Enum("BuiltIn_SMCountNV", 5375)
BuiltIn_WarpIDNV = Enum("BuiltIn_WarpIDNV", 5376)
BuiltIn_SMIDNV = Enum("BuiltIn_SMIDNV", 5377)

SelectionControlShift_Flatten = Enum("SelectionControlShift_Flatten", 0)
SelectionControlShift_DontFlatten = Enum("SelectionControlShift_DontFlatten", 1)

SelectionControlMask_MaskNone = Enum("SelectionControlMask_MaskNone", 0)
SelectionControlMask_Flatten = Enum("SelectionControlMask_Flatten", 1)
SelectionControlMask_DontFlatten = Enum("SelectionControlMask_DontFlatten", 2)

LoopControlShift_Unroll = Enum("LoopControlShift_Unroll", 0)
LoopControlShift_DontUnroll = Enum("LoopControlShift_DontUnroll", 1)
LoopControlShift_DependencyInfinite = Enum("LoopControlShift_DependencyInfinite", 2)
LoopControlShift_DependencyLength = Enum("LoopControlShift_DependencyLength", 3)
LoopControlShift_MinIterations = Enum("LoopControlShift_MinIterations", 4)
LoopControlShift_MaxIterations = Enum("LoopControlShift_MaxIterations", 5)
LoopControlShift_IterationMultiple = Enum("LoopControlShift_IterationMultiple", 6)
LoopControlShift_PeelCount = Enum("LoopControlShift_PeelCount", 7)
LoopControlShift_PartialCount = Enum("LoopControlShift_PartialCount", 8)

LoopControlMask_MaskNone = Enum("LoopControlMask_MaskNone", 0)
LoopControlMask_Unroll = Enum("LoopControlMask_Unroll", 1)
LoopControlMask_DontUnroll = Enum("LoopControlMask_DontUnroll", 2)
LoopControlMask_DependencyInfinite = Enum("LoopControlMask_DependencyInfinite", 4)
LoopControlMask_DependencyLength = Enum("LoopControlMask_DependencyLength", 8)
LoopControlMask_MinIterations = Enum("LoopControlMask_MinIterations", 16)
LoopControlMask_MaxIterations = Enum("LoopControlMask_MaxIterations", 32)
LoopControlMask_IterationMultiple = Enum("LoopControlMask_IterationMultiple", 64)
LoopControlMask_PeelCount = Enum("LoopControlMask_PeelCount", 128)
LoopControlMask_PartialCount = Enum("LoopControlMask_PartialCount", 256)

FunctionControlShift_Inline = Enum("FunctionControlShift_Inline", 0)
FunctionControlShift_DontInline = Enum("FunctionControlShift_DontInline", 1)
FunctionControlShift_Pure = Enum("FunctionControlShift_Pure", 2)
FunctionControlShift_Const = Enum("FunctionControlShift_Const", 3)

FunctionControlMask_MaskNone = Enum("FunctionControlMask_MaskNone", 0)
FunctionControlMask_Inline = Enum("FunctionControlMask_Inline", 1)
FunctionControlMask_DontInline = Enum("FunctionControlMask_DontInline", 2)
FunctionControlMask_Pure = Enum("FunctionControlMask_Pure", 4)
FunctionControlMask_Const = Enum("FunctionControlMask_Const", 8)

MemorySemanticsShift_Acquire = Enum("MemorySemanticsShift_Acquire", 1)
MemorySemanticsShift_Release = Enum("MemorySemanticsShift_Release", 2)
MemorySemanticsShift_AcquireRelease = Enum("MemorySemanticsShift_AcquireRelease", 3)
MemorySemanticsShift_SequentiallyConsistent = Enum(
    "MemorySemanticsShift_SequentiallyConsistent", 4
)
MemorySemanticsShift_UniformMemory = Enum("MemorySemanticsShift_UniformMemory", 6)
MemorySemanticsShift_SubgroupMemory = Enum("MemorySemanticsShift_SubgroupMemory", 7)
MemorySemanticsShift_WorkgroupMemory = Enum("MemorySemanticsShift_WorkgroupMemory", 8)
MemorySemanticsShift_CrossWorkgroupMemory = Enum(
    "MemorySemanticsShift_CrossWorkgroupMemory", 9
)
MemorySemanticsShift_AtomicCounterMemory = Enum(
    "MemorySemanticsShift_AtomicCounterMemory", 10
)
MemorySemanticsShift_ImageMemory = Enum("MemorySemanticsShift_ImageMemory", 11)
MemorySemanticsShift_OutputMemory = Enum("MemorySemanticsShift_OutputMemory", 12)
MemorySemanticsShift_OutputMemoryKHR = Enum("MemorySemanticsShift_OutputMemoryKHR", 12)
MemorySemanticsShift_MakeAvailable = Enum("MemorySemanticsShift_MakeAvailable", 13)
MemorySemanticsShift_MakeAvailableKHR = Enum(
    "MemorySemanticsShift_MakeAvailableKHR", 13
)
MemorySemanticsShift_MakeVisible = Enum("MemorySemanticsShift_MakeVisible", 14)
MemorySemanticsShift_MakeVisibleKHR = Enum("MemorySemanticsShift_MakeVisibleKHR", 14)
MemorySemanticsShift_Volatile = Enum("MemorySemanticsShift_Volatile", 15)

MemorySemanticsMask_MaskNone = Enum("MemorySemanticsMask_MaskNone", 0)
MemorySemanticsMask_Acquire = Enum("MemorySemanticsMask_Acquire", 2)
MemorySemanticsMask_Release = Enum("MemorySemanticsMask_Release", 4)
MemorySemanticsMask_AcquireRelease = Enum("MemorySemanticsMask_AcquireRelease", 8)
MemorySemanticsMask_SequentiallyConsistent = Enum(
    "MemorySemanticsMask_SequentiallyConsistent", 16
)
MemorySemanticsMask_UniformMemory = Enum("MemorySemanticsMask_UniformMemory", 64)
MemorySemanticsMask_SubgroupMemory = Enum("MemorySemanticsMask_SubgroupMemory", 128)
MemorySemanticsMask_WorkgroupMemory = Enum("MemorySemanticsMask_WorkgroupMemory", 256)
MemorySemanticsMask_CrossWorkgroupMemory = Enum(
    "MemorySemanticsMask_CrossWorkgroupMemory", 512
)
MemorySemanticsMask_AtomicCounterMemory = Enum(
    "MemorySemanticsMask_AtomicCounterMemory", 1024
)
MemorySemanticsMask_ImageMemory = Enum("MemorySemanticsMask_ImageMemory", 2048)
MemorySemanticsMask_OutputMemory = Enum("MemorySemanticsMask_OutputMemory", 4096)
MemorySemanticsMask_OutputMemoryKHR = Enum("MemorySemanticsMask_OutputMemoryKHR", 4096)
MemorySemanticsMask_MakeAvailable = Enum("MemorySemanticsMask_MakeAvailable", 8192)
MemorySemanticsMask_MakeAvailableKHR = Enum(
    "MemorySemanticsMask_MakeAvailableKHR", 8192
)
MemorySemanticsMask_MakeVisible = Enum("MemorySemanticsMask_MakeVisible", 16384)
MemorySemanticsMask_MakeVisibleKHR = Enum("MemorySemanticsMask_MakeVisibleKHR", 16384)
MemorySemanticsMask_Volatile = Enum("MemorySemanticsMask_Volatile", 32768)

MemoryAccessShift_Volatile = Enum("MemoryAccessShift_Volatile", 0)
MemoryAccessShift_Aligned = Enum("MemoryAccessShift_Aligned", 1)
MemoryAccessShift_Nontemporal = Enum("MemoryAccessShift_Nontemporal", 2)
MemoryAccessShift_MakePointerAvailable = Enum(
    "MemoryAccessShift_MakePointerAvailable", 3
)
MemoryAccessShift_MakePointerAvailableKHR = Enum(
    "MemoryAccessShift_MakePointerAvailableKHR", 3
)
MemoryAccessShift_MakePointerVisible = Enum("MemoryAccessShift_MakePointerVisible", 4)
MemoryAccessShift_MakePointerVisibleKHR = Enum(
    "MemoryAccessShift_MakePointerVisibleKHR", 4
)
MemoryAccessShift_NonPrivatePointer = Enum("MemoryAccessShift_NonPrivatePointer", 5)
MemoryAccessShift_NonPrivatePointerKHR = Enum(
    "MemoryAccessShift_NonPrivatePointerKHR", 5
)

MemoryAccessMask_MaskNone = Enum("MemoryAccessMask_MaskNone", 0)
MemoryAccessMask_Volatile = Enum("MemoryAccessMask_Volatile", 1)
MemoryAccessMask_Aligned = Enum("MemoryAccessMask_Aligned", 2)
MemoryAccessMask_Nontemporal = Enum("MemoryAccessMask_Nontemporal", 4)
MemoryAccessMask_MakePointerAvailable = Enum("MemoryAccessMask_MakePointerAvailable", 8)
MemoryAccessMask_MakePointerAvailableKHR = Enum(
    "MemoryAccessMask_MakePointerAvailableKHR", 8
)
MemoryAccessMask_MakePointerVisible = Enum("MemoryAccessMask_MakePointerVisible", 16)
MemoryAccessMask_MakePointerVisibleKHR = Enum(
    "MemoryAccessMask_MakePointerVisibleKHR", 16
)
MemoryAccessMask_NonPrivatePointer = Enum("MemoryAccessMask_NonPrivatePointer", 32)
MemoryAccessMask_NonPrivatePointerKHR = Enum(
    "MemoryAccessMask_NonPrivatePointerKHR", 32
)

Scope_CrossDevice = Enum("Scope_CrossDevice", 0)
Scope_Device = Enum("Scope_Device", 1)
Scope_Workgroup = Enum("Scope_Workgroup", 2)
Scope_Subgroup = Enum("Scope_Subgroup", 3)
Scope_Invocation = Enum("Scope_Invocation", 4)
Scope_QueueFamily = Enum("Scope_QueueFamily", 5)
Scope_QueueFamilyKHR = Enum("Scope_QueueFamilyKHR", 5)

GroupOperation_Reduce = Enum("GroupOperation_Reduce", 0)
GroupOperation_InclusiveScan = Enum("GroupOperation_InclusiveScan", 1)
GroupOperation_ExclusiveScan = Enum("GroupOperation_ExclusiveScan", 2)
GroupOperation_ClusteredReduce = Enum("GroupOperation_ClusteredReduce", 3)
GroupOperation_PartitionedReduceNV = Enum("GroupOperation_PartitionedReduceNV", 6)
GroupOperation_PartitionedInclusiveScanNV = Enum(
    "GroupOperation_PartitionedInclusiveScanNV", 7
)
GroupOperation_PartitionedExclusiveScanNV = Enum(
    "GroupOperation_PartitionedExclusiveScanNV", 8
)

KernelEnqueueFlags_NoWait = Enum("KernelEnqueueFlags_NoWait", 0)
KernelEnqueueFlags_WaitKernel = Enum("KernelEnqueueFlags_WaitKernel", 1)
KernelEnqueueFlags_WaitWorkGroup = Enum("KernelEnqueueFlags_WaitWorkGroup", 2)

KernelProfilingInfoShift_CmdExecTime = Enum("KernelProfilingInfoShift_CmdExecTime", 0)

KernelProfilingInfoMask_MaskNone = Enum("KernelProfilingInfoMask_MaskNone", 0)
KernelProfilingInfoMask_CmdExecTime = Enum("KernelProfilingInfoMask_CmdExecTime", 1)

Capability_Matrix = Enum("Capability_Matrix", 0)
Capability_Shader = Enum("Capability_Shader", 1)
Capability_Geometry = Enum("Capability_Geometry", 2)
Capability_Tessellation = Enum("Capability_Tessellation", 3)
Capability_Addresses = Enum("Capability_Addresses", 4)
Capability_Linkage = Enum("Capability_Linkage", 5)
Capability_Kernel = Enum("Capability_Kernel", 6)
Capability_Vector16 = Enum("Capability_Vector16", 7)
Capability_Float16Buffer = Enum("Capability_Float16Buffer", 8)
Capability_Float16 = Enum("Capability_Float16", 9)
Capability_Float64 = Enum("Capability_Float64", 10)
Capability_Int64 = Enum("Capability_Int64", 11)
Capability_Int64Atomics = Enum("Capability_Int64Atomics", 12)
Capability_ImageBasic = Enum("Capability_ImageBasic", 13)
Capability_ImageReadWrite = Enum("Capability_ImageReadWrite", 14)
Capability_ImageMipmap = Enum("Capability_ImageMipmap", 15)
Capability_Pipes = Enum("Capability_Pipes", 17)
Capability_Groups = Enum("Capability_Groups", 18)
Capability_DeviceEnqueue = Enum("Capability_DeviceEnqueue", 19)
Capability_LiteralSampler = Enum("Capability_LiteralSampler", 20)
Capability_AtomicStorage = Enum("Capability_AtomicStorage", 21)
Capability_Int16 = Enum("Capability_Int16", 22)
Capability_TessellationPointSize = Enum("Capability_TessellationPointSize", 23)
Capability_GeometryPointSize = Enum("Capability_GeometryPointSize", 24)
Capability_ImageGatherExtended = Enum("Capability_ImageGatherExtended", 25)
Capability_StorageImageMultisample = Enum("Capability_StorageImageMultisample", 27)
Capability_UniformBufferArrayDynamicIndexing = Enum(
    "Capability_UniformBufferArrayDynamicIndexing", 28
)
Capability_SampledImageArrayDynamicIndexing = Enum(
    "Capability_SampledImageArrayDynamicIndexing", 29
)
Capability_StorageBufferArrayDynamicIndexing = Enum(
    "Capability_StorageBufferArrayDynamicIndexing", 30
)
Capability_StorageImageArrayDynamicIndexing = Enum(
    "Capability_StorageImageArrayDynamicIndexing", 31
)
Capability_ClipDistance = Enum("Capability_ClipDistance", 32)
Capability_CullDistance = Enum("Capability_CullDistance", 33)
Capability_ImageCubeArray = Enum("Capability_ImageCubeArray", 34)
Capability_SampleRateShading = Enum("Capability_SampleRateShading", 35)
Capability_ImageRect = Enum("Capability_ImageRect", 36)
Capability_SampledRect = Enum("Capability_SampledRect", 37)
Capability_GenericPointer = Enum("Capability_GenericPointer", 38)
Capability_Int8 = Enum("Capability_Int8", 39)
Capability_InputAttachment = Enum("Capability_InputAttachment", 40)
Capability_SparseResidency = Enum("Capability_SparseResidency", 41)
Capability_MinLod = Enum("Capability_MinLod", 42)
Capability_Sampled1D = Enum("Capability_Sampled1D", 43)
Capability_Image1D = Enum("Capability_Image1D", 44)
Capability_SampledCubeArray = Enum("Capability_SampledCubeArray", 45)
Capability_SampledBuffer = Enum("Capability_SampledBuffer", 46)
Capability_ImageBuffer = Enum("Capability_ImageBuffer", 47)
Capability_ImageMSArray = Enum("Capability_ImageMSArray", 48)
Capability_StorageImageExtendedFormats = Enum(
    "Capability_StorageImageExtendedFormats", 49
)
Capability_ImageQuery = Enum("Capability_ImageQuery", 50)
Capability_DerivativeControl = Enum("Capability_DerivativeControl", 51)
Capability_InterpolationFunction = Enum("Capability_InterpolationFunction", 52)
Capability_TransformFeedback = Enum("Capability_TransformFeedback", 53)
Capability_GeometryStreams = Enum("Capability_GeometryStreams", 54)
Capability_StorageImageReadWithoutFormat = Enum(
    "Capability_StorageImageReadWithoutFormat", 55
)
Capability_StorageImageWriteWithoutFormat = Enum(
    "Capability_StorageImageWriteWithoutFormat", 56
)
Capability_MultiViewport = Enum("Capability_MultiViewport", 57)
Capability_SubgroupDispatch = Enum("Capability_SubgroupDispatch", 58)
Capability_NamedBarrier = Enum("Capability_NamedBarrier", 59)
Capability_PipeStorage = Enum("Capability_PipeStorage", 60)
Capability_GroupNonUniform = Enum("Capability_GroupNonUniform", 61)
Capability_GroupNonUniformVote = Enum("Capability_GroupNonUniformVote", 62)
Capability_GroupNonUniformArithmetic = Enum("Capability_GroupNonUniformArithmetic", 63)
Capability_GroupNonUniformBallot = Enum("Capability_GroupNonUniformBallot", 64)
Capability_GroupNonUniformShuffle = Enum("Capability_GroupNonUniformShuffle", 65)
Capability_GroupNonUniformShuffleRelative = Enum(
    "Capability_GroupNonUniformShuffleRelative", 66
)
Capability_GroupNonUniformClustered = Enum("Capability_GroupNonUniformClustered", 67)
Capability_GroupNonUniformQuad = Enum("Capability_GroupNonUniformQuad", 68)
Capability_ShaderLayer = Enum("Capability_ShaderLayer", 69)
Capability_ShaderViewportIndex = Enum("Capability_ShaderViewportIndex", 70)
Capability_SubgroupBallotKHR = Enum("Capability_SubgroupBallotKHR", 4423)
Capability_DrawParameters = Enum("Capability_DrawParameters", 4427)
Capability_SubgroupVoteKHR = Enum("Capability_SubgroupVoteKHR", 4431)
Capability_StorageBuffer16BitAccess = Enum("Capability_StorageBuffer16BitAccess", 4433)
Capability_StorageUniformBufferBlock16 = Enum(
    "Capability_StorageUniformBufferBlock16", 4433
)
Capability_StorageUniform16 = Enum("Capability_StorageUniform16", 4434)
Capability_UniformAndStorageBuffer16BitAccess = Enum(
    "Capability_UniformAndStorageBuffer16BitAccess", 4434
)
Capability_StoragePushConstant16 = Enum("Capability_StoragePushConstant16", 4435)
Capability_StorageInputOutput16 = Enum("Capability_StorageInputOutput16", 4436)
Capability_DeviceGroup = Enum("Capability_DeviceGroup", 4437)
Capability_MultiView = Enum("Capability_MultiView", 4439)
Capability_VariablePointersStorageBuffer = Enum(
    "Capability_VariablePointersStorageBuffer", 4441
)
Capability_VariablePointers = Enum("Capability_VariablePointers", 4442)
Capability_AtomicStorageOps = Enum("Capability_AtomicStorageOps", 4445)
Capability_SampleMaskPostDepthCoverage = Enum(
    "Capability_SampleMaskPostDepthCoverage", 4447
)
Capability_StorageBuffer8BitAccess = Enum("Capability_StorageBuffer8BitAccess", 4448)
Capability_UniformAndStorageBuffer8BitAccess = Enum(
    "Capability_UniformAndStorageBuffer8BitAccess", 4449
)
Capability_StoragePushConstant8 = Enum("Capability_StoragePushConstant8", 4450)
Capability_DenormPreserve = Enum("Capability_DenormPreserve", 4464)
Capability_DenormFlushToZero = Enum("Capability_DenormFlushToZero", 4465)
Capability_SignedZeroInfNanPreserve = Enum("Capability_SignedZeroInfNanPreserve", 4466)
Capability_RoundingModeRTE = Enum("Capability_RoundingModeRTE", 4467)
Capability_RoundingModeRTZ = Enum("Capability_RoundingModeRTZ", 4468)
Capability_Float16ImageAMD = Enum("Capability_Float16ImageAMD", 5008)
Capability_ImageGatherBiasLodAMD = Enum("Capability_ImageGatherBiasLodAMD", 5009)
Capability_FragmentMaskAMD = Enum("Capability_FragmentMaskAMD", 5010)
Capability_StencilExportEXT = Enum("Capability_StencilExportEXT", 5013)
Capability_ImageReadWriteLodAMD = Enum("Capability_ImageReadWriteLodAMD", 5015)
Capability_ShaderClockKHR = Enum("Capability_ShaderClockKHR", 5055)
Capability_SampleMaskOverrideCoverageNV = Enum(
    "Capability_SampleMaskOverrideCoverageNV", 5249
)
Capability_GeometryShaderPassthroughNV = Enum(
    "Capability_GeometryShaderPassthroughNV", 5251
)
Capability_ShaderViewportIndexLayerEXT = Enum(
    "Capability_ShaderViewportIndexLayerEXT", 5254
)
Capability_ShaderViewportIndexLayerNV = Enum(
    "Capability_ShaderViewportIndexLayerNV", 5254
)
Capability_ShaderViewportMaskNV = Enum("Capability_ShaderViewportMaskNV", 5255)
Capability_ShaderStereoViewNV = Enum("Capability_ShaderStereoViewNV", 5259)
Capability_PerViewAttributesNV = Enum("Capability_PerViewAttributesNV", 5260)
Capability_FragmentFullyCoveredEXT = Enum("Capability_FragmentFullyCoveredEXT", 5265)
Capability_MeshShadingNV = Enum("Capability_MeshShadingNV", 5266)
Capability_ImageFootprintNV = Enum("Capability_ImageFootprintNV", 5282)
Capability_FragmentBarycentricNV = Enum("Capability_FragmentBarycentricNV", 5284)
Capability_ComputeDerivativeGroupQuadsNV = Enum(
    "Capability_ComputeDerivativeGroupQuadsNV", 5288
)
Capability_FragmentDensityEXT = Enum("Capability_FragmentDensityEXT", 5291)
Capability_ShadingRateNV = Enum("Capability_ShadingRateNV", 5291)
Capability_GroupNonUniformPartitionedNV = Enum(
    "Capability_GroupNonUniformPartitionedNV", 5297
)
Capability_ShaderNonUniform = Enum("Capability_ShaderNonUniform", 5301)
Capability_ShaderNonUniformEXT = Enum("Capability_ShaderNonUniformEXT", 5301)
Capability_RuntimeDescriptorArray = Enum("Capability_RuntimeDescriptorArray", 5302)
Capability_RuntimeDescriptorArrayEXT = Enum(
    "Capability_RuntimeDescriptorArrayEXT", 5302
)
Capability_InputAttachmentArrayDynamicIndexing = Enum(
    "Capability_InputAttachmentArrayDynamicIndexing", 5303
)
Capability_InputAttachmentArrayDynamicIndexingEXT = Enum(
    "Capability_InputAttachmentArrayDynamicIndexingEXT", 5303
)
Capability_UniformTexelBufferArrayDynamicIndexing = Enum(
    "Capability_UniformTexelBufferArrayDynamicIndexing", 5304
)
Capability_UniformTexelBufferArrayDynamicIndexingEXT = Enum(
    "Capability_UniformTexelBufferArrayDynamicIndexingEXT", 5304
)
Capability_StorageTexelBufferArrayDynamicIndexing = Enum(
    "Capability_StorageTexelBufferArrayDynamicIndexing", 5305
)
Capability_StorageTexelBufferArrayDynamicIndexingEXT = Enum(
    "Capability_StorageTexelBufferArrayDynamicIndexingEXT", 5305
)
Capability_UniformBufferArrayNonUniformIndexing = Enum(
    "Capability_UniformBufferArrayNonUniformIndexing", 5306
)
Capability_UniformBufferArrayNonUniformIndexingEXT = Enum(
    "Capability_UniformBufferArrayNonUniformIndexingEXT", 5306
)
Capability_SampledImageArrayNonUniformIndexing = Enum(
    "Capability_SampledImageArrayNonUniformIndexing", 5307
)
Capability_SampledImageArrayNonUniformIndexingEXT = Enum(
    "Capability_SampledImageArrayNonUniformIndexingEXT", 5307
)
Capability_StorageBufferArrayNonUniformIndexing = Enum(
    "Capability_StorageBufferArrayNonUniformIndexing", 5308
)
Capability_StorageBufferArrayNonUniformIndexingEXT = Enum(
    "Capability_StorageBufferArrayNonUniformIndexingEXT", 5308
)
Capability_StorageImageArrayNonUniformIndexing = Enum(
    "Capability_StorageImageArrayNonUniformIndexing", 5309
)
Capability_StorageImageArrayNonUniformIndexingEXT = Enum(
    "Capability_StorageImageArrayNonUniformIndexingEXT", 5309
)
Capability_InputAttachmentArrayNonUniformIndexing = Enum(
    "Capability_InputAttachmentArrayNonUniformIndexing", 5310
)
Capability_InputAttachmentArrayNonUniformIndexingEXT = Enum(
    "Capability_InputAttachmentArrayNonUniformIndexingEXT", 5310
)
Capability_UniformTexelBufferArrayNonUniformIndexing = Enum(
    "Capability_UniformTexelBufferArrayNonUniformIndexing", 5311
)
Capability_UniformTexelBufferArrayNonUniformIndexingEXT = Enum(
    "Capability_UniformTexelBufferArrayNonUniformIndexingEXT", 5311
)
Capability_StorageTexelBufferArrayNonUniformIndexing = Enum(
    "Capability_StorageTexelBufferArrayNonUniformIndexing", 5312
)
Capability_StorageTexelBufferArrayNonUniformIndexingEXT = Enum(
    "Capability_StorageTexelBufferArrayNonUniformIndexingEXT", 5312
)
Capability_RayTracingNV = Enum("Capability_RayTracingNV", 5340)
Capability_VulkanMemoryModel = Enum("Capability_VulkanMemoryModel", 5345)
Capability_VulkanMemoryModelKHR = Enum("Capability_VulkanMemoryModelKHR", 5345)
Capability_VulkanMemoryModelDeviceScope = Enum(
    "Capability_VulkanMemoryModelDeviceScope", 5346
)
Capability_VulkanMemoryModelDeviceScopeKHR = Enum(
    "Capability_VulkanMemoryModelDeviceScopeKHR", 5346
)
Capability_PhysicalStorageBufferAddresses = Enum(
    "Capability_PhysicalStorageBufferAddresses", 5347
)
Capability_PhysicalStorageBufferAddressesEXT = Enum(
    "Capability_PhysicalStorageBufferAddressesEXT", 5347
)
Capability_ComputeDerivativeGroupLinearNV = Enum(
    "Capability_ComputeDerivativeGroupLinearNV", 5350
)
Capability_CooperativeMatrixNV = Enum("Capability_CooperativeMatrixNV", 5357)
Capability_FragmentShaderSampleInterlockEXT = Enum(
    "Capability_FragmentShaderSampleInterlockEXT", 5363
)
Capability_FragmentShaderShadingRateInterlockEXT = Enum(
    "Capability_FragmentShaderShadingRateInterlockEXT", 5372
)
Capability_ShaderSMBuiltinsNV = Enum("Capability_ShaderSMBuiltinsNV", 5373)
Capability_FragmentShaderPixelInterlockEXT = Enum(
    "Capability_FragmentShaderPixelInterlockEXT", 5378
)
Capability_DemoteToHelperInvocationEXT = Enum(
    "Capability_DemoteToHelperInvocationEXT", 5379
)
Capability_SubgroupShuffleINTEL = Enum("Capability_SubgroupShuffleINTEL", 5568)
Capability_SubgroupBufferBlockIOINTEL = Enum(
    "Capability_SubgroupBufferBlockIOINTEL", 5569
)
Capability_SubgroupImageBlockIOINTEL = Enum(
    "Capability_SubgroupImageBlockIOINTEL", 5570
)
Capability_SubgroupImageMediaBlockIOINTEL = Enum(
    "Capability_SubgroupImageMediaBlockIOINTEL", 5579
)
Capability_IntegerFunctions2INTEL = Enum("Capability_IntegerFunctions2INTEL", 5584)
Capability_SubgroupAvcMotionEstimationINTEL = Enum(
    "Capability_SubgroupAvcMotionEstimationINTEL", 5696
)
Capability_SubgroupAvcMotionEstimationIntraINTEL = Enum(
    "Capability_SubgroupAvcMotionEstimationIntraINTEL", 5697
)
Capability_SubgroupAvcMotionEstimationChromaINTEL = Enum(
    "Capability_SubgroupAvcMotionEstimationChromaINTEL", 5698
)

OpNop = Enum("OpNop", 0)
OpUndef = Enum("OpUndef", 1)
OpSourceContinued = Enum("OpSourceContinued", 2)
OpSource = Enum("OpSource", 3)
OpSourceExtension = Enum("OpSourceExtension", 4)
OpName = Enum("OpName", 5)
OpMemberName = Enum("OpMemberName", 6)
OpString = Enum("OpString", 7)
OpLine = Enum("OpLine", 8)
OpExtension = Enum("OpExtension", 10)
OpExtInstImport = Enum("OpExtInstImport", 11)
OpExtInst = Enum("OpExtInst", 12)
OpMemoryModel = Enum("OpMemoryModel", 14)
OpEntryPoint = Enum("OpEntryPoint", 15)
OpExecutionMode = Enum("OpExecutionMode", 16)
OpCapability = Enum("OpCapability", 17)
OpTypeVoid = Enum("OpTypeVoid", 19)
OpTypeBool = Enum("OpTypeBool", 20)
OpTypeInt = Enum("OpTypeInt", 21)
OpTypeFloat = Enum("OpTypeFloat", 22)
OpTypeVector = Enum("OpTypeVector", 23)
OpTypeMatrix = Enum("OpTypeMatrix", 24)
OpTypeImage = Enum("OpTypeImage", 25)
OpTypeSampler = Enum("OpTypeSampler", 26)
OpTypeSampledImage = Enum("OpTypeSampledImage", 27)
OpTypeArray = Enum("OpTypeArray", 28)
OpTypeRuntimeArray = Enum("OpTypeRuntimeArray", 29)
OpTypeStruct = Enum("OpTypeStruct", 30)
OpTypeOpaque = Enum("OpTypeOpaque", 31)
OpTypePointer = Enum("OpTypePointer", 32)
OpTypeFunction = Enum("OpTypeFunction", 33)
OpTypeEvent = Enum("OpTypeEvent", 34)
OpTypeDeviceEvent = Enum("OpTypeDeviceEvent", 35)
OpTypeReserveId = Enum("OpTypeReserveId", 36)
OpTypeQueue = Enum("OpTypeQueue", 37)
OpTypePipe = Enum("OpTypePipe", 38)
OpTypeForwardPointer = Enum("OpTypeForwardPointer", 39)
OpConstantTrue = Enum("OpConstantTrue", 41)
OpConstantFalse = Enum("OpConstantFalse", 42)
OpConstant = Enum("OpConstant", 43)
OpConstantComposite = Enum("OpConstantComposite", 44)
OpConstantSampler = Enum("OpConstantSampler", 45)
OpConstantNull = Enum("OpConstantNull", 46)
OpSpecConstantTrue = Enum("OpSpecConstantTrue", 48)
OpSpecConstantFalse = Enum("OpSpecConstantFalse", 49)
OpSpecConstant = Enum("OpSpecConstant", 50)
OpSpecConstantComposite = Enum("OpSpecConstantComposite", 51)
OpSpecConstantOp = Enum("OpSpecConstantOp", 52)
OpFunction = Enum("OpFunction", 54)
OpFunctionParameter = Enum("OpFunctionParameter", 55)
OpFunctionEnd = Enum("OpFunctionEnd", 56)
OpFunctionCall = Enum("OpFunctionCall", 57)
OpVariable = Enum("OpVariable", 59)
OpImageTexelPointer = Enum("OpImageTexelPointer", 60)
OpLoad = Enum("OpLoad", 61)
OpStore = Enum("OpStore", 62)
OpCopyMemory = Enum("OpCopyMemory", 63)
OpCopyMemorySized = Enum("OpCopyMemorySized", 64)
OpAccessChain = Enum("OpAccessChain", 65)
OpInBoundsAccessChain = Enum("OpInBoundsAccessChain", 66)
OpPtrAccessChain = Enum("OpPtrAccessChain", 67)
OpArrayLength = Enum("OpArrayLength", 68)
OpGenericPtrMemSemantics = Enum("OpGenericPtrMemSemantics", 69)
OpInBoundsPtrAccessChain = Enum("OpInBoundsPtrAccessChain", 70)
OpDecorate = Enum("OpDecorate", 71)
OpMemberDecorate = Enum("OpMemberDecorate", 72)
OpDecorationGroup = Enum("OpDecorationGroup", 73)
OpGroupDecorate = Enum("OpGroupDecorate", 74)
OpGroupMemberDecorate = Enum("OpGroupMemberDecorate", 75)
OpVectorExtractDynamic = Enum("OpVectorExtractDynamic", 77)
OpVectorInsertDynamic = Enum("OpVectorInsertDynamic", 78)
OpVectorShuffle = Enum("OpVectorShuffle", 79)
OpCompositeConstruct = Enum("OpCompositeConstruct", 80)
OpCompositeExtract = Enum("OpCompositeExtract", 81)
OpCompositeInsert = Enum("OpCompositeInsert", 82)
OpCopyObject = Enum("OpCopyObject", 83)
OpTranspose = Enum("OpTranspose", 84)
OpSampledImage = Enum("OpSampledImage", 86)
OpImageSampleImplicitLod = Enum("OpImageSampleImplicitLod", 87)
OpImageSampleExplicitLod = Enum("OpImageSampleExplicitLod", 88)
OpImageSampleDrefImplicitLod = Enum("OpImageSampleDrefImplicitLod", 89)
OpImageSampleDrefExplicitLod = Enum("OpImageSampleDrefExplicitLod", 90)
OpImageSampleProjImplicitLod = Enum("OpImageSampleProjImplicitLod", 91)
OpImageSampleProjExplicitLod = Enum("OpImageSampleProjExplicitLod", 92)
OpImageSampleProjDrefImplicitLod = Enum("OpImageSampleProjDrefImplicitLod", 93)
OpImageSampleProjDrefExplicitLod = Enum("OpImageSampleProjDrefExplicitLod", 94)
OpImageFetch = Enum("OpImageFetch", 95)
OpImageGather = Enum("OpImageGather", 96)
OpImageDrefGather = Enum("OpImageDrefGather", 97)
OpImageRead = Enum("OpImageRead", 98)
OpImageWrite = Enum("OpImageWrite", 99)
OpImage = Enum("OpImage", 100)
OpImageQueryFormat = Enum("OpImageQueryFormat", 101)
OpImageQueryOrder = Enum("OpImageQueryOrder", 102)
OpImageQuerySizeLod = Enum("OpImageQuerySizeLod", 103)
OpImageQuerySize = Enum("OpImageQuerySize", 104)
OpImageQueryLod = Enum("OpImageQueryLod", 105)
OpImageQueryLevels = Enum("OpImageQueryLevels", 106)
OpImageQuerySamples = Enum("OpImageQuerySamples", 107)
OpConvertFToU = Enum("OpConvertFToU", 109)
OpConvertFToS = Enum("OpConvertFToS", 110)
OpConvertSToF = Enum("OpConvertSToF", 111)
OpConvertUToF = Enum("OpConvertUToF", 112)
OpUConvert = Enum("OpUConvert", 113)
OpSConvert = Enum("OpSConvert", 114)
OpFConvert = Enum("OpFConvert", 115)
OpQuantizeToF16 = Enum("OpQuantizeToF16", 116)
OpConvertPtrToU = Enum("OpConvertPtrToU", 117)
OpSatConvertSToU = Enum("OpSatConvertSToU", 118)
OpSatConvertUToS = Enum("OpSatConvertUToS", 119)
OpConvertUToPtr = Enum("OpConvertUToPtr", 120)
OpPtrCastToGeneric = Enum("OpPtrCastToGeneric", 121)
OpGenericCastToPtr = Enum("OpGenericCastToPtr", 122)
OpGenericCastToPtrExplicit = Enum("OpGenericCastToPtrExplicit", 123)
OpBitcast = Enum("OpBitcast", 124)
OpSNegate = Enum("OpSNegate", 126)
OpFNegate = Enum("OpFNegate", 127)
OpIAdd = Enum("OpIAdd", 128)
OpFAdd = Enum("OpFAdd", 129)
OpISub = Enum("OpISub", 130)
OpFSub = Enum("OpFSub", 131)
OpIMul = Enum("OpIMul", 132)
OpFMul = Enum("OpFMul", 133)
OpUDiv = Enum("OpUDiv", 134)
OpSDiv = Enum("OpSDiv", 135)
OpFDiv = Enum("OpFDiv", 136)
OpUMod = Enum("OpUMod", 137)
OpSRem = Enum("OpSRem", 138)
OpSMod = Enum("OpSMod", 139)
OpFRem = Enum("OpFRem", 140)
OpFMod = Enum("OpFMod", 141)
OpVectorTimesScalar = Enum("OpVectorTimesScalar", 142)
OpMatrixTimesScalar = Enum("OpMatrixTimesScalar", 143)
OpVectorTimesMatrix = Enum("OpVectorTimesMatrix", 144)
OpMatrixTimesVector = Enum("OpMatrixTimesVector", 145)
OpMatrixTimesMatrix = Enum("OpMatrixTimesMatrix", 146)
OpOuterProduct = Enum("OpOuterProduct", 147)
OpDot = Enum("OpDot", 148)
OpIAddCarry = Enum("OpIAddCarry", 149)
OpISubBorrow = Enum("OpISubBorrow", 150)
OpUMulExtended = Enum("OpUMulExtended", 151)
OpSMulExtended = Enum("OpSMulExtended", 152)
OpAny = Enum("OpAny", 154)
OpAll = Enum("OpAll", 155)
OpIsNan = Enum("OpIsNan", 156)
OpIsInf = Enum("OpIsInf", 157)
OpIsFinite = Enum("OpIsFinite", 158)
OpIsNormal = Enum("OpIsNormal", 159)
OpSignBitSet = Enum("OpSignBitSet", 160)
OpLessOrGreater = Enum("OpLessOrGreater", 161)
OpOrdered = Enum("OpOrdered", 162)
OpUnordered = Enum("OpUnordered", 163)
OpLogicalEqual = Enum("OpLogicalEqual", 164)
OpLogicalNotEqual = Enum("OpLogicalNotEqual", 165)
OpLogicalOr = Enum("OpLogicalOr", 166)
OpLogicalAnd = Enum("OpLogicalAnd", 167)
OpLogicalNot = Enum("OpLogicalNot", 168)
OpSelect = Enum("OpSelect", 169)
OpIEqual = Enum("OpIEqual", 170)
OpINotEqual = Enum("OpINotEqual", 171)
OpUGreaterThan = Enum("OpUGreaterThan", 172)
OpSGreaterThan = Enum("OpSGreaterThan", 173)
OpUGreaterThanEqual = Enum("OpUGreaterThanEqual", 174)
OpSGreaterThanEqual = Enum("OpSGreaterThanEqual", 175)
OpULessThan = Enum("OpULessThan", 176)
OpSLessThan = Enum("OpSLessThan", 177)
OpULessThanEqual = Enum("OpULessThanEqual", 178)
OpSLessThanEqual = Enum("OpSLessThanEqual", 179)
OpFOrdEqual = Enum("OpFOrdEqual", 180)
OpFUnordEqual = Enum("OpFUnordEqual", 181)
OpFOrdNotEqual = Enum("OpFOrdNotEqual", 182)
OpFUnordNotEqual = Enum("OpFUnordNotEqual", 183)
OpFOrdLessThan = Enum("OpFOrdLessThan", 184)
OpFUnordLessThan = Enum("OpFUnordLessThan", 185)
OpFOrdGreaterThan = Enum("OpFOrdGreaterThan", 186)
OpFUnordGreaterThan = Enum("OpFUnordGreaterThan", 187)
OpFOrdLessThanEqual = Enum("OpFOrdLessThanEqual", 188)
OpFUnordLessThanEqual = Enum("OpFUnordLessThanEqual", 189)
OpFOrdGreaterThanEqual = Enum("OpFOrdGreaterThanEqual", 190)
OpFUnordGreaterThanEqual = Enum("OpFUnordGreaterThanEqual", 191)
OpShiftRightLogical = Enum("OpShiftRightLogical", 194)
OpShiftRightArithmetic = Enum("OpShiftRightArithmetic", 195)
OpShiftLeftLogical = Enum("OpShiftLeftLogical", 196)
OpBitwiseOr = Enum("OpBitwiseOr", 197)
OpBitwiseXor = Enum("OpBitwiseXor", 198)
OpBitwiseAnd = Enum("OpBitwiseAnd", 199)
OpNot = Enum("OpNot", 200)
OpBitFieldInsert = Enum("OpBitFieldInsert", 201)
OpBitFieldSExtract = Enum("OpBitFieldSExtract", 202)
OpBitFieldUExtract = Enum("OpBitFieldUExtract", 203)
OpBitReverse = Enum("OpBitReverse", 204)
OpBitCount = Enum("OpBitCount", 205)
OpDPdx = Enum("OpDPdx", 207)
OpDPdy = Enum("OpDPdy", 208)
OpFwidth = Enum("OpFwidth", 209)
OpDPdxFine = Enum("OpDPdxFine", 210)
OpDPdyFine = Enum("OpDPdyFine", 211)
OpFwidthFine = Enum("OpFwidthFine", 212)
OpDPdxCoarse = Enum("OpDPdxCoarse", 213)
OpDPdyCoarse = Enum("OpDPdyCoarse", 214)
OpFwidthCoarse = Enum("OpFwidthCoarse", 215)
OpEmitVertex = Enum("OpEmitVertex", 218)
OpEndPrimitive = Enum("OpEndPrimitive", 219)
OpEmitStreamVertex = Enum("OpEmitStreamVertex", 220)
OpEndStreamPrimitive = Enum("OpEndStreamPrimitive", 221)
OpControlBarrier = Enum("OpControlBarrier", 224)
OpMemoryBarrier = Enum("OpMemoryBarrier", 225)
OpAtomicLoad = Enum("OpAtomicLoad", 227)
OpAtomicStore = Enum("OpAtomicStore", 228)
OpAtomicExchange = Enum("OpAtomicExchange", 229)
OpAtomicCompareExchange = Enum("OpAtomicCompareExchange", 230)
OpAtomicCompareExchangeWeak = Enum("OpAtomicCompareExchangeWeak", 231)
OpAtomicIIncrement = Enum("OpAtomicIIncrement", 232)
OpAtomicIDecrement = Enum("OpAtomicIDecrement", 233)
OpAtomicIAdd = Enum("OpAtomicIAdd", 234)
OpAtomicISub = Enum("OpAtomicISub", 235)
OpAtomicSMin = Enum("OpAtomicSMin", 236)
OpAtomicUMin = Enum("OpAtomicUMin", 237)
OpAtomicSMax = Enum("OpAtomicSMax", 238)
OpAtomicUMax = Enum("OpAtomicUMax", 239)
OpAtomicAnd = Enum("OpAtomicAnd", 240)
OpAtomicOr = Enum("OpAtomicOr", 241)
OpAtomicXor = Enum("OpAtomicXor", 242)
OpPhi = Enum("OpPhi", 245)
OpLoopMerge = Enum("OpLoopMerge", 246)
OpSelectionMerge = Enum("OpSelectionMerge", 247)
OpLabel = Enum("OpLabel", 248)
OpBranch = Enum("OpBranch", 249)
OpBranchConditional = Enum("OpBranchConditional", 250)
OpSwitch = Enum("OpSwitch", 251)
OpKill = Enum("OpKill", 252)
OpReturn = Enum("OpReturn", 253)
OpReturnValue = Enum("OpReturnValue", 254)
OpUnreachable = Enum("OpUnreachable", 255)
OpLifetimeStart = Enum("OpLifetimeStart", 256)
OpLifetimeStop = Enum("OpLifetimeStop", 257)
OpGroupAsyncCopy = Enum("OpGroupAsyncCopy", 259)
OpGroupWaitEvents = Enum("OpGroupWaitEvents", 260)
OpGroupAll = Enum("OpGroupAll", 261)
OpGroupAny = Enum("OpGroupAny", 262)
OpGroupBroadcast = Enum("OpGroupBroadcast", 263)
OpGroupIAdd = Enum("OpGroupIAdd", 264)
OpGroupFAdd = Enum("OpGroupFAdd", 265)
OpGroupFMin = Enum("OpGroupFMin", 266)
OpGroupUMin = Enum("OpGroupUMin", 267)
OpGroupSMin = Enum("OpGroupSMin", 268)
OpGroupFMax = Enum("OpGroupFMax", 269)
OpGroupUMax = Enum("OpGroupUMax", 270)
OpGroupSMax = Enum("OpGroupSMax", 271)
OpReadPipe = Enum("OpReadPipe", 274)
OpWritePipe = Enum("OpWritePipe", 275)
OpReservedReadPipe = Enum("OpReservedReadPipe", 276)
OpReservedWritePipe = Enum("OpReservedWritePipe", 277)
OpReserveReadPipePackets = Enum("OpReserveReadPipePackets", 278)
OpReserveWritePipePackets = Enum("OpReserveWritePipePackets", 279)
OpCommitReadPipe = Enum("OpCommitReadPipe", 280)
OpCommitWritePipe = Enum("OpCommitWritePipe", 281)
OpIsValidReserveId = Enum("OpIsValidReserveId", 282)
OpGetNumPipePackets = Enum("OpGetNumPipePackets", 283)
OpGetMaxPipePackets = Enum("OpGetMaxPipePackets", 284)
OpGroupReserveReadPipePackets = Enum("OpGroupReserveReadPipePackets", 285)
OpGroupReserveWritePipePackets = Enum("OpGroupReserveWritePipePackets", 286)
OpGroupCommitReadPipe = Enum("OpGroupCommitReadPipe", 287)
OpGroupCommitWritePipe = Enum("OpGroupCommitWritePipe", 288)
OpEnqueueMarker = Enum("OpEnqueueMarker", 291)
OpEnqueueKernel = Enum("OpEnqueueKernel", 292)
OpGetKernelNDrangeSubGroupCount = Enum("OpGetKernelNDrangeSubGroupCount", 293)
OpGetKernelNDrangeMaxSubGroupSize = Enum("OpGetKernelNDrangeMaxSubGroupSize", 294)
OpGetKernelWorkGroupSize = Enum("OpGetKernelWorkGroupSize", 295)
OpGetKernelPreferredWorkGroupSizeMultiple = Enum(
    "OpGetKernelPreferredWorkGroupSizeMultiple", 296
)
OpRetainEvent = Enum("OpRetainEvent", 297)
OpReleaseEvent = Enum("OpReleaseEvent", 298)
OpCreateUserEvent = Enum("OpCreateUserEvent", 299)
OpIsValidEvent = Enum("OpIsValidEvent", 300)
OpSetUserEventStatus = Enum("OpSetUserEventStatus", 301)
OpCaptureEventProfilingInfo = Enum("OpCaptureEventProfilingInfo", 302)
OpGetDefaultQueue = Enum("OpGetDefaultQueue", 303)
OpBuildNDRange = Enum("OpBuildNDRange", 304)
OpImageSparseSampleImplicitLod = Enum("OpImageSparseSampleImplicitLod", 305)
OpImageSparseSampleExplicitLod = Enum("OpImageSparseSampleExplicitLod", 306)
OpImageSparseSampleDrefImplicitLod = Enum("OpImageSparseSampleDrefImplicitLod", 307)
OpImageSparseSampleDrefExplicitLod = Enum("OpImageSparseSampleDrefExplicitLod", 308)
OpImageSparseSampleProjImplicitLod = Enum("OpImageSparseSampleProjImplicitLod", 309)
OpImageSparseSampleProjExplicitLod = Enum("OpImageSparseSampleProjExplicitLod", 310)
OpImageSparseSampleProjDrefImplicitLod = Enum(
    "OpImageSparseSampleProjDrefImplicitLod", 311
)
OpImageSparseSampleProjDrefExplicitLod = Enum(
    "OpImageSparseSampleProjDrefExplicitLod", 312
)
OpImageSparseFetch = Enum("OpImageSparseFetch", 313)
OpImageSparseGather = Enum("OpImageSparseGather", 314)
OpImageSparseDrefGather = Enum("OpImageSparseDrefGather", 315)
OpImageSparseTexelsResident = Enum("OpImageSparseTexelsResident", 316)
OpNoLine = Enum("OpNoLine", 317)
OpAtomicFlagTestAndSet = Enum("OpAtomicFlagTestAndSet", 318)
OpAtomicFlagClear = Enum("OpAtomicFlagClear", 319)
OpImageSparseRead = Enum("OpImageSparseRead", 320)
OpSizeOf = Enum("OpSizeOf", 321)
OpTypePipeStorage = Enum("OpTypePipeStorage", 322)
OpConstantPipeStorage = Enum("OpConstantPipeStorage", 323)
OpCreatePipeFromPipeStorage = Enum("OpCreatePipeFromPipeStorage", 324)
OpGetKernelLocalSizeForSubgroupCount = Enum("OpGetKernelLocalSizeForSubgroupCount", 325)
OpGetKernelMaxNumSubgroups = Enum("OpGetKernelMaxNumSubgroups", 326)
OpTypeNamedBarrier = Enum("OpTypeNamedBarrier", 327)
OpNamedBarrierInitialize = Enum("OpNamedBarrierInitialize", 328)
OpMemoryNamedBarrier = Enum("OpMemoryNamedBarrier", 329)
OpModuleProcessed = Enum("OpModuleProcessed", 330)
OpExecutionModeId = Enum("OpExecutionModeId", 331)
OpDecorateId = Enum("OpDecorateId", 332)
OpGroupNonUniformElect = Enum("OpGroupNonUniformElect", 333)
OpGroupNonUniformAll = Enum("OpGroupNonUniformAll", 334)
OpGroupNonUniformAny = Enum("OpGroupNonUniformAny", 335)
OpGroupNonUniformAllEqual = Enum("OpGroupNonUniformAllEqual", 336)
OpGroupNonUniformBroadcast = Enum("OpGroupNonUniformBroadcast", 337)
OpGroupNonUniformBroadcastFirst = Enum("OpGroupNonUniformBroadcastFirst", 338)
OpGroupNonUniformBallot = Enum("OpGroupNonUniformBallot", 339)
OpGroupNonUniformInverseBallot = Enum("OpGroupNonUniformInverseBallot", 340)
OpGroupNonUniformBallotBitExtract = Enum("OpGroupNonUniformBallotBitExtract", 341)
OpGroupNonUniformBallotBitCount = Enum("OpGroupNonUniformBallotBitCount", 342)
OpGroupNonUniformBallotFindLSB = Enum("OpGroupNonUniformBallotFindLSB", 343)
OpGroupNonUniformBallotFindMSB = Enum("OpGroupNonUniformBallotFindMSB", 344)
OpGroupNonUniformShuffle = Enum("OpGroupNonUniformShuffle", 345)
OpGroupNonUniformShuffleXor = Enum("OpGroupNonUniformShuffleXor", 346)
OpGroupNonUniformShuffleUp = Enum("OpGroupNonUniformShuffleUp", 347)
OpGroupNonUniformShuffleDown = Enum("OpGroupNonUniformShuffleDown", 348)
OpGroupNonUniformIAdd = Enum("OpGroupNonUniformIAdd", 349)
OpGroupNonUniformFAdd = Enum("OpGroupNonUniformFAdd", 350)
OpGroupNonUniformIMul = Enum("OpGroupNonUniformIMul", 351)
OpGroupNonUniformFMul = Enum("OpGroupNonUniformFMul", 352)
OpGroupNonUniformSMin = Enum("OpGroupNonUniformSMin", 353)
OpGroupNonUniformUMin = Enum("OpGroupNonUniformUMin", 354)
OpGroupNonUniformFMin = Enum("OpGroupNonUniformFMin", 355)
OpGroupNonUniformSMax = Enum("OpGroupNonUniformSMax", 356)
OpGroupNonUniformUMax = Enum("OpGroupNonUniformUMax", 357)
OpGroupNonUniformFMax = Enum("OpGroupNonUniformFMax", 358)
OpGroupNonUniformBitwiseAnd = Enum("OpGroupNonUniformBitwiseAnd", 359)
OpGroupNonUniformBitwiseOr = Enum("OpGroupNonUniformBitwiseOr", 360)
OpGroupNonUniformBitwiseXor = Enum("OpGroupNonUniformBitwiseXor", 361)
OpGroupNonUniformLogicalAnd = Enum("OpGroupNonUniformLogicalAnd", 362)
OpGroupNonUniformLogicalOr = Enum("OpGroupNonUniformLogicalOr", 363)
OpGroupNonUniformLogicalXor = Enum("OpGroupNonUniformLogicalXor", 364)
OpGroupNonUniformQuadBroadcast = Enum("OpGroupNonUniformQuadBroadcast", 365)
OpGroupNonUniformQuadSwap = Enum("OpGroupNonUniformQuadSwap", 366)
OpCopyLogical = Enum("OpCopyLogical", 400)
OpPtrEqual = Enum("OpPtrEqual", 401)
OpPtrNotEqual = Enum("OpPtrNotEqual", 402)
OpPtrDiff = Enum("OpPtrDiff", 403)
OpSubgroupBallotKHR = Enum("OpSubgroupBallotKHR", 4421)
OpSubgroupFirstInvocationKHR = Enum("OpSubgroupFirstInvocationKHR", 4422)
OpSubgroupAllKHR = Enum("OpSubgroupAllKHR", 4428)
OpSubgroupAnyKHR = Enum("OpSubgroupAnyKHR", 4429)
OpSubgroupAllEqualKHR = Enum("OpSubgroupAllEqualKHR", 4430)
OpSubgroupReadInvocationKHR = Enum("OpSubgroupReadInvocationKHR", 4432)
OpGroupIAddNonUniformAMD = Enum("OpGroupIAddNonUniformAMD", 5000)
OpGroupFAddNonUniformAMD = Enum("OpGroupFAddNonUniformAMD", 5001)
OpGroupFMinNonUniformAMD = Enum("OpGroupFMinNonUniformAMD", 5002)
OpGroupUMinNonUniformAMD = Enum("OpGroupUMinNonUniformAMD", 5003)
OpGroupSMinNonUniformAMD = Enum("OpGroupSMinNonUniformAMD", 5004)
OpGroupFMaxNonUniformAMD = Enum("OpGroupFMaxNonUniformAMD", 5005)
OpGroupUMaxNonUniformAMD = Enum("OpGroupUMaxNonUniformAMD", 5006)
OpGroupSMaxNonUniformAMD = Enum("OpGroupSMaxNonUniformAMD", 5007)
OpFragmentMaskFetchAMD = Enum("OpFragmentMaskFetchAMD", 5011)
OpFragmentFetchAMD = Enum("OpFragmentFetchAMD", 5012)
OpReadClockKHR = Enum("OpReadClockKHR", 5056)
OpImageSampleFootprintNV = Enum("OpImageSampleFootprintNV", 5283)
OpGroupNonUniformPartitionNV = Enum("OpGroupNonUniformPartitionNV", 5296)
OpWritePackedPrimitiveIndices4x8NV = Enum("OpWritePackedPrimitiveIndices4x8NV", 5299)
OpReportIntersectionNV = Enum("OpReportIntersectionNV", 5334)
OpIgnoreIntersectionNV = Enum("OpIgnoreIntersectionNV", 5335)
OpTerminateRayNV = Enum("OpTerminateRayNV", 5336)
OpTraceNV = Enum("OpTraceNV", 5337)
OpTypeAccelerationStructureNV = Enum("OpTypeAccelerationStructureNV", 5341)
OpExecuteCallableNV = Enum("OpExecuteCallableNV", 5344)
OpTypeCooperativeMatrixNV = Enum("OpTypeCooperativeMatrixNV", 5358)
OpCooperativeMatrixLoadNV = Enum("OpCooperativeMatrixLoadNV", 5359)
OpCooperativeMatrixStoreNV = Enum("OpCooperativeMatrixStoreNV", 5360)
OpCooperativeMatrixMulAddNV = Enum("OpCooperativeMatrixMulAddNV", 5361)
OpCooperativeMatrixLengthNV = Enum("OpCooperativeMatrixLengthNV", 5362)
OpBeginInvocationInterlockEXT = Enum("OpBeginInvocationInterlockEXT", 5364)
OpEndInvocationInterlockEXT = Enum("OpEndInvocationInterlockEXT", 5365)
OpDemoteToHelperInvocationEXT = Enum("OpDemoteToHelperInvocationEXT", 5380)
OpIsHelperInvocationEXT = Enum("OpIsHelperInvocationEXT", 5381)
OpSubgroupShuffleINTEL = Enum("OpSubgroupShuffleINTEL", 5571)
OpSubgroupShuffleDownINTEL = Enum("OpSubgroupShuffleDownINTEL", 5572)
OpSubgroupShuffleUpINTEL = Enum("OpSubgroupShuffleUpINTEL", 5573)
OpSubgroupShuffleXorINTEL = Enum("OpSubgroupShuffleXorINTEL", 5574)
OpSubgroupBlockReadINTEL = Enum("OpSubgroupBlockReadINTEL", 5575)
OpSubgroupBlockWriteINTEL = Enum("OpSubgroupBlockWriteINTEL", 5576)
OpSubgroupImageBlockReadINTEL = Enum("OpSubgroupImageBlockReadINTEL", 5577)
OpSubgroupImageBlockWriteINTEL = Enum("OpSubgroupImageBlockWriteINTEL", 5578)
OpSubgroupImageMediaBlockReadINTEL = Enum("OpSubgroupImageMediaBlockReadINTEL", 5580)
OpSubgroupImageMediaBlockWriteINTEL = Enum("OpSubgroupImageMediaBlockWriteINTEL", 5581)
OpUCountLeadingZerosINTEL = Enum("OpUCountLeadingZerosINTEL", 5585)
OpUCountTrailingZerosINTEL = Enum("OpUCountTrailingZerosINTEL", 5586)
OpAbsISubINTEL = Enum("OpAbsISubINTEL", 5587)
OpAbsUSubINTEL = Enum("OpAbsUSubINTEL", 5588)
OpIAddSatINTEL = Enum("OpIAddSatINTEL", 5589)
OpUAddSatINTEL = Enum("OpUAddSatINTEL", 5590)
OpIAverageINTEL = Enum("OpIAverageINTEL", 5591)
OpUAverageINTEL = Enum("OpUAverageINTEL", 5592)
OpIAverageRoundedINTEL = Enum("OpIAverageRoundedINTEL", 5593)
OpUAverageRoundedINTEL = Enum("OpUAverageRoundedINTEL", 5594)
OpISubSatINTEL = Enum("OpISubSatINTEL", 5595)
OpUSubSatINTEL = Enum("OpUSubSatINTEL", 5596)
OpIMul32x16INTEL = Enum("OpIMul32x16INTEL", 5597)
OpUMul32x16INTEL = Enum("OpUMul32x16INTEL", 5598)
OpDecorateString = Enum("OpDecorateString", 5632)
OpDecorateStringGOOGLE = Enum("OpDecorateStringGOOGLE", 5632)
OpMemberDecorateString = Enum("OpMemberDecorateString", 5633)
OpMemberDecorateStringGOOGLE = Enum("OpMemberDecorateStringGOOGLE", 5633)
OpVmeImageINTEL = Enum("OpVmeImageINTEL", 5699)
OpTypeVmeImageINTEL = Enum("OpTypeVmeImageINTEL", 5700)
OpTypeAvcImePayloadINTEL = Enum("OpTypeAvcImePayloadINTEL", 5701)
OpTypeAvcRefPayloadINTEL = Enum("OpTypeAvcRefPayloadINTEL", 5702)
OpTypeAvcSicPayloadINTEL = Enum("OpTypeAvcSicPayloadINTEL", 5703)
OpTypeAvcMcePayloadINTEL = Enum("OpTypeAvcMcePayloadINTEL", 5704)
OpTypeAvcMceResultINTEL = Enum("OpTypeAvcMceResultINTEL", 5705)
OpTypeAvcImeResultINTEL = Enum("OpTypeAvcImeResultINTEL", 5706)
OpTypeAvcImeResultSingleReferenceStreamoutINTEL = Enum(
    "OpTypeAvcImeResultSingleReferenceStreamoutINTEL", 5707
)
OpTypeAvcImeResultDualReferenceStreamoutINTEL = Enum(
    "OpTypeAvcImeResultDualReferenceStreamoutINTEL", 5708
)
OpTypeAvcImeSingleReferenceStreaminINTEL = Enum(
    "OpTypeAvcImeSingleReferenceStreaminINTEL", 5709
)
OpTypeAvcImeDualReferenceStreaminINTEL = Enum(
    "OpTypeAvcImeDualReferenceStreaminINTEL", 5710
)
OpTypeAvcRefResultINTEL = Enum("OpTypeAvcRefResultINTEL", 5711)
OpTypeAvcSicResultINTEL = Enum("OpTypeAvcSicResultINTEL", 5712)
OpSubgroupAvcMceGetDefaultInterBaseMultiReferencePenaltyINTEL = Enum(
    "OpSubgroupAvcMceGetDefaultInterBaseMultiReferencePenaltyINTEL", 5713
)
OpSubgroupAvcMceSetInterBaseMultiReferencePenaltyINTEL = Enum(
    "OpSubgroupAvcMceSetInterBaseMultiReferencePenaltyINTEL", 5714
)
OpSubgroupAvcMceGetDefaultInterShapePenaltyINTEL = Enum(
    "OpSubgroupAvcMceGetDefaultInterShapePenaltyINTEL", 5715
)
OpSubgroupAvcMceSetInterShapePenaltyINTEL = Enum(
    "OpSubgroupAvcMceSetInterShapePenaltyINTEL", 5716
)
OpSubgroupAvcMceGetDefaultInterDirectionPenaltyINTEL = Enum(
    "OpSubgroupAvcMceGetDefaultInterDirectionPenaltyINTEL", 5717
)
OpSubgroupAvcMceSetInterDirectionPenaltyINTEL = Enum(
    "OpSubgroupAvcMceSetInterDirectionPenaltyINTEL", 5718
)
OpSubgroupAvcMceGetDefaultIntraLumaShapePenaltyINTEL = Enum(
    "OpSubgroupAvcMceGetDefaultIntraLumaShapePenaltyINTEL", 5719
)
OpSubgroupAvcMceGetDefaultInterMotionVectorCostTableINTEL = Enum(
    "OpSubgroupAvcMceGetDefaultInterMotionVectorCostTableINTEL", 5720
)
OpSubgroupAvcMceGetDefaultHighPenaltyCostTableINTEL = Enum(
    "OpSubgroupAvcMceGetDefaultHighPenaltyCostTableINTEL", 5721
)
OpSubgroupAvcMceGetDefaultMediumPenaltyCostTableINTEL = Enum(
    "OpSubgroupAvcMceGetDefaultMediumPenaltyCostTableINTEL", 5722
)
OpSubgroupAvcMceGetDefaultLowPenaltyCostTableINTEL = Enum(
    "OpSubgroupAvcMceGetDefaultLowPenaltyCostTableINTEL", 5723
)
OpSubgroupAvcMceSetMotionVectorCostFunctionINTEL = Enum(
    "OpSubgroupAvcMceSetMotionVectorCostFunctionINTEL", 5724
)
OpSubgroupAvcMceGetDefaultIntraLumaModePenaltyINTEL = Enum(
    "OpSubgroupAvcMceGetDefaultIntraLumaModePenaltyINTEL", 5725
)
OpSubgroupAvcMceGetDefaultNonDcLumaIntraPenaltyINTEL = Enum(
    "OpSubgroupAvcMceGetDefaultNonDcLumaIntraPenaltyINTEL", 5726
)
OpSubgroupAvcMceGetDefaultIntraChromaModeBasePenaltyINTEL = Enum(
    "OpSubgroupAvcMceGetDefaultIntraChromaModeBasePenaltyINTEL", 5727
)
OpSubgroupAvcMceSetAcOnlyHaarINTEL = Enum("OpSubgroupAvcMceSetAcOnlyHaarINTEL", 5728)
OpSubgroupAvcMceSetSourceInterlacedFieldPolarityINTEL = Enum(
    "OpSubgroupAvcMceSetSourceInterlacedFieldPolarityINTEL", 5729
)
OpSubgroupAvcMceSetSingleReferenceInterlacedFieldPolarityINTEL = Enum(
    "OpSubgroupAvcMceSetSingleReferenceInterlacedFieldPolarityINTEL", 5730
)
OpSubgroupAvcMceSetDualReferenceInterlacedFieldPolaritiesINTEL = Enum(
    "OpSubgroupAvcMceSetDualReferenceInterlacedFieldPolaritiesINTEL", 5731
)
OpSubgroupAvcMceConvertToImePayloadINTEL = Enum(
    "OpSubgroupAvcMceConvertToImePayloadINTEL", 5732
)
OpSubgroupAvcMceConvertToImeResultINTEL = Enum(
    "OpSubgroupAvcMceConvertToImeResultINTEL", 5733
)
OpSubgroupAvcMceConvertToRefPayloadINTEL = Enum(
    "OpSubgroupAvcMceConvertToRefPayloadINTEL", 5734
)
OpSubgroupAvcMceConvertToRefResultINTEL = Enum(
    "OpSubgroupAvcMceConvertToRefResultINTEL", 5735
)
OpSubgroupAvcMceConvertToSicPayloadINTEL = Enum(
    "OpSubgroupAvcMceConvertToSicPayloadINTEL", 5736
)
OpSubgroupAvcMceConvertToSicResultINTEL = Enum(
    "OpSubgroupAvcMceConvertToSicResultINTEL", 5737
)
OpSubgroupAvcMceGetMotionVectorsINTEL = Enum(
    "OpSubgroupAvcMceGetMotionVectorsINTEL", 5738
)
OpSubgroupAvcMceGetInterDistortionsINTEL = Enum(
    "OpSubgroupAvcMceGetInterDistortionsINTEL", 5739
)
OpSubgroupAvcMceGetBestInterDistortionsINTEL = Enum(
    "OpSubgroupAvcMceGetBestInterDistortionsINTEL", 5740
)
OpSubgroupAvcMceGetInterMajorShapeINTEL = Enum(
    "OpSubgroupAvcMceGetInterMajorShapeINTEL", 5741
)
OpSubgroupAvcMceGetInterMinorShapeINTEL = Enum(
    "OpSubgroupAvcMceGetInterMinorShapeINTEL", 5742
)
OpSubgroupAvcMceGetInterDirectionsINTEL = Enum(
    "OpSubgroupAvcMceGetInterDirectionsINTEL", 5743
)
OpSubgroupAvcMceGetInterMotionVectorCountINTEL = Enum(
    "OpSubgroupAvcMceGetInterMotionVectorCountINTEL", 5744
)
OpSubgroupAvcMceGetInterReferenceIdsINTEL = Enum(
    "OpSubgroupAvcMceGetInterReferenceIdsINTEL", 5745
)
OpSubgroupAvcMceGetInterReferenceInterlacedFieldPolaritiesINTEL = Enum(
    "OpSubgroupAvcMceGetInterReferenceInterlacedFieldPolaritiesINTEL", 5746
)
OpSubgroupAvcImeInitializeINTEL = Enum("OpSubgroupAvcImeInitializeINTEL", 5747)
OpSubgroupAvcImeSetSingleReferenceINTEL = Enum(
    "OpSubgroupAvcImeSetSingleReferenceINTEL", 5748
)
OpSubgroupAvcImeSetDualReferenceINTEL = Enum(
    "OpSubgroupAvcImeSetDualReferenceINTEL", 5749
)
OpSubgroupAvcImeRefWindowSizeINTEL = Enum("OpSubgroupAvcImeRefWindowSizeINTEL", 5750)
OpSubgroupAvcImeAdjustRefOffsetINTEL = Enum(
    "OpSubgroupAvcImeAdjustRefOffsetINTEL", 5751
)
OpSubgroupAvcImeConvertToMcePayloadINTEL = Enum(
    "OpSubgroupAvcImeConvertToMcePayloadINTEL", 5752
)
OpSubgroupAvcImeSetMaxMotionVectorCountINTEL = Enum(
    "OpSubgroupAvcImeSetMaxMotionVectorCountINTEL", 5753
)
OpSubgroupAvcImeSetUnidirectionalMixDisableINTEL = Enum(
    "OpSubgroupAvcImeSetUnidirectionalMixDisableINTEL", 5754
)
OpSubgroupAvcImeSetEarlySearchTerminationThresholdINTEL = Enum(
    "OpSubgroupAvcImeSetEarlySearchTerminationThresholdINTEL", 5755
)
OpSubgroupAvcImeSetWeightedSadINTEL = Enum("OpSubgroupAvcImeSetWeightedSadINTEL", 5756)
OpSubgroupAvcImeEvaluateWithSingleReferenceINTEL = Enum(
    "OpSubgroupAvcImeEvaluateWithSingleReferenceINTEL", 5757
)
OpSubgroupAvcImeEvaluateWithDualReferenceINTEL = Enum(
    "OpSubgroupAvcImeEvaluateWithDualReferenceINTEL", 5758
)
OpSubgroupAvcImeEvaluateWithSingleReferenceStreaminINTEL = Enum(
    "OpSubgroupAvcImeEvaluateWithSingleReferenceStreaminINTEL", 5759
)
OpSubgroupAvcImeEvaluateWithDualReferenceStreaminINTEL = Enum(
    "OpSubgroupAvcImeEvaluateWithDualReferenceStreaminINTEL", 5760
)
OpSubgroupAvcImeEvaluateWithSingleReferenceStreamoutINTEL = Enum(
    "OpSubgroupAvcImeEvaluateWithSingleReferenceStreamoutINTEL", 5761
)
OpSubgroupAvcImeEvaluateWithDualReferenceStreamoutINTEL = Enum(
    "OpSubgroupAvcImeEvaluateWithDualReferenceStreamoutINTEL", 5762
)
OpSubgroupAvcImeEvaluateWithSingleReferenceStreaminoutINTEL = Enum(
    "OpSubgroupAvcImeEvaluateWithSingleReferenceStreaminoutINTEL", 5763
)
OpSubgroupAvcImeEvaluateWithDualReferenceStreaminoutINTEL = Enum(
    "OpSubgroupAvcImeEvaluateWithDualReferenceStreaminoutINTEL", 5764
)
OpSubgroupAvcImeConvertToMceResultINTEL = Enum(
    "OpSubgroupAvcImeConvertToMceResultINTEL", 5765
)
OpSubgroupAvcImeGetSingleReferenceStreaminINTEL = Enum(
    "OpSubgroupAvcImeGetSingleReferenceStreaminINTEL", 5766
)
OpSubgroupAvcImeGetDualReferenceStreaminINTEL = Enum(
    "OpSubgroupAvcImeGetDualReferenceStreaminINTEL", 5767
)
OpSubgroupAvcImeStripSingleReferenceStreamoutINTEL = Enum(
    "OpSubgroupAvcImeStripSingleReferenceStreamoutINTEL", 5768
)
OpSubgroupAvcImeStripDualReferenceStreamoutINTEL = Enum(
    "OpSubgroupAvcImeStripDualReferenceStreamoutINTEL", 5769
)
OpSubgroupAvcImeGetStreamoutSingleReferenceMajorShapeMotionVectorsINTEL = Enum(
    "OpSubgroupAvcImeGetStreamoutSingleReferenceMajorShapeMotionVectorsINTEL", 5770
)
OpSubgroupAvcImeGetStreamoutSingleReferenceMajorShapeDistortionsINTEL = Enum(
    "OpSubgroupAvcImeGetStreamoutSingleReferenceMajorShapeDistortionsINTEL", 5771
)
OpSubgroupAvcImeGetStreamoutSingleReferenceMajorShapeReferenceIdsINTEL = Enum(
    "OpSubgroupAvcImeGetStreamoutSingleReferenceMajorShapeReferenceIdsINTEL", 5772
)
OpSubgroupAvcImeGetStreamoutDualReferenceMajorShapeMotionVectorsINTEL = Enum(
    "OpSubgroupAvcImeGetStreamoutDualReferenceMajorShapeMotionVectorsINTEL", 5773
)
OpSubgroupAvcImeGetStreamoutDualReferenceMajorShapeDistortionsINTEL = Enum(
    "OpSubgroupAvcImeGetStreamoutDualReferenceMajorShapeDistortionsINTEL", 5774
)
OpSubgroupAvcImeGetStreamoutDualReferenceMajorShapeReferenceIdsINTEL = Enum(
    "OpSubgroupAvcImeGetStreamoutDualReferenceMajorShapeReferenceIdsINTEL", 5775
)
OpSubgroupAvcImeGetBorderReachedINTEL = Enum(
    "OpSubgroupAvcImeGetBorderReachedINTEL", 5776
)
OpSubgroupAvcImeGetTruncatedSearchIndicationINTEL = Enum(
    "OpSubgroupAvcImeGetTruncatedSearchIndicationINTEL", 5777
)
OpSubgroupAvcImeGetUnidirectionalEarlySearchTerminationINTEL = Enum(
    "OpSubgroupAvcImeGetUnidirectionalEarlySearchTerminationINTEL", 5778
)
OpSubgroupAvcImeGetWeightingPatternMinimumMotionVectorINTEL = Enum(
    "OpSubgroupAvcImeGetWeightingPatternMinimumMotionVectorINTEL", 5779
)
OpSubgroupAvcImeGetWeightingPatternMinimumDistortionINTEL = Enum(
    "OpSubgroupAvcImeGetWeightingPatternMinimumDistortionINTEL", 5780
)
OpSubgroupAvcFmeInitializeINTEL = Enum("OpSubgroupAvcFmeInitializeINTEL", 5781)
OpSubgroupAvcBmeInitializeINTEL = Enum("OpSubgroupAvcBmeInitializeINTEL", 5782)
OpSubgroupAvcRefConvertToMcePayloadINTEL = Enum(
    "OpSubgroupAvcRefConvertToMcePayloadINTEL", 5783
)
OpSubgroupAvcRefSetBidirectionalMixDisableINTEL = Enum(
    "OpSubgroupAvcRefSetBidirectionalMixDisableINTEL", 5784
)
OpSubgroupAvcRefSetBilinearFilterEnableINTEL = Enum(
    "OpSubgroupAvcRefSetBilinearFilterEnableINTEL", 5785
)
OpSubgroupAvcRefEvaluateWithSingleReferenceINTEL = Enum(
    "OpSubgroupAvcRefEvaluateWithSingleReferenceINTEL", 5786
)
OpSubgroupAvcRefEvaluateWithDualReferenceINTEL = Enum(
    "OpSubgroupAvcRefEvaluateWithDualReferenceINTEL", 5787
)
OpSubgroupAvcRefEvaluateWithMultiReferenceINTEL = Enum(
    "OpSubgroupAvcRefEvaluateWithMultiReferenceINTEL", 5788
)
OpSubgroupAvcRefEvaluateWithMultiReferenceInterlacedINTEL = Enum(
    "OpSubgroupAvcRefEvaluateWithMultiReferenceInterlacedINTEL", 5789
)
OpSubgroupAvcRefConvertToMceResultINTEL = Enum(
    "OpSubgroupAvcRefConvertToMceResultINTEL", 5790
)
OpSubgroupAvcSicInitializeINTEL = Enum("OpSubgroupAvcSicInitializeINTEL", 5791)
OpSubgroupAvcSicConfigureSkcINTEL = Enum("OpSubgroupAvcSicConfigureSkcINTEL", 5792)
OpSubgroupAvcSicConfigureIpeLumaINTEL = Enum(
    "OpSubgroupAvcSicConfigureIpeLumaINTEL", 5793
)
OpSubgroupAvcSicConfigureIpeLumaChromaINTEL = Enum(
    "OpSubgroupAvcSicConfigureIpeLumaChromaINTEL", 5794
)
OpSubgroupAvcSicGetMotionVectorMaskINTEL = Enum(
    "OpSubgroupAvcSicGetMotionVectorMaskINTEL", 5795
)
OpSubgroupAvcSicConvertToMcePayloadINTEL = Enum(
    "OpSubgroupAvcSicConvertToMcePayloadINTEL", 5796
)
OpSubgroupAvcSicSetIntraLumaShapePenaltyINTEL = Enum(
    "OpSubgroupAvcSicSetIntraLumaShapePenaltyINTEL", 5797
)
OpSubgroupAvcSicSetIntraLumaModeCostFunctionINTEL = Enum(
    "OpSubgroupAvcSicSetIntraLumaModeCostFunctionINTEL", 5798
)
OpSubgroupAvcSicSetIntraChromaModeCostFunctionINTEL = Enum(
    "OpSubgroupAvcSicSetIntraChromaModeCostFunctionINTEL", 5799
)
OpSubgroupAvcSicSetBilinearFilterEnableINTEL = Enum(
    "OpSubgroupAvcSicSetBilinearFilterEnableINTEL", 5800
)
OpSubgroupAvcSicSetSkcForwardTransformEnableINTEL = Enum(
    "OpSubgroupAvcSicSetSkcForwardTransformEnableINTEL", 5801
)
OpSubgroupAvcSicSetBlockBasedRawSkipSadINTEL = Enum(
    "OpSubgroupAvcSicSetBlockBasedRawSkipSadINTEL", 5802
)
OpSubgroupAvcSicEvaluateIpeINTEL = Enum("OpSubgroupAvcSicEvaluateIpeINTEL", 5803)
OpSubgroupAvcSicEvaluateWithSingleReferenceINTEL = Enum(
    "OpSubgroupAvcSicEvaluateWithSingleReferenceINTEL", 5804
)
OpSubgroupAvcSicEvaluateWithDualReferenceINTEL = Enum(
    "OpSubgroupAvcSicEvaluateWithDualReferenceINTEL", 5805
)
OpSubgroupAvcSicEvaluateWithMultiReferenceINTEL = Enum(
    "OpSubgroupAvcSicEvaluateWithMultiReferenceINTEL", 5806
)
OpSubgroupAvcSicEvaluateWithMultiReferenceInterlacedINTEL = Enum(
    "OpSubgroupAvcSicEvaluateWithMultiReferenceInterlacedINTEL", 5807
)
OpSubgroupAvcSicConvertToMceResultINTEL = Enum(
    "OpSubgroupAvcSicConvertToMceResultINTEL", 5808
)
OpSubgroupAvcSicGetIpeLumaShapeINTEL = Enum(
    "OpSubgroupAvcSicGetIpeLumaShapeINTEL", 5809
)
OpSubgroupAvcSicGetBestIpeLumaDistortionINTEL = Enum(
    "OpSubgroupAvcSicGetBestIpeLumaDistortionINTEL", 5810
)
OpSubgroupAvcSicGetBestIpeChromaDistortionINTEL = Enum(
    "OpSubgroupAvcSicGetBestIpeChromaDistortionINTEL", 5811
)
OpSubgroupAvcSicGetPackedIpeLumaModesINTEL = Enum(
    "OpSubgroupAvcSicGetPackedIpeLumaModesINTEL", 5812
)
OpSubgroupAvcSicGetIpeChromaModeINTEL = Enum(
    "OpSubgroupAvcSicGetIpeChromaModeINTEL", 5813
)
OpSubgroupAvcSicGetPackedSkcLumaCountThresholdINTEL = Enum(
    "OpSubgroupAvcSicGetPackedSkcLumaCountThresholdINTEL", 5814
)
OpSubgroupAvcSicGetPackedSkcLumaSumThresholdINTEL = Enum(
    "OpSubgroupAvcSicGetPackedSkcLumaSumThresholdINTEL", 5815
)
OpSubgroupAvcSicGetInterRawSadsINTEL = Enum(
    "OpSubgroupAvcSicGetInterRawSadsINTEL", 5816
)
