"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DrdsInstance = exports.DrdsInstanceProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const drds_generated_1 = require("./drds.generated");
Object.defineProperty(exports, "DrdsInstanceProperty", { enumerable: true, get: function () { return drds_generated_1.RosDrdsInstance; } });
/**
 * A ROS resource type:  `ALIYUN::DRDS::DrdsInstance`
 */
class DrdsInstance extends ros.Resource {
    /**
     * Create a new `ALIYUN::DRDS::DrdsInstance`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosDrdsInstance = new drds_generated_1.RosDrdsInstance(this, id, {
            description: props.description,
            zoneId: props.zoneId,
            resourceGroupId: props.resourceGroupId,
            pricingCycle: props.pricingCycle,
            instanceSeries: props.instanceSeries,
            specification: props.specification,
            duration: props.duration,
            payType: props.payType,
            vswitchId: props.vswitchId,
            type: props.type,
            mySqlVersion: props.mySqlVersion === undefined || props.mySqlVersion === null ? '5' : props.mySqlVersion,
            vpcId: props.vpcId,
            isAutoRenew: props.isAutoRenew,
            tags: props.tags,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDrdsInstance;
        this.attrDrdsInstanceId = rosDrdsInstance.attrDrdsInstanceId;
        this.attrInternetEndpoint = rosDrdsInstance.attrInternetEndpoint;
        this.attrIntranetEndpoint = rosDrdsInstance.attrIntranetEndpoint;
        this.attrOrderId = rosDrdsInstance.attrOrderId;
    }
}
exports.DrdsInstance = DrdsInstance;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZHJkc2luc3RhbmNlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiZHJkc2luc3RhbmNlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLDhDQUE4QztBQUM5QyxxREFBbUQ7QUFFdkIscUdBRm5CLGdDQUFlLE9BRXdCO0FBOEVoRDs7R0FFRztBQUNILE1BQWEsWUFBYSxTQUFRLEdBQUcsQ0FBQyxRQUFRO0lBMkIxQzs7Ozs7O09BTUc7SUFDSCxZQUFZLEtBQW9CLEVBQUUsRUFBVSxFQUFFLEtBQXdCLEVBQUUsbUNBQTJDLElBQUk7UUFDbkgsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUVqQixNQUFNLGVBQWUsR0FBRyxJQUFJLGdDQUFlLENBQUMsSUFBSSxFQUFFLEVBQUUsRUFBRztZQUNuRCxXQUFXLEVBQUUsS0FBSyxDQUFDLFdBQVc7WUFDOUIsTUFBTSxFQUFFLEtBQUssQ0FBQyxNQUFNO1lBQ3BCLGVBQWUsRUFBRSxLQUFLLENBQUMsZUFBZTtZQUN0QyxZQUFZLEVBQUUsS0FBSyxDQUFDLFlBQVk7WUFDaEMsY0FBYyxFQUFFLEtBQUssQ0FBQyxjQUFjO1lBQ3BDLGFBQWEsRUFBRSxLQUFLLENBQUMsYUFBYTtZQUNsQyxRQUFRLEVBQUUsS0FBSyxDQUFDLFFBQVE7WUFDeEIsT0FBTyxFQUFFLEtBQUssQ0FBQyxPQUFPO1lBQ3RCLFNBQVMsRUFBRSxLQUFLLENBQUMsU0FBUztZQUMxQixJQUFJLEVBQUUsS0FBSyxDQUFDLElBQUk7WUFDaEIsWUFBWSxFQUFFLEtBQUssQ0FBQyxZQUFZLEtBQUssU0FBUyxJQUFJLEtBQUssQ0FBQyxZQUFZLEtBQUssSUFBSSxDQUFDLENBQUMsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxZQUFZO1lBQ3hHLEtBQUssRUFBRSxLQUFLLENBQUMsS0FBSztZQUNsQixXQUFXLEVBQUUsS0FBSyxDQUFDLFdBQVc7WUFDOUIsSUFBSSxFQUFFLEtBQUssQ0FBQyxJQUFJO1NBQ25CLEVBQUUsZ0NBQWdDLElBQUksSUFBSSxDQUFDLEtBQUssQ0FBQyxnQ0FBZ0MsQ0FBQyxDQUFDO1FBQ3BGLElBQUksQ0FBQyxRQUFRLEdBQUcsZUFBZSxDQUFDO1FBQ2hDLElBQUksQ0FBQyxrQkFBa0IsR0FBRyxlQUFlLENBQUMsa0JBQWtCLENBQUM7UUFDN0QsSUFBSSxDQUFDLG9CQUFvQixHQUFHLGVBQWUsQ0FBQyxvQkFBb0IsQ0FBQztRQUNqRSxJQUFJLENBQUMsb0JBQW9CLEdBQUcsZUFBZSxDQUFDLG9CQUFvQixDQUFDO1FBQ2pFLElBQUksQ0FBQyxXQUFXLEdBQUcsZUFBZSxDQUFDLFdBQVcsQ0FBQztJQUNuRCxDQUFDO0NBQ0o7QUEzREQsb0NBMkRDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgcm9zIGZyb20gJ0BhbGljbG91ZC9yb3MtY2RrLWNvcmUnO1xuaW1wb3J0IHsgUm9zRHJkc0luc3RhbmNlIH0gZnJvbSAnLi9kcmRzLmdlbmVyYXRlZCc7XG4vLyBHZW5lcmF0ZWQgZnJvbSB0aGUgQWxpQ2xvdWQgUk9TIFJlc291cmNlIFNwZWNpZmljYXRpb25cbmV4cG9ydCB7IFJvc0RyZHNJbnN0YW5jZSBhcyBEcmRzSW5zdGFuY2VQcm9wZXJ0eSB9O1xuXG4vKipcbiAqIFByb3BlcnRpZXMgZm9yIGRlZmluaW5nIGEgYEFMSVlVTjo6RFJEUzo6RHJkc0luc3RhbmNlYFxuICovXG5leHBvcnQgaW50ZXJmYWNlIERyZHNJbnN0YW5jZVByb3BzIHtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IGRlc2NyaXB0aW9uOiBEZXNjcmlwdGlvbiBvZiB0aGUgRFJEUyBpbnN0YW5jZSwgMi0xMjggY2hhcmFjdGVyc1xuICAgICAqL1xuICAgIHJlYWRvbmx5IGRlc2NyaXB0aW9uOiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBpbnN0YW5jZVNlcmllczogZHJkcy5zbjEuNGM4ZyBTdGFydGVyIEVkaXRpb247IGRyZHMuc24xLjhjMTZnIFN0YW5kYXJkIEVkaXRpb247IGRyZHMuc24xLjE2YzMyZyBCdXNpbmVzcyBFZGl0aW9uOyBkcmRzLnNuMS4zMmM2NGcgVWx0aW1hdGUgRWRpdGlvblxuICAgICAqL1xuICAgIHJlYWRvbmx5IGluc3RhbmNlU2VyaWVzOiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBwYXlUeXBlOiBGb3IgdGhlIHR5cGUgb2YgcGF5bWVudCwgc2VlIFwiUGF5bWVudCBUeXBlIFBhcmFtZXRlciBUYWJsZVwiXG4gICAgICovXG4gICAgcmVhZG9ubHkgcGF5VHlwZTogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgc3BlY2lmaWNhdGlvbjogVGhlIGV4YW1wbGUgc3BlY2lmaWNhdGlvbiwgZm9yIGV4YW1wbGUsIGRyZHMuc24xLjRjOGcuOEMxNkcsIGNvbnNpc3RzIG9mIHRoZSBEUkRTIGluc3RhbmNlIHNlcmllcyAoZHJkcy5zbjEuNGM4ZykgcGx1cyBhIHNwZWNpZmljIGV4YW1wbGUgc3BlY2lmaWNhdGlvbiAoOEMxNkcpLiBGb3IgdGhlIERSRFMgaW5zdGFuY2Ugc3BlY2lmaWNhdGlvbiB2YWx1ZSByYW5nZSwgc2VlOiBEaXN0cmlidXRlZCBSZWxhdGlvbmFsIERhdGFiYXNlIFNlcnZpY2UgU3BlY2lmaWNhdGlvbnMgYW5kIFByaWNpbmdcbiAgICAgKi9cbiAgICByZWFkb25seSBzcGVjaWZpY2F0aW9uOiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSB0eXBlOiBJbnN0YW5jZSB0eXBlLCBpbnN0YW5jZSB0eXBlIDAgLSBzaGFyZWQgaW5zdGFuY2UgMSAtIGV4Y2x1c2l2ZSBpbnN0YW5jZSwgaW4gYWRkaXRpb24sIHRoaXMgcGFyYW1ldGVyIGNhbiBhbHNvIHBhc3MgUFJJVkFURSBhbmQgUFVCTElDIHRvIHJlcHJlc2VudCBleGNsdXNpdmUgaW5zdGFuY2UgYW5kIHNoYXJlZCBpbnN0YW5jZSByZXNwZWN0aXZlbHlcbiAgICAgKi9cbiAgICByZWFkb25seSB0eXBlOiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSB6b25lSWQ6IEF2YWlsYWJpbGl0eSB6b25lLCBhbiBhdmFpbGFibGUgem9uZSBiZWxvbmdzIHRvIGEgY2VydGFpbiB6b25lLCBzdWNoIGFzIEhhbmd6aG91IEF2YWlsYWJpbGl0eSBab25lIEEgKGNuLWhhbmd6aG91LWEpIGJlbG9uZ3MgdG8gdGhlIHJlZ2lvbiBIYW5nemhvdSAoY24taGFuZ3pob3UpXG4gICAgICovXG4gICAgcmVhZG9ubHkgem9uZUlkOiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBkdXJhdGlvbjogVGhlIG51bWJlciBvZiBjeWNsZXMgb3JkZXJlZC4gV2hlbiBQcmljaW5nQ3ljbGU9eWVhciwgdGhlIHZhbHVlIGlzIDEtMzsgd2hlbiBQcmljaW5nQ3ljbGU9bW9udGgsIHRoZSB2YWx1ZSBpcyAxLTkuIFRoZSBwYXJhbWV0ZXIgdGFrZXMgZWZmZWN0IHdoZW4gdGhlIHBheW1lbnQgdHlwZSBpcyBkcmRzUHJlLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGR1cmF0aW9uPzogbnVtYmVyIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgaXNBdXRvUmVuZXc6IFdoZXRoZXIgdG8gcmVuZXcgdGhlIGZlZSBhdXRvbWF0aWNhbGx5LCBpZiBpdCBpcyBwdXJjaGFzZWQgb24gYSBtb250aGx5IGJhc2lzLCBpdCB3aWxsIGF1dG9tYXRpY2FsbHkgcmVuZXcgZm9yIG9uZSBtb250aCwgYW5kIGlmIGl0IGlzIHB1cmNoYXNlZCBvbiBhbiBhbm51YWwgYmFzaXMsIGl0IHdpbGwgYXV0b21hdGljYWxseSByZW5ldyBmb3Igb25lIHllYXIuIFRoZSBwYXJhbWV0ZXIgdGFrZXMgZWZmZWN0IHdoZW4gdGhlIHBheW1lbnQgdHlwZSBpcyBkcmRzUHJlLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGlzQXV0b1JlbmV3PzogYm9vbGVhbiB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IG15U3FsVmVyc2lvbjogVGhlIE15U1FMIHByb3RvY29sIHZlcnNpb24gc3VwcG9ydGVkIGJ5IERSRFMuIFZhbGlkIHZhbHVlczogNSBhbmQgOC4gRGVmYXVsdCB2YWx1ZTogNS4gVGhpcyBwYXJhbWV0ZXIgaXMgdmFsaWQgb25seSB3aGVuIHRoZSBwcmltYXJ5IGluc3RhbmNlIGlzIGNyZWF0ZWQuIFRoZSByZWFkLW9ubHkgaW5zdGFuY2UgaXMgdGhlIHNhbWUgYXMgdGhlIHByaW1hcnkgaW5zdGFuY2UgYnkgZGVmYXVsdC5cbiAgICAgKi9cbiAgICByZWFkb25seSBteVNxbFZlcnNpb24/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBwcmljaW5nQ3ljbGU6IFRoZSB1bml0IG9mIHRoZSBvcmRlciBwZXJpb2QsIHllYXI6IHllYXIsIG1vbnRoOiBtb250aC4gVGhlIHBhcmFtZXRlciB0YWtlcyBlZmZlY3Qgd2hlbiB0aGUgcGF5bWVudCB0eXBlIGlzIGRyZHNQcmUuXG4gICAgICovXG4gICAgcmVhZG9ubHkgcHJpY2luZ0N5Y2xlPzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgcmVzb3VyY2VHcm91cElkOiBSZXNvdXJjZSBncm91cCBpZC5cbiAgICAgKi9cbiAgICByZWFkb25seSByZXNvdXJjZUdyb3VwSWQ/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSB0YWdzOiBUYWdzIHRvIGF0dGFjaCB0byBpbnN0YW5jZS4gTWF4IHN1cHBvcnQgMjAgdGFncyB0byBhZGQgZHVyaW5nIGNyZWF0ZSBpbnN0YW5jZS4gRWFjaCB0YWcgd2l0aCB0d28gcHJvcGVydGllcyBLZXkgYW5kIFZhbHVlLCBhbmQgS2V5IGlzIHJlcXVpcmVkLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IHRhZ3M/OiBSb3NEcmRzSW5zdGFuY2UuVGFnc1Byb3BlcnR5W107XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSB2cGNJZDogVmlydHVhbCBwcml2YXRlIG5ldHdvcmsgSUQsIG11c3QgYmUgc3BlY2lmaWVkIHdoZW4gY3JlYXRpbmcgYSBEUkRTIGZvciBWUEMgbmV0d29yayB0eXBlXG4gICAgICovXG4gICAgcmVhZG9ubHkgdnBjSWQ/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSB2c3dpdGNoSWQ6IFZpcnR1YWwgc3dpdGNoIElELCBtdXN0IGJlIHNwZWNpZmllZCB3aGVuIGNyZWF0aW5nIGEgRFJEUyBmb3IgVlBDIG5ldHdvcmsgdHlwZVxuICAgICAqL1xuICAgIHJlYWRvbmx5IHZzd2l0Y2hJZD86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcbn1cblxuLyoqXG4gKiBBIFJPUyByZXNvdXJjZSB0eXBlOiAgYEFMSVlVTjo6RFJEUzo6RHJkc0luc3RhbmNlYFxuICovXG5leHBvcnQgY2xhc3MgRHJkc0luc3RhbmNlIGV4dGVuZHMgcm9zLlJlc291cmNlIHtcblxuICAgIC8qKlxuICAgICAqIEEgZmFjdG9yeSBtZXRob2QgdGhhdCBjcmVhdGVzIGEgbmV3IGluc3RhbmNlIG9mIHRoaXMgY2xhc3MgZnJvbSBhbiBvYmplY3RcbiAgICAgKiBjb250YWluaW5nIHRoZSBwcm9wZXJ0aWVzIG9mIHRoaXMgUk9TIHJlc291cmNlLCB3aGljaCB3aWxsIGJlIGFzc2lnbmVkIHRvIFJPUyByZXNvdXJjZS5cbiAgICAgKi9cblxuICAgIC8qKlxuICAgICAqIEF0dHJpYnV0ZSBEcmRzSW5zdGFuY2VJZDogaW5zdGFuY2UgaWRcbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgYXR0ckRyZHNJbnN0YW5jZUlkOiByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBBdHRyaWJ1dGUgSW50ZXJuZXRFbmRwb2ludDogUHVibGljIGVuZHBvaW50XG4gICAgICovXG4gICAgcHVibGljIHJlYWRvbmx5IGF0dHJJbnRlcm5ldEVuZHBvaW50OiByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBBdHRyaWJ1dGUgSW50cmFuZXRFbmRwb2ludDogVlBDIGVuZHBvaW50XG4gICAgICovXG4gICAgcHVibGljIHJlYWRvbmx5IGF0dHJJbnRyYW5ldEVuZHBvaW50OiByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBBdHRyaWJ1dGUgT3JkZXJJZDogb3JkZXIgbnVtYmVyXG4gICAgICovXG4gICAgcHVibGljIHJlYWRvbmx5IGF0dHJPcmRlcklkOiByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBDcmVhdGUgYSBuZXcgYEFMSVlVTjo6RFJEUzo6RHJkc0luc3RhbmNlYC5cbiAgICAgKlxuICAgICAqIFBhcmFtIHNjb3BlIC0gc2NvcGUgaW4gd2hpY2ggdGhpcyByZXNvdXJjZSBpcyBkZWZpbmVkXG4gICAgICogUGFyYW0gaWQgICAgLSBzY29wZWQgaWQgb2YgdGhlIHJlc291cmNlXG4gICAgICogUGFyYW0gcHJvcHMgLSByZXNvdXJjZSBwcm9wZXJ0aWVzXG4gICAgICovXG4gICAgY29uc3RydWN0b3Ioc2NvcGU6IHJvcy5Db25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBEcmRzSW5zdGFuY2VQcm9wcywgZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQ6Ym9vbGVhbiA9IHRydWUpIHtcbiAgICAgICAgc3VwZXIoc2NvcGUsIGlkKTtcblxuICAgICAgICBjb25zdCByb3NEcmRzSW5zdGFuY2UgPSBuZXcgUm9zRHJkc0luc3RhbmNlKHRoaXMsIGlkLCAge1xuICAgICAgICAgICAgZGVzY3JpcHRpb246IHByb3BzLmRlc2NyaXB0aW9uLFxuICAgICAgICAgICAgem9uZUlkOiBwcm9wcy56b25lSWQsXG4gICAgICAgICAgICByZXNvdXJjZUdyb3VwSWQ6IHByb3BzLnJlc291cmNlR3JvdXBJZCxcbiAgICAgICAgICAgIHByaWNpbmdDeWNsZTogcHJvcHMucHJpY2luZ0N5Y2xlLFxuICAgICAgICAgICAgaW5zdGFuY2VTZXJpZXM6IHByb3BzLmluc3RhbmNlU2VyaWVzLFxuICAgICAgICAgICAgc3BlY2lmaWNhdGlvbjogcHJvcHMuc3BlY2lmaWNhdGlvbixcbiAgICAgICAgICAgIGR1cmF0aW9uOiBwcm9wcy5kdXJhdGlvbixcbiAgICAgICAgICAgIHBheVR5cGU6IHByb3BzLnBheVR5cGUsXG4gICAgICAgICAgICB2c3dpdGNoSWQ6IHByb3BzLnZzd2l0Y2hJZCxcbiAgICAgICAgICAgIHR5cGU6IHByb3BzLnR5cGUsXG4gICAgICAgICAgICBteVNxbFZlcnNpb246IHByb3BzLm15U3FsVmVyc2lvbiA9PT0gdW5kZWZpbmVkIHx8IHByb3BzLm15U3FsVmVyc2lvbiA9PT0gbnVsbCA/ICc1JyA6IHByb3BzLm15U3FsVmVyc2lvbixcbiAgICAgICAgICAgIHZwY0lkOiBwcm9wcy52cGNJZCxcbiAgICAgICAgICAgIGlzQXV0b1JlbmV3OiBwcm9wcy5pc0F1dG9SZW5ldyxcbiAgICAgICAgICAgIHRhZ3M6IHByb3BzLnRhZ3MsXG4gICAgICAgIH0sIGVuYWJsZVJlc291cmNlUHJvcGVydHlDb25zdHJhaW50ICYmIHRoaXMuc3RhY2suZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQpO1xuICAgICAgICB0aGlzLnJlc291cmNlID0gcm9zRHJkc0luc3RhbmNlO1xuICAgICAgICB0aGlzLmF0dHJEcmRzSW5zdGFuY2VJZCA9IHJvc0RyZHNJbnN0YW5jZS5hdHRyRHJkc0luc3RhbmNlSWQ7XG4gICAgICAgIHRoaXMuYXR0ckludGVybmV0RW5kcG9pbnQgPSByb3NEcmRzSW5zdGFuY2UuYXR0ckludGVybmV0RW5kcG9pbnQ7XG4gICAgICAgIHRoaXMuYXR0ckludHJhbmV0RW5kcG9pbnQgPSByb3NEcmRzSW5zdGFuY2UuYXR0ckludHJhbmV0RW5kcG9pbnQ7XG4gICAgICAgIHRoaXMuYXR0ck9yZGVySWQgPSByb3NEcmRzSW5zdGFuY2UuYXR0ck9yZGVySWQ7XG4gICAgfVxufVxuIl19