# AUTOGENERATED! DO NOT EDIT! File to edit: 02_pandas.ipynb (unless otherwise specified).

__all__ = ['ends', 'group_by_summary']

# Cell
import pandas as pd
import pandas_flavor
import typing as T

# Cell
@pandas_flavor.register_dataframe_method
@pandas_flavor.register_series_method
def ends(self, n:int=3)-> pd.DataFrame:
    return pd.concat([self.head(n), self.tail(n)], axis=0).drop_duplicates()

# Cell
@pandas_flavor.register_dataframe_method
def group_by_summary(self, by:T.Union[T.AnyStr, T.List], filter_cols:T.Union[None, T.List[str]]=None)-> pd.DataFrame:
    if not filter_cols:
        filter_cols = self.columns[~self.columns.isin([by] if isinstance(by, (list, str)) else by)]
    return self.groupby(by)[filter_cols].agg(['mean','median','sem','std'])