/*!
 * Copyright (c) 2012 - 2021, Anaconda, Inc., and Bokeh Contributors
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * Neither the name of Anaconda nor the names of any contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */
(function(root, factory) {
  factory(root["Bokeh"], undefined);
})(this, function(Bokeh, version) {
  var define;
  return (function(modules, entry, aliases, externals) {
    const bokeh = typeof Bokeh !== "undefined" && (version != null ? Bokeh[version] : Bokeh);
    if (bokeh != null) {
      return bokeh.register_plugin(modules, entry, aliases);
    } else {
      throw new Error("Cannot find Bokeh " + version + ". You have to load it prior to loading plugins.");
    }
  })
({
"0896b22af1": function _(s,t,e,i,o){i();const n=s("tslib").__importStar(s("3e9dd62cf5"));e.HighChartsExtensions=n;s("@bokehjs/base").register_models(n)},
"3e9dd62cf5": function _(h,i,t,a,c){a(),c("HighChart",h("7c98d48d47").HighChart)},
"7c98d48d47": function _(t,e,n,i,o){i();const s=t("@bokehjs/models/layouts/html_box");class r extends s.HTMLBoxView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.config.change,this.render),this.connect(this.model.properties.config_update.change,this._handle_config_update_change)}render(){super.render(),this.chart&&this.chart.destroy();const t=window;if(t.Highcharts){const e=this._clean_config(this.model.config);this.chart=t.Highcharts.chart(this.el,e)}else console.error("HighCharts .js is not loaded. Could not create chart")}after_layout(){super.after_layout(),this._resize()}_resize(){this.chart&&this.chart.reflow()}_handle_config_update_change(){const t=this._clean_config(this.model.config_update);this.chart.update(t)}_clean_config(t){return a(t,this.model),t}}n.HighChartView=r,r.__name__="HighChartView";class h extends s.HTMLBox{constructor(t){super(t)}static init_HighChart(){this.prototype.default_view=r,this.define((({Any:t})=>({config:[t],config_update:[t],event:[t]}))),this.override({height:400,width:600})}}function a(t,e){if(null===t)return t;for(var n=0;n<Object.keys(t).length;n++){const i=Object.keys(t)[n],o=t[i];if("object"==typeof o)a(o,e);else if("string"==typeof o)if("@"===o[0].charAt(0)){const n=o.slice(1,o.length);t[i]=t=>c(t,e,n)}else if(o.startsWith("function")&&o.indexOf("{")>-1&&o.lastIndexOf("}")>-1){const e=o.indexOf("{"),n=o.lastIndexOf("}"),s=o.slice(e+1,n);try{t[i]=new Function(s)}catch(e){t[i]=null,console.log("Could not set key '"+i+"' to function '"+s+"'. ",e)}}}}function c(t,e,n=null){const i=function(t,e=null){const n={};null!==e&&""!==e&&(n.channel=e);return n.type=t.type,l(t,n),n}(t,n);i.uuid="xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g,(function(t){var e=16*Math.random()|0;return("x"==t?e:3&e|8).toString(16)})),e.event=i}function l(t,e){t.hasOwnProperty("index")&&void 0!==t.index&&(e.index=t.index),t.hasOwnProperty("name")&&void 0!==t.name&&(e.name=t.name),t.hasOwnProperty("x")&&void 0!==t.x&&(e.x=t.x),t.hasOwnProperty("y")&&void 0!==t.y&&(e.y=t.y),t.hasOwnProperty("target")&&(e.target={},l(t.target,e.target)),t.hasOwnProperty("series")&&(e.series={},l(t.series,e.series)),t.hasOwnProperty("point")&&(e.point={},l(t.point,e.point))}n.HighChart=h,h.__name__="HighChart",h.__module__="panel_highcharts.models.highchart",h.init_HighChart()},
}, "0896b22af1", {"index":"0896b22af1","models/index":"3e9dd62cf5","models/highchart":"7c98d48d47"}, {});});
