# -*- coding: utf-8 -*-

"""
swaggerpetstore

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from enum import Enum
from swaggerpetstore.api_helper import APIHelper
from swaggerpetstore.http.requests_client import RequestsClient
from swaggerpetstore.models.o_auth_token import OAuthToken


class Environment(Enum):
    """An enum for SDK environments"""
    PRODUCTION = 0


class Server(Enum):
    """An enum for API servers"""
    SERVER1 = 0
    SERVER2 = 1
    AUTH_SERVER = 2


class Configuration(object):
    """A class used for configuring the SDK by a user.
    """

    @property
    def http_client(self):
        return self._http_client

    @property
    def http_client_instance(self):
        return self._http_client_instance

    @property
    def override_http_client_configuration(self):
        return self._override_http_client_configuration

    @property
    def http_call_back(self):
        return self._http_call_back

    @property
    def timeout(self):
        return self._timeout

    @property
    def max_retries(self):
        return self._max_retries

    @property
    def backoff_factor(self):
        return self._backoff_factor

    @property
    def retry_statuses(self):
        return self._retry_statuses

    @property
    def retry_methods(self):
        return self._retry_methods

    @property
    def environment(self):
        return self._environment

    @property
    def custom_header_api_key(self):
        return self._custom_header_api_key

    @property
    def o_auth_client_id(self):
        return self._o_auth_client_id

    @property
    def o_auth_redirect_uri(self):
        return self._o_auth_redirect_uri

    @property
    def o_auth_scopes(self):
        return self._o_auth_scopes

    @property
    def o_auth_token(self):
        if type(self._o_auth_token) is OAuthToken:
            return OAuthToken.from_dictionary(APIHelper.to_dictionary(self._o_auth_token))
        else:
            return self._o_auth_token

    def __init__(
        self, http_client_instance=None,
        override_http_client_configuration=False, http_call_back=None,
        timeout=60, max_retries=0, backoff_factor=2,
        retry_statuses=[408, 413, 429, 500, 502, 503, 504, 521, 522, 524],
        retry_methods=['GET', 'PUT'], environment=Environment.PRODUCTION,
        custom_header_api_key='TODO: Replace', o_auth_client_id='TODO: Replace',
        o_auth_redirect_uri='TODO: Replace', o_auth_token=None,
        o_auth_scopes='TODO: Replace'
    ):
        # The Http Client passed from the sdk user for making requests
        self._http_client_instance = http_client_instance

        # The value which determines to override properties of the passed Http Client from the sdk user
        self._override_http_client_configuration = override_http_client_configuration

        #  The callback value that is invoked before and after an HTTP call is made to an endpoint
        self._http_call_back = http_call_back

        # The value to use for connection timeout
        self._timeout = timeout

        # The number of times to retry an endpoint call if it fails
        self._max_retries = max_retries

        # A backoff factor to apply between attempts after the second try.
        # urllib3 will sleep for:
        # `{backoff factor} * (2 ** ({number of total retries} - 1))`
        self._backoff_factor = backoff_factor

        # The http statuses on which retry is to be done
        self._retry_statuses = retry_statuses

        # The http methods on which retry is to be done
        self._retry_methods = retry_methods

        # Current API environment
        self._environment = environment

        # TODO: Replace
        self._custom_header_api_key = custom_header_api_key

        # OAuth 2 Client ID
        self._o_auth_client_id = o_auth_client_id

        # OAuth 2 Redirection endpoint or Callback Uri
        self._o_auth_redirect_uri = o_auth_redirect_uri

        # Object for storing information about the OAuth token
        if type(o_auth_token) is OAuthToken:
            self._o_auth_token = OAuthToken.from_dictionary(APIHelper.to_dictionary(o_auth_token))
        else:
            self._o_auth_token = o_auth_token

        # TODO: Replace
        self._o_auth_scopes = o_auth_scopes

        # The Http Client to use for making requests.
        self._http_client = self.create_http_client()

    def clone_with(self, http_client_instance=None,
                   override_http_client_configuration=None, http_call_back=None,
                   timeout=None, max_retries=None, backoff_factor=None,
                   retry_statuses=None, retry_methods=None, environment=None,
                   custom_header_api_key=None, o_auth_client_id=None,
                   o_auth_redirect_uri=None, o_auth_token=None,
                   o_auth_scopes=None):
        http_client_instance = http_client_instance or self.http_client_instance
        override_http_client_configuration = override_http_client_configuration or self.override_http_client_configuration
        http_call_back = http_call_back or self.http_call_back
        timeout = timeout or self.timeout
        max_retries = max_retries or self.max_retries
        backoff_factor = backoff_factor or self.backoff_factor
        retry_statuses = retry_statuses or self.retry_statuses
        retry_methods = retry_methods or self.retry_methods
        environment = environment or self.environment
        custom_header_api_key = custom_header_api_key or self.custom_header_api_key
        o_auth_client_id = o_auth_client_id or self.o_auth_client_id
        o_auth_redirect_uri = o_auth_redirect_uri or self.o_auth_redirect_uri
        o_auth_token = o_auth_token or self.o_auth_token
        o_auth_scopes = o_auth_scopes or self.o_auth_scopes

        return Configuration(
            http_client_instance=http_client_instance,
            override_http_client_configuration=override_http_client_configuration,
            http_call_back=http_call_back, timeout=timeout,
            max_retries=max_retries, backoff_factor=backoff_factor,
            retry_statuses=retry_statuses, retry_methods=retry_methods,
            environment=environment, custom_header_api_key=custom_header_api_key,
            o_auth_client_id=o_auth_client_id,
            o_auth_redirect_uri=o_auth_redirect_uri, o_auth_token=o_auth_token,
            o_auth_scopes=o_auth_scopes
        )

    def create_http_client(self):
        return RequestsClient(
            timeout=self.timeout, max_retries=self.max_retries,
            backoff_factor=self.backoff_factor, retry_statuses=self.retry_statuses,
            retry_methods=self.retry_methods,
            http_client_instance=self.http_client_instance,
            override_http_client_configuration=self.override_http_client_configuration
        )

    # All the environments the SDK can run in
    environments = {
        Environment.PRODUCTION: {
            Server.SERVER1: 'https://petstore.swagger.io/v2',
            Server.SERVER2: 'http://petstore.swagger.io/v2',
            Server.AUTH_SERVER: 'https://petstore.swagger.io/oauth'
        }
    }

    def get_base_uri(self, server=Server.SERVER1):
        """Generates the appropriate base URI for the environment and the
        server.

        Args:
            server (Configuration.Server): The server enum for which the base
            URI is required.

        Returns:
            String: The base URI.

        """
        return self.environments[self.environment][server]
