from hestia_earth.validation.utils import _list_sum, _filter_list_errors


def validate_economicValueShare(products: list):
    sum = _list_sum(products, 'economicValueShare')
    return sum <= 100.5 or {
        'level': 'error',
        'dataPath': '.products',
        'message': 'economicValueShare should sum to 100 or less across all products',
        'params': {
            'sum': sum
        }
    }


def validate_value(products: list):
    def validate(values):
        index = values[0]
        product = values[1]
        return len(product.get('value', [])) > 0 or {
            'level': 'warning',
            'dataPath': f".products[{index}].value",
            'message': 'may not be 0'
        }

    results = list(map(validate, enumerate(products)))
    return _filter_list_errors(results)
