"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MessagingAppInstance = exports.AppInstanceDataType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const appInstanceValidator_1 = require("./appInstanceValidator");
const messagingCustomResources_1 = require("./messagingCustomResources");
var AppInstanceDataType;
(function (AppInstanceDataType) {
    AppInstanceDataType["CHANNEL"] = "Channel";
    AppInstanceDataType["CHANNELMESSAGE"] = "ChannelMessage";
})(AppInstanceDataType = exports.AppInstanceDataType || (exports.AppInstanceDataType = {}));
class MessagingAppInstance extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const uid = cdk.Names.uniqueId(this);
        const { name, metadata, tags, clientRequestToken } = props;
        appInstanceValidator_1.appInstanceValidator(props);
        const appInstanceRequest = new messagingCustomResources_1.MessagingResources(this, 'MessagingAppInstance', {
            resourceType: 'AppInstance',
            uid: uid,
            properties: {
                name: name || uid,
                metadata: metadata,
                clientRequestToken: clientRequestToken,
                tags: tags,
            },
        });
        this.appInstanceArn =
            appInstanceRequest.messagingCustomResource.getAttString('appInstanceArn');
    }
    streaming(streamingConfigs) {
        const uid = cdk.Names.uniqueId(this);
        const result = new messagingCustomResources_1.MessagingResources(this, 'AppInstanceStreamingConfiguration', {
            resourceType: 'StreamingConfig',
            uid: uid,
            properties: {
                streamingConfigs: streamingConfigs,
                appInstanceArn: this.appInstanceArn,
            },
        });
        return result;
    }
    retention(days) {
        const uid = cdk.Names.uniqueId(this);
        const result = new messagingCustomResources_1.MessagingResources(this, 'AppInstanceDataRetentionConfig', {
            resourceType: 'DataRetention',
            uid: uid,
            properties: {
                dataRetention: days,
                appInstanceArn: this.appInstanceArn,
            },
        });
        return result;
    }
}
exports.MessagingAppInstance = MessagingAppInstance;
_a = JSII_RTTI_SYMBOL_1;
MessagingAppInstance[_a] = { fqn: "cdk-amazon-chime-resources.MessagingAppInstance", version: "2.0.14" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXBwSW5zdGFuY2UuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvbWVzc2FnaW5nL2FwcEluc3RhbmNlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsbUNBQW1DO0FBQ25DLDJDQUF1QztBQUN2QyxpRUFBOEQ7QUFDOUQseUVBQWdFO0FBRWhFLElBQVksbUJBR1g7QUFIRCxXQUFZLG1CQUFtQjtJQUM3QiwwQ0FBbUIsQ0FBQTtJQUNuQix3REFBaUMsQ0FBQTtBQUNuQyxDQUFDLEVBSFcsbUJBQW1CLEdBQW5CLDJCQUFtQixLQUFuQiwyQkFBbUIsUUFHOUI7QUFtREQsTUFBYSxvQkFBcUIsU0FBUSxzQkFBUztJQUdqRCxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQXVCO1FBQy9ELEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFFakIsTUFBTSxHQUFHLEdBQVcsR0FBRyxDQUFDLEtBQUssQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLENBQUM7UUFFN0MsTUFBTSxFQUFFLElBQUksRUFBRSxRQUFRLEVBQUUsSUFBSSxFQUFFLGtCQUFrQixFQUFFLEdBQUcsS0FBSyxDQUFDO1FBRTNELDJDQUFvQixDQUFDLEtBQUssQ0FBQyxDQUFDO1FBQzVCLE1BQU0sa0JBQWtCLEdBQUcsSUFBSSw2Q0FBa0IsQ0FDL0MsSUFBSSxFQUNKLHNCQUFzQixFQUN0QjtZQUNFLFlBQVksRUFBRSxhQUFhO1lBQzNCLEdBQUcsRUFBRSxHQUFHO1lBQ1IsVUFBVSxFQUFFO2dCQUNWLElBQUksRUFBRSxJQUFJLElBQUksR0FBRztnQkFDakIsUUFBUSxFQUFFLFFBQVE7Z0JBQ2xCLGtCQUFrQixFQUFFLGtCQUFrQjtnQkFDdEMsSUFBSSxFQUFFLElBQUk7YUFDWDtTQUNGLENBQ0YsQ0FBQztRQUVGLElBQUksQ0FBQyxjQUFjO1lBQ2pCLGtCQUFrQixDQUFDLHVCQUF1QixDQUFDLFlBQVksQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDO0lBQzlFLENBQUM7SUFFRCxTQUFTLENBQUMsZ0JBQWtDO1FBQzFDLE1BQU0sR0FBRyxHQUFXLEdBQUcsQ0FBQyxLQUFLLENBQUMsUUFBUSxDQUFDLElBQUksQ0FBQyxDQUFDO1FBQzdDLE1BQU0sTUFBTSxHQUFHLElBQUksNkNBQWtCLENBQ25DLElBQUksRUFDSixtQ0FBbUMsRUFDbkM7WUFDRSxZQUFZLEVBQUUsaUJBQWlCO1lBQy9CLEdBQUcsRUFBRSxHQUFHO1lBQ1IsVUFBVSxFQUFFO2dCQUNWLGdCQUFnQixFQUFFLGdCQUFnQjtnQkFDbEMsY0FBYyxFQUFFLElBQUksQ0FBQyxjQUFjO2FBQ3BDO1NBQ0YsQ0FDRixDQUFDO1FBQ0YsT0FBTyxNQUFNLENBQUM7SUFDaEIsQ0FBQztJQUVELFNBQVMsQ0FBQyxJQUFZO1FBQ3BCLE1BQU0sR0FBRyxHQUFXLEdBQUcsQ0FBQyxLQUFLLENBQUMsUUFBUSxDQUFDLElBQUksQ0FBQyxDQUFDO1FBQzdDLE1BQU0sTUFBTSxHQUFHLElBQUksNkNBQWtCLENBQ25DLElBQUksRUFDSixnQ0FBZ0MsRUFDaEM7WUFDRSxZQUFZLEVBQUUsZUFBZTtZQUM3QixHQUFHLEVBQUUsR0FBRztZQUNSLFVBQVUsRUFBRTtnQkFDVixhQUFhLEVBQUUsSUFBSTtnQkFDbkIsY0FBYyxFQUFFLElBQUksQ0FBQyxjQUFjO2FBQ3BDO1NBQ0YsQ0FDRixDQUFDO1FBQ0YsT0FBTyxNQUFNLENBQUM7SUFDaEIsQ0FBQzs7QUE5REgsb0RBK0RDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgY2RrIGZyb20gJ2F3cy1jZGstbGliJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0IHsgYXBwSW5zdGFuY2VWYWxpZGF0b3IgfSBmcm9tICcuL2FwcEluc3RhbmNlVmFsaWRhdG9yJztcbmltcG9ydCB7IE1lc3NhZ2luZ1Jlc291cmNlcyB9IGZyb20gJy4vbWVzc2FnaW5nQ3VzdG9tUmVzb3VyY2VzJztcblxuZXhwb3J0IGVudW0gQXBwSW5zdGFuY2VEYXRhVHlwZSB7XG4gIENIQU5ORUwgPSAnQ2hhbm5lbCcsXG4gIENIQU5ORUxNRVNTQUdFID0gJ0NoYW5uZWxNZXNzYWdlJyxcbn1cblxuLyoqXG4gKiBQcm9wcyBmb3IgYEFwcEluc3RhbmNlU3RyZWFtaW5nQ29uZmlndXJhdGlvbmAuXG4gKiBTZWU6IGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9jaGltZS1zZGsvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfQXBwSW5zdGFuY2VTdHJlYW1pbmdDb25maWd1cmF0aW9uLmh0bWxcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBTdHJlYW1pbmdDb25maWcge1xuICAvKipcbiAgICogVGhlIHR5cGUgb2YgZGF0YSB0byBiZSBzdHJlYW1lZC5cbiAgICovXG4gIHJlYWRvbmx5IGFwcEluc3RhbmNlRGF0YVR5cGU6IEFwcEluc3RhbmNlRGF0YVR5cGU7XG4gIC8qKlxuICAgKiBUaGUgcmVzb3VyY2UgQVJOIG9mIGEgS2luZXNpcyBTdHJlYW0uXG4gICAqL1xuICByZWFkb25seSByZXNvdXJjZUFybjogc3RyaW5nO1xufVxuZXhwb3J0IHR5cGUgU3RyZWFtaW5nQ29uZmlncyA9IEFycmF5PFN0cmVhbWluZ0NvbmZpZz47XG5cbmV4cG9ydCBpbnRlcmZhY2UgQXBwSW5zdGFuY2VUYWdzIHtcbiAgcmVhZG9ubHkga2V5OiBzdHJpbmc7XG4gIHJlYWRvbmx5IHZhbHVlOiBzdHJpbmc7XG59XG5cbi8qKlxuICogUHJvcHMgZm9yIGBBcHBJbnN0YW5jZWAuXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgQXBwSW5zdGFuY2VQcm9wcyB7XG4gIC8qKlxuICAgKiBUaGUgbmFtZSBvZiB0aGUgYXBwIGluc3RhbmNlLlxuICAgKiBAZGVmYXVsdCAtIE5vbmVcbiAgICovXG4gIHJlYWRvbmx5IG5hbWU/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFRoZSBtZXRhZGF0YSBvZiB0aGUgYXBwIGluc3RhbmNlLiBMaW1pdGVkIHRvIGEgMUtCIHN0cmluZyBpbiBVVEYtOC5cbiAgICogQGRlZmF1bHQgLSBOb25lXG4gICAqL1xuICByZWFkb25seSBtZXRhZGF0YT86IHN0cmluZztcbiAgLyoqXG4gICAqIFRoZSB0YWdzIGZvciB0aGUgY3JlYXRpb24gcmVxdWVzdC5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBOb25lXG4gICAqL1xuICByZWFkb25seSB0YWdzPzogQXJyYXk8QXBwSW5zdGFuY2VUYWdzPjtcbiAgLyoqXG4gICAqIFRoZSBDbGllbnRSZXF1ZXN0VG9rZW4gb2YgdGhlIGFwcCBpbnN0YW5jZS4gIFRoaXMgZmllbGQgaXMgYXV0b3BvcHVsYXRlZCBpZiBub3QgcHJvdmlkZWQuXG4gICAqIEBkZWZhdWx0IC0gTm9uZVxuICAgKi9cbiAgcmVhZG9ubHkgY2xpZW50UmVxdWVzdFRva2VuPzogc3RyaW5nO1xufVxuXG5leHBvcnQgY2xhc3MgTWVzc2FnaW5nQXBwSW5zdGFuY2UgZXh0ZW5kcyBDb25zdHJ1Y3Qge1xuICBwdWJsaWMgcmVhZG9ubHkgYXBwSW5zdGFuY2VBcm46IHN0cmluZztcblxuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogQXBwSW5zdGFuY2VQcm9wcykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG5cbiAgICBjb25zdCB1aWQ6IHN0cmluZyA9IGNkay5OYW1lcy51bmlxdWVJZCh0aGlzKTtcblxuICAgIGNvbnN0IHsgbmFtZSwgbWV0YWRhdGEsIHRhZ3MsIGNsaWVudFJlcXVlc3RUb2tlbiB9ID0gcHJvcHM7XG5cbiAgICBhcHBJbnN0YW5jZVZhbGlkYXRvcihwcm9wcyk7XG4gICAgY29uc3QgYXBwSW5zdGFuY2VSZXF1ZXN0ID0gbmV3IE1lc3NhZ2luZ1Jlc291cmNlcyhcbiAgICAgIHRoaXMsXG4gICAgICAnTWVzc2FnaW5nQXBwSW5zdGFuY2UnLFxuICAgICAge1xuICAgICAgICByZXNvdXJjZVR5cGU6ICdBcHBJbnN0YW5jZScsXG4gICAgICAgIHVpZDogdWlkLFxuICAgICAgICBwcm9wZXJ0aWVzOiB7XG4gICAgICAgICAgbmFtZTogbmFtZSB8fCB1aWQsXG4gICAgICAgICAgbWV0YWRhdGE6IG1ldGFkYXRhLFxuICAgICAgICAgIGNsaWVudFJlcXVlc3RUb2tlbjogY2xpZW50UmVxdWVzdFRva2VuLFxuICAgICAgICAgIHRhZ3M6IHRhZ3MsXG4gICAgICAgIH0sXG4gICAgICB9LFxuICAgICk7XG5cbiAgICB0aGlzLmFwcEluc3RhbmNlQXJuID1cbiAgICAgIGFwcEluc3RhbmNlUmVxdWVzdC5tZXNzYWdpbmdDdXN0b21SZXNvdXJjZS5nZXRBdHRTdHJpbmcoJ2FwcEluc3RhbmNlQXJuJyk7XG4gIH1cblxuICBzdHJlYW1pbmcoc3RyZWFtaW5nQ29uZmlnczogU3RyZWFtaW5nQ29uZmlncykge1xuICAgIGNvbnN0IHVpZDogc3RyaW5nID0gY2RrLk5hbWVzLnVuaXF1ZUlkKHRoaXMpO1xuICAgIGNvbnN0IHJlc3VsdCA9IG5ldyBNZXNzYWdpbmdSZXNvdXJjZXMoXG4gICAgICB0aGlzLFxuICAgICAgJ0FwcEluc3RhbmNlU3RyZWFtaW5nQ29uZmlndXJhdGlvbicsXG4gICAgICB7XG4gICAgICAgIHJlc291cmNlVHlwZTogJ1N0cmVhbWluZ0NvbmZpZycsXG4gICAgICAgIHVpZDogdWlkLFxuICAgICAgICBwcm9wZXJ0aWVzOiB7XG4gICAgICAgICAgc3RyZWFtaW5nQ29uZmlnczogc3RyZWFtaW5nQ29uZmlncyxcbiAgICAgICAgICBhcHBJbnN0YW5jZUFybjogdGhpcy5hcHBJbnN0YW5jZUFybixcbiAgICAgICAgfSxcbiAgICAgIH0sXG4gICAgKTtcbiAgICByZXR1cm4gcmVzdWx0O1xuICB9XG5cbiAgcmV0ZW50aW9uKGRheXM6IG51bWJlcikge1xuICAgIGNvbnN0IHVpZDogc3RyaW5nID0gY2RrLk5hbWVzLnVuaXF1ZUlkKHRoaXMpO1xuICAgIGNvbnN0IHJlc3VsdCA9IG5ldyBNZXNzYWdpbmdSZXNvdXJjZXMoXG4gICAgICB0aGlzLFxuICAgICAgJ0FwcEluc3RhbmNlRGF0YVJldGVudGlvbkNvbmZpZycsXG4gICAgICB7XG4gICAgICAgIHJlc291cmNlVHlwZTogJ0RhdGFSZXRlbnRpb24nLFxuICAgICAgICB1aWQ6IHVpZCxcbiAgICAgICAgcHJvcGVydGllczoge1xuICAgICAgICAgIGRhdGFSZXRlbnRpb246IGRheXMsXG4gICAgICAgICAgYXBwSW5zdGFuY2VBcm46IHRoaXMuYXBwSW5zdGFuY2VBcm4sXG4gICAgICAgIH0sXG4gICAgICB9LFxuICAgICk7XG4gICAgcmV0dXJuIHJlc3VsdDtcbiAgfVxufVxuIl19